/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.utils;

import com.akamai.amp.media.VideoPlayerView;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class SegmentTimer {
    public static final int INFINITY = -1;
    public static final int DEFAULT_TICK = 50;
    private long mDuration = 0L;
    private int mElapsedTime = 0;
    private ScheduledExecutorService mExecService = Executors.newSingleThreadScheduledExecutor();
    private Future<?> mFuture = null;
    private long mInterval = 0L;
    private volatile boolean mIsRunning = false;
    private VideoPlayerView mParentVideoPlayerView = null;
    private String mCurrentSegmentUrl = "";

    public SegmentTimer(VideoPlayerView parent) {
        this.mParentVideoPlayerView = parent;
        this.mInterval = 50L;
        this.mDuration = -1L;
        this.mElapsedTime = 0;
    }

    public void cancel() {
        this.pause();
        this.mElapsedTime = 0;
    }

    public long getElapsedTime() {
        return this.mElapsedTime;
    }

    public long getRemainingTime() {
        if (this.mDuration < 0L) {
            return -1L;
        }
        return this.mDuration - (long)this.mElapsedTime;
    }

    public boolean isRunning() {
        return this.mIsRunning;
    }

    public void pause() {
        if (!this.mIsRunning) {
            return;
        }
        this.mFuture.cancel(false);
        this.mIsRunning = false;
    }

    public void restart(String segmentUrl) {
        this.start(segmentUrl);
    }

    public void resume() {
        this.start(this.mCurrentSegmentUrl);
    }

    public void start(String segmentUrl) {
        this.mElapsedTime = -50;
        this.mIsRunning = true;
        this.mFuture = this.mExecService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                String currentSegmentUrl = SegmentTimer.this.mParentVideoPlayerView.getCurrentSegmentUrl();
                if (!currentSegmentUrl.equals("") && !currentSegmentUrl.equalsIgnoreCase(SegmentTimer.this.mCurrentSegmentUrl)) {
                    SegmentTimer.this.mCurrentSegmentUrl = currentSegmentUrl;
                    SegmentTimer.this.cancel();
                    SegmentTimer.this.restart(currentSegmentUrl);
                }
                if (SegmentTimer.this.mParentVideoPlayerView.isPlaying() && !SegmentTimer.this.mParentVideoPlayerView.isSeeking()) {
                    SegmentTimer.this.onTick();
                    SegmentTimer.this.mElapsedTime = (int)((long)SegmentTimer.this.mElapsedTime + SegmentTimer.this.mInterval);
                    if (SegmentTimer.this.mDuration > 0L && (long)SegmentTimer.this.mElapsedTime >= SegmentTimer.this.mDuration) {
                        SegmentTimer.this.onFinish();
                        SegmentTimer.this.mFuture.cancel(false);
                    }
                }
            }
        }, 0L, this.mInterval, TimeUnit.MILLISECONDS);
    }

    protected void onFinish() {
    }

    protected void onTick() {
        this.mParentVideoPlayerView.onSegmentProgress(this.mCurrentSegmentUrl, this.mElapsedTime);
    }
}

