/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.drm;

import android.annotation.SuppressLint;
import android.media.NotProvisionedException;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.Pair;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.akamai.amp.exoplayer2.C;
import com.akamai.amp.exoplayer2.drm.DrmInitData;
import com.akamai.amp.exoplayer2.drm.DrmSession;
import com.akamai.amp.exoplayer2.drm.DrmSessionEventListener;
import com.akamai.amp.exoplayer2.drm.ExoMediaCrypto;
import com.akamai.amp.exoplayer2.drm.ExoMediaDrm;
import com.akamai.amp.exoplayer2.drm.KeysExpiredException;
import com.akamai.amp.exoplayer2.drm.MediaDrmCallback;
import com.akamai.amp.exoplayer2.drm.MediaDrmCallbackException;
import com.akamai.amp.exoplayer2.drm.WidevineUtil;
import com.akamai.amp.exoplayer2.source.LoadEventInfo;
import com.akamai.amp.exoplayer2.source.MediaLoadData;
import com.akamai.amp.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Consumer;
import com.akamai.amp.exoplayer2.util.CopyOnWriteMultiset;
import com.akamai.amp.exoplayer2.util.Log;
import com.akamai.amp.exoplayer2.util.Util;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@RequiresApi(value=18)
class DefaultDrmSession
implements DrmSession {
    private static final String TAG = "DefaultDrmSession";
    private static final int MSG_PROVISION = 0;
    private static final int MSG_KEYS = 1;
    private static final int MAX_LICENSE_DURATION_TO_RENEW_SECONDS = 60;
    @Nullable
    public final List<DrmInitData.SchemeData> schemeDatas;
    private final ExoMediaDrm mediaDrm;
    private final ProvisioningManager provisioningManager;
    private final ReferenceCountListener referenceCountListener;
    private final int mode;
    private final boolean playClearSamplesWithoutKeys;
    private final boolean isPlaceholderSession;
    private final HashMap<String, String> keyRequestParameters;
    private final CopyOnWriteMultiset<DrmSessionEventListener.EventDispatcher> eventDispatchers;
    private final LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    final MediaDrmCallback callback;
    final UUID uuid;
    final ResponseHandler responseHandler;
    private int state;
    private int referenceCount;
    @Nullable
    private HandlerThread requestHandlerThread;
    @Nullable
    private RequestHandler requestHandler;
    @Nullable
    private ExoMediaCrypto mediaCrypto;
    @Nullable
    private DrmSession.DrmSessionException lastException;
    @Nullable
    private byte[] sessionId;
    private byte @MonotonicNonNull [] offlineLicenseKeySetId;
    @Nullable
    private ExoMediaDrm.KeyRequest currentKeyRequest;
    @Nullable
    private ExoMediaDrm.ProvisionRequest currentProvisionRequest;

    public DefaultDrmSession(UUID uuid, ExoMediaDrm mediaDrm, ProvisioningManager provisioningManager, ReferenceCountListener referenceCountListener, @Nullable List<DrmInitData.SchemeData> schemeDatas, int mode, boolean playClearSamplesWithoutKeys, boolean isPlaceholderSession, @Nullable byte[] offlineLicenseKeySetId, HashMap<String, String> keyRequestParameters, MediaDrmCallback callback, Looper playbackLooper, LoadErrorHandlingPolicy loadErrorHandlingPolicy) {
        if (mode == 1 || mode == 3) {
            Assertions.checkNotNull(offlineLicenseKeySetId);
        }
        this.uuid = uuid;
        this.provisioningManager = provisioningManager;
        this.referenceCountListener = referenceCountListener;
        this.mediaDrm = mediaDrm;
        this.mode = mode;
        this.playClearSamplesWithoutKeys = playClearSamplesWithoutKeys;
        this.isPlaceholderSession = isPlaceholderSession;
        if (offlineLicenseKeySetId != null) {
            this.offlineLicenseKeySetId = offlineLicenseKeySetId;
            this.schemeDatas = null;
        } else {
            this.schemeDatas = Collections.unmodifiableList(Assertions.checkNotNull(schemeDatas));
        }
        this.keyRequestParameters = keyRequestParameters;
        this.callback = callback;
        this.eventDispatchers = new CopyOnWriteMultiset();
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        this.state = 2;
        this.responseHandler = new ResponseHandler(playbackLooper);
    }

    public boolean hasSessionId(byte[] sessionId) {
        return Arrays.equals(this.sessionId, sessionId);
    }

    public void onMediaDrmEvent(int what) {
        switch (what) {
            case 2: {
                this.onKeysRequired();
                break;
            }
        }
    }

    public void provision() {
        this.currentProvisionRequest = this.mediaDrm.getProvisionRequest();
        Util.castNonNull(this.requestHandler).post(0, Assertions.checkNotNull(this.currentProvisionRequest), true);
    }

    public void onProvisionCompleted() {
        if (this.openInternal(false)) {
            this.doLicense(true);
        }
    }

    public void onProvisionError(Exception error) {
        this.onError(error);
    }

    @Override
    public final int getState() {
        return this.state;
    }

    @Override
    public boolean playClearSamplesWithoutKeys() {
        return this.playClearSamplesWithoutKeys;
    }

    @Override
    @Nullable
    public final DrmSession.DrmSessionException getError() {
        return this.state == 1 ? this.lastException : null;
    }

    @Override
    @Nullable
    public final ExoMediaCrypto getMediaCrypto() {
        return this.mediaCrypto;
    }

    @Override
    @Nullable
    public Map<String, String> queryKeyStatus() {
        return this.sessionId == null ? null : this.mediaDrm.queryKeyStatus(this.sessionId);
    }

    @Override
    @Nullable
    public byte[] getOfflineLicenseKeySetId() {
        return this.offlineLicenseKeySetId;
    }

    @Override
    public void acquire(@Nullable DrmSessionEventListener.EventDispatcher eventDispatcher) {
        Assertions.checkState(this.referenceCount >= 0);
        if (eventDispatcher != null) {
            this.eventDispatchers.add(eventDispatcher);
        }
        if (++this.referenceCount == 1) {
            Assertions.checkState(this.state == 2);
            this.requestHandlerThread = new HandlerThread("ExoPlayer:DrmRequestHandler");
            this.requestHandlerThread.start();
            this.requestHandler = new RequestHandler(this.requestHandlerThread.getLooper());
            if (this.openInternal(true)) {
                this.doLicense(true);
            }
        } else if (eventDispatcher != null && this.isOpen()) {
            eventDispatcher.drmSessionAcquired();
        }
        this.referenceCountListener.onReferenceCountIncremented(this, this.referenceCount);
    }

    @Override
    public void release(@Nullable DrmSessionEventListener.EventDispatcher eventDispatcher) {
        Assertions.checkState(this.referenceCount > 0);
        if (--this.referenceCount == 0) {
            this.state = 0;
            Util.castNonNull(this.responseHandler).removeCallbacksAndMessages(null);
            Util.castNonNull(this.requestHandler).removeCallbacksAndMessages(null);
            this.requestHandler = null;
            Util.castNonNull(this.requestHandlerThread).quit();
            this.requestHandlerThread = null;
            this.mediaCrypto = null;
            this.lastException = null;
            this.currentKeyRequest = null;
            this.currentProvisionRequest = null;
            if (this.sessionId != null) {
                this.mediaDrm.closeSession(this.sessionId);
                this.sessionId = null;
            }
            this.dispatchEvent(DrmSessionEventListener.EventDispatcher::drmSessionReleased);
        }
        if (eventDispatcher != null) {
            if (this.isOpen()) {
                eventDispatcher.drmSessionReleased();
            }
            this.eventDispatchers.remove(eventDispatcher);
        }
        this.referenceCountListener.onReferenceCountDecremented(this, this.referenceCount);
    }

    @EnsuresNonNullIf(result=true, expression={"sessionId"})
    private boolean openInternal(boolean allowProvisioning) {
        if (this.isOpen()) {
            return true;
        }
        try {
            this.sessionId = this.mediaDrm.openSession();
            this.mediaCrypto = this.mediaDrm.createMediaCrypto(this.sessionId);
            this.dispatchEvent(DrmSessionEventListener.EventDispatcher::drmSessionAcquired);
            this.state = 3;
            Assertions.checkNotNull(this.sessionId);
            return true;
        }
        catch (NotProvisionedException e) {
            if (allowProvisioning) {
                this.provisioningManager.provisionRequired(this);
            } else {
                this.onError((Exception)((Object)e));
            }
        }
        catch (Exception e) {
            this.onError(e);
        }
        return false;
    }

    private void onProvisionResponse(Object request, Object response) {
        if (request != this.currentProvisionRequest || this.state != 2 && !this.isOpen()) {
            return;
        }
        this.currentProvisionRequest = null;
        if (response instanceof Exception) {
            this.provisioningManager.onProvisionError((Exception)response);
            return;
        }
        try {
            this.mediaDrm.provideProvisionResponse((byte[])response);
        }
        catch (Exception e) {
            this.provisioningManager.onProvisionError(e);
            return;
        }
        this.provisioningManager.onProvisionCompleted();
    }

    @RequiresNonNull(value={"sessionId"})
    private void doLicense(boolean allowRetry) {
        if (this.isPlaceholderSession) {
            return;
        }
        byte[] sessionId = Util.castNonNull(this.sessionId);
        switch (this.mode) {
            case 0: 
            case 1: {
                if (this.offlineLicenseKeySetId == null) {
                    this.postKeyRequest(sessionId, 1, allowRetry);
                    break;
                }
                if (this.state != 4 && !this.restoreKeys()) break;
                long licenseDurationRemainingSec = this.getLicenseDurationRemainingSec();
                if (this.mode == 0 && licenseDurationRemainingSec <= 60L) {
                    Log.d(TAG, "Offline license has expired or will expire soon. Remaining seconds: " + licenseDurationRemainingSec);
                    this.postKeyRequest(sessionId, 2, allowRetry);
                    break;
                }
                if (licenseDurationRemainingSec <= 0L) {
                    this.onError(new KeysExpiredException());
                    break;
                }
                this.state = 4;
                this.dispatchEvent(DrmSessionEventListener.EventDispatcher::drmKeysRestored);
                break;
            }
            case 2: {
                if (this.offlineLicenseKeySetId != null && !this.restoreKeys()) break;
                this.postKeyRequest(sessionId, 2, allowRetry);
                break;
            }
            case 3: {
                Assertions.checkNotNull(this.offlineLicenseKeySetId);
                Assertions.checkNotNull(this.sessionId);
                if (!this.restoreKeys()) break;
                this.postKeyRequest(this.offlineLicenseKeySetId, 3, allowRetry);
                break;
            }
        }
    }

    @RequiresNonNull(value={"sessionId", "offlineLicenseKeySetId"})
    private boolean restoreKeys() {
        try {
            this.mediaDrm.restoreKeys(this.sessionId, this.offlineLicenseKeySetId);
            return true;
        }
        catch (Exception e) {
            Log.e(TAG, "Error trying to restore keys.", e);
            this.onError(e);
            return false;
        }
    }

    private long getLicenseDurationRemainingSec() {
        if (!C.WIDEVINE_UUID.equals(this.uuid)) {
            return Long.MAX_VALUE;
        }
        Pair<Long, Long> pair = Assertions.checkNotNull(WidevineUtil.getLicenseDurationRemainingSec(this));
        return Math.min((Long)pair.first, (Long)pair.second);
    }

    private void postKeyRequest(byte[] scope, int type, boolean allowRetry) {
        try {
            this.currentKeyRequest = this.mediaDrm.getKeyRequest(scope, this.schemeDatas, type, this.keyRequestParameters);
            Util.castNonNull(this.requestHandler).post(1, Assertions.checkNotNull(this.currentKeyRequest), allowRetry);
        }
        catch (Exception e) {
            this.onKeysError(e);
        }
    }

    private void onKeyResponse(Object request, Object response) {
        if (request != this.currentKeyRequest || !this.isOpen()) {
            return;
        }
        this.currentKeyRequest = null;
        if (response instanceof Exception) {
            this.onKeysError((Exception)response);
            return;
        }
        try {
            byte[] responseData = (byte[])response;
            if (this.mode == 3) {
                this.mediaDrm.provideKeyResponse(Util.castNonNull(this.offlineLicenseKeySetId), responseData);
                this.dispatchEvent(DrmSessionEventListener.EventDispatcher::drmKeysRemoved);
            } else {
                byte[] keySetId = this.mediaDrm.provideKeyResponse(this.sessionId, responseData);
                if ((this.mode == 2 || this.mode == 0 && this.offlineLicenseKeySetId != null) && keySetId != null && keySetId.length != 0) {
                    this.offlineLicenseKeySetId = keySetId;
                }
                this.state = 4;
                this.dispatchEvent(DrmSessionEventListener.EventDispatcher::drmKeysLoaded);
            }
        }
        catch (Exception e) {
            this.onKeysError(e);
        }
    }

    private void onKeysRequired() {
        if (this.mode == 0 && this.state == 4) {
            Util.castNonNull(this.sessionId);
            this.doLicense(false);
        }
    }

    private void onKeysError(Exception e) {
        if (e instanceof NotProvisionedException) {
            this.provisioningManager.provisionRequired(this);
        } else {
            this.onError(e);
        }
    }

    private void onError(Exception e) {
        this.lastException = new DrmSession.DrmSessionException(e);
        this.dispatchEvent(eventDispatcher -> eventDispatcher.drmSessionManagerError(e));
        if (this.state != 4) {
            this.state = 1;
        }
    }

    @EnsuresNonNullIf(result=true, expression={"sessionId"})
    private boolean isOpen() {
        return this.state == 3 || this.state == 4;
    }

    private void dispatchEvent(Consumer<DrmSessionEventListener.EventDispatcher> event) {
        for (DrmSessionEventListener.EventDispatcher eventDispatcher : this.eventDispatchers.elementSet()) {
            event.accept(eventDispatcher);
        }
    }

    public static interface ProvisioningManager {
        public void provisionRequired(DefaultDrmSession var1);

        public void onProvisionError(Exception var1);

        public void onProvisionCompleted();
    }

    public static interface ReferenceCountListener {
        public void onReferenceCountIncremented(DefaultDrmSession var1, int var2);

        public void onReferenceCountDecremented(DefaultDrmSession var1, int var2);
    }

    @SuppressLint(value={"HandlerLeak"})
    private class ResponseHandler
    extends Handler {
        public ResponseHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            Pair requestAndResponse = (Pair)msg.obj;
            Object request = requestAndResponse.first;
            Object response = requestAndResponse.second;
            switch (msg.what) {
                case 0: {
                    DefaultDrmSession.this.onProvisionResponse(request, response);
                    break;
                }
                case 1: {
                    DefaultDrmSession.this.onKeyResponse(request, response);
                    break;
                }
            }
        }
    }

    @SuppressLint(value={"HandlerLeak"})
    private class RequestHandler
    extends Handler {
        public RequestHandler(Looper backgroundLooper) {
            super(backgroundLooper);
        }

        void post(int what, Object request, boolean allowRetry) {
            RequestTask requestTask = new RequestTask(LoadEventInfo.getNewId(), allowRetry, SystemClock.elapsedRealtime(), request);
            this.obtainMessage(what, requestTask).sendToTarget();
        }

        public void handleMessage(Message msg) {
            Object response;
            RequestTask requestTask = (RequestTask)msg.obj;
            try {
                switch (msg.what) {
                    case 0: {
                        response = DefaultDrmSession.this.callback.executeProvisionRequest(DefaultDrmSession.this.uuid, (ExoMediaDrm.ProvisionRequest)requestTask.request);
                        break;
                    }
                    case 1: {
                        response = DefaultDrmSession.this.callback.executeKeyRequest(DefaultDrmSession.this.uuid, (ExoMediaDrm.KeyRequest)requestTask.request);
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            }
            catch (MediaDrmCallbackException e) {
                if (this.maybeRetryRequest(msg, e)) {
                    return;
                }
                response = e;
            }
            catch (Exception e) {
                Log.w(DefaultDrmSession.TAG, "Key/provisioning request produced an unexpected exception. Not retrying.", e);
                response = e;
            }
            DefaultDrmSession.this.loadErrorHandlingPolicy.onLoadTaskConcluded(requestTask.taskId);
            DefaultDrmSession.this.responseHandler.obtainMessage(msg.what, Pair.create((Object)requestTask.request, (Object)response)).sendToTarget();
        }

        private boolean maybeRetryRequest(Message originalMsg, MediaDrmCallbackException exception) {
            IOException loadErrorCause;
            MediaLoadData mediaLoadData;
            RequestTask requestTask = (RequestTask)originalMsg.obj;
            if (!requestTask.allowRetry) {
                return false;
            }
            ++requestTask.errorCount;
            if (requestTask.errorCount > DefaultDrmSession.this.loadErrorHandlingPolicy.getMinimumLoadableRetryCount(3)) {
                return false;
            }
            LoadEventInfo loadEventInfo = new LoadEventInfo(requestTask.taskId, exception.dataSpec, exception.uriAfterRedirects, exception.responseHeaders, SystemClock.elapsedRealtime(), SystemClock.elapsedRealtime() - requestTask.startTimeMs, exception.bytesLoaded);
            long retryDelayMs = DefaultDrmSession.this.loadErrorHandlingPolicy.getRetryDelayMsFor(new LoadErrorHandlingPolicy.LoadErrorInfo(loadEventInfo, mediaLoadData = new MediaLoadData(3), loadErrorCause = exception.getCause() instanceof IOException ? (IOException)exception.getCause() : new UnexpectedDrmSessionException(exception.getCause()), requestTask.errorCount));
            if (retryDelayMs == -9223372036854775807L) {
                return false;
            }
            this.sendMessageDelayed(Message.obtain((Message)originalMsg), retryDelayMs);
            return true;
        }
    }

    private static final class RequestTask {
        public final long taskId;
        public final boolean allowRetry;
        public final long startTimeMs;
        public final Object request;
        public int errorCount;

        public RequestTask(long taskId, boolean allowRetry, long startTimeMs, Object request) {
            this.taskId = taskId;
            this.allowRetry = allowRetry;
            this.startTimeMs = startTimeMs;
            this.request = request;
        }
    }

    public static final class UnexpectedDrmSessionException
    extends IOException {
        public UnexpectedDrmSessionException(@Nullable Throwable cause) {
            super(cause);
        }
    }
}

