/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.analytics;

import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;
import com.akamai.amp.ads.AdsCount;
import com.akamai.amp.ads.AdsInfo;
import com.akamai.amp.ads.IAdsComponentListener;
import com.akamai.amp.analytics.AnalyticsTrackerData;
import com.akamai.amp.analytics.BaseTracker;
import com.akamai.amp.cast.OTTDevice;
import com.akamai.amp.config.Config;
import com.akamai.amp.config.data.GenericData;
import com.akamai.amp.media.IPlayerEventsListener;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.utils.LogManager;
import com.akamai.amp.utils.Utils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AnalyticsTracker<T extends AnalyticsTrackerData>
implements BaseTracker {
    private static final String LOG_TAG = "AnalyticsTracker";
    protected boolean isSessionInitialized = false;
    protected static final String UNKNOWN_VERSION = "UNKNOWN_VERSION";
    protected static final long NOT_REPORTED = -1L;
    protected VideoPlayerView mVideoPlayerView;
    protected boolean multiInstance = false;
    protected boolean trackPlaybackInit = true;
    protected T data;
    private boolean mPlaying = false;
    protected boolean mEnabledReporting = true;
    protected int latestReportedPositionSeconds = -1;
    protected boolean isLive = false;
    protected int currentTimeInMillis = 0;
    protected int duration = 0;
    protected Boolean adStarted = null;
    protected Boolean adBreakStarted = null;
    protected Boolean adErrorHappened = null;
    private IAdsComponentListener iAdsComponentListener = new IAdsComponentListener(){

        @Override
        public void onAdsError(String reason) {
            Log.e((String)AnalyticsTracker.LOG_TAG, (String)("ADS Error: " + reason));
            AnalyticsTracker.this.adErrorHappened = true;
            AnalyticsTracker.this.trackAdsError(reason);
        }

        @Override
        public void onAdsTapped() {
        }

        @Override
        public void onAdSkipped() {
            AnalyticsTracker.this.trackOnAdSkipped();
        }

        @Override
        public void onListenerRegistered() {
        }

        @Override
        public void onAdsInitialized() {
        }

        @Override
        public void onAdRequest() {
            AnalyticsTracker.this.trackOnAdRequest();
        }

        @Override
        public void onPauseContentRequested() {
            AnalyticsTracker.this.trackPauseContentRequested();
        }

        @Override
        public void onResumeContentRequested() {
            AnalyticsTracker.this.trackMissingAdEndEvents();
            AnalyticsTracker.this.trackResumeContentRequested();
        }

        @Override
        public void onAdsLoaded(AdsCount adsCount) {
            AnalyticsTracker.this.trackAdsLoaded(adsCount);
        }

        public void onAdsStarted(AdsInfo ad) {
            AnalyticsTracker.this.adStarted = true;
            AnalyticsTracker.this.adErrorHappened = false;
            AnalyticsTracker.this.latestReportedPositionSeconds = -1;
            AnalyticsTracker.this.trackAdsStarted(ad);
        }

        @Override
        public void onAdsPaused() {
            AnalyticsTracker.this.trackAdsPaused();
        }

        @Override
        public void onAdsResumed() {
            AnalyticsTracker.this.latestReportedPositionSeconds = -1;
            AnalyticsTracker.this.trackAdsResumed();
        }

        @Override
        public void onAdsEnded() {
            if (AnalyticsTracker.this.adStarted != null && AnalyticsTracker.this.adStarted.booleanValue()) {
                AnalyticsTracker.this.adStarted = false;
                AnalyticsTracker.this.trackAdsEnded();
            }
        }

        @Override
        public void onAdBreakStarted() {
            AnalyticsTracker.this.adBreakStarted = true;
            AnalyticsTracker.this.trackAdBreakStart();
        }

        @Override
        public void onAdBreakEnded() {
            if (AnalyticsTracker.this.adBreakStarted != null && AnalyticsTracker.this.adBreakStarted.booleanValue()) {
                AnalyticsTracker.this.adBreakStarted = false;
                AnalyticsTracker.this.trackAdBreakEnd();
            }
        }

        @Override
        public void onAllPostrollsEnded() {
            AnalyticsTracker.this.trackOnAllPostrollsEnded();
        }

        @Override
        public void onAdsTrackProgress(int progress) {
            AnalyticsTracker.this.trackAdsTrackProgress(progress);
        }

        @Override
        public void onAdsPlayheadUpdate(int seconds) {
            AnalyticsTracker.this.trackAdsPlayheadUpdate(seconds);
        }

        @Override
        public void onAdEvent() {
        }

        @Override
        public void onAdBufferingStarted() {
        }

        @Override
        public void onAdBufferingEnded() {
        }
    };
    private IPlayerEventsListener iPlayerEventsListener = new IPlayerEventsListener(){

        @Override
        public boolean onPlayerEvent(int eventId) {
            switch (eventId) {
                case 16: {
                    AnalyticsTracker.this.trackPauseEvent();
                    break;
                }
                case 15: {
                    AnalyticsTracker.this.latestReportedPositionSeconds = -1;
                    AnalyticsTracker.this.trackMissingAdEndEvents();
                    AnalyticsTracker.this.trackResumeEvent();
                    break;
                }
                case 8: {
                    AnalyticsTracker.this.trackABR();
                    break;
                }
                case 5: {
                    if (!AnalyticsTracker.this.mPlaying) break;
                    AnalyticsTracker.this.trackStartRebuffering();
                    break;
                }
                case 6: {
                    if (!AnalyticsTracker.this.mPlaying) break;
                    AnalyticsTracker.this.trackStopRebuffering();
                    break;
                }
                case 2: {
                    AnalyticsTracker.this.currentTimeInMillis = AnalyticsTracker.this.getCurrentPositionInMillis();
                    AnalyticsTracker.this.trackFinish();
                    AnalyticsTracker.this.mPlaying = false;
                    break;
                }
                case 21: {
                    AnalyticsTracker.this.trackStopPlaying();
                    AnalyticsTracker.this.mPlaying = false;
                    break;
                }
                case 19: {
                    AnalyticsTracker.this.trackSeekStarted();
                    break;
                }
                case 11: {
                    AnalyticsTracker.this.trackSeekComplete();
                    break;
                }
                case 22: {
                    if (!AnalyticsTracker.this.trackPlaybackInit) break;
                    AnalyticsTracker.this.trackPlayRequestedEvent();
                    break;
                }
                case 9: {
                    if (!AnalyticsTracker.this.trackPlaybackInit) break;
                    AnalyticsTracker.this.trackVideoLoad();
                    break;
                }
                case 3: {
                    String stream = "";
                    if (AnalyticsTracker.this.mVideoPlayerView != null) {
                        AnalyticsTracker.this.duration = AnalyticsTracker.this.mVideoPlayerView.getTimelineDuration();
                        stream = AnalyticsTracker.this.mVideoPlayerView.getStreamUrl();
                        AnalyticsTracker.this.isLive = AnalyticsTracker.this.mVideoPlayerView.isLive();
                    }
                    if (AnalyticsTracker.this.mPlaying || !AnalyticsTracker.this.trackPlaybackInit) break;
                    AnalyticsTracker.this.mPlaying = true;
                    AnalyticsTracker.this.latestReportedPositionSeconds = -1;
                    AnalyticsTracker.this.trackStartPlaying(AnalyticsTracker.this.duration, AnalyticsTracker.this.isLive, stream);
                    break;
                }
                case 0: {
                    AnalyticsTracker.this.currentTimeInMillis = AnalyticsTracker.this.getCurrentPositionInMillis();
                    if (AnalyticsTracker.this.mVideoPlayerView != null && !AnalyticsTracker.this.isLive) {
                        boolean validPlayhead;
                        int currentPositionSeconds = AnalyticsTracker.this.currentTimeInMillis / 1000;
                        boolean bl = validPlayhead = currentPositionSeconds >= 0 && currentPositionSeconds != AnalyticsTracker.this.latestReportedPositionSeconds;
                        if (validPlayhead) {
                            AnalyticsTracker.this.latestReportedPositionSeconds = currentPositionSeconds;
                            AnalyticsTracker.this.trackPositionUpdate(AnalyticsTracker.this.latestReportedPositionSeconds);
                        } else {
                            LogManager.log(AnalyticsTracker.LOG_TAG, "PLAYER_EVENT_TYPE_POSITION_UPDATE !validPlayhead current: " + currentPositionSeconds + ", latest: " + AnalyticsTracker.this.latestReportedPositionSeconds);
                        }
                    }
                    if (AnalyticsTracker.this.isSessionInitialized) break;
                    AnalyticsTracker.this.trackInit();
                    AnalyticsTracker.this.trackABR();
                    break;
                }
                case 17: {
                    if (AnalyticsTracker.this.multiInstance) break;
                    AnalyticsTracker.this.trackSendToBackground();
                    break;
                }
                case 18: {
                    if (AnalyticsTracker.this.multiInstance) break;
                    AnalyticsTracker.this.latestReportedPositionSeconds = -1;
                    AnalyticsTracker.this.trackSendToForeground();
                    break;
                }
                case 23: {
                    AnalyticsTracker.this.currentTimeInMillis = AnalyticsTracker.this.getCurrentPositionInMillis();
                    AnalyticsTracker.this.onDestroy();
                    break;
                }
                case 4: {
                    String errorMessage = "Error code: " + AnalyticsTracker.this.mVideoPlayerView.getLastErrorCode() + ", last HTTP code: " + AnalyticsTracker.this.mVideoPlayerView.getLastHttpErrorCode();
                    AnalyticsTracker.this.trackError(errorMessage);
                    break;
                }
                case 12: {
                    AnalyticsTracker.this.trackFullScreen();
                }
                case 26: {
                    AnalyticsTracker.this.trackLogicalResumeIsComing();
                    break;
                }
                case 27: {
                    AnalyticsTracker.this.trackLogicalPauseIsComing();
                    break;
                }
                case 31: {
                    AnalyticsTracker.this.trackSubtitlesEnabled();
                    break;
                }
                case 32: {
                    AnalyticsTracker.this.trackSubtitlesDisabled();
                    break;
                }
                case 33: {
                    AnalyticsTracker.this.trackPlaybackStalled();
                    break;
                }
                case 13: {
                    AnalyticsTracker.this.trackSizeChange();
                    break;
                }
            }
            return true;
        }

        @Override
        public boolean onPlayerExtendedEvent(int iInEventType, int arg1, int arg2) {
            return true;
        }
    };

    private void trackMissingAdEndEvents() {
        if (this.adStarted != null && this.adStarted.booleanValue()) {
            LogManager.log(LOG_TAG, "adStarted, artificially invoking iAdsComponentListener.onAdsEnded()");
            this.iAdsComponentListener.onAdsEnded();
            this.adStarted = null;
        }
        if (this.adBreakStarted != null && this.adBreakStarted.booleanValue()) {
            LogManager.log(LOG_TAG, "adBreakStarted, artificially invoking iAdsComponentListener.onAdBreakEnded()");
            this.iAdsComponentListener.onAdBreakEnded();
            this.adBreakStarted = null;
        }
    }

    public AnalyticsTracker(VideoPlayerView videoPlayerView, T dataParam, String moduleName, String moduleVersion) {
        Utils.checkModuleVersion(moduleName, moduleVersion);
        this.setData(dataParam);
        this.setVideoPlayerView(videoPlayerView);
    }

    public AnalyticsTracker(T dataParam, String moduleName, String moduleVersion) {
        Utils.checkModuleVersion(moduleName, moduleVersion);
        this.setData(dataParam);
    }

    @Override
    public void enableReporting(Boolean enable) {
        this.mEnabledReporting = enable;
    }

    @Override
    public boolean isReportingEnabled() {
        return this.mEnabledReporting;
    }

    @Override
    public IPlayerEventsListener getiPlayerEventsListener() {
        return this.iPlayerEventsListener;
    }

    @Override
    public IAdsComponentListener getiAdsComponentListener() {
        return this.iAdsComponentListener;
    }

    @Override
    public void setMultiInstance(boolean isMultiInstance) {
        this.multiInstance = isMultiInstance;
    }

    @Override
    public abstract String getExternalLibVersion();

    @Override
    public void trackStartPlaying(int duration, boolean isLive, String streamUrl) {
        this.isLive = isLive;
        this.latestReportedPositionSeconds = -1;
        this.trackPlayEvent();
    }

    @Override
    public void trackOnStart(String viewName) {
    }

    @Override
    public void trackPauseEvent() {
    }

    @Override
    public void trackResumeEvent() {
    }

    @Override
    public void trackPlayRequestedEvent() {
    }

    @Override
    public void trackPlayEvent() {
    }

    @Override
    public void trackStopPlaying() {
    }

    @Override
    public void trackFinish() {
    }

    @Override
    public void trackSeekStarted() {
    }

    @Override
    public void trackSeekComplete() {
    }

    @Override
    public void trackVideoLoad() {
    }

    @Override
    public void trackSizeChange() {
    }

    @Override
    public void trackError(String errorMessage) {
        Log.e((String)LOG_TAG, (String)("trackError: " + errorMessage));
    }

    @Override
    public void trackStartRebuffering() {
    }

    @Override
    public void trackStopRebuffering() {
    }

    @Override
    public void trackSubtitlesDisabled() {
    }

    @Override
    public void trackSubtitlesEnabled() {
    }

    @Override
    public void trackPlaybackStalled() {
    }

    @Override
    public void trackTextSizeChanged(int newTextSize) {
    }

    @Override
    public void trackScreenPositionChanges(String newScreenPosition) {
    }

    @Override
    public void trackTextStyleChanges(String newTextStyle) {
    }

    @Override
    public void trackFontChanges(String newFontName) {
    }

    @Override
    public void trackScrollingChanges(String newScrollingType) {
    }

    @Override
    public void trackWindowColorChanges(int newWindowColor) {
    }

    @Override
    public void trackBackgroundColorChanges(int newBackgroundColor) {
    }

    @Override
    public void trackFontColorChanges(int newFontColor) {
    }

    @Override
    public void trackPresetChanges(String newPresetType) {
    }

    @Override
    public void trackPositionUpdate(long playheadPosition) {
    }

    @Override
    public void trackSendToForeground() {
    }

    @Override
    public void trackSendToBackground() {
    }

    @Override
    public void trackABR() {
    }

    @Override
    public void trackInit() {
    }

    @Override
    public void trackFullScreen() {
    }

    @Override
    public void trackOnDestroy() {
        this.doDestroy(true);
    }

    @Override
    public void trackAdsError(String reason) {
        Log.e((String)LOG_TAG, (String)("ADS Error: " + reason));
    }

    @Override
    public void trackPauseContentRequested() {
    }

    @Override
    public void trackResumeContentRequested() {
    }

    @Override
    public void trackAdsLoaded(AdsCount adsCount) {
    }

    @Override
    public void trackAdsStarted(AdsInfo ad) {
    }

    @Override
    public void trackAdsPaused() {
    }

    @Override
    public void trackAdsResumed() {
    }

    @Override
    public void trackAdsEnded() {
    }

    @Override
    public void trackOnAdSkipped() {
    }

    @Override
    public void trackOnAdRequest() {
    }

    @Override
    public void trackAdBreakStart() {
    }

    @Override
    public void trackAdBreakEnd() {
    }

    @Override
    public void trackOnAllPostrollsEnded() {
    }

    @Override
    public void trackAdsTrackProgress(int progress) {
    }

    @Override
    public void trackAdsPlayheadUpdate(int seconds) {
    }

    @Override
    public void trackLogicalResumeIsComing() {
    }

    @Override
    public void trackLogicalPauseIsComing() {
    }

    @Override
    public void setContentLabel(String tag, String value) {
    }

    @Override
    public void setContentLabels(Map<String, String> map) {
    }

    @Override
    public void setAdLabel(String tag, String value) {
    }

    @Override
    public void setAdLabels(Map<String, String> map) {
    }

    @Override
    public void trackDeviceConnected(OTTDevice args) {
    }

    @Override
    public void trackDeviceDisconnected() {
    }

    @Override
    public void onDestroy() {
        LogManager.error(LOG_TAG, "onDestroy()");
        this.destroy();
    }

    @Override
    public void setVideoPlayerView(VideoPlayerView videoView) {
        this.doSetVideoPlayerView(videoView);
        this.init();
    }

    @Override
    public void resetVideoPlayerView(VideoPlayerView videoView) {
        this.doSetVideoPlayerView(videoView);
        this.trackPlaybackInit = false;
    }

    @Override
    public void removeFromPlayerListeners() {
        if (this.mVideoPlayerView != null) {
            this.mVideoPlayerView.removeEventsListener(this.getiPlayerEventsListener());
        }
        this.mVideoPlayerView = null;
    }

    @Override
    public Context getOwner() {
        if (this.mVideoPlayerView == null) {
            return null;
        }
        return this.mVideoPlayerView.getContext();
    }

    @Override
    public void cleanup() {
    }

    public void setData(T dataParam) {
        if (dataParam == null) {
            this.checkConfigModelIsInitialized();
            this.data = this.loadDataFromConfig();
            if (this.data == null) {
                throw new IllegalStateException("The analytics data was not provided");
            }
        } else {
            this.data = dataParam;
        }
    }

    @Override
    public T getData() {
        return this.data;
    }

    private void destroy() {
        this.doDestroy(!this.multiInstance);
    }

    @Override
    public abstract void init();

    protected T loadDataFromConfig() {
        return null;
    }

    private void doDestroy(boolean doCleanup) {
        this.removeFromPlayerListeners();
        if (doCleanup) {
            AsyncTask.execute(this::cleanup);
        }
    }

    private void doSetVideoPlayerView(VideoPlayerView videoPlayerView) {
        if (videoPlayerView == null) {
            LogManager.error(LOG_TAG, "setVideoPlayerView: VideoPlayerView is NULL()");
            return;
        }
        this.mVideoPlayerView = videoPlayerView;
        this.mVideoPlayerView.addEventsListener(this.getiPlayerEventsListener());
    }

    protected void checkConfigModelIsInitialized() {
        Config config = Config.getConfig();
        if (config == null) {
            throw new IllegalStateException("com.akamai.amp.config.Config is null");
        }
        if (!config.configLoaded) {
            throw new IllegalStateException("com.akamai.model.Config has not been loaded");
        }
    }

    protected void addValue(String key, String value, Map<String, String> map) {
        if (key == null || value == null) {
            return;
        }
        map.put(key, value);
    }

    protected void moveValues(GenericData data, Map<String, String> map) {
        Map<String, String> allValues = data.getValues();
        Set<String> keys = allValues.keySet();
        for (String key : keys) {
            String value = allValues.get(key);
            this.addValue(key, value, map);
        }
    }

    protected void addValues(GenericData data, Map<String, String> values) {
        Set<String> allMetadata = data.getAllMetadata();
        for (String key : allMetadata) {
            String value = data.getValue(key);
            this.addValue(key, value, values);
        }
    }

    protected void checkMissingMandatoryValues(GenericData data, String logTag, String defaultValue) {
        Set<String> missingMandatoryValues = this.getMissingMandatoryValues(data);
        if (!missingMandatoryValues.isEmpty()) {
            String errorMsg = "ERROR: Missing mandatory field(s): " + missingMandatoryValues;
            Log.e((String)logTag, (String)errorMsg);
        }
        this.addMissingMandatoryValuesWithDefault(data, defaultValue, missingMandatoryValues);
    }

    private void addMissingMandatoryValuesWithDefault(GenericData data, String defaultValue, Set<String> missingMandatoryValues) {
        for (String key : missingMandatoryValues) {
            data.addValue(key, defaultValue);
        }
    }

    private Set<String> getMissingMandatoryValues(GenericData data) {
        HashSet<String> missingMandatoryValues = new HashSet<String>();
        for (String key : data.getMandatoryMetadata()) {
            String value = data.getValue(key);
            boolean valueNotFound = value == null;
            if (!valueNotFound) continue;
            missingMandatoryValues.add(key);
        }
        return missingMandatoryValues;
    }

    protected String evaluateJs(String param) {
        Config config = Config.getConfig();
        if (config == null) {
            return param;
        }
        String result = config.validateJSExpression(param);
        return result;
    }

    protected String str(Object o) {
        return String.valueOf(o);
    }

    protected int getCurrentPositionInMillis() {
        int currentPositionInSeconds = this.mVideoPlayerView != null ? this.mVideoPlayerView.getCurrentTimelinePosition() : this.currentTimeInMillis;
        return currentPositionInSeconds * 1000;
    }

    @Override
    public long getPlayheadPosition() {
        if (this.mVideoPlayerView == null) {
            return -1L;
        }
        if (this.isLive) {
            return this.getPlayheadPositionForLive();
        }
        return this.latestReportedPositionSeconds;
    }

    protected long getPlayheadPositionForLive() {
        return -1L;
    }
}

