/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.media.exowrapper2;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.opengl.GLSurfaceView;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Pair;
import android.view.Surface;
import android.view.SurfaceHolder;
import androidx.annotation.Nullable;
import com.akamai.amp.cmcd.CMCDProxy;
import com.akamai.amp.downloader.DownloadRequestProvider;
import com.akamai.amp.downloader.LocalPathProvider;
import com.akamai.amp.exoplayer2.ExoPlaybackException;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.MediaItem;
import com.akamai.amp.exoplayer2.PlaybackParameters;
import com.akamai.amp.exoplayer2.Player;
import com.akamai.amp.exoplayer2.SimpleExoPlayer;
import com.akamai.amp.exoplayer2.Timeline;
import com.akamai.amp.exoplayer2.ampcustom.AMPPreSettings;
import com.akamai.amp.exoplayer2.ampcustom.AmpBasePlayer;
import com.akamai.amp.exoplayer2.ampcustom.LowLatencySettings;
import com.akamai.amp.exoplayer2.audio.AudioAttributes;
import com.akamai.amp.exoplayer2.drm.DrmSessionManager;
import com.akamai.amp.exoplayer2.mediacodec.MediaCodecRenderer;
import com.akamai.amp.exoplayer2.mediacodec.MediaCodecUtil;
import com.akamai.amp.exoplayer2.metadata.Metadata;
import com.akamai.amp.exoplayer2.metadata.MetadataOutput;
import com.akamai.amp.exoplayer2.offline.DownloadRequest;
import com.akamai.amp.exoplayer2.source.BehindLiveWindowException;
import com.akamai.amp.exoplayer2.source.ConcatenatingMediaSource;
import com.akamai.amp.exoplayer2.source.DefaultMediaSourceFactory;
import com.akamai.amp.exoplayer2.source.MediaSource;
import com.akamai.amp.exoplayer2.source.MediaSourceEventListener;
import com.akamai.amp.exoplayer2.source.MergingMediaSource;
import com.akamai.amp.exoplayer2.source.ProgressiveMediaSource;
import com.akamai.amp.exoplayer2.source.SingleSampleMediaSource;
import com.akamai.amp.exoplayer2.source.TrackGroup;
import com.akamai.amp.exoplayer2.source.TrackGroupArray;
import com.akamai.amp.exoplayer2.source.dash.DashMediaSource;
import com.akamai.amp.exoplayer2.source.hls.HlsMediaSource;
import com.akamai.amp.exoplayer2.source.hls.playlist.DefaultHlsPlaylistParserFactory;
import com.akamai.amp.exoplayer2.source.smoothstreaming.SsMediaSource;
import com.akamai.amp.exoplayer2.text.Cue;
import com.akamai.amp.exoplayer2.text.TextOutput;
import com.akamai.amp.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.akamai.amp.exoplayer2.trackselection.DefaultTrackSelector;
import com.akamai.amp.exoplayer2.trackselection.MappingTrackSelector;
import com.akamai.amp.exoplayer2.trackselection.RandomTrackSelection;
import com.akamai.amp.exoplayer2.trackselection.TrackSelection;
import com.akamai.amp.exoplayer2.trackselection.TrackSelectionArray;
import com.akamai.amp.exoplayer2.upstream.BandwidthMeter;
import com.akamai.amp.exoplayer2.upstream.DataSource;
import com.akamai.amp.exoplayer2.upstream.DefaultBandwidthMeter;
import com.akamai.amp.exoplayer2.util.EventLogger;
import com.akamai.amp.exoplayer2.util.Log;
import com.akamai.amp.exoplayer2.util.Util;
import com.akamai.amp.exoplayer2.video.VideoListener;
import com.akamai.amp.media.VideoPlayerContainer;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.VideoPlayerViewExo;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.media.elements.QualityLevel;
import com.akamai.amp.media.exowrapper2.DataSourceBuilder;
import com.akamai.amp.media.exowrapper2.ExoMessages;
import com.akamai.amp.media.exowrapper2.SideloadedCaptionsData;
import com.akamai.amp.media.exowrapper2.TrackNameBuilder;
import com.akamai.amp.media.exowrapper2.drm.DrmHandler;
import com.akamai.amp.media.mute.IMuteable;
import com.akamai.amp.media.mute.MuteHelper;
import com.akamai.amp.utils.IntentUtil;
import com.akamai.amp.utils.LogManager;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ExoWrapper
implements VideoListener,
IMuteable {
    private static final String TAG = ExoWrapper.class.getSimpleName();
    private static BandwidthMeter bandwidthMeter;
    private static final CookieManager DEFAULT_COOKIE_MANAGER;
    private Handler mainHandler;
    private EventLogger eventLogger;
    private DataSource.Factory mediaDataSourceFactory;
    private AmpBasePlayer player;
    private DefaultTrackSelector trackSelector;
    private DefaultTrackSelector.Parameters trackSelectorParameters;
    private boolean inErrorState;
    private TrackGroupArray lastSeenTrackGroupArray;
    private boolean shouldAutoPlay;
    private int resumeWindow;
    private long resumePosition;
    private String protocol;
    private int repeatMode;
    private static final int VIDEO_TRACK_INDEX = 0;
    private static final int AUDIO_TRACK_INDEX = 1;
    private static final int DATA_TRACK_INDEX = 2;
    private int currentAudioTrackIndex = 0;
    private int maxBitrate = Integer.MAX_VALUE;
    private VideoPlayerViewExo.VideoStatsEvents videoSizeEvents;
    private VideoPlayerContainer videoPlayerContainer;
    private Context context;
    private SurfaceHolder surfaceHolder;
    private MediaSource mediaSource;
    private MediaResource mediaResource;
    private Surface surface;
    private MetadataOutput metadaRenderer;
    private TextOutput textRendererOutput;
    private List<SideloadedCaptionsData> sideloadedCaptionsData;
    private boolean closeCaptionsEnabled;
    private int trackIndex = 0;
    private int formatIndex = 0;
    private Player.EventListener exoEventListener;
    private LocalPathProvider localPathProvider;
    private CMCDProxy commonMediaClientDataProxy;
    private UUID sessionId;
    private MediaItem downloadMediaItem;
    int type = 3;
    private DownloadRequestProvider downloadRequestProvider;
    private float playbackRate = 1.0f;
    private long bufferAvailable;
    private long latency;
    int selectedQualityLevel = -1;
    private Player.EventListener exoPlayerEventListener;
    private MediaSourceEventListener adaptiveMediaSourceEventListener;
    private static final String MPD_ISM_EXTENSION = ".ism/manifest(format=mpd-time-csf)";
    public boolean isOnResume = false;
    private MetadataOutput defaultMetaDataOutput = new MetadataOutput(){

        @Override
        public void onMetadata(Metadata metadata) {
            if (ExoWrapper.this.metadaRenderer != null) {
                ExoWrapper.this.metadaRenderer.onMetadata(metadata);
            }
        }
    };

    public ExoWrapper(Context c, Player.EventListener exoEventListener, UUID sessionId) {
        this.exoEventListener = exoEventListener;
        this.sessionId = sessionId;
        this.setContext(c);
        this.onCreate();
    }

    public void onCreate() {
        this.shouldAutoPlay = true;
        this.clearResumePosition();
        this.mainHandler = new Handler();
        if (CookieHandler.getDefault() != DEFAULT_COOKIE_MANAGER) {
            CookieHandler.setDefault(DEFAULT_COOKIE_MANAGER);
        }
        DefaultTrackSelector.ParametersBuilder builder = new DefaultTrackSelector.ParametersBuilder(this.context);
        if (Util.SDK_INT >= 21) {
            // empty if block
        }
        this.trackSelectorParameters = builder.build();
    }

    public void setShouldAutoPlay(boolean shouldAutoPlay) {
        this.shouldAutoPlay = shouldAutoPlay;
    }

    public void setRepeatMode(int repeatMode) {
        this.repeatMode = repeatMode;
    }

    public void onStart() {
        if (Util.SDK_INT > 23) {
            this.initializePlayer();
        }
    }

    public void onResume() {
        if (Util.SDK_INT <= 23 || this.player == null) {
            this.initializePlayer();
        }
    }

    public void onPause() {
        if (Util.SDK_INT <= 23) {
            this.releasePlayer();
        }
    }

    public void onStop() {
        if (Util.SDK_INT > 23) {
            this.releasePlayer();
        }
    }

    public void preparePlayback() {
        this.initializePlayer();
    }

    private void initializePlayer() {
        Intent intent = IntentUtil.getIntentFromMediaSource(this.mediaResource);
        if (VideoPlayerContainer.isAppInBackground) {
            return;
        }
        if (AMPPreSettings.getPreSettingsInstance().getLowLatencySettings().isLowLatencyTurnedOn()) {
            AMPPreSettings.getPreSettingsInstance().getLowLatencySettings().startSntpClient();
        }
        this.setDataSourceFactory();
        this.validateNewPlayerInstance(intent);
        if (this.player == null) {
            Log.e(TAG, "Player Initialization failed");
            return;
        }
        this.downloadMediaItem = null;
        this.initializeMediaSource(intent);
        if (this.mediaSource == null && this.downloadMediaItem == null) {
            Log.e(TAG, "MediaSource Initialization failed");
        } else {
            boolean haveResumePosition;
            this.checkAddSubtitles();
            boolean bl = haveResumePosition = this.resumeWindow != -1 && this.resumePosition != -1L;
            if (haveResumePosition) {
                this.player.seekTo(this.resumeWindow, this.resumePosition);
            }
            if (this.downloadMediaItem != null) {
                this.setSubtitlesForOfflinePlayback(this.downloadMediaItem);
                this.player.setMediaItem(this.downloadMediaItem, !haveResumePosition);
            } else {
                this.player.setMediaSource(this.mediaSource, !haveResumePosition);
            }
            this.player.prepare();
            this.inErrorState = false;
        }
    }

    private void setSubtitlesForOfflinePlayback(MediaItem downloadMediaItem) {
        if (this.sideloadedCaptionsData == null) {
            return;
        }
        MediaItem.PlaybackProperties properties = downloadMediaItem.playbackProperties;
        if (properties == null) {
            return;
        }
        List<MediaItem.Subtitle> current = properties.subtitles;
        ArrayList<MediaItem.Subtitle> subtitles = current == null ? new ArrayList<MediaItem.Subtitle>() : new ArrayList<MediaItem.Subtitle>(current);
        for (SideloadedCaptionsData captions : this.sideloadedCaptionsData) {
            Uri uri = Uri.parse((String)captions.getSubtitleUriString());
            String mimeType = captions.getSubtitleMimeType();
            String language = captions.getSubtitleLanguage();
            MediaItem.Subtitle s = new MediaItem.Subtitle(uri, mimeType, language);
            subtitles.add(s);
        }
        properties.subtitles = subtitles;
    }

    private void initializeMediaSource(Intent intent) {
        int i;
        String[] extensions;
        Uri[] uris;
        DrmHandler drmHandler = new DrmHandler(this.context, intent);
        String action = intent.getAction();
        if ("com.akamai.amp.exoplayer.demo.action.VIEW".equals(action)) {
            uris = new Uri[]{intent.getData()};
            extensions = new String[]{intent.getStringExtra("extension")};
        } else if ("com.akamai.amp.exoplayer.demo.action.VIEW_LIST".equals(action)) {
            String[] uriStrings = intent.getStringArrayExtra("uri_list");
            uris = new Uri[uriStrings.length];
            for (i = 0; i < uriStrings.length; ++i) {
                uris[i] = Uri.parse((String)uriStrings[i]);
            }
            extensions = intent.getStringArrayExtra("extension_list");
            if (extensions == null) {
                extensions = new String[uriStrings.length];
            }
        } else {
            this.showToast(this.getString(0, action));
            return;
        }
        if (intent.getData() == null) {
            return;
        }
        MediaSource[] mediaSources = new MediaSource[uris.length];
        for (i = 0; i < uris.length; ++i) {
            String securityLevel = AMPPreSettings.getPreSettingsInstance().getSecurityLevel();
            DrmSessionManager drmSessionManager = drmHandler.getDRMSessionManager(securityLevel);
            if (drmSessionManager == null) continue;
            mediaSources[i] = this.buildMediaSource(uris[i], extensions[i], this.mainHandler, this.adaptiveMediaSourceEventListener, drmSessionManager);
        }
        this.mediaSource = mediaSources.length == 1 ? mediaSources[0] : new ConcatenatingMediaSource(mediaSources);
    }

    private void validateNewPlayerInstance(Intent intent) {
        boolean needNewPlayer;
        boolean bl = needNewPlayer = this.player == null;
        if (needNewPlayer) {
            TrackSelection.Factory trackSelectionFactory;
            String abrAlgorithm = intent.getStringExtra("abr_algorithm");
            if (abrAlgorithm == null || "default".equals(abrAlgorithm)) {
                trackSelectionFactory = new AdaptiveTrackSelection.Factory();
            } else if ("random".equals(abrAlgorithm)) {
                trackSelectionFactory = new RandomTrackSelection.Factory();
            } else {
                this.showToast("Unrecognized ABR algorithm");
                return;
            }
            this.lastSeenTrackGroupArray = null;
            this.eventLogger = new EventLogger(this.trackSelector);
            this.trackSelector = new DefaultTrackSelector(this.context, trackSelectionFactory);
            this.trackSelector.setParameters(this.trackSelectorParameters);
            this.lastSeenTrackGroupArray = null;
            this.setDefaultMaxBitrate();
            if (bandwidthMeter == null) {
                bandwidthMeter = new DefaultBandwidthMeter.Builder(this.context).build();
            }
            this.player = new SimpleExoPlayer.Builder(this.context, DataSourceBuilder.buildRendererFactory(this.context, intent.getBooleanExtra("prefer_extension_decoders", false))).setMediaSourceFactory(new DefaultMediaSourceFactory(this.mediaDataSourceFactory, this.trackSelector)).setLoadControl(AMPPreSettings.getPreSettingsInstance().getDefaultLoadControl()).setTrackSelector(this.trackSelector).setBandwidthMeter(bandwidthMeter).build();
            this.player.addListener(new PlayerEventListener());
            this.player.setAudioAttributes(AudioAttributes.DEFAULT, false);
            if (this.exoEventListener != null) {
                this.player.addListener(this.exoEventListener);
            }
            this.player.setRepeatMode(this.repeatMode);
            this.player.addMetadataOutput(this.defaultMetaDataOutput);
            this.player.setPlayWhenReady(this.shouldAutoPlay);
            this.onPlayerCreated();
        }
    }

    public AmpBasePlayer getPlayer() {
        return this.player;
    }

    public void releasePlayer() {
        if (this.player != null) {
            this.shouldAutoPlay = this.player.getPlayWhenReady();
            this.updateResumePosition();
            this.player.release();
            this.player = null;
            this.trackSelector = null;
            this.eventLogger = null;
            this.commonMediaClientDataProxy = null;
            this.nullifyErrorEventListeners();
        }
    }

    public void setBandwidthMeter(BandwidthMeter bandwidthMeter) {
        ExoWrapper.bandwidthMeter = bandwidthMeter;
    }

    private void updateResumePosition() {
        this.resumeWindow = this.player.getCurrentWindowIndex();
        this.resumePosition = this.player.getContentPosition();
    }

    private void clearResumePosition() {
        this.resumeWindow = -1;
        this.resumePosition = -1L;
    }

    private void showToast(int messageId) {
        this.showToast(this.getString(messageId));
    }

    private void showToast(String message) {
        LogManager.error(TAG, message);
    }

    private static boolean isBehindLiveWindow(ExoPlaybackException e) {
        if (e.type != 0) {
            return false;
        }
        for (Throwable cause = e.getSourceException(); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof BehindLiveWindowException)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private MediaSource buildMediaSource(Uri uri, String overrideExtension, @Nullable Handler handler, @Nullable MediaSourceEventListener listener, DrmSessionManager drmSessionManager) {
        overrideExtension = this.checkMissingExtension(uri, overrideExtension);
        Intent mediaIntent = IntentUtil.getIntentFromMediaSource(this.mediaResource);
        MediaItem mediaItem = IntentUtil.createMediaItemFromIntent(this.mediaResource, mediaIntent);
        DownloadRequest downloadRequest = this.getDownloadRequest(uri);
        if (downloadRequest != null) {
            MediaItem.Builder builder = mediaItem.buildUpon();
            this.downloadMediaItem = builder.setMediaId(downloadRequest.id).setUri(downloadRequest.uri).setCustomCacheKey(downloadRequest.customCacheKey).setMimeType(downloadRequest.mimeType).setStreamKeys(downloadRequest.streamKeys).setDrmKeySetId(downloadRequest.keySetId).setDrmLicenseRequestHeaders(this.getDrmHeaders()).build();
            return null;
        }
        this.type = TextUtils.isEmpty((CharSequence)overrideExtension) ? Util.inferContentType(uri) : Util.inferContentType("." + overrideExtension);
        MediaSource mediaSource = this.buildMediaSource(this.type, uri, drmSessionManager);
        this.addMediaSourceEventListener(mediaSource, handler, listener);
        return mediaSource;
    }

    private Map<String, String> getDrmHeaders() {
        Map<String, String> drmHeaders = AMPPreSettings.getPreSettingsInstance().getDrmLicenseHeaders();
        if (drmHeaders == null || drmHeaders.isEmpty()) {
            drmHeaders = AMPPreSettings.getPreSettingsInstance().getHttpHeaders();
        }
        return drmHeaders;
    }

    private void setDataSourceFactory() {
        DataSource.Factory downloadDataSourceFactory = this.getDownloadDataSourceFactory();
        if (downloadDataSourceFactory != null) {
            this.mediaDataSourceFactory = downloadDataSourceFactory;
        } else if (this.mediaDataSourceFactory == null) {
            this.localPathProvider = new LocalPathProvider(this.context);
            this.mediaDataSourceFactory = DataSourceBuilder.buildDataSourceFactory(this.context, this.localPathProvider);
        }
    }

    public int getStreamType() {
        return this.type;
    }

    private MediaSource buildMediaSource(int type, Uri uri, DrmSessionManager drmSessionManager) {
        switch (type) {
            case 0: {
                this.protocol = "MPEG-DASH";
                return new DashMediaSource.Factory(this.mediaDataSourceFactory).setDrmSessionManager(drmSessionManager).createMediaSource(MediaItem.fromUri(uri));
            }
            case 1: {
                this.protocol = "Smooth";
                return new SsMediaSource.Factory(this.mediaDataSourceFactory).setDrmSessionManager(drmSessionManager).createMediaSource(MediaItem.fromUri(uri));
            }
            case 2: {
                this.protocol = "HLS";
                return new HlsMediaSource.Factory(this.mediaDataSourceFactory).setDrmSessionManager(drmSessionManager).setAllowChunklessPreparation(AMPPreSettings.getPreSettingsInstance().allowChunklessPreparation()).createMediaSource(MediaItem.fromUri(uri));
            }
            case 3: {
                this.protocol = "PMD";
                return new ProgressiveMediaSource.Factory(this.mediaDataSourceFactory).setDrmSessionManager(drmSessionManager).createMediaSource(MediaItem.fromUri(uri));
            }
        }
        return null;
    }

    private void addMediaSourceEventListener(MediaSource mediaSource, @Nullable Handler handler, @Nullable MediaSourceEventListener listener) {
        if (handler != null && listener != null) {
            mediaSource.addEventListener(handler, listener);
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setDownloadRequestProvider(DownloadRequestProvider p) {
        this.downloadRequestProvider = p;
    }

    private DownloadRequest getDownloadRequest(Uri uri) {
        if (this.downloadRequestProvider == null) {
            return null;
        }
        return this.downloadRequestProvider.getDownloadRequest(uri);
    }

    private DataSource.Factory getDownloadDataSourceFactory() {
        if (this.downloadRequestProvider == null) {
            return null;
        }
        return this.downloadRequestProvider.getDataSource();
    }

    public float getPlaybackRate() {
        return this.playbackRate;
    }

    public long getBufferAvailable() {
        return this.bufferAvailable;
    }

    public long getLatency() {
        return this.latency;
    }

    public void adjustPlaybackRate() {
        if (this.player != null) {
            LowLatencySettings lowLatencySettings = AMPPreSettings.getPreSettingsInstance().getLowLatencySettings();
            this.bufferAvailable = this.getAvailableBuffer();
            if (lowLatencySettings.isLowLatencyTurnedOn() && this.playbackRate < 1.3f) {
                float defaultPlaybackPitch = 1.0f;
                float defaultPlaybackSpeed = 1.0f;
                float spedUpPlaybackSpeed = 1.2f;
                float targetBufferSize = lowLatencySettings.getTargetLowLatencyBuffer() + 1000;
                float maxLowLatencyBufferSize = lowLatencySettings.getMaxLowLatencyBuffer();
                if ((float)this.bufferAvailable >= maxLowLatencyBufferSize && lowLatencySettings.allowSeekJumps()) {
                    this.seekToClosestPositionToEdge();
                } else {
                    PlaybackParameters playbackParameters = this.player.getPlaybackParameters();
                    if ((float)this.bufferAvailable <= targetBufferSize && playbackParameters.speed > 1.0f) {
                        this.playbackRate = 1.0f;
                        Log.d(TAG, "buffer Available: " + this.bufferAvailable + ", playback speed 1X");
                        this.player.setPlaybackParameters(new PlaybackParameters(1.0f, 1.0f));
                    } else if ((float)this.bufferAvailable > targetBufferSize && playbackParameters.speed == 1.0f) {
                        this.playbackRate = 1.2f;
                        Log.d(TAG, "buffer Available: " + this.bufferAvailable + ", playback speed 1.2X");
                        this.player.setPlaybackParameters(new PlaybackParameters(1.2f, 1.0f));
                    }
                }
            }
        }
    }

    public void seekToClosestPositionToEdge() {
        if (this.player == null) {
            return;
        }
        float targetBufferSize = AMPPreSettings.getPreSettingsInstance().getLowLatencySettings().getTargetLowLatencyBuffer();
        long targetPosition = this.player.getDuration() - (long)((int)targetBufferSize);
        Log.d(TAG, "current position too far from the live edge, scrubbing to position " + targetPosition);
        this.player.seekTo(targetPosition);
    }

    private long getAvailableBuffer() {
        if (this.player != null) {
            return this.player.getBufferedPosition() - this.player.getCurrentPosition();
        }
        return 0L;
    }

    public void setSurfaceHolder(SurfaceHolder param) {
        this.surfaceHolder = param;
        if (this.player != null) {
            this.player.setVideoSurfaceHolder(this.surfaceHolder);
        }
    }

    public SurfaceHolder getSurfaceHolder() {
        return this.surfaceHolder;
    }

    public void setSurface(Surface surface) {
        this.surface = surface;
        if (this.player != null) {
            this.player.setVideoSurface(surface);
        }
    }

    public GLSurfaceView.Renderer getRenderer() {
        return null;
    }

    public void setVideoSurfaceHolder(SurfaceHolder surfaceHolder) {
        if (this.player != null) {
            this.player.setVideoSurfaceHolder(surfaceHolder);
        }
    }

    @Override
    public void onVideoSizeChanged(int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
        float aspectRatio = height == 0 ? 1.0f : (float)width * pixelWidthHeightRatio / (float)height;
        this.videoSizeEvents.videoSizeChanged(width, height);
        LogManager.log(TAG, "onVideoSizeChanged() " + width + "x" + height + " / Aspect ratio: " + aspectRatio);
    }

    @Override
    public void onRenderedFirstFrame() {
        LogManager.log(TAG, "onRenderedFirstFrame()");
    }

    public void setVideoPlayerContainer(VideoPlayerContainer container) {
        this.videoPlayerContainer = container;
        if (this.videoPlayerContainer.isCMCDEnabled()) {
            this.commonMediaClientDataProxy = new CMCDProxy();
            this.commonMediaClientDataProxy.clearAllData();
        }
    }

    public void setVideoSizeEvents(VideoPlayerViewExo.VideoStatsEvents videoSizeEvents) {
        this.videoSizeEvents = videoSizeEvents;
    }

    public long getCurrentBitrate() {
        if (this.player == null) {
            return 0L;
        }
        Format videoFormat = this.player.getVideoFormat();
        if (videoFormat == null) {
            return 0L;
        }
        int bitrate = videoFormat.bitrate;
        return bitrate == -1 ? this.getBitrateBySearching() : (long)bitrate;
    }

    private long getBitrateBySearching() {
        MappingTrackSelector.MappedTrackInfo trackInfo = this.trackSelector.getCurrentMappedTrackInfo();
        if (trackInfo == null) {
            return 0L;
        }
        TrackGroupArray trackGroupArray = trackInfo.getTrackGroups(0);
        TrackGroup trackGroup = trackGroupArray.get(0);
        for (int count = 0; count < trackGroup.length; ++count) {
            Format format = trackGroup.getFormat(count);
            if (format.width != this.player.getVideoFormat().width) continue;
            return format.bitrate;
        }
        return 0L;
    }

    public float getFrameRate() {
        return this.player != null && this.player.getVideoFormat() != null ? this.player.getVideoFormat().frameRate : 0.0f;
    }

    public long getCurrentPositionMillis() {
        if (this.player == null) {
            return 0L;
        }
        long currentPosition = this.player.getCurrentPosition();
        return currentPosition;
    }

    public int getCurrentPositionSeconds() {
        if (this.player == null) {
            return 0;
        }
        long millis = this.getCurrentPositionMillis();
        int seconds = this.millisToSeconds(millis);
        return seconds;
    }

    public long getDurationMillis() {
        if (this.player == null) {
            return 0L;
        }
        long duration = this.player.getDuration();
        if (duration == -9223372036854775807L) {
            return 0L;
        }
        return duration;
    }

    public int getDurationSeconds() {
        return this.millisToSeconds(this.getDurationMillis());
    }

    private int millisToSeconds(long millis) {
        if (millis == 0L) {
            return 0;
        }
        int seconds = this.roundToNearestSecond(millis);
        return seconds;
    }

    private int roundToNearestSecond(long millis) {
        return (int)((millis + 500L) / 1000L);
    }

    public int getPlaybackState() {
        if (this.player == null) {
            return 4;
        }
        return this.player.getPlaybackState();
    }

    public void setPlaybackRate(float rate, float pitch) {
        if (this.player != null) {
            this.playbackRate = rate;
            this.player.setPlaybackParameters(new PlaybackParameters(rate, pitch));
        }
    }

    public boolean getPlayWhenReady() {
        if (this.player != null) {
            return this.player.getPlayWhenReady();
        }
        return false;
    }

    public boolean isLive() {
        if (this.mediaSource == null) {
            return false;
        }
        return this.mediaSource.isLive();
    }

    public void setTextRendererOutput(TextOutput output) {
        this.textRendererOutput = output;
        if (this.player == null) {
            return;
        }
        this.player.addTextOutput(this.textRendererOutput);
    }

    public void clearTextOutput(TextOutput output) {
        this.textRendererOutput = null;
        if (this.player == null) {
            return;
        }
        this.player.addTextOutput(output);
    }

    public List<Cue> getThumbnail(long position) {
        if (this.player == null) {
            return null;
        }
        return this.player.getCueByPosition(position);
    }

    public void enableCloseCaptions() {
        this.closeCaptionsEnabled = true;
    }

    private void doEnableCloseCaptions() {
        if (!this.validateIndexes()) {
            return;
        }
        MappingTrackSelector.MappedTrackInfo currentMappedTrackInfo = this.trackSelector.getCurrentMappedTrackInfo();
        TrackGroupArray trackGroups = currentMappedTrackInfo.getTrackGroups(2);
        DefaultTrackSelector.SelectionOverride override = new DefaultTrackSelector.SelectionOverride(this.trackIndex, this.formatIndex);
        this.applySelection(2, trackGroups, override);
        LogManager.log(TAG, "Enabled Close Captions, track " + this.trackIndex + ", format " + this.formatIndex);
    }

    private void applySelection(int rendererIndex, TrackGroupArray trackGroups, DefaultTrackSelector.SelectionOverride override) {
        DefaultTrackSelector.ParametersBuilder parametersBuilder = this.trackSelector.buildUponParameters();
        parametersBuilder.setRendererDisabled(rendererIndex, false);
        if (override != null) {
            parametersBuilder.setSelectionOverride(rendererIndex, trackGroups, override);
        } else {
            parametersBuilder.clearSelectionOverrides(rendererIndex);
        }
        this.trackSelector.setParameters(parametersBuilder);
    }

    private boolean validateIndexes() {
        if (this.trackSelector == null) {
            return false;
        }
        MappingTrackSelector.MappedTrackInfo currentMappedTrackInfo = this.trackSelector.getCurrentMappedTrackInfo();
        if (currentMappedTrackInfo == null) {
            return false;
        }
        TrackGroupArray trackGroups = currentMappedTrackInfo.getTrackGroups(2);
        if (trackGroups == null) {
            return false;
        }
        if (this.trackIndex < 0 || this.trackIndex >= trackGroups.length) {
            return false;
        }
        TrackGroup trackGroup = trackGroups.get(this.trackIndex);
        if (trackGroup == null) {
            return false;
        }
        return this.formatIndex >= 0 && this.formatIndex < trackGroup.length;
    }

    public Map<Pair<Integer, Integer>, String> getDataTracks() {
        LinkedHashMap<Pair<Integer, Integer>, String> formats = new LinkedHashMap<Pair<Integer, Integer>, String>();
        if (this.trackSelector == null) {
            return formats;
        }
        MappingTrackSelector.MappedTrackInfo currentMappedTrackInfo = this.trackSelector.getCurrentMappedTrackInfo();
        if (currentMappedTrackInfo == null) {
            return formats;
        }
        TrackGroupArray trackGroups = currentMappedTrackInfo.getTrackGroups(2);
        if (trackGroups.length <= 0) {
            return formats;
        }
        for (int trackGroupIndex = 0; trackGroupIndex < trackGroups.length; ++trackGroupIndex) {
            TrackGroup tg = trackGroups.get(trackGroupIndex);
            for (int formatIndex = 0; formatIndex < tg.length; ++formatIndex) {
                Format f = tg.getFormat(formatIndex);
                String trackName = TrackNameBuilder.buildTrackName(f);
                Pair indexes = new Pair((Object)trackGroupIndex, (Object)formatIndex);
                formats.put((Pair<Integer, Integer>)indexes, trackName);
            }
        }
        return formats;
    }

    public List<Format> getDataFormats() {
        ArrayList<Format> formats = new ArrayList<Format>();
        if (this.trackSelector == null) {
            return formats;
        }
        MappingTrackSelector.MappedTrackInfo currentMappedTrackInfo = this.trackSelector.getCurrentMappedTrackInfo();
        if (currentMappedTrackInfo == null) {
            return formats;
        }
        TrackGroupArray trackGroups = currentMappedTrackInfo.getTrackGroups(2);
        if (trackGroups.length <= 0) {
            return formats;
        }
        for (int trackGroupIndex = 0; trackGroupIndex < trackGroups.length; ++trackGroupIndex) {
            TrackGroup tg = trackGroups.get(trackGroupIndex);
            for (int formatIndex = 0; formatIndex < tg.length; ++formatIndex) {
                Format f = tg.getFormat(formatIndex);
                formats.add(f);
            }
        }
        return formats;
    }

    public void setTrackIndex(int i) {
        this.trackIndex = i;
        this.doEnableCloseCaptions();
    }

    public void setFormatIndex(int i) {
        this.formatIndex = i;
        this.doEnableCloseCaptions();
    }

    public void setTrackIndexes(int trackIndex, int formatIndex) {
        this.trackIndex = trackIndex;
        this.formatIndex = formatIndex;
        this.doEnableCloseCaptions();
    }

    public void sideload(List<SideloadedCaptionsData> captions) {
        this.sideloadedCaptionsData = captions;
        if (this.mediaSource == null) {
            return;
        }
        this.mediaSource = this.mergeWithCaptions(this.mediaSource, captions);
    }

    private MergingMediaSource mergeWithCaptions(MediaSource videoSource, List<SideloadedCaptionsData> captions) {
        ArrayList<MediaSource> mediaSources = new ArrayList<MediaSource>();
        mediaSources.add(videoSource);
        for (SideloadedCaptionsData s : captions) {
            MediaSource subtitleSource = this.buildCaptionsMediaSource(s);
            mediaSources.add(subtitleSource);
        }
        MediaSource[] array = mediaSources.toArray(new MediaSource[mediaSources.size()]);
        MergingMediaSource mergingMediaSource = new MergingMediaSource(array);
        return mergingMediaSource;
    }

    private MediaSource buildCaptionsMediaSource(SideloadedCaptionsData captions) {
        Uri subtitleUri = Uri.parse((String)captions.getSubtitleUriString());
        String mimeType = captions.getSubtitleMimeType();
        if ("application/x-mpegURL".equals(mimeType)) {
            return new HlsMediaSource.Factory(this.mediaDataSourceFactory).setPlaylistParserFactory(new DefaultHlsPlaylistParserFactory()).createMediaSource(subtitleUri);
        }
        Format subtitleFormat = Format.createTextSampleFormat(captions.getSubtitleIdentifier(), mimeType, 2, captions.getSubtitleLanguage());
        return new SingleSampleMediaSource.Factory(this.mediaDataSourceFactory, this.trackSelector).createMediaSource(subtitleUri, subtitleFormat, -9223372036854775807L);
    }

    @Override
    public void mute() {
        MuteHelper.mute(this.player);
    }

    @Override
    public void unmute() {
        MuteHelper.unmute(this.player);
    }

    @Override
    public void setVolume(float volume) {
        MuteHelper.trySetVolume(this.player, volume);
    }

    public void selectAudioTrack(int trackGroupIndex) {
        this.currentAudioTrackIndex = trackGroupIndex;
        if (this.trackSelector == null) {
            return;
        }
        TrackGroupArray trackGroups = this.getAudioTrackArray();
        DefaultTrackSelector.Parameters parameters = this.trackSelector.getParameters();
        if (trackGroups.length <= 0) {
            return;
        }
        DefaultTrackSelector.ParametersBuilder builder = parameters.buildUpon();
        builder.clearSelectionOverrides(1);
        builder.setSelectionOverride(1, trackGroups, this.getOverride(trackGroupIndex));
        this.trackSelector.setParameters(builder);
    }

    public TrackGroupArray getAudioTrackArray() {
        if (this.trackSelector == null) {
            return null;
        }
        MappingTrackSelector.MappedTrackInfo currentMappedTrackInfo = this.trackSelector.getCurrentMappedTrackInfo();
        if (currentMappedTrackInfo != null) {
            return currentMappedTrackInfo.getTrackGroups(1);
        }
        return null;
    }

    public TrackGroupArray getVideoTrackArray() {
        if (this.trackSelector == null) {
            return null;
        }
        MappingTrackSelector.MappedTrackInfo currentMappedTrackInfo = this.trackSelector.getCurrentMappedTrackInfo();
        if (currentMappedTrackInfo == null) {
            return null;
        }
        return currentMappedTrackInfo.getTrackGroups(0);
    }

    private DefaultTrackSelector.SelectionOverride getOverride(int audioIndex) {
        return new DefaultTrackSelector.SelectionOverride(audioIndex, 0);
    }

    public int getCurrentAudioTrackIndex() {
        return this.currentAudioTrackIndex;
    }

    public int getBitratesCount() {
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo = this.trackSelector.getCurrentMappedTrackInfo();
        if (mappedTrackInfo != null) {
            TrackGroupArray trackGroups = mappedTrackInfo.getTrackGroups(0);
            return trackGroups.get((int)0).length;
        }
        return 0;
    }

    public int getBitrateByIndex(int index) {
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo = this.trackSelector.getCurrentMappedTrackInfo();
        if (mappedTrackInfo != null) {
            TrackGroupArray trackGroups = mappedTrackInfo.getTrackGroups(0);
            return trackGroups.get((int)0).getFormat((int)index).bitrate;
        }
        return 0;
    }

    public void setBitrateIndexForPlay(int index) {
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo = this.trackSelector.getCurrentMappedTrackInfo();
        if (mappedTrackInfo != null) {
            TrackGroupArray trackGroups = mappedTrackInfo.getTrackGroups(0);
            if (index <= trackGroups.get((int)0).length) {
                DefaultTrackSelector.ParametersBuilder parametersBuilder = this.trackSelector.buildUponParameters();
                parametersBuilder.setRendererDisabled(0, false);
                TrackGroup videoTracks = trackGroups.get(0);
                int mainIndexCounter = 0;
                for (int realIndex = 0; realIndex < videoTracks.length; ++realIndex) {
                    Format format = videoTracks.getFormat(realIndex);
                    if (format.roleFlags == 16384) continue;
                    if (mainIndexCounter == index) {
                        DefaultTrackSelector.SelectionOverride override = new DefaultTrackSelector.SelectionOverride(0, realIndex);
                        parametersBuilder.setSelectionOverride(0, trackGroups, override);
                        this.trackSelector.setParameters(parametersBuilder);
                        LogManager.log(TAG, "setBitrateIndexForPlay " + index);
                        return;
                    }
                    ++mainIndexCounter;
                }
            }
        }
    }

    public int getSelectionOverride() {
        if (this.trackSelector == null) {
            return -1;
        }
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo = this.trackSelector.getCurrentMappedTrackInfo();
        if (mappedTrackInfo != null) {
            TrackGroupArray trackGroups = mappedTrackInfo.getTrackGroups(0);
            DefaultTrackSelector.SelectionOverride selectionOverride = this.trackSelector.getParameters().getSelectionOverride(0, trackGroups);
            if (selectionOverride != null) {
                return selectionOverride.tracks[0];
            }
        }
        return -1;
    }

    public int getIndexByBitRate(int bitrate) {
        TrackGroup videoTrackGroup = this.getTrackGroup(0);
        for (int count = 0; count < videoTrackGroup.length; ++count) {
            Format format = videoTrackGroup.getFormat(count);
            if (format.bitrate != bitrate) continue;
            return count;
        }
        return 0;
    }

    public HashMap<Integer, Integer> getAvailableBitrates() {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        TrackGroup videoTrackGroup = this.getTrackGroup(0);
        for (int count = 0; count < videoTrackGroup.length; ++count) {
            Format format = videoTrackGroup.getFormat(count);
            hashMap.put(count, format.bitrate);
        }
        return hashMap;
    }

    private TrackGroup getTrackGroup(int trackIndex) {
        if (this.trackSelector == null) {
            return null;
        }
        MappingTrackSelector.MappedTrackInfo trackInfo = this.trackSelector.getCurrentMappedTrackInfo();
        if (trackInfo == null) {
            return null;
        }
        TrackGroupArray trackGroup = trackInfo.getTrackGroups(trackIndex);
        TrackGroup first = trackGroup.get(0);
        return first;
    }

    public List<QualityLevel> getQualityLevels() {
        ArrayList<QualityLevel> qualityLevels = new ArrayList<QualityLevel>();
        TrackGroup videoTrackGroup = this.getTrackGroup(0);
        if (videoTrackGroup == null) {
            return qualityLevels;
        }
        for (int i = 0; i < videoTrackGroup.length; ++i) {
            Format format = videoTrackGroup.getFormat(i);
            if (format.roleFlags == 16384) continue;
            QualityLevel level = new QualityLevel(format.bitrate, format.width, format.height);
            qualityLevels.add(level);
        }
        return qualityLevels;
    }

    public void setQualityLevel(int index) {
        if (index != -1) {
            this.selectedQualityLevel = index;
            this.setBitrateIndexForPlay(this.selectedQualityLevel);
        } else {
            this.clearBitrateSelection();
        }
    }

    private void clearBitrateSelection() {
        DefaultTrackSelector.ParametersBuilder parametersBuilder = this.trackSelector.buildUponParameters();
        parametersBuilder.clearSelectionOverrides(0);
        this.trackSelector.setParameters(parametersBuilder);
    }

    public void setVideoPlayerAsErrorListener(VideoPlayerViewExo playerView) {
        this.exoPlayerEventListener = playerView;
        this.adaptiveMediaSourceEventListener = playerView;
    }

    public void nullifyErrorEventListeners() {
        this.setVideoPlayerAsErrorListener(null);
    }

    public void setMetadataListener(MetadataOutput metadataListener) {
        this.metadaRenderer = metadataListener;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void play(MediaResource mediaResource) {
        this.play(mediaResource, -1);
    }

    public void play(MediaResource mediaResource, int position) {
        if (this.videoPlayerContainer.isCMCDEnabled()) {
            this.commonMediaClientDataProxy.clearAllData();
        }
        this.setMediaResource(mediaResource);
        this.resumeWindow = 0;
        if (position > 0) {
            this.resumePosition = position * 1000;
        }
        this.initializePlayer();
        this.checkAddSubtitles();
        LogManager.log(TAG, "Using MODE_EXO2 v2.12.3 to play " + mediaResource.getMimeType());
    }

    public void setMediaResource(MediaResource mediaResource) {
        this.mediaResource = mediaResource;
    }

    public void seekToSeconds(int seconds) {
        long millis = seconds * 1000;
        this.seekToMillis(millis);
    }

    public void seekToMillis(long millis) {
        if (this.player != null) {
            this.player.seekTo(millis);
        }
    }

    public void seekToDefaultPosition() {
        if (this.player != null) {
            this.player.seekToDefaultPosition();
        }
    }

    public void pause() {
        this.setPlayWhenReady(false);
    }

    public void resume() {
        this.setPlayWhenReady(true);
    }

    public void setPlayWhenReady(boolean b) {
        if (this.player != null) {
            this.player.setPlayWhenReady(b);
        }
    }

    public void stop() {
        this.releasePlayer();
    }

    public int getBufferedPercentage() {
        int bufferedPercentage = 0;
        if (this.player != null) {
            bufferedPercentage = this.player.getBufferedPercentage();
        }
        return bufferedPercentage;
    }

    public void onDestroy() {
        this.releasePlayer();
    }

    public void checkInitializePlayer() {
        if (this.player == null) {
            this.initializePlayer();
        }
    }

    private String getString(int messageId) {
        return ExoMessages.getResource(messageId);
    }

    private String getString(int error_no_secure_decoder, String mimeType) {
        return String.format("%s %s", this.getString(error_no_secure_decoder), mimeType);
    }

    private void checkAddSubtitles() {
        if (this.sideloadedCaptionsData != null) {
            this.sideload(this.sideloadedCaptionsData);
        } else if (this.closeCaptionsEnabled) {
            this.doEnableCloseCaptions();
        }
    }

    private void setDefaultMaxBitrate() {
        DefaultTrackSelector.ParametersBuilder parameters = this.trackSelector.getParameters().buildUpon();
        parameters.setMaxVideoBitrate(this.maxBitrate);
        this.trackSelector.setParameters(parameters.build());
    }

    public void setMaxBitrate(int maxBitrate) {
        this.maxBitrate = maxBitrate;
    }

    private VideoPlayerViewExo getExoWrapper2() {
        if (!this.videoPlayerContainer.isVideoPlayerViewAvailable()) {
            return null;
        }
        VideoPlayerView videoPlayer = this.videoPlayerContainer.getVideoPlayer();
        return (VideoPlayerViewExo)videoPlayer;
    }

    private void onPlayerCreated() {
        VideoPlayerViewExo exoWrapper2;
        if (this.eventLogger == null) {
            this.eventLogger = new EventLogger(this.trackSelector);
        }
        if (LogManager.isLogEnabled()) {
            this.player.addListener(new PlayerEventListener());
            this.player.addAnalyticsListener(this.eventLogger);
        }
        this.player.addListener(this.exoPlayerEventListener);
        this.player.addVideoListener(this);
        this.player.setVideoSurfaceHolder(this.surfaceHolder);
        if (this.surface != null) {
            this.player.setVideoSurface(this.surface);
        }
        if (this.textRendererOutput != null) {
            this.player.addTextOutput(this.textRendererOutput);
        }
        if (this.sideloadedCaptionsData != null) {
            this.sideload(this.sideloadedCaptionsData);
        }
        if ((exoWrapper2 = this.getExoWrapper2()) != null) {
            this.player.addListener(exoWrapper2);
        }
    }

    private String checkMissingExtension(Uri uri, String overrideExtension) {
        boolean emptyExtension = TextUtils.isEmpty((CharSequence)overrideExtension);
        if (emptyExtension && uri != null) {
            String url = uri.toString();
            boolean hasMPDExtension = url.endsWith(MPD_ISM_EXTENSION);
            if (hasMPDExtension) {
                return "mpd";
            }
            boolean hasHLSExtension = url.contains("m3u8");
            if (hasHLSExtension) {
                return "m3u8";
            }
        }
        return overrideExtension;
    }

    public void setIsOnResume() {
        this.isOnResume = true;
    }

    private void onStateReady() {
        if (this.isOnResume && this.selectedQualityLevel != -1) {
            this.isOnResume = false;
            this.setQualityLevel(this.selectedQualityLevel);
        }
        this.checkAddSubtitles();
    }

    public boolean isAtLivePoint(long currentPosition) {
        if (this.player == null) {
            return false;
        }
        Timeline.Window window = new Timeline.Window();
        this.player.getCurrentTimeline().getWindow(this.player.getCurrentWindowIndex(), window);
        long liveWindowEdgeInSeconds = window.getDefaultPositionMs() / 1000L;
        return currentPosition >= liveWindowEdgeInSeconds;
    }

    public long getWindowStartTime() {
        long windowStartTimeMs;
        Timeline timeline;
        if (this.player != null && !(timeline = this.player.getCurrentTimeline()).isEmpty() && (windowStartTimeMs = timeline.getWindow((int)0, (Timeline.Window)new Timeline.Window()).windowStartTimeMs) != -9223372036854775807L) {
            return this.millisToSeconds(windowStartTimeMs);
        }
        return -9223372036854775807L;
    }

    public long getCurrentPositionPeriod() {
        if (this.player != null) {
            long position = this.getCurrentPositionMillis();
            Timeline currentTimeline = this.player.getCurrentTimeline();
            if (!currentTimeline.isEmpty()) {
                position -= currentTimeline.getPeriod(this.player.getCurrentPeriodIndex(), new Timeline.Period()).getPositionInWindowMs();
            }
            return position;
        }
        return -9223372036854775807L;
    }

    public void updateCMCD(String ... dataValues) {
        if (!this.videoPlayerContainer.isCMCDEnabled()) {
            return;
        }
        if (this.commonMediaClientDataProxy == null) {
            return;
        }
        String[] stringArray = dataValues;
        int n = stringArray.length;
        block16: for (int i = 0; i < n; ++i) {
            String dataValue;
            switch (dataValue = stringArray[i]) {
                case "br": {
                    this.commonMediaClientDataProxy.updateEncodedBitrate(this.getCurrentBitrate() / 1000L);
                    continue block16;
                }
                case "sid": {
                    this.commonMediaClientDataProxy.updateSessionId(this.sessionId);
                    continue block16;
                }
                case "st": {
                    this.commonMediaClientDataProxy.updateStreamType(this.isLive());
                    continue block16;
                }
                case "sf": {
                    this.commonMediaClientDataProxy.updateStreamFormat(this.protocol);
                    continue block16;
                }
                case "pr": {
                    this.commonMediaClientDataProxy.updatePlaybackRate(Float.valueOf(this.playbackRate), !this.getPlayWhenReady());
                    continue block16;
                }
                case "tb": {
                    QualityLevel topQualityLevel = this.getQualityLevels().get(this.getQualityLevels().size() - 1);
                    int topBitrate = topQualityLevel.getBitrateInBitsPerSecond() / 1000;
                    this.commonMediaClientDataProxy.updateTopBitrate(topBitrate);
                }
            }
        }
    }

    static {
        DEFAULT_COOKIE_MANAGER = new CookieManager();
        DEFAULT_COOKIE_MANAGER.setCookiePolicy(CookiePolicy.ACCEPT_ORIGINAL_SERVER);
    }

    private class PlayerEventListener
    implements Player.EventListener {
        private PlayerEventListener() {
        }

        @Override
        public void onPlaybackStateChanged(int playbackState) {
            if (playbackState == 3) {
                ExoWrapper.this.onStateReady();
            }
        }

        @Override
        public void onPositionDiscontinuity(int reason) {
            if (ExoWrapper.this.inErrorState) {
                ExoWrapper.this.updateResumePosition();
            }
        }

        @Override
        public void onPlayerError(ExoPlaybackException e) {
            Exception cause;
            String errorString = null;
            if (e.type == 1 && (cause = e.getRendererException()) instanceof MediaCodecRenderer.DecoderInitializationException) {
                MediaCodecRenderer.DecoderInitializationException decoderInitializationException = (MediaCodecRenderer.DecoderInitializationException)cause;
                errorString = decoderInitializationException.codecInfo == null ? (decoderInitializationException.getCause() instanceof MediaCodecUtil.DecoderQueryException ? ExoWrapper.this.getString(6) : (decoderInitializationException.secureDecoderRequired ? ExoWrapper.this.getString(5, decoderInitializationException.mimeType) : ExoWrapper.this.getString(4, decoderInitializationException.mimeType))) : ExoWrapper.this.getString(7, decoderInitializationException.codecInfo.name);
            }
            if (errorString != null) {
                ExoWrapper.this.showToast(errorString);
            }
            ExoWrapper.this.inErrorState = true;
            if (ExoWrapper.isBehindLiveWindow(e)) {
                ExoWrapper.this.clearResumePosition();
                ExoWrapper.this.initializePlayer();
            } else {
                ExoWrapper.this.updateResumePosition();
            }
        }

        @Override
        public void onTracksChanged(TrackGroupArray trackGroups, TrackSelectionArray trackSelections) {
            if (trackGroups != ExoWrapper.this.lastSeenTrackGroupArray) {
                MappingTrackSelector.MappedTrackInfo mappedTrackInfo = ExoWrapper.this.trackSelector.getCurrentMappedTrackInfo();
                if (mappedTrackInfo != null) {
                    if (mappedTrackInfo.getTypeSupport(2) == 1) {
                        ExoWrapper.this.showToast(8);
                    }
                    if (mappedTrackInfo.getTypeSupport(1) == 1) {
                        ExoWrapper.this.showToast(9);
                    }
                }
                ExoWrapper.this.lastSeenTrackGroupArray = trackGroups;
            }
        }
    }
}

