/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.metadata;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.BaseRenderer;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.FormatHolder;
import com.akamai.amp.exoplayer2.RendererCapabilities;
import com.akamai.amp.exoplayer2.metadata.Metadata;
import com.akamai.amp.exoplayer2.metadata.MetadataDecoder;
import com.akamai.amp.exoplayer2.metadata.MetadataDecoderFactory;
import com.akamai.amp.exoplayer2.metadata.MetadataInputBuffer;
import com.akamai.amp.exoplayer2.metadata.MetadataOutput;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.compatqual.NullableType;

public final class MetadataRenderer
extends BaseRenderer
implements Handler.Callback {
    private static final String TAG = "MetadataRenderer";
    private static final int MSG_INVOKE_RENDERER = 0;
    private static final int MAX_PENDING_METADATA_COUNT = 5;
    private final MetadataDecoderFactory decoderFactory;
    private final MetadataOutput output;
    @Nullable
    private final Handler outputHandler;
    private final MetadataInputBuffer buffer;
    private final @NullableType Metadata[] pendingMetadata;
    private final long[] pendingMetadataTimestamps;
    private int pendingMetadataIndex;
    private int pendingMetadataCount;
    @Nullable
    private MetadataDecoder decoder;
    private boolean inputStreamEnded;
    private long subsampleOffsetUs;

    public MetadataRenderer(MetadataOutput output, @Nullable Looper outputLooper) {
        this(output, outputLooper, MetadataDecoderFactory.DEFAULT);
    }

    public MetadataRenderer(MetadataOutput output, @Nullable Looper outputLooper, MetadataDecoderFactory decoderFactory) {
        super(4);
        this.output = Assertions.checkNotNull(output);
        this.outputHandler = outputLooper == null ? null : Util.createHandler(outputLooper, this);
        this.decoderFactory = Assertions.checkNotNull(decoderFactory);
        this.buffer = new MetadataInputBuffer();
        this.pendingMetadata = new Metadata[5];
        this.pendingMetadataTimestamps = new long[5];
    }

    @Override
    public String getName() {
        return TAG;
    }

    @Override
    public int supportsFormat(Format format) {
        if (this.decoderFactory.supportsFormat(format)) {
            return RendererCapabilities.create(format.exoMediaCryptoType == null ? 4 : 2);
        }
        return RendererCapabilities.create(0);
    }

    @Override
    protected void onStreamChanged(Format[] formats, long startPositionUs, long offsetUs) {
        this.decoder = this.decoderFactory.createDecoder(formats[0]);
    }

    @Override
    protected void onPositionReset(long positionUs, boolean joining) {
        this.flushPendingMetadata();
        this.inputStreamEnded = false;
    }

    @Override
    public void render(long positionUs, long elapsedRealtimeUs) {
        if (!this.inputStreamEnded && this.pendingMetadataCount < 5) {
            this.buffer.clear();
            FormatHolder formatHolder = this.getFormatHolder();
            int result = this.readSource(formatHolder, this.buffer, false);
            if (result == -4) {
                if (this.buffer.isEndOfStream()) {
                    this.inputStreamEnded = true;
                } else {
                    this.buffer.subsampleOffsetUs = this.subsampleOffsetUs;
                    this.buffer.flip();
                    Metadata metadata = Util.castNonNull(this.decoder).decode(this.buffer);
                    if (metadata != null) {
                        ArrayList<Metadata.Entry> entries = new ArrayList<Metadata.Entry>(metadata.length());
                        this.decodeWrappedMetadata(metadata, entries);
                        if (!entries.isEmpty()) {
                            Metadata expandedMetadata = new Metadata(entries);
                            int index = (this.pendingMetadataIndex + this.pendingMetadataCount) % 5;
                            this.pendingMetadata[index] = expandedMetadata;
                            this.pendingMetadataTimestamps[index] = this.buffer.timeUs;
                            ++this.pendingMetadataCount;
                        }
                    }
                }
            } else if (result == -5) {
                this.subsampleOffsetUs = Assertions.checkNotNull(formatHolder.format).subsampleOffsetUs;
            }
        }
        if (this.pendingMetadataCount > 0 && this.pendingMetadataTimestamps[this.pendingMetadataIndex] <= positionUs) {
            Metadata metadata = Util.castNonNull(this.pendingMetadata[this.pendingMetadataIndex]);
            this.invokeRenderer(metadata);
            this.pendingMetadata[this.pendingMetadataIndex] = null;
            this.pendingMetadataIndex = (this.pendingMetadataIndex + 1) % 5;
            --this.pendingMetadataCount;
        }
    }

    private void decodeWrappedMetadata(Metadata metadata, List<Metadata.Entry> decodedEntries) {
        for (int i = 0; i < metadata.length(); ++i) {
            Format wrappedMetadataFormat = metadata.get(i).getWrappedMetadataFormat();
            if (wrappedMetadataFormat != null && this.decoderFactory.supportsFormat(wrappedMetadataFormat)) {
                MetadataDecoder wrappedMetadataDecoder = this.decoderFactory.createDecoder(wrappedMetadataFormat);
                byte[] wrappedMetadataBytes = Assertions.checkNotNull(metadata.get(i).getWrappedMetadataBytes());
                this.buffer.clear();
                this.buffer.ensureSpaceForWrite(wrappedMetadataBytes.length);
                Util.castNonNull(this.buffer.data).put(wrappedMetadataBytes);
                this.buffer.flip();
                Metadata innerMetadata = wrappedMetadataDecoder.decode(this.buffer);
                if (innerMetadata == null) continue;
                this.decodeWrappedMetadata(innerMetadata, decodedEntries);
                continue;
            }
            decodedEntries.add(metadata.get(i));
        }
    }

    @Override
    protected void onDisabled() {
        this.flushPendingMetadata();
        this.decoder = null;
    }

    @Override
    public boolean isEnded() {
        return this.inputStreamEnded;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    private void invokeRenderer(Metadata metadata) {
        if (this.outputHandler != null) {
            this.outputHandler.obtainMessage(0, (Object)metadata).sendToTarget();
        } else {
            this.invokeRendererInternal(metadata);
        }
    }

    private void flushPendingMetadata() {
        Arrays.fill(this.pendingMetadata, null);
        this.pendingMetadataIndex = 0;
        this.pendingMetadataCount = 0;
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                this.invokeRendererInternal((Metadata)msg.obj);
                return true;
            }
        }
        throw new IllegalStateException();
    }

    private void invokeRendererInternal(Metadata metadata) {
        this.output.onMetadata(metadata);
    }
}

