/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.ads.ima;

import android.content.Context;
import com.akamai.amp.ads.ima.AmpDAIManager;
import com.akamai.amp.ads.ima.AmpIMAManager;
import com.akamai.amp.ads.ima.ClientSideAdsHandler;
import com.akamai.amp.ads.ima.IMABuilder;
import com.akamai.amp.ads.ima.ServerSideAdsHandler;
import com.google.ads.interactivemedia.v3.api.ImaSdkSettings;

public class IMA {
    public static IMABuilder create(Context context) {
        return new Builder(context);
    }

    public static class Builder
    implements IMABuilder {
        Context context;
        String fallbackURL;
        boolean disableAdsCountdown;
        ImaSdkSettings imaSdkSettings;

        public Builder(Context context) {
            this.context = context;
        }

        @Override
        public IMABuilder withFallbackURL(String fallbackURL) {
            this.fallbackURL = fallbackURL;
            return this;
        }

        @Override
        public IMABuilder withAdsCountdownDisabled(boolean disableAdsCountdown) {
            this.disableAdsCountdown = disableAdsCountdown;
            return this;
        }

        @Override
        public IMABuilder withImaSdkSettings(ImaSdkSettings imaSdkSettings) {
            this.imaSdkSettings = imaSdkSettings;
            return this;
        }

        @Override
        public AmpDAIManager buildServerSideManager() {
            return new ServerSideAdsHandler(this.context, this.fallbackURL, this.disableAdsCountdown, this.imaSdkSettings);
        }

        @Override
        public AmpIMAManager buildClientSideManager() {
            return new ClientSideAdsHandler(this.context, this.disableAdsCountdown, this.imaSdkSettings);
        }
    }
}

