/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.media;

import android.content.Context;
import android.net.Uri;
import android.opengl.GLSurfaceView;
import android.os.Looper;
import android.util.Log;
import android.util.Pair;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.MainThread;
import androidx.annotation.Nullable;
import com.akamai.amp.ThreadHolder;
import com.akamai.amp.downloader.DownloadRequestProvider;
import com.akamai.amp.exoplayer2.ExoPlaybackException;
import com.akamai.amp.exoplayer2.ExoPlayerImplInternal;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.PlaybackParameters;
import com.akamai.amp.exoplayer2.Player;
import com.akamai.amp.exoplayer2.Timeline;
import com.akamai.amp.exoplayer2.ampcustom.AmpBasePlayer;
import com.akamai.amp.exoplayer2.metadata.MetadataOutput;
import com.akamai.amp.exoplayer2.source.LoadEventInfo;
import com.akamai.amp.exoplayer2.source.MediaLoadData;
import com.akamai.amp.exoplayer2.source.MediaSource;
import com.akamai.amp.exoplayer2.source.MediaSourceEventListener;
import com.akamai.amp.exoplayer2.source.TrackGroupArray;
import com.akamai.amp.exoplayer2.text.Cue;
import com.akamai.amp.exoplayer2.text.TextOutput;
import com.akamai.amp.exoplayer2.trackselection.TrackSelectionArray;
import com.akamai.amp.exoplayer2.upstream.BandwidthMeter;
import com.akamai.amp.exoplayer2.upstream.HttpDataSource;
import com.akamai.amp.exoplayer2.util.Util;
import com.akamai.amp.id3.ID3TagEventListener;
import com.akamai.amp.id3.ID3TagsSessionHandler;
import com.akamai.amp.license.manager.RSALicenseDecryption;
import com.akamai.amp.media.VideoPlayerContainer;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.media.elements.QualityLevel;
import com.akamai.amp.media.errors.ErrorType;
import com.akamai.amp.media.exowrapper2.ExoWrapper;
import com.akamai.amp.media.exowrapper2.SideloadedCaptionsData;
import com.akamai.amp.media.mute.IMuteable;
import com.akamai.amp.media.mute.MuteHelper;
import com.akamai.amp.utils.LogManager;
import com.akamai.amp.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VideoPlayerViewExo
extends VideoPlayerView
implements SurfaceHolder.Callback,
Player.EventListener,
IMuteable,
MediaSourceEventListener {
    private static final String TAG = VideoPlayerViewExo.class.getSimpleName();
    private static final String METHOD_NOT_SUPPORTED = "() method not supported in MODE_EXO2";
    private static final int THUMBNAILS_RESERVED_INDEX = 0;
    private ExoWrapper exo;
    private final VideoPlayerContainer videoPlayerContainer;
    private ThreadHolder threadHolder;
    private boolean closeCaptionsEnabled = false;
    private TextOutput textRendererOutput;
    private List<SideloadedCaptionsData> sideloadedCaptionsData;
    private int trackIndex = -1;
    private int formatIndex = -1;
    private int selectedQualityLevel = -1;
    private boolean mSeeking = false;
    private boolean mBuffering = false;
    private boolean isResuming = false;
    private boolean isPlaybackReady = false;
    private boolean areThumbnailsEnabled = false;
    private String thumbnailsBasePath;
    private int mStartPositionInSeconds = 0;
    private long mCurrentBitrate = -1L;
    private long mBitrateBeforeSwitch = -1L;
    private int mBitrateSwitchUpCount = 0;
    private int mBitrateSwitchDownCount = 0;
    private float mFps = -1.0f;
    private long previousPositionSeconds = -1L;
    private boolean isDVREnabled = false;
    private boolean alreadySetRenderer = false;
    private String latestChunkUri = "";
    private DownloadRequestProvider downloadRequestProvider;
    private final ID3TagsSessionHandler id3TagsSessionHandler = new ID3TagsSessionHandler();
    private final VideoStatsEvents videoSizeEvents = new VideoStatsEvents(){

        @Override
        public void videoSizeChanged(int width, int height) {
            VideoPlayerViewExo.this.mVideoWidth = width;
            VideoPlayerViewExo.this.mVideoHeight = height;
            VideoPlayerViewExo.this.scaledWidth = width;
            VideoPlayerViewExo.this.scaledHeight = height;
            VideoPlayerViewExo.this.safeRun(VideoPlayerViewExo.this.mVideoSize);
        }

        @Override
        public void onChunkLoadCompleted(String uri) {
            VideoPlayerViewExo.this.latestChunkUri = uri;
            VideoPlayerViewExo.this.fireEvent(20);
            if (VideoPlayerViewExo.this.exo != null) {
                VideoPlayerViewExo.this.exo.adjustPlaybackRate();
            }
        }

        @Override
        public void onChunkLoadStarted(String uri) {
            if (VideoPlayerViewExo.this.mSeeking) {
                VideoPlayerViewExo.this.fireEvent(11);
                VideoPlayerViewExo.this.mSeeking = false;
            }
        }
    };
    private final Runnable mVideoSize = new Runnable(){

        @Override
        public void run() {
            if (VideoPlayerViewExo.this.exo != null) {
                VideoPlayerViewExo.this.exo.getSurfaceHolder().setFixedSize(VideoPlayerViewExo.this.mVideoWidth, VideoPlayerViewExo.this.mVideoHeight);
                VideoPlayerViewExo.this.fireEvent(13);
                VideoPlayerViewExo.this.validateBitrateChange();
            }
        }
    };
    private final Runnable updateProgressAction = this::updateProgress;
    Boolean isLiveCache = null;
    public static int nTrackIndex = -1;
    public static int nFormatIndex = -1;

    public void preparePlayback() {
        if (this.exo == null) {
            if (this.getContext() == null) {
                LogManager.error(TAG, "Can't perform auto-recovery, view context is null");
                return;
            }
            this.iniVideoPlayerViewExo(this.getContext());
        }
        this.exo.setMediaResource(this.mMediaResource);
        this.exo.preparePlayback();
    }

    public VideoPlayerViewExo(VideoPlayerContainer param, RSALicenseDecryption RSALicenseDecryptor, Player.EventListener exoEventsListener) {
        super(param.getContext(), RSALicenseDecryptor);
        this.threadHolder = new ThreadHolder();
        this.videoPlayerContainer = param;
        this.setExoEventsListener(exoEventsListener);
        this.iniVideoPlayerViewExo(param.getContext());
        this.id3TagsSessionHandler.setVideoPlayerView(this);
    }

    protected void iniVideoPlayerViewExo(Context context) {
        this.exo = new ExoWrapper(context, this.exoEventsListener, Utils.generateSessionId());
        this.exo.setVideoPlayerAsErrorListener(this);
        this.exo.setVideoSurfaceHolder(this.getHolder());
        if (!this.alreadySetRenderer) {
            this.alreadySetRenderer = true;
            GLSurfaceView.Renderer renderer = this.exo.getRenderer();
            this.setRenderer(renderer);
        }
        if (this.closeCaptionsEnabled) {
            this.exo.enableCloseCaptions();
        }
        if (this.textRendererOutput != null) {
            this.exo.setTextRendererOutput(this.textRendererOutput);
        }
        if (this.sideloadedCaptionsData != null) {
            this.exo.sideload(this.sideloadedCaptionsData);
        }
        if (this.trackIndex != -1) {
            this.exo.setTrackIndex(this.trackIndex);
        }
        if (this.formatIndex != -1) {
            this.exo.setFormatIndex(this.formatIndex);
        }
        if (this.downloadRequestProvider != null) {
            this.exo.setDownloadRequestProvider(this.downloadRequestProvider);
        }
        this.exo.setVideoPlayerContainer(this.videoPlayerContainer);
        this.exo.setVideoSizeEvents(this.videoSizeEvents);
        this.exo.updateCMCD("sid");
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.setWillNotDraw(false);
        if (this.exo != null) {
            this.exo.setSurfaceHolder(holder);
        }
        if (this.getSurface() != null) {
            this.setSurface(this.getSurface());
        }
    }

    @Override
    public void setSurface(Surface s) {
        super.setSurface(s);
        if (this.exo != null) {
            this.exo.setSurface(s);
        }
    }

    @Override
    public void play(MediaResource media) {
        this.play(media, -1);
    }

    @Override
    public void playAudio(MediaResource media, int position) {
        this.play(media, position);
    }

    @Override
    public void playAudio(MediaResource media, int position, int duration) {
        if (media.getDuration() <= 0) {
            media.setDuration(duration);
        }
        this.play(media, position);
    }

    @Override
    public void play(MediaResource media, int position) {
        this.isLiveCache = null;
        if (this.abortPlayback) {
            this.abortPlayback();
        } else if (this.shouldAllowPlayback()) {
            super.play(media, position);
            this.fireEvent(9);
            this.fireEvent(22);
            this.fireEvent(14);
            this.mStartPositionInSeconds = position * 1000;
            if (this.exo != null) {
                this.exo.setRepeatMode(this.repeatMode);
                this.exo.setShouldAutoPlay(this.shouldAutoPlay);
                this.exo.setPlayWhenReady(true);
                this.exo.play(media, position);
                this.exo.updateCMCD("sf");
            }
        }
    }

    @Override
    public void play(MediaResource media, int position, int duration) {
        if (media.getDuration() <= 0) {
            media.setDuration(duration);
        }
        this.play(media, position);
    }

    @Override
    public void resume() {
        if (this.exo != null) {
            this.exo.resume();
            this.exo.updateCMCD("pr");
        }
        this.fireEvent(15);
    }

    @Override
    public void stop() {
        if (this.exo != null) {
            this.exo.stop();
        }
        if (this.mMediaResource != null) {
            this.mMediaResource.setVideoContentType(null);
        }
        this.isPlaybackReady = false;
        this.fireEvent(21);
    }

    @Override
    public void pause() {
        if (this.exo != null) {
            this.exo.pause();
            this.exo.updateCMCD("pr");
        }
        this.fireEvent(16);
    }

    @Override
    public void signalLogicalPause() {
        this.fireEvent(27);
    }

    @Override
    public void signalLogicalResume() {
        this.fireEvent(26);
    }

    @Override
    public void seek(int newPositionInSeconds) {
        if (newPositionInSeconds < 0 || newPositionInSeconds > this.getStreamDuration()) {
            LogManager.error(TAG, "Seek action cancelled: The new position (" + newPositionInSeconds + ") is not within the content boundaries");
            return;
        }
        if (this.exo == null) {
            return;
        }
        this.exo.seekToSeconds(newPositionInSeconds);
        this.mSeeking = true;
        this.fireEvent(19);
    }

    @Override
    public void seek(long newPositionInMilliseconds) {
        if (newPositionInMilliseconds < 0L || newPositionInMilliseconds > (long)(this.getStreamDuration() * 1000)) {
            LogManager.error(TAG, "Seek action cancelled: The new position (" + newPositionInMilliseconds + ") is not within the content boundaries");
            return;
        }
        if (this.exo == null) {
            return;
        }
        this.exo.seekToMillis(newPositionInMilliseconds);
        this.mSeeking = true;
        this.fireEvent(19);
    }

    @Override
    public long toUTC(int relativeTime) {
        return this.getDVRWindowStartTime() + (long)relativeTime;
    }

    @Override
    public long fromUTC(int absoluteTime) {
        return (long)absoluteTime - this.getDVRWindowStartTime();
    }

    @Override
    public void seekToLive() {
        if (this.exo != null) {
            this.exo.seekToDefaultPosition();
            this.mSeeking = true;
        }
        this.fireEvent(19);
    }

    @Override
    public void onPause() {
        LogManager.log(TAG, "onPause()");
        if (this.exo != null) {
            this.exo.releasePlayer();
        }
        super.onPause();
    }

    @Override
    public void onResume() {
        super.onResume();
        this.isResuming = true;
        LogManager.log(TAG, "onResume()");
        if (this.exo != null) {
            this.exo.setIsOnResume();
            this.exo.setVideoPlayerAsErrorListener(this);
            this.exo.checkInitializePlayer();
        }
    }

    @Override
    public void onDestroy() {
        if (this.exo != null) {
            this.exo.onDestroy();
            this.exo.nullifyErrorEventListeners();
            this.exo = null;
        }
        this.id3TagsSessionHandler.removeAllEventListeners();
        this.areThumbnailsEnabled = false;
        this.thumbnailsBasePath = null;
        super.onDestroy();
    }

    @Override
    public void switchBitrateUp() throws Exception {
    }

    @Override
    public void switchBitrateDown() throws Exception {
    }

    @Override
    public void setMaxBitrate(int iMaxBitrate) {
        if (this.exo == null) {
            return;
        }
        this.exo.setMaxBitrate(iMaxBitrate * 1000);
    }

    @Override
    public void setBitrateToPlay(int bitrateIndex) throws Exception {
        this.exo.setBitrateIndexForPlay(bitrateIndex);
    }

    @Override
    public void setStartingBitrateIndex(int iIndex) {
    }

    @Override
    public int getBitratesCount() {
        return this.exo.getBitratesCount();
    }

    @Override
    public int getBitrateByIndex(int index) {
        return this.exo.getBitrateByIndex(index);
    }

    @Override
    public int getIndexByBitrate(int bitrate) {
        return this.exo.getIndexByBitRate(bitrate);
    }

    @Override
    public boolean isPlaying() {
        if (this.exo != null) {
            return this.exo.getPlayWhenReady();
        }
        return false;
    }

    @Override
    public boolean isPaused() {
        if (this.exo != null) {
            return !this.exo.getPlayWhenReady();
        }
        return false;
    }

    @Override
    public String getProtocol() {
        if (this.exo == null) {
            return "Unknown";
        }
        return this.exo.getProtocol();
    }

    @Override
    public boolean isError() {
        return this.mLastErrorCode != 0;
    }

    @Override
    public boolean isFinished() {
        if (this.exo == null) {
            return true;
        }
        boolean hasEnded = this.exo != null && 4 == this.exo.getPlaybackState();
        return hasEnded;
    }

    @Override
    public boolean isSeeking() {
        return this.mSeeking;
    }

    @Override
    public boolean isAudioOnly() {
        TrackGroupArray audios;
        TrackGroupArray videos;
        return this.exo != null && (videos = this.exo.getVideoTrackArray()) != null && videos.length == 0 && (audios = this.exo.getAudioTrackArray()) != null && audios.length > 0;
    }

    @Override
    public boolean isLive() {
        if (this.isLiveCache != null) {
            return this.isLiveCache;
        }
        boolean isLive = false;
        if (this.mMediaResource != null) {
            if (this.mMediaResource.getVideoContentType() != null) {
                return "LIVE".equals(this.mMediaResource.getVideoContentType());
            }
            if (this.exo != null && (isLive = this.exo.isLive())) {
                this.isLiveCache = isLive;
            }
            return isLive;
        }
        return isLive;
    }

    private void logExoType(String typeName) {
        String exoVersion = "2.12.3";
        String message = "Using MODE_EXO v" + exoVersion + " to play " + typeName;
        Log.i((String)TAG, (String)message);
    }

    @Override
    public int getCurrentStreamPosition() {
        if (this.exo == null) {
            return -1;
        }
        return this.exo.getCurrentPositionSeconds();
    }

    @Override
    public long getCurrentStreamPositionMS() {
        if (this.exo == null) {
            return -1L;
        }
        return this.exo.getCurrentPositionMillis();
    }

    @Override
    public Date getCurrentStreamPositionAsDate() {
        throw new UnsupportedOperationException("getCurrentStreamPositionAsDate() method not supported in MODE_EXO2");
    }

    @Override
    public int getPositionInDVR() {
        int d;
        if (this.exo != null && this.isLive() && (d = this.getStreamDuration()) > 0) {
            return this.exo.getCurrentPositionSeconds();
        }
        return 0;
    }

    @Override
    public long getDVRLength() {
        return this.getStreamDuration();
    }

    @Override
    public String getStreamsInfo() {
        throw new UnsupportedOperationException("getStreamsInfo() method not supported in MODE_EXO2");
    }

    @Override
    public int getStreamDuration() {
        if (this.exo == null) {
            return 0;
        }
        if (this.exo != null && this.isLive() && !this.isDVREnabled) {
            return 0;
        }
        return this.exo.getDurationSeconds();
    }

    @Override
    public void setFullScreenMode(int mode) {
        Log.i((String)TAG, (String)("Calling setFullScreen: " + mode));
        this.mFullscreenMode = mode;
        if (mode == 1 && this.mVideoWidth != 0 && this.mVideoHeight != 0) {
            ViewGroup.LayoutParams layout = this.getLayoutParams();
            layout.width = this.mVideoWidth;
            layout.height = this.mVideoHeight;
            this.setLayoutParams(layout);
        } else {
            ViewGroup.LayoutParams layout = this.getLayoutParams();
            layout.width = -1;
            layout.height = -1;
            this.setLayoutParams(layout);
        }
        this.scaledHeight = this.mVideoHeight;
        this.scaledWidth = this.mVideoWidth;
        this.fireEvent(12);
    }

    @Override
    public void setFullScreen(boolean fullscreen) {
        if (fullscreen) {
            this.setFullScreenMode(3);
        } else {
            this.setFullScreenMode(1);
        }
    }

    @Override
    public int getFullScreenMode() {
        return this.mFullscreenMode;
    }

    @MainThread
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.getRawDimensions(widthMeasureSpec, heightMeasureSpec);
        if (this.mFullscreenMode == 2) {
            if (this.scaledHeight != 0 && this.scaledWidth != 0) {
                this.resizeVideoWithRatio(this.rawWidth, this.rawHeight, false);
            } else {
                this.setMeasuredDimension(1, 1);
            }
        } else if (this.mFullscreenMode == 5) {
            if (this.scaledHeight != 0 && this.scaledWidth != 0) {
                this.resizeVideoWithRatio(this.rawWidth, this.rawHeight, true);
            } else {
                this.setMeasuredDimension(1, 1);
            }
        } else if (this.mFullscreenMode == 1) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        } else if (this.mFullscreenMode == 3) {
            this.setMeasuredDimension(this.rawWidth, this.rawHeight);
        }
    }

    private void getRawDimensions(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (width != 0) {
            this.rawWidth = width;
        }
        if (height != 0) {
            this.rawHeight = height;
        }
    }

    private void resizeVideoWithRatio(int width, int height, boolean fillScreen) {
        if (this.isResizingCompleted(width, height, fillScreen)) {
            this.setScaledDimensions();
        } else {
            this.recalculateScaledWidthAndHeight(width, height, fillScreen);
            this.resizeVideoWithRatio(width, height, fillScreen);
        }
    }

    public boolean isResizingCompleted(int width, int height, boolean fillScreen) {
        boolean c;
        boolean b;
        boolean a = width == this.scaledWidth;
        boolean bl = b = height == this.scaledHeight;
        boolean bl2 = fillScreen ? this.scaledWidth > width : (c = this.scaledWidth < width);
        boolean d = fillScreen ? this.scaledHeight > height : this.scaledHeight < height;
        return a && b || (a || b) && (c || d);
    }

    private void setScaledDimensions() {
        this.setMeasuredDimension(this.scaledWidth, this.scaledHeight);
        if (this.exo == null) {
            return;
        }
        SurfaceHolder surfaceHolder = this.exo.getSurfaceHolder();
        if (surfaceHolder == null) {
            return;
        }
        surfaceHolder.setFixedSize(this.scaledWidth, this.scaledHeight);
    }

    private void recalculateScaledWidthAndHeight(int width, int height, boolean fillScreen) {
        int widthDifference = width - this.scaledWidth;
        int heightDifference = height - this.scaledHeight;
        if (widthDifference != 0 || heightDifference != 0) {
            boolean videoHeightClosestToScreenHeight;
            boolean isScreenWidthSmallerThanVideo = widthDifference < 0;
            boolean isScreenHeightSmallerThanVideo = heightDifference < 0;
            boolean videoWidthClosestToScreenWidth = Math.abs(widthDifference) < Math.abs(heightDifference);
            boolean bl = videoHeightClosestToScreenHeight = Math.abs(widthDifference) > Math.abs(heightDifference);
            if (isScreenWidthSmallerThanVideo && isScreenHeightSmallerThanVideo) {
                this.expandVideoFrameSize(fillScreen ? videoWidthClosestToScreenWidth : videoHeightClosestToScreenHeight, width, height);
            } else if (isScreenWidthSmallerThanVideo) {
                this.calculateNewHeight(width);
            } else if (isScreenHeightSmallerThanVideo) {
                this.calculateNewWidth(height);
            } else {
                this.expandVideoFrameSize(fillScreen ? videoHeightClosestToScreenHeight : videoWidthClosestToScreenWidth, width, height);
            }
        }
    }

    public int getScaledWidth() {
        return this.scaledWidth;
    }

    public int getScaledHeight() {
        return this.scaledHeight;
    }

    private void expandVideoFrameSize(boolean calculateHeight, int width, int height) {
        if (calculateHeight) {
            this.calculateNewHeight(width);
        } else {
            this.calculateNewWidth(height);
        }
    }

    private void calculateNewHeight(int width) {
        float res = ((float)this.scaledHeight + 0.0f) / (float)this.scaledWidth;
        this.scaledHeight = (int)((float)width * res);
        this.scaledWidth = width;
    }

    private void calculateNewWidth(int height) {
        float res = ((float)this.scaledWidth + 0.0f) / (float)this.scaledHeight;
        this.scaledWidth = (int)((float)height * res);
        this.scaledHeight = height;
    }

    @Override
    public int getBufferingPercentage() {
        if (this.exo != null) {
            return this.exo.getBufferedPercentage();
        }
        return 0;
    }

    @Override
    public int getBitratesSwitchesUp() {
        return 0;
    }

    @Override
    public int getBitratesSwitchesDown() {
        return 0;
    }

    @Override
    public int getRebuffers() {
        return 0;
    }

    @Override
    public double getRebufferingTime() {
        return 0.0;
    }

    @Override
    public void setManualSwitching(boolean bInValue) {
    }

    @Override
    public long getBytesLoaded() {
        return 0L;
    }

    @Override
    public void setNetSessionMode(int mode) {
        throw new UnsupportedOperationException("setNetSessionMode() method not supported in MODE_EXO2");
    }

    @Override
    public void setVideoBufferSize(int amountOfBuffersInQueue) {
        throw new UnsupportedOperationException("setVideoBufferSize() method not supported in MODE_EXO2");
    }

    @Override
    public TrackGroupArray getAvailableAudioTracks() {
        if (this.exo == null) {
            return null;
        }
        return this.exo.getAudioTrackArray();
    }

    @Override
    public void switchAudioTrack(int trackIndex) {
        if (this.exo == null) {
            return;
        }
        this.exo.selectAudioTrack(trackIndex);
    }

    @Override
    public int getCurrentAudioTrackIndex() {
        if (this.exo == null) {
            return 0;
        }
        return this.exo.getCurrentAudioTrackIndex();
    }

    @Override
    public float getFPS() {
        if (this.exo == null) {
            return -1.0f;
        }
        this.mFps = this.exo.getFrameRate();
        return this.mFps;
    }

    @Override
    public void onTimelineChanged(Timeline timeline, int reason) {
        LogManager.log(TAG, "onTimelineChanged");
        this.updateProgress();
    }

    @Override
    public void onTracksChanged(TrackGroupArray trackGroups, TrackSelectionArray trackSelections) {
        LogManager.log(TAG, "onTracksChanged");
        if (nTrackIndex != -1 || nFormatIndex != -1) {
            nTrackIndex = Math.max(nTrackIndex, 0);
            nFormatIndex = Math.max(nFormatIndex, 0);
            this.setTrackIndexes(nTrackIndex, nFormatIndex);
            nTrackIndex = -1;
            nFormatIndex = -1;
        }
    }

    @Override
    public void onLoadingChanged(boolean isLoading) {
        LogManager.log(TAG, "onLoadingChanged " + isLoading);
    }

    @Override
    public void onPlaybackStateChanged(int state) {
        String msg = "state [" + this.getStateString(state) + "]";
        LogManager.log(TAG, msg);
        switch (state) {
            case 3: {
                this.checkMediaResourceDuration();
                if (this.mBuffering) {
                    this.mBuffering = false;
                    this.fireEvent(6);
                }
                if (this.mSeeking) {
                    this.fireEvent(11);
                    this.mSeeking = false;
                }
                if (this.isResuming) {
                    this.fireEvent(1);
                    this.isResuming = false;
                }
                if (this.isPlaybackReady) break;
                this.isPlaybackReady = true;
                this.fireEvent(3);
                this.validateBitrateChange();
                if (this.exo == null) break;
                this.exo.updateCMCD("tb", "st", "br", "pr");
                break;
            }
            case 4: {
                this.isPlaybackReady = false;
                this.fireEvent(2);
                this.stop();
                break;
            }
            case 2: {
                this.mBuffering = true;
                this.checkStall();
                this.fireEvent(5);
                break;
            }
            case 1: {
                Exception exception = this.getLastException();
                if (exception == null) {
                    return;
                }
                if (!(exception instanceof IOException)) break;
                this.videoPlayerContainer.onResourceError(ErrorType.TYPE_SOURCE, exception);
            }
        }
    }

    private void checkStall() {
        if (ExoPlayerImplInternal.rebuffering) {
            this.fireEvent(33);
        }
    }

    private void checkMediaResourceDuration() {
        if (this.mMediaResource == null) {
            return;
        }
        if (this.mMediaResource.isDurationSet()) {
            return;
        }
        int duration = this.getStreamDuration();
        this.mMediaResource.setDuration(duration);
    }

    @Override
    public void onRepeatModeChanged(int repeatMode) {
        LogManager.error(TAG, "onRepeatModeChanged: " + repeatMode);
    }

    @Override
    public void onShuffleModeEnabledChanged(boolean shuffleModeEnabled) {
        LogManager.error(TAG, "onShuffleModeEnabledChanged: " + shuffleModeEnabled);
    }

    private String getStateString(int state) {
        switch (state) {
            case 2: {
                return "STATE_BUFFERING";
            }
            case 4: {
                return "STATE_ENDED";
            }
            case 1: {
                return "STATE_IDLE";
            }
            case 3: {
                return "STATE_READY";
            }
        }
        return "?";
    }

    @Override
    public void onPlayerError(ExoPlaybackException error) {
        LogManager.error(TAG, "ExoPlaybackException on VideoPlayerViewExo", error);
        this.mLastException = this.getRealException(error);
        this.mLastErrorCode = error.type + 7;
        this.mLastHttpErrorCode = this.getLastHttpErrorCode(error.getCause());
        this.fireEvent(4);
    }

    @Override
    public void onPositionDiscontinuity(int reason) {
        LogManager.error(TAG, "onPositionDiscontinuity: " + reason);
    }

    private void doOnExoError(Exception e, String errorMessage) {
        LogManager.error(TAG, errorMessage);
        LogManager.error(TAG, e);
        this.mLastException = e;
        this.mLastErrorCode = 7;
        this.mLastHttpErrorCode = this.getLastHttpErrorCode(e);
        this.fireEvent(4);
    }

    private Exception getRealException(ExoPlaybackException error) {
        switch (error.type) {
            case 0: {
                return error.getSourceException();
            }
            case 1: {
                return error.getRendererException();
            }
            case 2: {
                return error.getUnexpectedException();
            }
        }
        return error;
    }

    private int getLastHttpErrorCode(Throwable cause) {
        if (cause != null && cause instanceof HttpDataSource.InvalidResponseCodeException) {
            HttpDataSource.InvalidResponseCodeException e = (HttpDataSource.InvalidResponseCodeException)cause;
            int responseCode = e.responseCode;
            return responseCode;
        }
        return -1;
    }

    @Override
    public void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
        LogManager.log(TAG, "onPlaybackParametersChanged" + playbackParameters);
    }

    @Override
    public long getCurrentBitrate() {
        if (this.exo == null) {
            return -1L;
        }
        this.mCurrentBitrate = this.exo.getCurrentBitrate();
        return this.mCurrentBitrate;
    }

    private void updateProgress() {
        if (this.abortPlayback) {
            this.abortPlayback();
        } else {
            int playbackState;
            int positionSeconds;
            long positionMillis = this.exo == null ? 0L : this.exo.getCurrentPositionMillis();
            int n = positionSeconds = this.exo == null ? 0 : this.exo.getCurrentPositionSeconds();
            if (this.isPlaybackReady) {
                this.fireEvent(0);
            }
            this.removeCallbacks(this.updateProgressAction);
            int n2 = playbackState = this.exo == null ? 1 : this.exo.getPlaybackState();
            if (playbackState != 1 && playbackState != 4) {
                long delayMs = this.getDelayMs(positionMillis, playbackState);
                this.postDelayed(this.updateProgressAction, delayMs);
            }
        }
    }

    private long getDelayMs(long positionMillis, int playbackState) {
        long delayMs;
        if (this.exo.getPlayWhenReady() && playbackState == 3) {
            delayMs = 1000L - positionMillis % 1000L;
            if (delayMs < 200L) {
                delayMs += 1000L;
            }
        } else {
            delayMs = 1000L;
        }
        return delayMs;
    }

    public void enableCloseCaptions() {
        this.closeCaptionsEnabled = true;
        if (this.exo == null) {
            return;
        }
        this.exo.enableCloseCaptions();
    }

    public void setTextRendererOutput(TextOutput output) {
        this.textRendererOutput = output;
        if (this.exo == null) {
            return;
        }
        this.exo.setTextRendererOutput(this.textRendererOutput);
    }

    public void clearTextOutput(TextOutput output) {
        this.textRendererOutput = null;
        if (this.exo == null) {
            return;
        }
        this.exo.clearTextOutput(output);
    }

    public void setID3MetadataListener(MetadataOutput metadataListener) {
        if (this.exo != null) {
            this.exo.setMetadataListener(metadataListener);
        }
    }

    @Override
    public void mute() {
        MuteHelper.mute(this.exo);
    }

    @Override
    public void unmute() {
        MuteHelper.unmute(this.exo);
    }

    @Override
    public void setVolume(float volume) {
        if (this.exo == null) {
            return;
        }
        this.exo.setVolume(volume);
    }

    private long getDVRWindowStartTime() {
        if (this.exo == null) {
            return -9223372036854775807L;
        }
        return this.exo.getWindowStartTime();
    }

    @Override
    public long getCurrentPositionPeriodInMillis() {
        if (this.exo == null) {
            return -9223372036854775807L;
        }
        return this.exo.getCurrentPositionPeriod();
    }

    private void validateBitrateChange() {
        if (this.mBitrateBeforeSwitch != -1L && this.mBitrateBeforeSwitch != this.getCurrentBitrate()) {
            long currentBitrate = this.getCurrentBitrate();
            if (currentBitrate > this.mBitrateBeforeSwitch) {
                ++this.mBitrateSwitchUpCount;
            } else {
                ++this.mBitrateSwitchDownCount;
            }
            if (this.exo != null) {
                this.exo.updateCMCD("br");
            }
            this.fireEvent(8);
        } else if (this.mBitrateBeforeSwitch == -1L) {
            this.mBitrateBeforeSwitch = this.getCurrentBitrate();
        }
    }

    public void setPlayWhenReady(boolean b) {
        if (this.exo == null) {
            return;
        }
        this.exo.setPlayWhenReady(b);
    }

    @Override
    public void enableDVRfeatures(boolean enabled) {
        super.enableDVRfeatures(enabled);
        this.isDVREnabled = enabled;
    }

    public void setTrackIndex(int param) {
        this.trackIndex = param;
        if (this.exo != null) {
            this.exo.setTrackIndex(this.trackIndex);
        }
    }

    public void setFormatIndex(int param) {
        this.formatIndex = param;
        if (this.exo != null) {
            this.exo.setFormatIndex(this.formatIndex);
        }
    }

    public void setTrackIndexes(int trackIndex, int formatIndex) {
        this.trackIndex = trackIndex;
        this.formatIndex = formatIndex;
        if (this.exo == null) {
            return;
        }
        this.exo.setTrackIndexes(trackIndex, formatIndex);
    }

    public Map<Pair<Integer, Integer>, String> getDataTracks() {
        if (this.exo == null) {
            return new HashMap<Pair<Integer, Integer>, String>();
        }
        return this.exo.getDataTracks();
    }

    public List<Format> getDataFormats() {
        if (this.exo == null) {
            return new ArrayList<Format>();
        }
        return this.exo.getDataFormats();
    }

    public void sideload(List<SideloadedCaptionsData> data) {
        if (this.sideloadedCaptionsData == null || this.sideloadedCaptionsData.isEmpty()) {
            this.sideloadedCaptionsData = new ArrayList<SideloadedCaptionsData>(data);
        } else if (this.areThumbnailsEnabled()) {
            this.sideloadedCaptionsData.add(0, data.get(0));
        } else {
            this.sideloadedCaptionsData.addAll(data);
        }
        if (this.exo == null) {
            return;
        }
        this.exo.sideload(this.sideloadedCaptionsData);
    }

    @Override
    public HashMap<Integer, Integer> getAvailableBitrates() {
        return this.exo.getAvailableBitrates();
    }

    @Override
    public List<QualityLevel> getQualityLevels() {
        if (this.exo == null) {
            return new ArrayList<QualityLevel>();
        }
        return this.exo.getQualityLevels();
    }

    @Override
    public void setQualityLevel(int index) {
        this.selectedQualityLevel = index;
        if (this.exo == null) {
            return;
        }
        this.exo.setQualityLevel(this.selectedQualityLevel);
    }

    @Override
    public int getSelectedQualityLevelIndex() {
        if (this.exo == null) {
            return -1;
        }
        return this.exo.getSelectionOverride();
    }

    @Override
    public QualityLevel getSelectedQualityLevel() {
        List<QualityLevel> qualityLevels = this.getQualityLevels();
        if (this.selectedQualityLevel < 0 || this.selectedQualityLevel >= qualityLevels.size()) {
            return null;
        }
        return qualityLevels.get(this.selectedQualityLevel);
    }

    public int getPlaybackState() {
        if (this.exo == null) {
            return 4;
        }
        return this.exo.getPlaybackState();
    }

    @Override
    public void onLoadError(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData, IOException error, boolean wasCanceled) {
        this.doOnExoError(error, "onLoadError AdaptiveMediaSourceEventListener");
    }

    @Override
    public void onLoadStarted(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
        String uri = this.toString(loadEventInfo.uri);
        this.videoSizeEvents.onChunkLoadStarted(uri);
    }

    private String toString(Uri uri) {
        if (uri == null) {
            return "";
        }
        String result = uri.toString();
        return result;
    }

    @Override
    public void onLoadCompleted(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
        String uri = this.toString(loadEventInfo.uri);
        this.videoSizeEvents.onChunkLoadCompleted(uri);
    }

    @Override
    public void onLoadCanceled(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
    }

    @Override
    public void onUpstreamDiscarded(int windowIndex, MediaSource.MediaPeriodId mediaPeriodId, MediaLoadData mediaLoadData) {
    }

    @Override
    public void onDownstreamFormatChanged(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, MediaLoadData mediaLoadData) {
    }

    @Override
    public void setDownloadRequestProvider(DownloadRequestProvider p) {
        this.downloadRequestProvider = p;
        if (this.exo != null) {
            this.exo.setDownloadRequestProvider(this.downloadRequestProvider);
        }
    }

    @Override
    public float getPlaybackRate() {
        if (this.exo != null) {
            return this.exo.getPlaybackRate();
        }
        return 1.0f;
    }

    @Override
    public void setPlaybackRate(float newRate, float newPitch) {
        float rate = newRate;
        float pitch = newPitch;
        if (rate <= 0.0f) {
            LogManager.error(TAG, "Rate can't be negative or zero, continuing the action with default value 1x");
            rate = 1.0f;
        }
        if (pitch <= 0.0f) {
            LogManager.error(TAG, "Pitch can't be negative or zero, continuing the action with default value 1x");
            pitch = 1.0f;
        }
        if (this.exo != null) {
            this.exo.setPlaybackRate(rate, pitch);
            this.exo.updateCMCD("pr");
        }
    }

    @Override
    public long getBufferAvailable() {
        if (this.exo != null) {
            return this.exo.getBufferAvailable();
        }
        return 0L;
    }

    @Override
    public long getLatency() {
        return 0L;
    }

    public void onCCEnabled() {
        this.fireEvent(31);
    }

    public void onCCDisabled() {
        this.fireEvent(32);
    }

    @Override
    public AmpBasePlayer getAmpBasePlayer() {
        if (this.exo != null) {
            return this.exo.getPlayer();
        }
        return null;
    }

    @Override
    public void setBandwidthMeter(BandwidthMeter bandwidthMeter) {
        if (this.exo != null) {
            this.exo.setBandwidthMeter(bandwidthMeter);
        }
    }

    @Override
    public void safeRun(Runnable runnable) {
        if (this.threadHolder == null) {
            this.threadHolder = new ThreadHolder();
        }
        this.threadHolder.execute(runnable);
    }

    @Override
    public Looper getCurrentLooper() {
        return Util.getCurrentOrMainLooper();
    }

    public String getLatestChunkUri() {
        return this.latestChunkUri;
    }

    @Override
    public void setThumbnails(String vttURL) {
        this.areThumbnailsEnabled = true;
        SideloadedCaptionsData videoPreviewVTTData = new SideloadedCaptionsData("text/vtt", vttURL);
        this.sideload(Collections.singletonList(videoPreviewVTTData));
        if (this.exo == null) {
            return;
        }
        this.exo.setTrackIndexes(0, 0);
    }

    @Override
    public void setThumbnails(String vttURL, String path) {
        this.thumbnailsBasePath = path;
        this.setThumbnails(vttURL);
    }

    @Override
    public List<Cue> getThumbnailByPosition(long positionInSeconds) {
        if (this.exo == null) {
            return null;
        }
        return this.exo.getThumbnail(positionInSeconds * 1000L);
    }

    @Override
    public boolean areThumbnailsEnabled() {
        return this.areThumbnailsEnabled;
    }

    @Override
    public String getThumbnailsBasePath() {
        return this.thumbnailsBasePath;
    }

    @Override
    public boolean isBuffering() {
        return this.mBuffering;
    }

    @Override
    public int getStreamType() {
        if (this.exo == null) {
            return 3;
        }
        return this.exo.getStreamType();
    }

    @Override
    public void addId3TagsEventListener(ID3TagEventListener listener) {
        this.id3TagsSessionHandler.addEventListener(listener);
    }

    @Override
    public void removeId3TagsEventListener(ID3TagEventListener listener) {
        this.id3TagsSessionHandler.removeEventListener(listener);
    }

    public static interface VideoStatsEvents {
        public void videoSizeChanged(int var1, int var2);

        public void onChunkLoadCompleted(String var1);

        public void onChunkLoadStarted(String var1);
    }
}

