/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.source.dash;

import android.os.SystemClock;
import androidx.annotation.CheckResult;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.C;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.SeekParameters;
import com.akamai.amp.exoplayer2.ampcustom.AMPPreSettings;
import com.akamai.amp.exoplayer2.ampcustom.SntpClient;
import com.akamai.amp.exoplayer2.extractor.ChunkIndex;
import com.akamai.amp.exoplayer2.extractor.Extractor;
import com.akamai.amp.exoplayer2.extractor.TrackOutput;
import com.akamai.amp.exoplayer2.extractor.mkv.MatroskaExtractor;
import com.akamai.amp.exoplayer2.extractor.mp4.FragmentedMp4Extractor;
import com.akamai.amp.exoplayer2.extractor.rawcc.RawCcExtractor;
import com.akamai.amp.exoplayer2.source.BehindLiveWindowException;
import com.akamai.amp.exoplayer2.source.chunk.BaseMediaChunkIterator;
import com.akamai.amp.exoplayer2.source.chunk.BundledChunkExtractor;
import com.akamai.amp.exoplayer2.source.chunk.Chunk;
import com.akamai.amp.exoplayer2.source.chunk.ChunkExtractor;
import com.akamai.amp.exoplayer2.source.chunk.ChunkHolder;
import com.akamai.amp.exoplayer2.source.chunk.ContainerMediaChunk;
import com.akamai.amp.exoplayer2.source.chunk.InitializationChunk;
import com.akamai.amp.exoplayer2.source.chunk.MediaChunk;
import com.akamai.amp.exoplayer2.source.chunk.MediaChunkIterator;
import com.akamai.amp.exoplayer2.source.chunk.SingleSampleMediaChunk;
import com.akamai.amp.exoplayer2.source.dash.DashChunkSource;
import com.akamai.amp.exoplayer2.source.dash.DashSegmentIndex;
import com.akamai.amp.exoplayer2.source.dash.DashUtil;
import com.akamai.amp.exoplayer2.source.dash.DashWrappingSegmentIndex;
import com.akamai.amp.exoplayer2.source.dash.PlayerEmsgHandler;
import com.akamai.amp.exoplayer2.source.dash.manifest.AdaptationSet;
import com.akamai.amp.exoplayer2.source.dash.manifest.DashManifest;
import com.akamai.amp.exoplayer2.source.dash.manifest.RangedUri;
import com.akamai.amp.exoplayer2.source.dash.manifest.Representation;
import com.akamai.amp.exoplayer2.trackselection.TrackSelection;
import com.akamai.amp.exoplayer2.upstream.DataSource;
import com.akamai.amp.exoplayer2.upstream.DataSpec;
import com.akamai.amp.exoplayer2.upstream.HttpDataSource;
import com.akamai.amp.exoplayer2.upstream.LoaderErrorThrower;
import com.akamai.amp.exoplayer2.upstream.TransferListener;
import com.akamai.amp.exoplayer2.util.MimeTypes;
import com.akamai.amp.exoplayer2.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DefaultDashChunkSource
implements DashChunkSource {
    private final LoaderErrorThrower manifestLoaderErrorThrower;
    private final int[] adaptationSetIndices;
    private final int trackType;
    private final DataSource dataSource;
    private final long elapsedRealtimeOffsetMs;
    private final int maxSegmentsPerLoad;
    @Nullable
    private final PlayerEmsgHandler.PlayerTrackEmsgHandler playerTrackEmsgHandler;
    protected final RepresentationHolder[] representationHolders;
    private TrackSelection trackSelection;
    private DashManifest manifest;
    private int periodIndex;
    private IOException fatalError;
    private boolean missingLastSegment;
    private long liveEdgeTimeUs;

    public DefaultDashChunkSource(LoaderErrorThrower manifestLoaderErrorThrower, DashManifest manifest, int periodIndex, int[] adaptationSetIndices, TrackSelection trackSelection, int trackType, DataSource dataSource, long elapsedRealtimeOffsetMs, int maxSegmentsPerLoad, boolean enableEventMessageTrack, List<Format> closedCaptionFormats, @Nullable PlayerEmsgHandler.PlayerTrackEmsgHandler playerTrackEmsgHandler) {
        this.manifestLoaderErrorThrower = manifestLoaderErrorThrower;
        this.manifest = manifest;
        this.adaptationSetIndices = adaptationSetIndices;
        this.trackSelection = trackSelection;
        this.trackType = trackType;
        this.dataSource = dataSource;
        this.periodIndex = periodIndex;
        this.elapsedRealtimeOffsetMs = elapsedRealtimeOffsetMs;
        this.maxSegmentsPerLoad = maxSegmentsPerLoad;
        this.playerTrackEmsgHandler = playerTrackEmsgHandler;
        long periodDurationUs = manifest.getPeriodDurationUs(periodIndex);
        this.liveEdgeTimeUs = -9223372036854775807L;
        ArrayList<Representation> representations = this.getRepresentations();
        this.representationHolders = new RepresentationHolder[trackSelection.length()];
        for (int i = 0; i < this.representationHolders.length; ++i) {
            Representation representation = (Representation)representations.get(trackSelection.getIndexInTrackGroup(i));
            this.representationHolders[i] = new RepresentationHolder(periodDurationUs, trackType, representation, enableEventMessageTrack, closedCaptionFormats, playerTrackEmsgHandler);
        }
    }

    @Override
    public long getAdjustedSeekPositionUs(long positionUs, SeekParameters seekParameters) {
        for (RepresentationHolder representationHolder : this.representationHolders) {
            if (representationHolder.segmentIndex == null) continue;
            long segmentNum = representationHolder.getSegmentNum(positionUs);
            long firstSyncUs = representationHolder.getSegmentStartTimeUs(segmentNum);
            long secondSyncUs = firstSyncUs < positionUs && segmentNum < (long)(representationHolder.getSegmentCount() - 1) ? representationHolder.getSegmentStartTimeUs(segmentNum + 1L) : firstSyncUs;
            return seekParameters.resolveSeekPositionUs(positionUs, firstSyncUs, secondSyncUs);
        }
        return positionUs;
    }

    @Override
    public void updateManifest(DashManifest newManifest, int newPeriodIndex) {
        try {
            this.manifest = newManifest;
            this.periodIndex = newPeriodIndex;
            long periodDurationUs = this.manifest.getPeriodDurationUs(this.periodIndex);
            ArrayList<Representation> representations = this.getRepresentations();
            for (int i = 0; i < this.representationHolders.length; ++i) {
                Representation representation = (Representation)representations.get(this.trackSelection.getIndexInTrackGroup(i));
                this.representationHolders[i] = this.representationHolders[i].copyWithNewRepresentation(periodDurationUs, representation);
            }
        }
        catch (BehindLiveWindowException e) {
            this.fatalError = e;
        }
    }

    @Override
    public void updateTrackSelection(TrackSelection trackSelection) {
        this.trackSelection = trackSelection;
    }

    @Override
    public void maybeThrowError() throws IOException {
        if (this.fatalError != null) {
            throw this.fatalError;
        }
        this.manifestLoaderErrorThrower.maybeThrowError();
    }

    @Override
    public int getPreferredQueueSize(long playbackPositionUs, List<? extends MediaChunk> queue) {
        if (this.fatalError != null || this.trackSelection.length() < 2) {
            return queue.size();
        }
        return this.trackSelection.evaluateQueueSize(playbackPositionUs, queue);
    }

    private long getUnixTime() {
        if (AMPPreSettings.getPreSettingsInstance().getLowLatencySettings().isLowLatencyTurnedOn()) {
            SntpClient sntpClient = AMPPreSettings.getPreSettingsInstance().getLowLatencySettings().getSntpClient();
            if (sntpClient.isInitialized()) {
                return C.msToUs(sntpClient.getNtpTime() + SystemClock.elapsedRealtime() - sntpClient.getNtpTimeReference());
            }
            return C.msToUs(Util.getNowUnixTimeMs(this.elapsedRealtimeOffsetMs));
        }
        return C.msToUs(Util.getNowUnixTimeMs(this.elapsedRealtimeOffsetMs));
    }

    @Override
    public boolean shouldCancelLoad(long playbackPositionUs, Chunk loadingChunk, List<? extends MediaChunk> queue) {
        if (this.fatalError != null) {
            return false;
        }
        return this.trackSelection.shouldCancelChunkLoad(playbackPositionUs, loadingChunk, queue);
    }

    @Override
    public void getNextChunk(long playbackPositionUs, long loadPositionUs, List<? extends MediaChunk> queue, ChunkHolder out) {
        int maxSegmentCount;
        long periodDurationUs;
        boolean periodEnded;
        if (this.fatalError != null) {
            return;
        }
        long bufferedDurationUs = loadPositionUs - playbackPositionUs;
        long timeToLiveEdgeUs = this.resolveTimeToLiveEdgeUs(playbackPositionUs);
        long presentationPositionUs = C.msToUs(this.manifest.availabilityStartTimeMs) + C.msToUs(this.manifest.getPeriod((int)this.periodIndex).startMs) + loadPositionUs;
        if (this.playerTrackEmsgHandler != null && this.playerTrackEmsgHandler.maybeRefreshManifestBeforeLoadingNextChunk(presentationPositionUs)) {
            return;
        }
        long nowUnixTimeUs = this.getUnixTime();
        MediaChunk previous = queue.isEmpty() ? null : queue.get(queue.size() - 1);
        MediaChunkIterator[] chunkIterators = new MediaChunkIterator[this.trackSelection.length()];
        for (int i = 0; i < chunkIterators.length; ++i) {
            long lastAvailableSegmentNum;
            long firstAvailableSegmentNum;
            long segmentNum;
            RepresentationHolder representationHolder = this.representationHolders[i];
            chunkIterators[i] = representationHolder.segmentIndex == null ? MediaChunkIterator.EMPTY : ((segmentNum = this.getSegmentNum(representationHolder, previous, loadPositionUs, firstAvailableSegmentNum = representationHolder.getFirstAvailableSegmentNum(this.manifest, this.periodIndex, nowUnixTimeUs), lastAvailableSegmentNum = representationHolder.getLastAvailableSegmentNum(this.manifest, this.periodIndex, nowUnixTimeUs))) < firstAvailableSegmentNum ? MediaChunkIterator.EMPTY : new RepresentationSegmentIterator(representationHolder, segmentNum, lastAvailableSegmentNum));
        }
        this.trackSelection.updateSelectedTrack(playbackPositionUs, bufferedDurationUs, timeToLiveEdgeUs, queue, chunkIterators);
        RepresentationHolder representationHolder = this.representationHolders[this.trackSelection.getSelectedIndex()];
        if (representationHolder.chunkExtractor != null) {
            Representation selectedRepresentation = representationHolder.representation;
            RangedUri pendingInitializationUri = null;
            RangedUri pendingIndexUri = null;
            if (representationHolder.chunkExtractor.getSampleFormats() == null) {
                pendingInitializationUri = selectedRepresentation.getInitializationUri();
            }
            if (representationHolder.segmentIndex == null) {
                pendingIndexUri = selectedRepresentation.getIndexUri();
            }
            if (pendingInitializationUri != null || pendingIndexUri != null) {
                out.chunk = this.newInitializationChunk(representationHolder, this.dataSource, this.trackSelection.getSelectedFormat(), this.trackSelection.getSelectionReason(), this.trackSelection.getSelectionData(), pendingInitializationUri, pendingIndexUri);
                return;
            }
        }
        boolean bl = periodEnded = (periodDurationUs = representationHolder.periodDurationUs) != -9223372036854775807L;
        if (representationHolder.getSegmentCount() == 0) {
            out.endOfStream = periodEnded;
            return;
        }
        long firstAvailableSegmentNum = representationHolder.getFirstAvailableSegmentNum(this.manifest, this.periodIndex, nowUnixTimeUs);
        long lastAvailableSegmentNum = representationHolder.getLastAvailableSegmentNum(this.manifest, this.periodIndex, nowUnixTimeUs);
        this.updateLiveEdgeTimeUs(representationHolder, lastAvailableSegmentNum);
        long segmentNum = this.getSegmentNum(representationHolder, previous, loadPositionUs, firstAvailableSegmentNum, lastAvailableSegmentNum);
        if (segmentNum < firstAvailableSegmentNum) {
            this.fatalError = new BehindLiveWindowException();
            return;
        }
        if (segmentNum > lastAvailableSegmentNum || this.missingLastSegment && segmentNum >= lastAvailableSegmentNum) {
            out.endOfStream = periodEnded;
            return;
        }
        if (periodEnded && representationHolder.getSegmentStartTimeUs(segmentNum) >= periodDurationUs) {
            out.endOfStream = true;
            return;
        }
        if (periodDurationUs != -9223372036854775807L) {
            for (maxSegmentCount = (int)Math.min((long)this.maxSegmentsPerLoad, lastAvailableSegmentNum - segmentNum + 1L); maxSegmentCount > 1 && representationHolder.getSegmentStartTimeUs(segmentNum + (long)maxSegmentCount - 1L) >= periodDurationUs; --maxSegmentCount) {
            }
        }
        long seekTimeUs = queue.isEmpty() ? loadPositionUs : -9223372036854775807L;
        out.chunk = this.newMediaChunk(representationHolder, this.dataSource, this.trackType, this.trackSelection.getSelectedFormat(), this.trackSelection.getSelectionReason(), this.trackSelection.getSelectionData(), segmentNum, maxSegmentCount, seekTimeUs);
    }

    @Override
    public void onChunkLoadCompleted(Chunk chunk) {
        if (chunk instanceof InitializationChunk) {
            ChunkIndex chunkIndex;
            InitializationChunk initializationChunk = (InitializationChunk)chunk;
            int trackIndex = this.trackSelection.indexOf(initializationChunk.trackFormat);
            RepresentationHolder representationHolder = this.representationHolders[trackIndex];
            if (representationHolder.segmentIndex == null && (chunkIndex = representationHolder.chunkExtractor.getChunkIndex()) != null) {
                this.representationHolders[trackIndex] = representationHolder.copyWithNewSegmentIndex(new DashWrappingSegmentIndex(chunkIndex, representationHolder.representation.presentationTimeOffsetUs));
            }
        }
        if (this.playerTrackEmsgHandler != null) {
            this.playerTrackEmsgHandler.onChunkLoadCompleted(chunk);
        }
    }

    @Override
    public boolean onChunkLoadError(Chunk chunk, boolean cancelable, Exception e, long exclusionDurationMs) {
        RepresentationHolder representationHolder;
        int segmentCount;
        if (!cancelable) {
            return false;
        }
        if (this.playerTrackEmsgHandler != null && this.playerTrackEmsgHandler.maybeRefreshManifestOnLoadingError(chunk)) {
            return true;
        }
        if (!this.manifest.dynamic && chunk instanceof MediaChunk && e instanceof HttpDataSource.InvalidResponseCodeException && ((HttpDataSource.InvalidResponseCodeException)e).responseCode == 404 && (segmentCount = (representationHolder = this.representationHolders[this.trackSelection.indexOf(chunk.trackFormat)]).getSegmentCount()) != -1 && segmentCount != 0) {
            long lastAvailableSegmentNum = representationHolder.getFirstSegmentNum() + (long)segmentCount - 1L;
            if (((MediaChunk)chunk).getNextChunkIndex() > lastAvailableSegmentNum) {
                this.missingLastSegment = true;
                return true;
            }
        }
        return exclusionDurationMs != -9223372036854775807L && this.trackSelection.blacklist(this.trackSelection.indexOf(chunk.trackFormat), exclusionDurationMs);
    }

    @Override
    public void release() {
        for (RepresentationHolder representationHolder : this.representationHolders) {
            ChunkExtractor chunkExtractor = representationHolder.chunkExtractor;
            if (chunkExtractor == null) continue;
            chunkExtractor.release();
        }
    }

    private long getSegmentNum(RepresentationHolder representationHolder, @Nullable MediaChunk previousChunk, long loadPositionUs, long firstAvailableSegmentNum, long lastAvailableSegmentNum) {
        return previousChunk != null ? previousChunk.getNextChunkIndex() : Util.constrainValue(representationHolder.getSegmentNum(loadPositionUs), firstAvailableSegmentNum, lastAvailableSegmentNum);
    }

    private ArrayList<Representation> getRepresentations() {
        List<AdaptationSet> manifestAdaptationSets = this.manifest.getPeriod((int)this.periodIndex).adaptationSets;
        ArrayList<Representation> representations = new ArrayList<Representation>();
        for (int adaptationSetIndex : this.adaptationSetIndices) {
            representations.addAll(manifestAdaptationSets.get((int)adaptationSetIndex).representations);
        }
        return representations;
    }

    private void updateLiveEdgeTimeUs(RepresentationHolder representationHolder, long lastAvailableSegmentNum) {
        this.liveEdgeTimeUs = this.manifest.dynamic ? representationHolder.getSegmentEndTimeUs(lastAvailableSegmentNum) : -9223372036854775807L;
    }

    private long resolveTimeToLiveEdgeUs(long playbackPositionUs) {
        boolean resolveTimeToLiveEdgePossible = this.manifest.dynamic && this.liveEdgeTimeUs != -9223372036854775807L;
        return resolveTimeToLiveEdgePossible ? this.liveEdgeTimeUs - playbackPositionUs : -9223372036854775807L;
    }

    protected Chunk newInitializationChunk(RepresentationHolder representationHolder, DataSource dataSource, Format trackFormat, int trackSelectionReason, Object trackSelectionData, RangedUri initializationUri, RangedUri indexUri) {
        RangedUri requestUri;
        Representation representation = representationHolder.representation;
        if (initializationUri != null) {
            requestUri = initializationUri.attemptMerge(indexUri, representation.baseUrl);
            if (requestUri == null) {
                requestUri = initializationUri;
            }
        } else {
            requestUri = indexUri;
        }
        DataSpec dataSpec = DashUtil.buildDataSpec(representation, requestUri);
        return new InitializationChunk(dataSource, dataSpec, trackFormat, trackSelectionReason, trackSelectionData, representationHolder.chunkExtractor);
    }

    protected Chunk newMediaChunk(RepresentationHolder representationHolder, DataSource dataSource, int trackType, Format trackFormat, int trackSelectionReason, Object trackSelectionData, long firstSegmentNum, int maxSegmentCount, long seekTimeUs) {
        RangedUri nextSegmentUri;
        RangedUri mergedSegmentUri;
        Representation representation = representationHolder.representation;
        long startTimeUs = representationHolder.getSegmentStartTimeUs(firstSegmentNum);
        RangedUri segmentUri = representationHolder.getSegmentUrl(firstSegmentNum);
        String baseUrl = representation.baseUrl;
        if (representationHolder.chunkExtractor == null) {
            long endTimeUs = representationHolder.getSegmentEndTimeUs(firstSegmentNum);
            DataSpec dataSpec = DashUtil.buildDataSpec(representation, segmentUri);
            return new SingleSampleMediaChunk(dataSource, dataSpec, trackFormat, trackSelectionReason, trackSelectionData, startTimeUs, endTimeUs, firstSegmentNum, trackType, trackFormat);
        }
        int segmentCount = 1;
        for (int i = 1; i < maxSegmentCount && (mergedSegmentUri = segmentUri.attemptMerge(nextSegmentUri = representationHolder.getSegmentUrl(firstSegmentNum + (long)i), baseUrl)) != null; ++i) {
            segmentUri = mergedSegmentUri;
            ++segmentCount;
        }
        long endTimeUs = representationHolder.getSegmentEndTimeUs(firstSegmentNum + (long)segmentCount - 1L);
        long periodDurationUs = representationHolder.periodDurationUs;
        long clippedEndTimeUs = periodDurationUs != -9223372036854775807L && periodDurationUs <= endTimeUs ? periodDurationUs : -9223372036854775807L;
        DataSpec dataSpec = DashUtil.buildDataSpec(representation, segmentUri);
        long sampleOffsetUs = -representation.presentationTimeOffsetUs;
        return new ContainerMediaChunk(dataSource, dataSpec, trackFormat, trackSelectionReason, trackSelectionData, startTimeUs, endTimeUs, seekTimeUs, clippedEndTimeUs, firstSegmentNum, segmentCount, sampleOffsetUs, representationHolder.chunkExtractor);
    }

    protected static final class RepresentationHolder {
        @Nullable
        final ChunkExtractor chunkExtractor;
        public final Representation representation;
        @Nullable
        public final DashSegmentIndex segmentIndex;
        private final long periodDurationUs;
        private final long segmentNumShift;

        RepresentationHolder(long periodDurationUs, int trackType, Representation representation, boolean enableEventMessageTrack, List<Format> closedCaptionFormats, @Nullable TrackOutput playerEmsgTrackOutput) {
            this(periodDurationUs, representation, RepresentationHolder.createChunkExtractor(trackType, representation, enableEventMessageTrack, closedCaptionFormats, playerEmsgTrackOutput), 0L, representation.getIndex());
        }

        private RepresentationHolder(long periodDurationUs, Representation representation, @Nullable ChunkExtractor chunkExtractor, long segmentNumShift, @Nullable DashSegmentIndex segmentIndex) {
            this.periodDurationUs = periodDurationUs;
            this.representation = representation;
            this.segmentNumShift = segmentNumShift;
            this.chunkExtractor = chunkExtractor;
            this.segmentIndex = segmentIndex;
        }

        @CheckResult
        RepresentationHolder copyWithNewRepresentation(long newPeriodDurationUs, Representation newRepresentation) throws BehindLiveWindowException {
            DashSegmentIndex oldIndex = this.representation.getIndex();
            DashSegmentIndex newIndex = newRepresentation.getIndex();
            if (oldIndex == null) {
                return new RepresentationHolder(newPeriodDurationUs, newRepresentation, this.chunkExtractor, this.segmentNumShift, oldIndex);
            }
            if (!oldIndex.isExplicit()) {
                return new RepresentationHolder(newPeriodDurationUs, newRepresentation, this.chunkExtractor, this.segmentNumShift, newIndex);
            }
            int oldIndexSegmentCount = oldIndex.getSegmentCount(newPeriodDurationUs);
            if (oldIndexSegmentCount == 0) {
                return new RepresentationHolder(newPeriodDurationUs, newRepresentation, this.chunkExtractor, this.segmentNumShift, newIndex);
            }
            long oldIndexFirstSegmentNum = oldIndex.getFirstSegmentNum();
            long oldIndexStartTimeUs = oldIndex.getTimeUs(oldIndexFirstSegmentNum);
            long oldIndexLastSegmentNum = oldIndexFirstSegmentNum + (long)oldIndexSegmentCount - 1L;
            long oldIndexEndTimeUs = oldIndex.getTimeUs(oldIndexLastSegmentNum) + oldIndex.getDurationUs(oldIndexLastSegmentNum, newPeriodDurationUs);
            long newIndexFirstSegmentNum = newIndex.getFirstSegmentNum();
            long newIndexStartTimeUs = newIndex.getTimeUs(newIndexFirstSegmentNum);
            long newSegmentNumShift = this.segmentNumShift;
            if (oldIndexEndTimeUs == newIndexStartTimeUs) {
                newSegmentNumShift += oldIndexLastSegmentNum + 1L - newIndexFirstSegmentNum;
            } else {
                if (oldIndexEndTimeUs < newIndexStartTimeUs) {
                    throw new BehindLiveWindowException();
                }
                newSegmentNumShift = newIndexStartTimeUs < oldIndexStartTimeUs ? (newSegmentNumShift -= newIndex.getSegmentNum(oldIndexStartTimeUs, newPeriodDurationUs) - oldIndexFirstSegmentNum) : (newSegmentNumShift += oldIndex.getSegmentNum(newIndexStartTimeUs, newPeriodDurationUs) - newIndexFirstSegmentNum);
            }
            return new RepresentationHolder(newPeriodDurationUs, newRepresentation, this.chunkExtractor, newSegmentNumShift, newIndex);
        }

        @CheckResult
        RepresentationHolder copyWithNewSegmentIndex(DashSegmentIndex segmentIndex) {
            return new RepresentationHolder(this.periodDurationUs, this.representation, this.chunkExtractor, this.segmentNumShift, segmentIndex);
        }

        public long getFirstSegmentNum() {
            return this.segmentIndex.getFirstSegmentNum() + this.segmentNumShift;
        }

        public int getSegmentCount() {
            return this.segmentIndex.getSegmentCount(this.periodDurationUs);
        }

        public long getSegmentStartTimeUs(long segmentNum) {
            return this.segmentIndex.getTimeUs(segmentNum - this.segmentNumShift);
        }

        public long getSegmentEndTimeUs(long segmentNum) {
            return this.getSegmentStartTimeUs(segmentNum) + this.segmentIndex.getDurationUs(segmentNum - this.segmentNumShift, this.periodDurationUs);
        }

        public long getSegmentNum(long positionUs) {
            return this.segmentIndex.getSegmentNum(positionUs, this.periodDurationUs) + this.segmentNumShift;
        }

        public RangedUri getSegmentUrl(long segmentNum) {
            return this.segmentIndex.getSegmentUrl(segmentNum - this.segmentNumShift);
        }

        public long getFirstAvailableSegmentNum(DashManifest manifest, int periodIndex, long nowUnixTimeUs) {
            if (this.getSegmentCount() == -1 && manifest.timeShiftBufferDepthMs != -9223372036854775807L) {
                long liveEdgeTimeUs = nowUnixTimeUs - C.msToUs(manifest.availabilityStartTimeMs);
                long periodStartUs = C.msToUs(manifest.getPeriod((int)periodIndex).startMs);
                long liveEdgeTimeInPeriodUs = liveEdgeTimeUs - periodStartUs;
                long bufferDepthUs = C.msToUs(manifest.timeShiftBufferDepthMs);
                return Math.max(this.getFirstSegmentNum(), this.getSegmentNum(liveEdgeTimeInPeriodUs - bufferDepthUs));
            }
            return this.getFirstSegmentNum();
        }

        public long getLastAvailableSegmentNum(DashManifest manifest, int periodIndex, long nowUnixTimeUs) {
            int availableSegmentCount = this.getSegmentCount();
            if (availableSegmentCount == -1) {
                long liveEdgeTimeUs = nowUnixTimeUs - C.msToUs(manifest.availabilityStartTimeMs);
                if (this.representation instanceof Representation.MultiSegmentRepresentation && AMPPreSettings.getPreSettingsInstance().getLowLatencySettings().isLowLatencyTurnedOn()) {
                    liveEdgeTimeUs += ((Representation.MultiSegmentRepresentation)this.representation).getAvailabilityTimeOffsetUs();
                }
                long periodStartUs = C.msToUs(manifest.getPeriod((int)periodIndex).startMs);
                long liveEdgeTimeInPeriodUs = liveEdgeTimeUs - periodStartUs;
                return this.getSegmentNum(liveEdgeTimeInPeriodUs) - 1L;
            }
            return this.getFirstSegmentNum() + (long)availableSegmentCount - 1L;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        private static ChunkExtractor createChunkExtractor(int trackType, Representation representation, boolean enableEventMessageTrack, List<Format> closedCaptionFormats, @Nullable TrackOutput playerEmsgTrackOutput) {
            void var6_9;
            String containerMimeType = representation.format.containerMimeType;
            if (MimeTypes.isText(containerMimeType)) {
                if (!"application/x-rawcc".equals(containerMimeType)) return null;
                RawCcExtractor rawCcExtractor = new RawCcExtractor(representation.format);
                return new BundledChunkExtractor((Extractor)var6_9, trackType, representation.format);
            } else if (MimeTypes.isMatroska(containerMimeType)) {
                MatroskaExtractor matroskaExtractor = new MatroskaExtractor(1);
                return new BundledChunkExtractor((Extractor)var6_9, trackType, representation.format);
            } else {
                int flags = 0;
                if (enableEventMessageTrack) {
                    flags |= 4;
                }
                FragmentedMp4Extractor fragmentedMp4Extractor = new FragmentedMp4Extractor(flags, null, null, closedCaptionFormats, playerEmsgTrackOutput);
            }
            return new BundledChunkExtractor((Extractor)var6_9, trackType, representation.format);
        }
    }

    protected static final class RepresentationSegmentIterator
    extends BaseMediaChunkIterator {
        private final RepresentationHolder representationHolder;

        public RepresentationSegmentIterator(RepresentationHolder representation, long firstAvailableSegmentNum, long lastAvailableSegmentNum) {
            super(firstAvailableSegmentNum, lastAvailableSegmentNum);
            this.representationHolder = representation;
        }

        @Override
        public DataSpec getDataSpec() {
            this.checkInBounds();
            RangedUri segmentUri = this.representationHolder.getSegmentUrl(this.getCurrentIndex());
            return DashUtil.buildDataSpec(this.representationHolder.representation, segmentUri);
        }

        @Override
        public long getChunkStartTimeUs() {
            this.checkInBounds();
            return this.representationHolder.getSegmentStartTimeUs(this.getCurrentIndex());
        }

        @Override
        public long getChunkEndTimeUs() {
            this.checkInBounds();
            return this.representationHolder.getSegmentEndTimeUs(this.getCurrentIndex());
        }
    }

    public static final class Factory
    implements DashChunkSource.Factory {
        private final DataSource.Factory dataSourceFactory;
        private final int maxSegmentsPerLoad;

        public Factory(DataSource.Factory dataSourceFactory) {
            this(dataSourceFactory, 1);
        }

        public Factory(DataSource.Factory dataSourceFactory, int maxSegmentsPerLoad) {
            this.dataSourceFactory = dataSourceFactory;
            this.maxSegmentsPerLoad = maxSegmentsPerLoad;
        }

        @Override
        public DashChunkSource createDashChunkSource(LoaderErrorThrower manifestLoaderErrorThrower, DashManifest manifest, int periodIndex, int[] adaptationSetIndices, TrackSelection trackSelection, int trackType, long elapsedRealtimeOffsetMs, boolean enableEventMessageTrack, List<Format> closedCaptionFormats, @Nullable PlayerEmsgHandler.PlayerTrackEmsgHandler playerEmsgHandler, @Nullable TransferListener transferListener) {
            DataSource dataSource = this.dataSourceFactory.createDataSource();
            if (transferListener != null) {
                dataSource.addTransferListener(transferListener);
            }
            return new DefaultDashChunkSource(manifestLoaderErrorThrower, manifest, periodIndex, adaptationSetIndices, trackSelection, trackType, dataSource, elapsedRealtimeOffsetMs, this.maxSegmentsPerLoad, enableEventMessageTrack, closedCaptionFormats, playerEmsgHandler);
        }
    }
}

