/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.offline;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.util.SparseIntArray;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.ExoPlaybackException;
import com.akamai.amp.exoplayer2.MediaItem;
import com.akamai.amp.exoplayer2.Renderer;
import com.akamai.amp.exoplayer2.RendererCapabilities;
import com.akamai.amp.exoplayer2.RenderersFactory;
import com.akamai.amp.exoplayer2.Timeline;
import com.akamai.amp.exoplayer2.audio.AudioRendererEventListener;
import com.akamai.amp.exoplayer2.drm.DrmSessionManager;
import com.akamai.amp.exoplayer2.extractor.ExtractorsFactory;
import com.akamai.amp.exoplayer2.offline.DownloadRequest;
import com.akamai.amp.exoplayer2.offline.StreamKey;
import com.akamai.amp.exoplayer2.source.DefaultMediaSourceFactory;
import com.akamai.amp.exoplayer2.source.MediaPeriod;
import com.akamai.amp.exoplayer2.source.MediaSource;
import com.akamai.amp.exoplayer2.source.TrackGroup;
import com.akamai.amp.exoplayer2.source.TrackGroupArray;
import com.akamai.amp.exoplayer2.source.chunk.MediaChunk;
import com.akamai.amp.exoplayer2.source.chunk.MediaChunkIterator;
import com.akamai.amp.exoplayer2.trackselection.BaseTrackSelection;
import com.akamai.amp.exoplayer2.trackselection.DefaultTrackSelector;
import com.akamai.amp.exoplayer2.trackselection.MappingTrackSelector;
import com.akamai.amp.exoplayer2.trackselection.TrackSelection;
import com.akamai.amp.exoplayer2.trackselection.TrackSelectorResult;
import com.akamai.amp.exoplayer2.upstream.Allocator;
import com.akamai.amp.exoplayer2.upstream.BandwidthMeter;
import com.akamai.amp.exoplayer2.upstream.DataSource;
import com.akamai.amp.exoplayer2.upstream.DefaultAllocator;
import com.akamai.amp.exoplayer2.upstream.TransferListener;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Util;
import com.akamai.amp.exoplayer2.video.VideoRendererEventListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.compatqual.NullableType;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class DownloadHelper {
    public static final DefaultTrackSelector.Parameters DEFAULT_TRACK_SELECTOR_PARAMETERS_WITHOUT_CONTEXT;
    @Deprecated
    public static final DefaultTrackSelector.Parameters DEFAULT_TRACK_SELECTOR_PARAMETERS_WITHOUT_VIEWPORT;
    @Deprecated
    public static final DefaultTrackSelector.Parameters DEFAULT_TRACK_SELECTOR_PARAMETERS;
    private final MediaItem.PlaybackProperties playbackProperties;
    @Nullable
    private final MediaSource mediaSource;
    private final DefaultTrackSelector trackSelector;
    private final RendererCapabilities[] rendererCapabilities;
    private final SparseIntArray scratchSet;
    private final Handler callbackHandler;
    private final Timeline.Window window;
    private boolean isPreparedWithMedia;
    private @MonotonicNonNull Callback callback;
    private @MonotonicNonNull MediaPreparer mediaPreparer;
    private TrackGroupArray @MonotonicNonNull [] trackGroupArrays;
    private MappingTrackSelector.MappedTrackInfo @MonotonicNonNull [] mappedTrackInfos;
    private List<TrackSelection> @MonotonicNonNull [][] trackSelectionsByPeriodAndRenderer;
    private List<TrackSelection> @MonotonicNonNull [][] immutableTrackSelectionsByPeriodAndRenderer;

    public static DefaultTrackSelector.Parameters getDefaultTrackSelectorParameters(Context context) {
        return DefaultTrackSelector.Parameters.getDefaults(context).buildUpon().setForceHighestSupportedBitrate(true).build();
    }

    public static RendererCapabilities[] getRendererCapabilities(RenderersFactory renderersFactory) {
        Renderer[] renderers = renderersFactory.createRenderers(Util.createHandlerForCurrentOrMainLooper(), new VideoRendererEventListener(){}, new AudioRendererEventListener(){}, cues -> {}, metadata -> {});
        RendererCapabilities[] capabilities = new RendererCapabilities[renderers.length];
        for (int i = 0; i < renderers.length; ++i) {
            capabilities[i] = renderers[i].getCapabilities();
        }
        return capabilities;
    }

    @Deprecated
    public static DownloadHelper forProgressive(Context context, Uri uri) {
        return DownloadHelper.forMediaItem(context, new MediaItem.Builder().setUri(uri).build());
    }

    @Deprecated
    public static DownloadHelper forProgressive(Context context, Uri uri, @Nullable String cacheKey) {
        return DownloadHelper.forMediaItem(context, new MediaItem.Builder().setUri(uri).setCustomCacheKey(cacheKey).build());
    }

    @Deprecated
    public static DownloadHelper forDash(Context context, Uri uri, DataSource.Factory dataSourceFactory, RenderersFactory renderersFactory) {
        return DownloadHelper.forDash(uri, dataSourceFactory, renderersFactory, null, DownloadHelper.getDefaultTrackSelectorParameters(context));
    }

    @Deprecated
    public static DownloadHelper forDash(Uri uri, DataSource.Factory dataSourceFactory, RenderersFactory renderersFactory, @Nullable DrmSessionManager drmSessionManager, DefaultTrackSelector.Parameters trackSelectorParameters) {
        return DownloadHelper.forMediaItem(new MediaItem.Builder().setUri(uri).setMimeType("application/dash+xml").build(), trackSelectorParameters, renderersFactory, dataSourceFactory, drmSessionManager);
    }

    @Deprecated
    public static DownloadHelper forHls(Context context, Uri uri, DataSource.Factory dataSourceFactory, RenderersFactory renderersFactory) {
        return DownloadHelper.forHls(uri, dataSourceFactory, renderersFactory, null, DownloadHelper.getDefaultTrackSelectorParameters(context));
    }

    @Deprecated
    public static DownloadHelper forHls(Uri uri, DataSource.Factory dataSourceFactory, RenderersFactory renderersFactory, @Nullable DrmSessionManager drmSessionManager, DefaultTrackSelector.Parameters trackSelectorParameters) {
        return DownloadHelper.forMediaItem(new MediaItem.Builder().setUri(uri).setMimeType("application/x-mpegURL").build(), trackSelectorParameters, renderersFactory, dataSourceFactory, drmSessionManager);
    }

    @Deprecated
    public static DownloadHelper forSmoothStreaming(Uri uri, DataSource.Factory dataSourceFactory, RenderersFactory renderersFactory) {
        return DownloadHelper.forSmoothStreaming(uri, dataSourceFactory, renderersFactory, null, DEFAULT_TRACK_SELECTOR_PARAMETERS_WITHOUT_CONTEXT);
    }

    @Deprecated
    public static DownloadHelper forSmoothStreaming(Context context, Uri uri, DataSource.Factory dataSourceFactory, RenderersFactory renderersFactory) {
        return DownloadHelper.forSmoothStreaming(uri, dataSourceFactory, renderersFactory, null, DownloadHelper.getDefaultTrackSelectorParameters(context));
    }

    @Deprecated
    public static DownloadHelper forSmoothStreaming(Uri uri, DataSource.Factory dataSourceFactory, RenderersFactory renderersFactory, @Nullable DrmSessionManager drmSessionManager, DefaultTrackSelector.Parameters trackSelectorParameters) {
        return DownloadHelper.forMediaItem(new MediaItem.Builder().setUri(uri).setMimeType("application/vnd.ms-sstr+xml").build(), trackSelectorParameters, renderersFactory, dataSourceFactory, drmSessionManager);
    }

    public static DownloadHelper forMediaItem(Context context, MediaItem mediaItem) {
        Assertions.checkArgument(DownloadHelper.isProgressive(Assertions.checkNotNull(mediaItem.playbackProperties)));
        return DownloadHelper.forMediaItem(mediaItem, DownloadHelper.getDefaultTrackSelectorParameters(context), null, null, null);
    }

    public static DownloadHelper forMediaItem(Context context, MediaItem mediaItem, @Nullable RenderersFactory renderersFactory, @Nullable DataSource.Factory dataSourceFactory) {
        return DownloadHelper.forMediaItem(mediaItem, DownloadHelper.getDefaultTrackSelectorParameters(context), renderersFactory, dataSourceFactory, null);
    }

    public static DownloadHelper forMediaItem(MediaItem mediaItem, DefaultTrackSelector.Parameters trackSelectorParameters, @Nullable RenderersFactory renderersFactory, @Nullable DataSource.Factory dataSourceFactory) {
        return DownloadHelper.forMediaItem(mediaItem, trackSelectorParameters, renderersFactory, dataSourceFactory, null);
    }

    public static DownloadHelper forMediaItem(MediaItem mediaItem, DefaultTrackSelector.Parameters trackSelectorParameters, @Nullable RenderersFactory renderersFactory, @Nullable DataSource.Factory dataSourceFactory, @Nullable DrmSessionManager drmSessionManager) {
        boolean isProgressive = DownloadHelper.isProgressive(Assertions.checkNotNull(mediaItem.playbackProperties));
        Assertions.checkArgument(isProgressive || dataSourceFactory != null);
        return new DownloadHelper(mediaItem, isProgressive ? null : DownloadHelper.createMediaSourceInternal(mediaItem, Util.castNonNull(dataSourceFactory), drmSessionManager), trackSelectorParameters, renderersFactory != null ? DownloadHelper.getRendererCapabilities(renderersFactory) : new RendererCapabilities[]{});
    }

    public static MediaSource createMediaSource(DownloadRequest downloadRequest, DataSource.Factory dataSourceFactory) {
        return DownloadHelper.createMediaSource(downloadRequest, dataSourceFactory, null);
    }

    public static MediaSource createMediaSource(DownloadRequest downloadRequest, DataSource.Factory dataSourceFactory, @Nullable DrmSessionManager drmSessionManager) {
        return DownloadHelper.createMediaSourceInternal(downloadRequest.toMediaItem(), dataSourceFactory, drmSessionManager);
    }

    public DownloadHelper(MediaItem mediaItem, @Nullable MediaSource mediaSource, DefaultTrackSelector.Parameters trackSelectorParameters, RendererCapabilities[] rendererCapabilities) {
        this.playbackProperties = Assertions.checkNotNull(mediaItem.playbackProperties);
        this.mediaSource = mediaSource;
        this.trackSelector = new DefaultTrackSelector(trackSelectorParameters, (TrackSelection.Factory)new DownloadTrackSelection.Factory());
        this.rendererCapabilities = rendererCapabilities;
        this.scratchSet = new SparseIntArray();
        this.trackSelector.init(() -> {}, new FakeBandwidthMeter());
        this.callbackHandler = Util.createHandlerForCurrentOrMainLooper();
        this.window = new Timeline.Window();
    }

    public void prepare(Callback callback) {
        Assertions.checkState(this.callback == null);
        this.callback = callback;
        if (this.mediaSource != null) {
            this.mediaPreparer = new MediaPreparer(this.mediaSource, this);
        } else {
            this.callbackHandler.post(() -> callback.onPrepared(this));
        }
    }

    public void release() {
        if (this.mediaPreparer != null) {
            this.mediaPreparer.release();
        }
    }

    @Nullable
    public Object getManifest() {
        if (this.mediaSource == null) {
            return null;
        }
        this.assertPreparedWithMedia();
        return this.mediaPreparer.timeline.getWindowCount() > 0 ? this.mediaPreparer.timeline.getWindow((int)0, (Timeline.Window)this.window).manifest : null;
    }

    public int getPeriodCount() {
        if (this.mediaSource == null) {
            return 0;
        }
        this.assertPreparedWithMedia();
        return this.trackGroupArrays.length;
    }

    public TrackGroupArray getTrackGroups(int periodIndex) {
        this.assertPreparedWithMedia();
        return this.trackGroupArrays[periodIndex];
    }

    public MappingTrackSelector.MappedTrackInfo getMappedTrackInfo(int periodIndex) {
        this.assertPreparedWithMedia();
        return this.mappedTrackInfos[periodIndex];
    }

    public List<TrackSelection> getTrackSelections(int periodIndex, int rendererIndex) {
        this.assertPreparedWithMedia();
        return this.immutableTrackSelectionsByPeriodAndRenderer[periodIndex][rendererIndex];
    }

    public void clearTrackSelections(int periodIndex) {
        this.assertPreparedWithMedia();
        for (int i = 0; i < this.rendererCapabilities.length; ++i) {
            this.trackSelectionsByPeriodAndRenderer[periodIndex][i].clear();
        }
    }

    public void replaceTrackSelections(int periodIndex, DefaultTrackSelector.Parameters trackSelectorParameters) {
        this.clearTrackSelections(periodIndex);
        this.addTrackSelection(periodIndex, trackSelectorParameters);
    }

    public void addTrackSelection(int periodIndex, DefaultTrackSelector.Parameters trackSelectorParameters) {
        this.assertPreparedWithMedia();
        this.trackSelector.setParameters(trackSelectorParameters);
        this.runTrackSelection(periodIndex);
    }

    public void addAudioLanguagesToSelection(String ... languages) {
        this.assertPreparedWithMedia();
        for (int periodIndex = 0; periodIndex < this.mappedTrackInfos.length; ++periodIndex) {
            DefaultTrackSelector.ParametersBuilder parametersBuilder = DEFAULT_TRACK_SELECTOR_PARAMETERS_WITHOUT_CONTEXT.buildUpon();
            MappingTrackSelector.MappedTrackInfo mappedTrackInfo = this.mappedTrackInfos[periodIndex];
            int rendererCount = mappedTrackInfo.getRendererCount();
            for (int rendererIndex = 0; rendererIndex < rendererCount; ++rendererIndex) {
                if (mappedTrackInfo.getRendererType(rendererIndex) == 1) continue;
                parametersBuilder.setRendererDisabled(rendererIndex, true);
            }
            for (String language : languages) {
                parametersBuilder.setPreferredAudioLanguage(language);
                this.addTrackSelection(periodIndex, parametersBuilder.build());
            }
        }
    }

    public void addTextLanguagesToSelection(boolean selectUndeterminedTextLanguage, String ... languages) {
        this.assertPreparedWithMedia();
        for (int periodIndex = 0; periodIndex < this.mappedTrackInfos.length; ++periodIndex) {
            DefaultTrackSelector.ParametersBuilder parametersBuilder = DEFAULT_TRACK_SELECTOR_PARAMETERS_WITHOUT_CONTEXT.buildUpon();
            MappingTrackSelector.MappedTrackInfo mappedTrackInfo = this.mappedTrackInfos[periodIndex];
            int rendererCount = mappedTrackInfo.getRendererCount();
            for (int rendererIndex = 0; rendererIndex < rendererCount; ++rendererIndex) {
                if (mappedTrackInfo.getRendererType(rendererIndex) == 3) continue;
                parametersBuilder.setRendererDisabled(rendererIndex, true);
            }
            parametersBuilder.setSelectUndeterminedTextLanguage(selectUndeterminedTextLanguage);
            for (String language : languages) {
                parametersBuilder.setPreferredTextLanguage(language);
                this.addTrackSelection(periodIndex, parametersBuilder.build());
            }
        }
    }

    public void addTrackSelectionForSingleRenderer(int periodIndex, int rendererIndex, DefaultTrackSelector.Parameters trackSelectorParameters, List<DefaultTrackSelector.SelectionOverride> overrides) {
        this.assertPreparedWithMedia();
        DefaultTrackSelector.ParametersBuilder builder = trackSelectorParameters.buildUpon();
        for (int i = 0; i < this.mappedTrackInfos[periodIndex].getRendererCount(); ++i) {
            builder.setRendererDisabled(i, i != rendererIndex);
        }
        if (overrides.isEmpty()) {
            this.addTrackSelection(periodIndex, builder.build());
        } else {
            TrackGroupArray trackGroupArray = this.mappedTrackInfos[periodIndex].getTrackGroups(rendererIndex);
            for (int i = 0; i < overrides.size(); ++i) {
                builder.setSelectionOverride(rendererIndex, trackGroupArray, overrides.get(i));
                this.addTrackSelection(periodIndex, builder.build());
            }
        }
    }

    public DownloadRequest getDownloadRequest(@Nullable byte[] data) {
        return this.getDownloadRequest(this.playbackProperties.uri.toString(), data);
    }

    public DownloadRequest getDownloadRequest(String id, @Nullable byte[] data) {
        DownloadRequest.Builder requestBuilder = new DownloadRequest.Builder(id, this.playbackProperties.uri).setMimeType(this.playbackProperties.mimeType).setKeySetId(this.playbackProperties.drmConfiguration != null ? this.playbackProperties.drmConfiguration.getKeySetId() : null).setCustomCacheKey(this.playbackProperties.customCacheKey).setData(data);
        if (this.mediaSource == null) {
            return requestBuilder.build();
        }
        this.assertPreparedWithMedia();
        ArrayList<StreamKey> streamKeys = new ArrayList<StreamKey>();
        ArrayList<TrackSelection> allSelections = new ArrayList<TrackSelection>();
        int periodCount = this.trackSelectionsByPeriodAndRenderer.length;
        for (int periodIndex = 0; periodIndex < periodCount; ++periodIndex) {
            allSelections.clear();
            int rendererCount = this.trackSelectionsByPeriodAndRenderer[periodIndex].length;
            for (int rendererIndex = 0; rendererIndex < rendererCount; ++rendererIndex) {
                allSelections.addAll(this.trackSelectionsByPeriodAndRenderer[periodIndex][rendererIndex]);
            }
            streamKeys.addAll(this.mediaPreparer.mediaPeriods[periodIndex].getStreamKeys(allSelections));
        }
        return requestBuilder.setStreamKeys(streamKeys).build();
    }

    private void onMediaPrepared() {
        int i;
        Assertions.checkNotNull(this.mediaPreparer);
        Assertions.checkNotNull(this.mediaPreparer.mediaPeriods);
        Assertions.checkNotNull(this.mediaPreparer.timeline);
        int periodCount = this.mediaPreparer.mediaPeriods.length;
        int rendererCount = this.rendererCapabilities.length;
        this.trackSelectionsByPeriodAndRenderer = new List[periodCount][rendererCount];
        this.immutableTrackSelectionsByPeriodAndRenderer = new List[periodCount][rendererCount];
        for (i = 0; i < periodCount; ++i) {
            for (int j = 0; j < rendererCount; ++j) {
                this.trackSelectionsByPeriodAndRenderer[i][j] = new ArrayList<TrackSelection>();
                this.immutableTrackSelectionsByPeriodAndRenderer[i][j] = Collections.unmodifiableList(this.trackSelectionsByPeriodAndRenderer[i][j]);
            }
        }
        this.trackGroupArrays = new TrackGroupArray[periodCount];
        this.mappedTrackInfos = new MappingTrackSelector.MappedTrackInfo[periodCount];
        for (i = 0; i < periodCount; ++i) {
            this.trackGroupArrays[i] = this.mediaPreparer.mediaPeriods[i].getTrackGroups();
            TrackSelectorResult trackSelectorResult = this.runTrackSelection(i);
            this.trackSelector.onSelectionActivated(trackSelectorResult.info);
            this.mappedTrackInfos[i] = Assertions.checkNotNull(this.trackSelector.getCurrentMappedTrackInfo());
        }
        this.setPreparedWithMedia();
        Assertions.checkNotNull(this.callbackHandler).post(() -> Assertions.checkNotNull(this.callback).onPrepared(this));
    }

    private void onMediaPreparationFailed(IOException error) {
        Assertions.checkNotNull(this.callbackHandler).post(() -> Assertions.checkNotNull(this.callback).onPrepareError(this, error));
    }

    @RequiresNonNull(value={"trackGroupArrays", "mappedTrackInfos", "trackSelectionsByPeriodAndRenderer", "immutableTrackSelectionsByPeriodAndRenderer", "mediaPreparer", "mediaPreparer.timeline", "mediaPreparer.mediaPeriods"})
    private void setPreparedWithMedia() {
        this.isPreparedWithMedia = true;
    }

    @EnsuresNonNull(value={"trackGroupArrays", "mappedTrackInfos", "trackSelectionsByPeriodAndRenderer", "immutableTrackSelectionsByPeriodAndRenderer", "mediaPreparer", "mediaPreparer.timeline", "mediaPreparer.mediaPeriods"})
    private void assertPreparedWithMedia() {
        Assertions.checkState(this.isPreparedWithMedia);
    }

    @RequiresNonNull(value={"trackGroupArrays", "trackSelectionsByPeriodAndRenderer", "mediaPreparer", "mediaPreparer.timeline"})
    private TrackSelectorResult runTrackSelection(int periodIndex) {
        try {
            TrackSelectorResult trackSelectorResult = this.trackSelector.selectTracks(this.rendererCapabilities, this.trackGroupArrays[periodIndex], new MediaSource.MediaPeriodId(this.mediaPreparer.timeline.getUidOfPeriod(periodIndex)), this.mediaPreparer.timeline);
            for (int i = 0; i < trackSelectorResult.length; ++i) {
                TrackSelection newSelection = trackSelectorResult.selections.get(i);
                if (newSelection == null) continue;
                List<TrackSelection> existingSelectionList = this.trackSelectionsByPeriodAndRenderer[periodIndex][i];
                boolean mergedWithExistingSelection = false;
                for (int j = 0; j < existingSelectionList.size(); ++j) {
                    int k;
                    TrackSelection existingSelection = existingSelectionList.get(j);
                    if (existingSelection.getTrackGroup() != newSelection.getTrackGroup()) continue;
                    this.scratchSet.clear();
                    for (k = 0; k < existingSelection.length(); ++k) {
                        this.scratchSet.put(existingSelection.getIndexInTrackGroup(k), 0);
                    }
                    for (k = 0; k < newSelection.length(); ++k) {
                        this.scratchSet.put(newSelection.getIndexInTrackGroup(k), 0);
                    }
                    int[] mergedTracks = new int[this.scratchSet.size()];
                    for (int k2 = 0; k2 < this.scratchSet.size(); ++k2) {
                        mergedTracks[k2] = this.scratchSet.keyAt(k2);
                    }
                    existingSelectionList.set(j, new DownloadTrackSelection(existingSelection.getTrackGroup(), mergedTracks));
                    mergedWithExistingSelection = true;
                    break;
                }
                if (mergedWithExistingSelection) continue;
                existingSelectionList.add(newSelection);
            }
            return trackSelectorResult;
        }
        catch (ExoPlaybackException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    private static MediaSource createMediaSourceInternal(MediaItem mediaItem, DataSource.Factory dataSourceFactory, @Nullable DrmSessionManager drmSessionManager) {
        return new DefaultMediaSourceFactory(dataSourceFactory, ExtractorsFactory.EMPTY, null).setDrmSessionManager(drmSessionManager).createMediaSource(mediaItem);
    }

    private static boolean isProgressive(MediaItem.PlaybackProperties playbackProperties) {
        return Util.inferContentTypeForUriAndMimeType(playbackProperties.uri, playbackProperties.mimeType) == 3;
    }

    static {
        DEFAULT_TRACK_SELECTOR_PARAMETERS_WITHOUT_VIEWPORT = DEFAULT_TRACK_SELECTOR_PARAMETERS_WITHOUT_CONTEXT = DefaultTrackSelector.Parameters.DEFAULT_WITHOUT_CONTEXT.buildUpon().setForceHighestSupportedBitrate(true).build();
        DEFAULT_TRACK_SELECTOR_PARAMETERS = DEFAULT_TRACK_SELECTOR_PARAMETERS_WITHOUT_CONTEXT;
    }

    private static final class DownloadTrackSelection
    extends BaseTrackSelection {
        public DownloadTrackSelection(TrackGroup trackGroup, int[] tracks) {
            super(trackGroup, tracks);
        }

        @Override
        public int getSelectedIndex() {
            return 0;
        }

        @Override
        public int getSelectionReason() {
            return 0;
        }

        @Override
        @Nullable
        public Object getSelectionData() {
            return null;
        }

        @Override
        public void updateSelectedTrack(long playbackPositionUs, long bufferedDurationUs, long availableDurationUs, List<? extends MediaChunk> queue, MediaChunkIterator[] mediaChunkIterators) {
        }

        private static final class Factory
        implements TrackSelection.Factory {
            private Factory() {
            }

            @Override
            public @NullableType TrackSelection[] createTrackSelections(@NullableType TrackSelection.Definition[] definitions, BandwidthMeter bandwidthMeter) {
                @NullableType TrackSelection[] selections = new TrackSelection[definitions.length];
                for (int i = 0; i < definitions.length; ++i) {
                    selections[i] = definitions[i] == null ? null : new DownloadTrackSelection(definitions[i].group, definitions[i].tracks);
                }
                return selections;
            }
        }
    }

    private static final class FakeBandwidthMeter
    implements BandwidthMeter {
        private FakeBandwidthMeter() {
        }

        @Override
        public long getBitrateEstimate() {
            return 0L;
        }

        @Override
        @Nullable
        public TransferListener getTransferListener() {
            return null;
        }

        @Override
        public void addEventListener(Handler eventHandler, BandwidthMeter.EventListener eventListener) {
        }

        @Override
        public void removeEventListener(BandwidthMeter.EventListener eventListener) {
        }
    }

    public static interface Callback {
        public void onPrepared(DownloadHelper var1);

        public void onPrepareError(DownloadHelper var1, IOException var2);
    }

    private static final class MediaPreparer
    implements MediaSource.MediaSourceCaller,
    MediaPeriod.Callback,
    Handler.Callback {
        private static final int MESSAGE_PREPARE_SOURCE = 0;
        private static final int MESSAGE_CHECK_FOR_FAILURE = 1;
        private static final int MESSAGE_CONTINUE_LOADING = 2;
        private static final int MESSAGE_RELEASE = 3;
        private static final int DOWNLOAD_HELPER_CALLBACK_MESSAGE_PREPARED = 0;
        private static final int DOWNLOAD_HELPER_CALLBACK_MESSAGE_FAILED = 1;
        private final MediaSource mediaSource;
        private final DownloadHelper downloadHelper;
        private final Allocator allocator;
        private final ArrayList<MediaPeriod> pendingMediaPeriods;
        private final Handler downloadHelperHandler;
        private final HandlerThread mediaSourceThread;
        private final Handler mediaSourceHandler;
        public @MonotonicNonNull Timeline timeline;
        public MediaPeriod @MonotonicNonNull [] mediaPeriods;
        private boolean released;

        public MediaPreparer(MediaSource mediaSource, DownloadHelper downloadHelper) {
            Handler downloadThreadHandler;
            this.mediaSource = mediaSource;
            this.downloadHelper = downloadHelper;
            this.allocator = new DefaultAllocator(true, 65536);
            this.pendingMediaPeriods = new ArrayList();
            this.downloadHelperHandler = downloadThreadHandler = Util.createHandlerForCurrentOrMainLooper(this::handleDownloadHelperCallbackMessage);
            this.mediaSourceThread = new HandlerThread("ExoPlayer:DownloadHelper");
            this.mediaSourceThread.start();
            this.mediaSourceHandler = Util.createHandler(this.mediaSourceThread.getLooper(), this);
            this.mediaSourceHandler.sendEmptyMessage(0);
        }

        public void release() {
            if (this.released) {
                return;
            }
            this.released = true;
            this.mediaSourceHandler.sendEmptyMessage(3);
        }

        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    this.mediaSource.prepareSource(this, null);
                    this.mediaSourceHandler.sendEmptyMessage(1);
                    return true;
                }
                case 1: {
                    try {
                        if (this.mediaPeriods == null) {
                            this.mediaSource.maybeThrowSourceInfoRefreshError();
                        } else {
                            for (int i = 0; i < this.pendingMediaPeriods.size(); ++i) {
                                this.pendingMediaPeriods.get(i).maybeThrowPrepareError();
                            }
                        }
                        this.mediaSourceHandler.sendEmptyMessageDelayed(1, 100L);
                    }
                    catch (IOException e) {
                        this.downloadHelperHandler.obtainMessage(1, (Object)e).sendToTarget();
                    }
                    return true;
                }
                case 2: {
                    MediaPeriod mediaPeriod = (MediaPeriod)msg.obj;
                    if (this.pendingMediaPeriods.contains(mediaPeriod)) {
                        mediaPeriod.continueLoading(0L);
                    }
                    return true;
                }
                case 3: {
                    if (this.mediaPeriods != null) {
                        for (MediaPeriod period : this.mediaPeriods) {
                            this.mediaSource.releasePeriod(period);
                        }
                    }
                    this.mediaSource.releaseSource(this);
                    this.mediaSourceHandler.removeCallbacksAndMessages(null);
                    this.mediaSourceThread.quit();
                    return true;
                }
            }
            return false;
        }

        @Override
        public void onSourceInfoRefreshed(MediaSource source, Timeline timeline) {
            if (this.timeline != null) {
                return;
            }
            if (timeline.getWindow((int)0, (Timeline.Window)new Timeline.Window()).isLive) {
                this.downloadHelperHandler.obtainMessage(1, (Object)new LiveContentUnsupportedException()).sendToTarget();
                return;
            }
            this.timeline = timeline;
            this.mediaPeriods = new MediaPeriod[timeline.getPeriodCount()];
            for (int i = 0; i < this.mediaPeriods.length; ++i) {
                MediaPeriod mediaPeriod;
                this.mediaPeriods[i] = mediaPeriod = this.mediaSource.createPeriod(new MediaSource.MediaPeriodId(timeline.getUidOfPeriod(i)), this.allocator, 0L);
                this.pendingMediaPeriods.add(mediaPeriod);
            }
            for (MediaPeriod mediaPeriod : this.mediaPeriods) {
                mediaPeriod.prepare(this, 0L);
            }
        }

        @Override
        public void onPrepared(MediaPeriod mediaPeriod) {
            this.pendingMediaPeriods.remove(mediaPeriod);
            if (this.pendingMediaPeriods.isEmpty()) {
                this.mediaSourceHandler.removeMessages(1);
                this.downloadHelperHandler.sendEmptyMessage(0);
            }
        }

        @Override
        public void onContinueLoadingRequested(MediaPeriod mediaPeriod) {
            if (this.pendingMediaPeriods.contains(mediaPeriod)) {
                this.mediaSourceHandler.obtainMessage(2, (Object)mediaPeriod).sendToTarget();
            }
        }

        private boolean handleDownloadHelperCallbackMessage(Message msg) {
            if (this.released) {
                return false;
            }
            switch (msg.what) {
                case 0: {
                    this.downloadHelper.onMediaPrepared();
                    return true;
                }
                case 1: {
                    this.release();
                    this.downloadHelper.onMediaPreparationFailed((IOException)Util.castNonNull(msg.obj));
                    return true;
                }
            }
            return false;
        }
    }

    public static class LiveContentUnsupportedException
    extends IOException {
    }
}

