/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.extractor.wav;

import android.util.Pair;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.ParserException;
import com.akamai.amp.exoplayer2.extractor.ExtractorInput;
import com.akamai.amp.exoplayer2.extractor.wav.WavHeader;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Log;
import com.akamai.amp.exoplayer2.util.ParsableByteArray;
import com.akamai.amp.exoplayer2.util.Util;
import java.io.IOException;

final class WavHeaderReader {
    private static final String TAG = "WavHeaderReader";

    @Nullable
    public static WavHeader peek(ExtractorInput input) throws IOException {
        byte[] extraData;
        Assertions.checkNotNull(input);
        ParsableByteArray scratch = new ParsableByteArray(16);
        ChunkHeader chunkHeader = ChunkHeader.peek(input, scratch);
        if (chunkHeader.id != 1380533830) {
            return null;
        }
        input.peekFully(scratch.getData(), 0, 4);
        scratch.setPosition(0);
        int riffFormat = scratch.readInt();
        if (riffFormat != 1463899717) {
            Log.e(TAG, "Unsupported RIFF format: " + riffFormat);
            return null;
        }
        chunkHeader = ChunkHeader.peek(input, scratch);
        while (chunkHeader.id != 1718449184) {
            input.advancePeekPosition((int)chunkHeader.size);
            chunkHeader = ChunkHeader.peek(input, scratch);
        }
        Assertions.checkState(chunkHeader.size >= 16L);
        input.peekFully(scratch.getData(), 0, 16);
        scratch.setPosition(0);
        int audioFormatType = scratch.readLittleEndianUnsignedShort();
        int numChannels = scratch.readLittleEndianUnsignedShort();
        int frameRateHz = scratch.readLittleEndianUnsignedIntToInt();
        int averageBytesPerSecond = scratch.readLittleEndianUnsignedIntToInt();
        int blockSize = scratch.readLittleEndianUnsignedShort();
        int bitsPerSample = scratch.readLittleEndianUnsignedShort();
        int bytesLeft = (int)chunkHeader.size - 16;
        if (bytesLeft > 0) {
            extraData = new byte[bytesLeft];
            input.peekFully(extraData, 0, bytesLeft);
        } else {
            extraData = Util.EMPTY_BYTE_ARRAY;
        }
        return new WavHeader(audioFormatType, numChannels, frameRateHz, averageBytesPerSecond, blockSize, bitsPerSample, extraData);
    }

    public static Pair<Long, Long> skipToData(ExtractorInput input) throws IOException {
        Assertions.checkNotNull(input);
        input.resetPeekPosition();
        ParsableByteArray scratch = new ParsableByteArray(8);
        ChunkHeader chunkHeader = ChunkHeader.peek(input, scratch);
        while (chunkHeader.id != 1684108385) {
            if (chunkHeader.id != 1380533830 && chunkHeader.id != 1718449184) {
                Log.w(TAG, "Ignoring unknown WAV chunk: " + chunkHeader.id);
            }
            long bytesToSkip = 8L + chunkHeader.size;
            if (chunkHeader.id == 1380533830) {
                bytesToSkip = 12L;
            }
            if (bytesToSkip > Integer.MAX_VALUE) {
                throw new ParserException("Chunk is too large (~2GB+) to skip; id: " + chunkHeader.id);
            }
            input.skipFully((int)bytesToSkip);
            chunkHeader = ChunkHeader.peek(input, scratch);
        }
        input.skipFully(8);
        long dataStartPosition = input.getPosition();
        long dataEndPosition = dataStartPosition + chunkHeader.size;
        long inputLength = input.getLength();
        if (inputLength != -1L && dataEndPosition > inputLength) {
            Log.w(TAG, "Data exceeds input length: " + dataEndPosition + ", " + inputLength);
            dataEndPosition = inputLength;
        }
        return Pair.create((Object)dataStartPosition, (Object)dataEndPosition);
    }

    private WavHeaderReader() {
    }

    private static final class ChunkHeader {
        public static final int SIZE_IN_BYTES = 8;
        public final int id;
        public final long size;

        private ChunkHeader(int id2, long size) {
            this.id = id2;
            this.size = size;
        }

        public static ChunkHeader peek(ExtractorInput input, ParsableByteArray scratch) throws IOException {
            input.peekFully(scratch.getData(), 0, 8);
            scratch.setPosition(0);
            int id2 = scratch.readInt();
            long size = scratch.readLittleEndianUnsignedInt();
            return new ChunkHeader(id2, size);
        }
    }
}

