/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.config.data.heartbeat;

import com.akamai.amp.analytics.AnalyticsTrackerData;
import com.akamai.amp.config.data.heartbeat.HeartbeatConfigurationData;
import java.util.HashMap;
import java.util.Map;

public class HeartbeatData
extends AnalyticsTrackerData {
    private HeartbeatConfigurationData config;
    private Map<String, String> standardVideoMetadata;
    private Map<String, String> customVideoMetadata;
    private Map<String, String> standardAdMetadata;
    private Map<String, String> customAdMetadata;

    public HeartbeatData(HeartbeatConfigurationData config) {
        this.config = config;
    }

    public HeartbeatData(HeartbeatConfigurationData config, Map<String, String> videoMetadata, Map<String, String> adMetadata) {
        this.config = config;
        this.standardVideoMetadata = this.validMap(videoMetadata);
        this.standardAdMetadata = this.validMap(adMetadata);
    }

    public HeartbeatData(HeartbeatConfigurationData config, Map<String, String> standardVideoMetadata, Map<String, String> customVideoMetadata, Map<String, String> standardAdMetadata, Map<String, String> customAdMetadata) {
        this.config = config;
        this.standardVideoMetadata = this.validMap(standardVideoMetadata);
        this.customVideoMetadata = this.validMap(customVideoMetadata);
        this.standardAdMetadata = this.validMap(standardAdMetadata);
        this.customAdMetadata = this.validMap(customAdMetadata);
    }

    public HeartbeatConfigurationData getConfig() {
        return this.config;
    }

    public void setConfig(HeartbeatConfigurationData config) {
        this.config = config;
    }

    public void setStandardVideoMetadata(Map<String, String> standardVideoMetadata) {
        this.standardVideoMetadata = standardVideoMetadata;
    }

    public void setCustomVideoMetadata(Map<String, String> customVideoMetadata) {
        this.customVideoMetadata = customVideoMetadata;
    }

    public void setStandardAdMetadata(Map<String, String> standardAdMetadata) {
        this.standardAdMetadata = standardAdMetadata;
    }

    public void setCustomAdMetadata(Map<String, String> customAdMetadata) {
        this.customAdMetadata = customAdMetadata;
    }

    public Map<String, String> getVideoMetadata() {
        return this.join(this.standardVideoMetadata, this.customVideoMetadata);
    }

    public Map<String, String> getAdMetadata() {
        return this.join(this.standardAdMetadata, this.customAdMetadata);
    }

    public void putContentData(String key, String value) {
        this.customVideoMetadata = this.validMap(this.customVideoMetadata);
        this.customVideoMetadata.put(key, value);
    }

    public void putAdData(String key, String value) {
        this.customAdMetadata = this.validMap(this.customAdMetadata);
        this.customAdMetadata.put(key, value);
    }

    private Map<String, String> getStandardVideoMetadata() {
        return this.standardVideoMetadata;
    }

    private Map<String, String> getCustomVideoMetadata() {
        return this.customVideoMetadata;
    }

    private Map<String, String> getStandardAdMetadata() {
        return this.standardAdMetadata;
    }

    private Map<String, String> getCustomAdMetadata() {
        return this.customAdMetadata;
    }

    private Map<String, String> validMap(Map<String, String> param) {
        if (param == null) {
            return new HashMap<String, String>();
        }
        return param;
    }

    private Map<String, String> join(Map<String, String> param1, Map<String, String> param2) {
        Map<String, String> a = this.validMap(param1);
        Map<String, String> b = this.validMap(param2);
        HashMap<String, String> result = new HashMap<String, String>();
        result.putAll(a);
        result.putAll(b);
        return result;
    }
}

