/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.source;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.extractor.DefaultExtractorInput;
import com.akamai.amp.exoplayer2.extractor.Extractor;
import com.akamai.amp.exoplayer2.extractor.ExtractorInput;
import com.akamai.amp.exoplayer2.extractor.ExtractorOutput;
import com.akamai.amp.exoplayer2.extractor.ExtractorsFactory;
import com.akamai.amp.exoplayer2.extractor.PositionHolder;
import com.akamai.amp.exoplayer2.extractor.mp3.Mp3Extractor;
import com.akamai.amp.exoplayer2.source.ProgressiveMediaExtractor;
import com.akamai.amp.exoplayer2.source.UnrecognizedInputFormatException;
import com.akamai.amp.exoplayer2.upstream.DataReader;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Util;
import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import java.util.Map;

final class BundledExtractorsAdapter
implements ProgressiveMediaExtractor {
    private final ExtractorsFactory extractorsFactory;
    @Nullable
    private Extractor extractor;
    @Nullable
    private ExtractorInput extractorInput;

    public BundledExtractorsAdapter(ExtractorsFactory extractorsFactory) {
        this.extractorsFactory = extractorsFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    @Override
    public void init(DataReader dataReader, Uri uri, Map<String, List<String>> responseHeaders, long position, long length, ExtractorOutput output) throws IOException {
        DefaultExtractorInput extractorInput = new DefaultExtractorInput(dataReader, position, length);
        this.extractorInput = extractorInput;
        if (this.extractor != null) {
            return;
        }
        Object[] extractors = this.extractorsFactory.createExtractors(uri, responseHeaders);
        if (extractors.length == 1) {
            this.extractor = extractors[0];
        } else {
            for (Extractor extractor : extractors) {
                block9: {
                    try {
                        if (!extractor.sniff(extractorInput)) break block9;
                        this.extractor = extractor;
                        Assertions.checkState(this.extractor != null || extractorInput.getPosition() == position);
                    }
                    catch (EOFException eOFException) {
                        Assertions.checkState(this.extractor != null || extractorInput.getPosition() == position);
                        extractorInput.resetPeekPosition();
                        continue;
                        catch (Throwable throwable) {
                            Assertions.checkState(this.extractor != null || extractorInput.getPosition() == position);
                            extractorInput.resetPeekPosition();
                            throw throwable;
                        }
                    }
                    extractorInput.resetPeekPosition();
                    break;
                }
                Assertions.checkState(this.extractor != null || extractorInput.getPosition() == position);
                extractorInput.resetPeekPosition();
            }
            if (this.extractor == null) {
                throw new UnrecognizedInputFormatException("None of the available extractors (" + Util.getCommaDelimitedSimpleClassNames(extractors) + ") could read the stream.", Assertions.checkNotNull(uri));
            }
        }
        this.extractor.init(output);
    }

    @Override
    public void release() {
        if (this.extractor != null) {
            this.extractor.release();
            this.extractor = null;
        }
        this.extractorInput = null;
    }

    @Override
    public void disableSeekingOnMp3Streams() {
        if (this.extractor instanceof Mp3Extractor) {
            ((Mp3Extractor)this.extractor).disableSeeking();
        }
    }

    @Override
    public long getCurrentInputPosition() {
        return this.extractorInput != null ? this.extractorInput.getPosition() : -1L;
    }

    @Override
    public void seek(long position, long seekTimeUs) {
        Assertions.checkNotNull(this.extractor).seek(position, seekTimeUs);
    }

    @Override
    public int read(PositionHolder positionHolder) throws IOException {
        return Assertions.checkNotNull(this.extractor).read(Assertions.checkNotNull(this.extractorInput), positionHolder);
    }
}

