/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.trackselection;

import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.source.TrackGroup;
import com.akamai.amp.exoplayer2.source.chunk.MediaChunk;
import com.akamai.amp.exoplayer2.source.chunk.MediaChunkIterator;
import com.akamai.amp.exoplayer2.trackselection.BaseTrackSelection;
import com.akamai.amp.exoplayer2.trackselection.TrackSelection;
import com.akamai.amp.exoplayer2.trackselection.TrackSelectionUtil;
import com.akamai.amp.exoplayer2.upstream.BandwidthMeter;
import java.util.List;
import org.checkerframework.checker.nullness.compatqual.NullableType;

public final class FixedTrackSelection
extends BaseTrackSelection {
    private final int reason;
    @Nullable
    private final Object data;

    public FixedTrackSelection(TrackGroup group, int track) {
        this(group, track, 0, null);
    }

    public FixedTrackSelection(TrackGroup group, int track, int reason, @Nullable Object data) {
        super(group, track);
        this.reason = reason;
        this.data = data;
    }

    @Override
    public void updateSelectedTrack(long playbackPositionUs, long bufferedDurationUs, long availableDurationUs, List<? extends MediaChunk> queue, MediaChunkIterator[] mediaChunkIterators) {
    }

    @Override
    public int getSelectedIndex() {
        return 0;
    }

    @Override
    public int getSelectionReason() {
        return this.reason;
    }

    @Override
    @Nullable
    public Object getSelectionData() {
        return this.data;
    }

    @Deprecated
    public static final class Factory
    implements TrackSelection.Factory {
        private final int reason;
        @Nullable
        private final Object data;

        public Factory() {
            this.reason = 0;
            this.data = null;
        }

        public Factory(int reason, @Nullable Object data) {
            this.reason = reason;
            this.data = data;
        }

        @Override
        public @NullableType TrackSelection[] createTrackSelections(@NullableType TrackSelection.Definition[] definitions, BandwidthMeter bandwidthMeter) {
            return TrackSelectionUtil.createTrackSelectionsForDefinitions(definitions, definition -> new FixedTrackSelection(definition.group, definition.tracks[0], this.reason, this.data));
        }
    }
}

