/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.source.chunk;

import android.os.Looper;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.C;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.FormatHolder;
import com.akamai.amp.exoplayer2.SeekParameters;
import com.akamai.amp.exoplayer2.decoder.DecoderInputBuffer;
import com.akamai.amp.exoplayer2.drm.DrmSessionEventListener;
import com.akamai.amp.exoplayer2.drm.DrmSessionManager;
import com.akamai.amp.exoplayer2.source.LoadEventInfo;
import com.akamai.amp.exoplayer2.source.MediaLoadData;
import com.akamai.amp.exoplayer2.source.MediaSourceEventListener;
import com.akamai.amp.exoplayer2.source.SampleQueue;
import com.akamai.amp.exoplayer2.source.SampleStream;
import com.akamai.amp.exoplayer2.source.SequenceableLoader;
import com.akamai.amp.exoplayer2.source.chunk.BaseMediaChunk;
import com.akamai.amp.exoplayer2.source.chunk.BaseMediaChunkOutput;
import com.akamai.amp.exoplayer2.source.chunk.Chunk;
import com.akamai.amp.exoplayer2.source.chunk.ChunkHolder;
import com.akamai.amp.exoplayer2.source.chunk.ChunkSource;
import com.akamai.amp.exoplayer2.source.chunk.InitializationChunk;
import com.akamai.amp.exoplayer2.upstream.Allocator;
import com.akamai.amp.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.akamai.amp.exoplayer2.upstream.Loader;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Log;
import com.akamai.amp.exoplayer2.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class ChunkSampleStream<T extends ChunkSource>
implements SampleStream,
SequenceableLoader,
Loader.Callback<Chunk>,
Loader.ReleaseCallback {
    private static final String TAG = "ChunkSampleStream";
    public final int primaryTrackType;
    private final int[] embeddedTrackTypes;
    private final Format[] embeddedTrackFormats;
    private final boolean[] embeddedTracksSelected;
    private final T chunkSource;
    private final SequenceableLoader.Callback<ChunkSampleStream<T>> callback;
    private final MediaSourceEventListener.EventDispatcher mediaSourceEventDispatcher;
    private final LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    private final Loader loader;
    private final ChunkHolder nextChunkHolder;
    private final ArrayList<BaseMediaChunk> mediaChunks;
    private final List<BaseMediaChunk> readOnlyMediaChunks;
    private final SampleQueue primarySampleQueue;
    private final SampleQueue[] embeddedSampleQueues;
    private final BaseMediaChunkOutput chunkOutput;
    @Nullable
    private Chunk loadingChunk;
    private @MonotonicNonNull Format primaryDownstreamTrackFormat;
    @Nullable
    private ReleaseCallback<T> releaseCallback;
    private long pendingResetPositionUs;
    private long lastSeekPositionUs;
    private int nextNotifyPrimaryFormatMediaChunkIndex;
    @Nullable
    private BaseMediaChunk canceledMediaChunk;
    boolean loadingFinished;

    public ChunkSampleStream(int primaryTrackType, @Nullable int[] embeddedTrackTypes, @Nullable Format[] embeddedTrackFormats, T chunkSource, SequenceableLoader.Callback<ChunkSampleStream<T>> callback, Allocator allocator, long positionUs, DrmSessionManager drmSessionManager, DrmSessionEventListener.EventDispatcher drmEventDispatcher, LoadErrorHandlingPolicy loadErrorHandlingPolicy, MediaSourceEventListener.EventDispatcher mediaSourceEventDispatcher) {
        this.primaryTrackType = primaryTrackType;
        this.embeddedTrackTypes = embeddedTrackTypes == null ? new int[]{} : embeddedTrackTypes;
        this.embeddedTrackFormats = embeddedTrackFormats == null ? new Format[]{} : embeddedTrackFormats;
        this.chunkSource = chunkSource;
        this.callback = callback;
        this.mediaSourceEventDispatcher = mediaSourceEventDispatcher;
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        this.loader = new Loader("Loader:ChunkSampleStream");
        this.nextChunkHolder = new ChunkHolder();
        this.mediaChunks = new ArrayList();
        this.readOnlyMediaChunks = Collections.unmodifiableList(this.mediaChunks);
        int embeddedTrackCount = this.embeddedTrackTypes.length;
        this.embeddedSampleQueues = new SampleQueue[embeddedTrackCount];
        this.embeddedTracksSelected = new boolean[embeddedTrackCount];
        int[] trackTypes = new int[1 + embeddedTrackCount];
        SampleQueue[] sampleQueues = new SampleQueue[1 + embeddedTrackCount];
        this.primarySampleQueue = new SampleQueue(allocator, Assertions.checkNotNull(Looper.myLooper()), drmSessionManager, drmEventDispatcher);
        trackTypes[0] = primaryTrackType;
        sampleQueues[0] = this.primarySampleQueue;
        for (int i = 0; i < embeddedTrackCount; ++i) {
            SampleQueue sampleQueue;
            this.embeddedSampleQueues[i] = sampleQueue = new SampleQueue(allocator, Assertions.checkNotNull(Looper.myLooper()), DrmSessionManager.getDummyDrmSessionManager(), drmEventDispatcher);
            sampleQueues[i + 1] = sampleQueue;
            trackTypes[i + 1] = this.embeddedTrackTypes[i];
        }
        this.chunkOutput = new BaseMediaChunkOutput(trackTypes, sampleQueues);
        this.pendingResetPositionUs = positionUs;
        this.lastSeekPositionUs = positionUs;
    }

    public void discardBuffer(long positionUs, boolean toKeyframe) {
        if (this.isPendingReset()) {
            return;
        }
        int oldFirstSampleIndex = this.primarySampleQueue.getFirstIndex();
        this.primarySampleQueue.discardTo(positionUs, toKeyframe, true);
        int newFirstSampleIndex = this.primarySampleQueue.getFirstIndex();
        if (newFirstSampleIndex > oldFirstSampleIndex) {
            long discardToUs = this.primarySampleQueue.getFirstTimestampUs();
            for (int i = 0; i < this.embeddedSampleQueues.length; ++i) {
                this.embeddedSampleQueues[i].discardTo(discardToUs, toKeyframe, this.embeddedTracksSelected[i]);
            }
        }
        this.discardDownstreamMediaChunks(newFirstSampleIndex);
    }

    public EmbeddedSampleStream selectEmbeddedTrack(long positionUs, int trackType) {
        for (int i = 0; i < this.embeddedSampleQueues.length; ++i) {
            if (this.embeddedTrackTypes[i] != trackType) continue;
            Assertions.checkState(!this.embeddedTracksSelected[i]);
            this.embeddedTracksSelected[i] = true;
            this.embeddedSampleQueues[i].seekTo(positionUs, true);
            return new EmbeddedSampleStream(this, this.embeddedSampleQueues[i], i);
        }
        throw new IllegalStateException();
    }

    public T getChunkSource() {
        return this.chunkSource;
    }

    @Override
    public long getBufferedPositionUs() {
        BaseMediaChunk lastCompletedMediaChunk;
        if (this.loadingFinished) {
            return Long.MIN_VALUE;
        }
        if (this.isPendingReset()) {
            return this.pendingResetPositionUs;
        }
        long bufferedPositionUs = this.lastSeekPositionUs;
        BaseMediaChunk lastMediaChunk = this.getLastMediaChunk();
        BaseMediaChunk baseMediaChunk = lastMediaChunk.isLoadCompleted() ? lastMediaChunk : (lastCompletedMediaChunk = this.mediaChunks.size() > 1 ? this.mediaChunks.get(this.mediaChunks.size() - 2) : null);
        if (lastCompletedMediaChunk != null) {
            bufferedPositionUs = Math.max(bufferedPositionUs, lastCompletedMediaChunk.endTimeUs);
        }
        return Math.max(bufferedPositionUs, this.primarySampleQueue.getLargestQueuedTimestampUs());
    }

    public long getAdjustedSeekPositionUs(long positionUs, SeekParameters seekParameters) {
        return this.chunkSource.getAdjustedSeekPositionUs(positionUs, seekParameters);
    }

    public void seekToUs(long positionUs) {
        boolean seekInsideBuffer;
        this.lastSeekPositionUs = positionUs;
        if (this.isPendingReset()) {
            this.pendingResetPositionUs = positionUs;
            return;
        }
        BaseMediaChunk seekToMediaChunk = null;
        for (int i = 0; i < this.mediaChunks.size(); ++i) {
            BaseMediaChunk mediaChunk = this.mediaChunks.get(i);
            long mediaChunkStartTimeUs = mediaChunk.startTimeUs;
            if (mediaChunkStartTimeUs == positionUs && mediaChunk.clippedStartTimeUs == -9223372036854775807L) {
                seekToMediaChunk = mediaChunk;
                break;
            }
            if (mediaChunkStartTimeUs > positionUs) break;
        }
        if (seekInsideBuffer = seekToMediaChunk != null ? this.primarySampleQueue.seekTo(seekToMediaChunk.getFirstSampleIndex(0)) : this.primarySampleQueue.seekTo(positionUs, positionUs < this.getNextLoadPositionUs())) {
            this.nextNotifyPrimaryFormatMediaChunkIndex = this.primarySampleIndexToMediaChunkIndex(this.primarySampleQueue.getReadIndex(), 0);
            for (SampleQueue embeddedSampleQueue : this.embeddedSampleQueues) {
                embeddedSampleQueue.seekTo(positionUs, true);
            }
        } else {
            this.pendingResetPositionUs = positionUs;
            this.loadingFinished = false;
            this.mediaChunks.clear();
            this.nextNotifyPrimaryFormatMediaChunkIndex = 0;
            if (this.loader.isLoading()) {
                this.primarySampleQueue.discardToEnd();
                for (SampleQueue embeddedSampleQueue : this.embeddedSampleQueues) {
                    embeddedSampleQueue.discardToEnd();
                }
                this.loader.cancelLoading();
            } else {
                this.loader.clearFatalError();
                this.resetSampleQueues();
            }
        }
    }

    public void release() {
        this.release(null);
    }

    public void release(@Nullable ReleaseCallback<T> callback) {
        this.releaseCallback = callback;
        this.primarySampleQueue.preRelease();
        for (SampleQueue embeddedSampleQueue : this.embeddedSampleQueues) {
            embeddedSampleQueue.preRelease();
        }
        this.loader.release(this);
    }

    @Override
    public void onLoaderReleased() {
        this.primarySampleQueue.release();
        for (SampleQueue embeddedSampleQueue : this.embeddedSampleQueues) {
            embeddedSampleQueue.release();
        }
        this.chunkSource.release();
        if (this.releaseCallback != null) {
            this.releaseCallback.onSampleStreamReleased(this);
        }
    }

    @Override
    public boolean isReady() {
        return !this.isPendingReset() && this.primarySampleQueue.isReady(this.loadingFinished);
    }

    @Override
    public void maybeThrowError() throws IOException {
        this.loader.maybeThrowError();
        this.primarySampleQueue.maybeThrowError();
        if (!this.loader.isLoading()) {
            this.chunkSource.maybeThrowError();
        }
    }

    @Override
    public int readData(FormatHolder formatHolder, DecoderInputBuffer buffer, boolean formatRequired) {
        if (this.isPendingReset()) {
            return -3;
        }
        if (this.canceledMediaChunk != null && this.canceledMediaChunk.getFirstSampleIndex(0) <= this.primarySampleQueue.getReadIndex()) {
            return -3;
        }
        this.maybeNotifyPrimaryTrackFormatChanged();
        return this.primarySampleQueue.read(formatHolder, buffer, formatRequired, this.loadingFinished);
    }

    @Override
    public int skipData(long positionUs) {
        if (this.isPendingReset()) {
            return 0;
        }
        int skipCount = this.primarySampleQueue.getSkipCount(positionUs, this.loadingFinished);
        if (this.canceledMediaChunk != null) {
            int maxSkipCount = this.canceledMediaChunk.getFirstSampleIndex(0) - this.primarySampleQueue.getReadIndex();
            skipCount = Math.min(skipCount, maxSkipCount);
        }
        this.primarySampleQueue.skip(skipCount);
        this.maybeNotifyPrimaryTrackFormatChanged();
        return skipCount;
    }

    @Override
    public void onLoadCompleted(Chunk loadable, long elapsedRealtimeMs, long loadDurationMs) {
        this.loadingChunk = null;
        this.chunkSource.onChunkLoadCompleted(loadable);
        LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
        this.mediaSourceEventDispatcher.loadCompleted(loadEventInfo, loadable.type, this.primaryTrackType, loadable.trackFormat, loadable.trackSelectionReason, loadable.trackSelectionData, loadable.startTimeUs, loadable.endTimeUs);
        this.callback.onContinueLoadingRequested(this);
    }

    @Override
    public void onLoadCanceled(Chunk loadable, long elapsedRealtimeMs, long loadDurationMs, boolean released) {
        this.loadingChunk = null;
        this.canceledMediaChunk = null;
        LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
        this.mediaSourceEventDispatcher.loadCanceled(loadEventInfo, loadable.type, this.primaryTrackType, loadable.trackFormat, loadable.trackSelectionReason, loadable.trackSelectionData, loadable.startTimeUs, loadable.endTimeUs);
        if (!released) {
            if (this.isPendingReset()) {
                this.resetSampleQueues();
            } else if (this.isMediaChunk(loadable)) {
                this.discardUpstreamMediaChunksFromIndex(this.mediaChunks.size() - 1);
                if (this.mediaChunks.isEmpty()) {
                    this.pendingResetPositionUs = this.lastSeekPositionUs;
                }
            }
            this.callback.onContinueLoadingRequested(this);
        }
    }

    @Override
    public Loader.LoadErrorAction onLoadError(Chunk loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error, int errorCount) {
        long bytesLoaded = loadable.bytesLoaded();
        boolean isMediaChunk = this.isMediaChunk(loadable);
        int lastChunkIndex = this.mediaChunks.size() - 1;
        boolean cancelable = bytesLoaded == 0L || !isMediaChunk || !this.haveReadFromMediaChunk(lastChunkIndex);
        LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), elapsedRealtimeMs, loadDurationMs, bytesLoaded);
        MediaLoadData mediaLoadData = new MediaLoadData(loadable.type, this.primaryTrackType, loadable.trackFormat, loadable.trackSelectionReason, loadable.trackSelectionData, C.usToMs(loadable.startTimeUs), C.usToMs(loadable.endTimeUs));
        LoadErrorHandlingPolicy.LoadErrorInfo loadErrorInfo = new LoadErrorHandlingPolicy.LoadErrorInfo(loadEventInfo, mediaLoadData, error, errorCount);
        long exclusionDurationMs = cancelable ? this.loadErrorHandlingPolicy.getBlacklistDurationMsFor(loadErrorInfo) : -9223372036854775807L;
        Loader.LoadErrorAction loadErrorAction = null;
        if (this.chunkSource.onChunkLoadError(loadable, cancelable, error, exclusionDurationMs)) {
            if (cancelable) {
                loadErrorAction = Loader.DONT_RETRY;
                if (isMediaChunk) {
                    BaseMediaChunk removed = this.discardUpstreamMediaChunksFromIndex(lastChunkIndex);
                    Assertions.checkState(removed == loadable);
                    if (this.mediaChunks.isEmpty()) {
                        this.pendingResetPositionUs = this.lastSeekPositionUs;
                    }
                }
            } else {
                Log.w(TAG, "Ignoring attempt to cancel non-cancelable load.");
            }
        }
        if (loadErrorAction == null) {
            long retryDelayMs = this.loadErrorHandlingPolicy.getRetryDelayMsFor(loadErrorInfo);
            loadErrorAction = retryDelayMs != -9223372036854775807L ? Loader.createRetryAction(false, retryDelayMs) : Loader.DONT_RETRY_FATAL;
        }
        boolean canceled = !loadErrorAction.isRetry();
        this.mediaSourceEventDispatcher.loadError(loadEventInfo, loadable.type, this.primaryTrackType, loadable.trackFormat, loadable.trackSelectionReason, loadable.trackSelectionData, loadable.startTimeUs, loadable.endTimeUs, error, canceled);
        if (canceled) {
            this.loadingChunk = null;
            this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
            this.callback.onContinueLoadingRequested(this);
        }
        return loadErrorAction;
    }

    @Override
    public boolean continueLoading(long positionUs) {
        long loadPositionUs;
        List<Object> chunkQueue;
        if (this.loadingFinished || this.loader.isLoading() || this.loader.hasFatalError()) {
            return false;
        }
        boolean pendingReset = this.isPendingReset();
        if (pendingReset) {
            chunkQueue = Collections.emptyList();
            loadPositionUs = this.pendingResetPositionUs;
        } else {
            chunkQueue = this.readOnlyMediaChunks;
            loadPositionUs = this.getLastMediaChunk().endTimeUs;
        }
        this.chunkSource.getNextChunk(positionUs, loadPositionUs, chunkQueue, this.nextChunkHolder);
        boolean endOfStream = this.nextChunkHolder.endOfStream;
        Chunk loadable = this.nextChunkHolder.chunk;
        this.nextChunkHolder.clear();
        if (endOfStream) {
            this.pendingResetPositionUs = -9223372036854775807L;
            this.loadingFinished = true;
            return true;
        }
        if (loadable == null) {
            return false;
        }
        this.loadingChunk = loadable;
        if (this.isMediaChunk(loadable)) {
            BaseMediaChunk mediaChunk = (BaseMediaChunk)loadable;
            if (pendingReset) {
                if (mediaChunk.startTimeUs != this.pendingResetPositionUs) {
                    this.primarySampleQueue.setStartTimeUs(this.pendingResetPositionUs);
                    for (SampleQueue embeddedSampleQueue : this.embeddedSampleQueues) {
                        embeddedSampleQueue.setStartTimeUs(this.pendingResetPositionUs);
                    }
                }
                this.pendingResetPositionUs = -9223372036854775807L;
            }
            mediaChunk.init(this.chunkOutput);
            this.mediaChunks.add(mediaChunk);
        } else if (loadable instanceof InitializationChunk) {
            ((InitializationChunk)loadable).init(this.chunkOutput);
        }
        long elapsedRealtimeMs = this.loader.startLoading(loadable, this, this.loadErrorHandlingPolicy.getMinimumLoadableRetryCount(loadable.type));
        this.mediaSourceEventDispatcher.loadStarted(new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, elapsedRealtimeMs), loadable.type, this.primaryTrackType, loadable.trackFormat, loadable.trackSelectionReason, loadable.trackSelectionData, loadable.startTimeUs, loadable.endTimeUs);
        return true;
    }

    @Override
    public boolean isLoading() {
        return this.loader.isLoading();
    }

    @Override
    public long getNextLoadPositionUs() {
        if (this.isPendingReset()) {
            return this.pendingResetPositionUs;
        }
        return this.loadingFinished ? Long.MIN_VALUE : this.getLastMediaChunk().endTimeUs;
    }

    @Override
    public void reevaluateBuffer(long positionUs) {
        if (this.loader.hasFatalError() || this.isPendingReset()) {
            return;
        }
        if (this.loader.isLoading()) {
            Chunk loadingChunk = Assertions.checkNotNull(this.loadingChunk);
            if (this.isMediaChunk(loadingChunk) && this.haveReadFromMediaChunk(this.mediaChunks.size() - 1)) {
                return;
            }
            if (this.chunkSource.shouldCancelLoad(positionUs, loadingChunk, this.readOnlyMediaChunks)) {
                this.loader.cancelLoading();
                if (this.isMediaChunk(loadingChunk)) {
                    this.canceledMediaChunk = (BaseMediaChunk)loadingChunk;
                }
            }
            return;
        }
        int preferredQueueSize = this.chunkSource.getPreferredQueueSize(positionUs, this.readOnlyMediaChunks);
        if (preferredQueueSize < this.mediaChunks.size()) {
            this.discardUpstream(preferredQueueSize);
        }
    }

    private void discardUpstream(int preferredQueueSize) {
        Assertions.checkState(!this.loader.isLoading());
        int currentQueueSize = this.mediaChunks.size();
        int newQueueSize = -1;
        for (int i = preferredQueueSize; i < currentQueueSize; ++i) {
            if (this.haveReadFromMediaChunk(i)) continue;
            newQueueSize = i;
            break;
        }
        if (newQueueSize == -1) {
            return;
        }
        long endTimeUs = this.getLastMediaChunk().endTimeUs;
        BaseMediaChunk firstRemovedChunk = this.discardUpstreamMediaChunksFromIndex(newQueueSize);
        if (this.mediaChunks.isEmpty()) {
            this.pendingResetPositionUs = this.lastSeekPositionUs;
        }
        this.loadingFinished = false;
        this.mediaSourceEventDispatcher.upstreamDiscarded(this.primaryTrackType, firstRemovedChunk.startTimeUs, endTimeUs);
    }

    private boolean isMediaChunk(Chunk chunk) {
        return chunk instanceof BaseMediaChunk;
    }

    private void resetSampleQueues() {
        this.primarySampleQueue.reset();
        for (SampleQueue embeddedSampleQueue : this.embeddedSampleQueues) {
            embeddedSampleQueue.reset();
        }
    }

    private boolean haveReadFromMediaChunk(int mediaChunkIndex) {
        BaseMediaChunk mediaChunk = this.mediaChunks.get(mediaChunkIndex);
        if (this.primarySampleQueue.getReadIndex() > mediaChunk.getFirstSampleIndex(0)) {
            return true;
        }
        for (int i = 0; i < this.embeddedSampleQueues.length; ++i) {
            if (this.embeddedSampleQueues[i].getReadIndex() <= mediaChunk.getFirstSampleIndex(i + 1)) continue;
            return true;
        }
        return false;
    }

    boolean isPendingReset() {
        return this.pendingResetPositionUs != -9223372036854775807L;
    }

    private void discardDownstreamMediaChunks(int discardToSampleIndex) {
        int discardToMediaChunkIndex = this.primarySampleIndexToMediaChunkIndex(discardToSampleIndex, 0);
        if ((discardToMediaChunkIndex = Math.min(discardToMediaChunkIndex, this.nextNotifyPrimaryFormatMediaChunkIndex)) > 0) {
            Util.removeRange(this.mediaChunks, 0, discardToMediaChunkIndex);
            this.nextNotifyPrimaryFormatMediaChunkIndex -= discardToMediaChunkIndex;
        }
    }

    private void maybeNotifyPrimaryTrackFormatChanged() {
        int readSampleIndex = this.primarySampleQueue.getReadIndex();
        int notifyToMediaChunkIndex = this.primarySampleIndexToMediaChunkIndex(readSampleIndex, this.nextNotifyPrimaryFormatMediaChunkIndex - 1);
        while (this.nextNotifyPrimaryFormatMediaChunkIndex <= notifyToMediaChunkIndex) {
            this.maybeNotifyPrimaryTrackFormatChanged(this.nextNotifyPrimaryFormatMediaChunkIndex++);
        }
    }

    private void maybeNotifyPrimaryTrackFormatChanged(int mediaChunkReadIndex) {
        BaseMediaChunk currentChunk = this.mediaChunks.get(mediaChunkReadIndex);
        Format trackFormat = currentChunk.trackFormat;
        if (!trackFormat.equals(this.primaryDownstreamTrackFormat)) {
            this.mediaSourceEventDispatcher.downstreamFormatChanged(this.primaryTrackType, trackFormat, currentChunk.trackSelectionReason, currentChunk.trackSelectionData, currentChunk.startTimeUs);
        }
        this.primaryDownstreamTrackFormat = trackFormat;
    }

    private int primarySampleIndexToMediaChunkIndex(int primarySampleIndex, int minChunkIndex) {
        for (int i = minChunkIndex + 1; i < this.mediaChunks.size(); ++i) {
            if (this.mediaChunks.get(i).getFirstSampleIndex(0) <= primarySampleIndex) continue;
            return i - 1;
        }
        return this.mediaChunks.size() - 1;
    }

    private BaseMediaChunk getLastMediaChunk() {
        return this.mediaChunks.get(this.mediaChunks.size() - 1);
    }

    private BaseMediaChunk discardUpstreamMediaChunksFromIndex(int chunkIndex) {
        BaseMediaChunk firstRemovedChunk = this.mediaChunks.get(chunkIndex);
        Util.removeRange(this.mediaChunks, chunkIndex, this.mediaChunks.size());
        this.nextNotifyPrimaryFormatMediaChunkIndex = Math.max(this.nextNotifyPrimaryFormatMediaChunkIndex, this.mediaChunks.size());
        this.primarySampleQueue.discardUpstreamSamples(firstRemovedChunk.getFirstSampleIndex(0));
        for (int i = 0; i < this.embeddedSampleQueues.length; ++i) {
            this.embeddedSampleQueues[i].discardUpstreamSamples(firstRemovedChunk.getFirstSampleIndex(i + 1));
        }
        return firstRemovedChunk;
    }

    public final class EmbeddedSampleStream
    implements SampleStream {
        public final ChunkSampleStream<T> parent;
        private final SampleQueue sampleQueue;
        private final int index;
        private boolean notifiedDownstreamFormat;

        public EmbeddedSampleStream(ChunkSampleStream<T> parent, SampleQueue sampleQueue, int index) {
            this.parent = parent;
            this.sampleQueue = sampleQueue;
            this.index = index;
        }

        @Override
        public boolean isReady() {
            return !ChunkSampleStream.this.isPendingReset() && this.sampleQueue.isReady(ChunkSampleStream.this.loadingFinished);
        }

        @Override
        public int skipData(long positionUs) {
            if (ChunkSampleStream.this.isPendingReset()) {
                return 0;
            }
            int skipCount = this.sampleQueue.getSkipCount(positionUs, ChunkSampleStream.this.loadingFinished);
            if (ChunkSampleStream.this.canceledMediaChunk != null) {
                int maxSkipCount = ChunkSampleStream.this.canceledMediaChunk.getFirstSampleIndex(1 + this.index) - this.sampleQueue.getReadIndex();
                skipCount = Math.min(skipCount, maxSkipCount);
            }
            this.sampleQueue.skip(skipCount);
            if (skipCount > 0) {
                this.maybeNotifyDownstreamFormat();
            }
            return skipCount;
        }

        @Override
        public void maybeThrowError() {
        }

        @Override
        public int readData(FormatHolder formatHolder, DecoderInputBuffer buffer, boolean formatRequired) {
            if (ChunkSampleStream.this.isPendingReset()) {
                return -3;
            }
            if (ChunkSampleStream.this.canceledMediaChunk != null && ChunkSampleStream.this.canceledMediaChunk.getFirstSampleIndex(1 + this.index) <= this.sampleQueue.getReadIndex()) {
                return -3;
            }
            this.maybeNotifyDownstreamFormat();
            return this.sampleQueue.read(formatHolder, buffer, formatRequired, ChunkSampleStream.this.loadingFinished);
        }

        public void release() {
            Assertions.checkState(ChunkSampleStream.this.embeddedTracksSelected[this.index]);
            ChunkSampleStream.this.embeddedTracksSelected[this.index] = false;
        }

        private void maybeNotifyDownstreamFormat() {
            if (!this.notifiedDownstreamFormat) {
                ChunkSampleStream.this.mediaSourceEventDispatcher.downstreamFormatChanged(ChunkSampleStream.this.embeddedTrackTypes[this.index], ChunkSampleStream.this.embeddedTrackFormats[this.index], 0, null, ChunkSampleStream.this.lastSeekPositionUs);
                this.notifiedDownstreamFormat = true;
            }
        }
    }

    public static interface ReleaseCallback<T extends ChunkSource> {
        public void onSampleStreamReleased(ChunkSampleStream<T> var1);
    }
}

