/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteStatement;
import android.os.Process;
import com.adobe.mobile.AbstractDatabaseBacking;
import com.adobe.mobile.AbstractHitDatabase;
import com.adobe.mobile.MobileConfig;
import com.adobe.mobile.MobilePrivacyStatus;
import com.adobe.mobile.RequestHandler;
import com.adobe.mobile.StaticMethods;
import java.io.File;
import java.util.HashMap;

class ThirdPartyQueue
extends AbstractHitDatabase {
    private SQLiteStatement _preparedInsertStatement = null;
    private static final String _hitsTableName = "HITS";
    private static final String[] _hitsSelectedColumns = new String[]{"ID", "URL", "POSTBODY", "POSTTYPE", "TIMESTAMP", "TIMEOUT"};
    private static final String _hitsOrderBy = "ID ASC";
    private static final String _hitsNumberOfRowsToReturn = "1";
    private static final int THIRDPARTY_TIMESTAMP_DISABLED_WAIT_THRESHOLD = 60;
    private static final int THIRDPARTY_TIMEOUT_COOLDOWN_TIMER = 30;
    protected static final String THIRDPARTY_THREAD_SUFFIX = "third-party";
    protected static final String THIRDPARTY_FILENAME = "ADBMobile3rdPartyDataCache.sqlite";
    protected static final String THIRDPARTY_LOG_PREFIX = "External Callback";
    protected static final String THIRDPARTY_DB_CREATE_STATEMENT = "CREATE TABLE IF NOT EXISTS HITS (ID INTEGER PRIMARY KEY AUTOINCREMENT, URL TEXT, POSTBODY TEXT, POSTTYPE TEXT, TIMESTAMP INTEGER, TIMEOUT INTEGER)";
    private static ThirdPartyQueue _instance = null;
    private static final Object _instanceMutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ThirdPartyQueue sharedInstance() {
        Object object = _instanceMutex;
        synchronized (object) {
            if (_instance == null) {
                _instance = new ThirdPartyQueue();
            }
            return _instance;
        }
    }

    protected ThirdPartyQueue() {
        this.fileName = this.fileName();
        this.logPrefix = this.logPrefix();
        this.dbCreateStatement = THIRDPARTY_DB_CREATE_STATEMENT;
        this.lastHitTimestamp = 0L;
        this.initDatabaseBacking(new File(StaticMethods.getCacheDirectory(), this.fileName));
        this.numberOfUnsentHits = this.getTrackingQueueSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queue(String url, String postBody, String type, long timestamp, long timeout) {
        MobileConfig mobileConfigInstance = MobileConfig.getInstance();
        if (mobileConfigInstance == null) {
            StaticMethods.logErrorFormat("%s - Cannot send hit, MobileConfig is null (this really shouldn't happen)", this.logPrefix);
            return;
        }
        if (mobileConfigInstance.getPrivacyStatus() == MobilePrivacyStatus.MOBILE_PRIVACY_STATUS_OPT_OUT) {
            StaticMethods.logDebugFormat("%s - Ignoring hit due to privacy status being opted out", this.logPrefix);
            return;
        }
        Object object = this.dbMutex;
        synchronized (object) {
            try {
                this._preparedInsertStatement.bindString(1, url);
                if (postBody != null && postBody.length() > 0) {
                    this._preparedInsertStatement.bindString(2, postBody);
                } else {
                    this._preparedInsertStatement.bindNull(2);
                }
                if (type != null && type.length() > 0) {
                    this._preparedInsertStatement.bindString(3, type);
                } else {
                    this._preparedInsertStatement.bindNull(3);
                }
                this._preparedInsertStatement.bindLong(4, timestamp);
                this._preparedInsertStatement.bindLong(5, timeout);
                this._preparedInsertStatement.execute();
                ++this.numberOfUnsentHits;
                this._preparedInsertStatement.clearBindings();
            }
            catch (SQLException e) {
                StaticMethods.logErrorFormat("%s - Unable to insert url (%s)", this.logPrefix, url);
                this.resetDatabase((Exception)((Object)e));
            }
            catch (Exception e) {
                StaticMethods.logErrorFormat("%s - Unknown error while inserting url (%s)", this.logPrefix, url);
                this.resetDatabase(e);
            }
        }
        this.kick(false);
    }

    protected String threadSuffix() {
        return THIRDPARTY_THREAD_SUFFIX;
    }

    protected String logPrefix() {
        return THIRDPARTY_LOG_PREFIX;
    }

    protected String fileName() {
        return THIRDPARTY_FILENAME;
    }

    @Override
    protected void prepareStatements() {
        try {
            this._preparedInsertStatement = this.database.compileStatement("INSERT INTO HITS (URL, POSTBODY, POSTTYPE, TIMESTAMP, TIMEOUT) VALUES (?, ?, ?, ?, ?)");
        }
        catch (NullPointerException x) {
            StaticMethods.logErrorFormat("%s - Unable to create database due to an invalid path (%s)", this.logPrefix, x.getLocalizedMessage());
        }
        catch (SQLException x) {
            StaticMethods.logErrorFormat("%s - Unable to create database due to a sql error (%s)", this.logPrefix, x.getLocalizedMessage());
        }
        catch (Exception x) {
            StaticMethods.logErrorFormat("%s - Unable to create database due to an unexpected error (%s)", this.logPrefix, x.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AbstractHitDatabase.Hit selectOldestHit() {
        AbstractHitDatabase.Hit hit = null;
        Object object = this.dbMutex;
        synchronized (object) {
            Cursor cursor = null;
            try {
                cursor = this.database.query(_hitsTableName, _hitsSelectedColumns, null, null, null, null, _hitsOrderBy, _hitsNumberOfRowsToReturn);
                if (cursor.moveToFirst()) {
                    hit = new AbstractHitDatabase.Hit();
                    hit.identifier = cursor.getString(0);
                    hit.urlFragment = cursor.getString(1);
                    hit.postBody = cursor.getString(2);
                    hit.postType = cursor.getString(3);
                    hit.timestamp = cursor.getLong(4);
                    hit.timeout = cursor.getInt(5);
                }
            }
            catch (SQLException e) {
                StaticMethods.logErrorFormat("%s - Unable to read from database (%s)", this.logPrefix, e.getMessage());
            }
            catch (Exception e) {
                StaticMethods.logErrorFormat("%s - Unknown error reading from database (%s)", this.logPrefix, e.getMessage());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        return hit;
    }

    protected ThirdPartyQueue getWorker() {
        return ThirdPartyQueue.sharedInstance();
    }

    @Override
    protected Runnable workerThread() {
        final ThirdPartyQueue worker = this.getWorker();
        return new Runnable(){

            @Override
            public void run() {
                AbstractHitDatabase.Hit hit;
                Process.setThreadPriority((int)10);
                boolean offlineEnabled = MobileConfig.getInstance().getOfflineTrackingEnabled();
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Accept-Language", StaticMethods.getDefaultAcceptLanguage());
                headers.put("User-Agent", StaticMethods.getDefaultUserAgent());
                while (MobileConfig.getInstance().getPrivacyStatus() == MobilePrivacyStatus.MOBILE_PRIVACY_STATUS_OPT_IN && (!MobileConfig.getInstance().reachabilityChecksEnabled() || MobileConfig.getInstance().networkConnectivity()) && (hit = worker.selectOldestHit()) != null && hit.urlFragment != null) {
                    if (!offlineEnabled && hit.timestamp < StaticMethods.getTimeSince1970() - 60L) {
                        try {
                            worker.deleteHit(hit.identifier);
                            continue;
                        }
                        catch (AbstractDatabaseBacking.CorruptedDatabaseException ex) {
                            worker.resetDatabase(ex);
                            break;
                        }
                    }
                    hit.postBody = hit.postBody != null ? hit.postBody : "";
                    hit.postType = hit.postType != null ? hit.postType : "";
                    int n = hit.timeout = hit.timeout < 2 ? 2000 : hit.timeout * 1000;
                    if (RequestHandler.sendThirdPartyRequest(hit.urlFragment, hit.postBody, headers, hit.timeout, hit.postType, ThirdPartyQueue.this.logPrefix)) {
                        try {
                            worker.deleteHit(hit.identifier);
                        }
                        catch (AbstractDatabaseBacking.CorruptedDatabaseException ex) {
                            worker.resetDatabase(ex);
                            break;
                        }
                        worker.lastHitTimestamp = hit.timestamp;
                        continue;
                    }
                    StaticMethods.logWarningFormat("%s - Unable to forward hit (%s)", ThirdPartyQueue.this.logPrefix, hit.urlFragment);
                    if (!MobileConfig.getInstance().getOfflineTrackingEnabled()) {
                        try {
                            worker.deleteHit(hit.identifier);
                            continue;
                        }
                        catch (AbstractDatabaseBacking.CorruptedDatabaseException ex) {
                            worker.resetDatabase(ex);
                            break;
                        }
                    }
                    long delay = 30L;
                    StaticMethods.logDebugFormat("%s - Network error, imposing internal cooldown (%d seconds)", ThirdPartyQueue.this.logPrefix, delay);
                    try {
                        MobileConfig mobileConfig = MobileConfig.getInstance();
                        int i = 0;
                        while ((long)i < delay && (!mobileConfig.reachabilityChecksEnabled() || mobileConfig.networkConnectivity())) {
                            Thread.sleep(1000L);
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        StaticMethods.logWarningFormat("%s - Background Thread Interrupted (%s)", ThirdPartyQueue.this.logPrefix, e.getMessage());
                    }
                }
                worker.bgThreadActive = false;
            }
        };
    }
}

