/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.widget.Toast;
import com.adobe.mobile.FloatingButton;
import com.adobe.mobile.MessageMatcherEquals;
import com.adobe.mobile.MessageTargetExperienceUIFullScreen;
import com.adobe.mobile.Messages;
import com.adobe.mobile.MobileConfig;
import com.adobe.mobile.NetworkObject;
import com.adobe.mobile.RequestHandler;
import com.adobe.mobile.StaticMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;

class TargetPreviewManager
implements FloatingButton.OnButtonDetachedFromWindowListener,
FloatingButton.OnPositionChangedListener {
    static final String ADB_TARGET_PREVIEW_URL_TOKEN_KEY = "at_preview_token";
    static final String ADB_TARGET_PREVIEW_URL_ENDPOINT_KEY = "at_preview_endpoint";
    private static final String TARGET_PREVIEW_API_UI_FETCH_URL_BASE = "https://hal.testandtarget.omniture.com";
    private static final String TARGET_PREVIEW_API_UI_FETCH_URL_PATH = "/ui/admin/%s/preview/?token=%s";
    private String targetPreviewApiUiFetchUrlBaseOverride = null;
    private static final String TARGET_PREVIEW_UI_MESSAGE_TRIGGER_KEY = "a.targetpreview.show";
    private static final String TARGET_PREVIEW_UI_MESSAGE_TRIGGER_VALUE = "true";
    private String restartDeeplink = null;
    private static TargetPreviewManager targetPreviewManager = null;
    private float lastFloatingButtonX = -1.0f;
    private float lastFloatingButtonY = -1.0f;
    private String targetPreviewToken = null;
    private static final Object _targetPreviewTokenMutex = new Object();
    private String targetPreviewParams = null;
    private final Object _targetPreviewParamsMutex = new Object();
    private String targetPreviewExperienceUIHtml = null;
    private MessageTargetExperienceUIFullScreen targetPreviewExperienceUI = null;
    private static final Object _instanceMutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setToken(String token) {
        Object object = _targetPreviewTokenMutex;
        synchronized (object) {
            this.targetPreviewToken = token;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getToken() {
        Object object = _targetPreviewTokenMutex;
        synchronized (object) {
            return this.targetPreviewToken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPreviewParams(String params) {
        Object object = this._targetPreviewParamsMutex;
        synchronized (object) {
            this.targetPreviewParams = params;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getPreviewParams() {
        Object object = this._targetPreviewParamsMutex;
        synchronized (object) {
            return this.targetPreviewParams;
        }
    }

    private TargetPreviewManager() {
    }

    protected MessageTargetExperienceUIFullScreen getMessageTargetExperienceUIFullscreen() {
        if (this.targetPreviewExperienceUI == null) {
            this.targetPreviewExperienceUI = this.createMessageTargetExperienceUIFullscreen();
        }
        return this.targetPreviewExperienceUI;
    }

    protected MessageTargetExperienceUIFullScreen createMessageTargetExperienceUIFullscreen() {
        MessageTargetExperienceUIFullScreen targetPreviewMessage = new MessageTargetExperienceUIFullScreen();
        targetPreviewMessage.messageId = "TargetPreview-" + UUID.randomUUID();
        targetPreviewMessage.startDate = new Date(StaticMethods.getTimeSince1970() * 1000L);
        targetPreviewMessage.html = this.getTargetPreviewExperienceUIHtml();
        targetPreviewMessage.showRule = Messages.MessageShowRule.MESSAGE_SHOW_RULE_ALWAYS;
        targetPreviewMessage.triggers = new ArrayList();
        MessageMatcherEquals messageMatcher = new MessageMatcherEquals();
        messageMatcher.key = TARGET_PREVIEW_UI_MESSAGE_TRIGGER_KEY;
        messageMatcher.values = new ArrayList();
        messageMatcher.values.add(TARGET_PREVIEW_UI_MESSAGE_TRIGGER_VALUE);
        targetPreviewMessage.triggers.add(messageMatcher);
        targetPreviewMessage.audiences = new ArrayList();
        return targetPreviewMessage;
    }

    private synchronized void showPreviewButton() {
        try {
            Activity activity = StaticMethods.getCurrentActivity();
            FloatingButton floatingButton = new FloatingButton((Context)activity, this.lastFloatingButtonX, this.lastFloatingButtonY);
            floatingButton.setTag("ADBFloatingButtonTag");
            floatingButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    StaticMethods.getAnalyticsExecutor().execute(new Runnable(){

                        @Override
                        public void run() {
                            TargetPreviewManager.this.downloadAndShowTargetPreviewUI();
                        }
                    });
                }
            });
            floatingButton.showButton(activity, this, this);
        }
        catch (StaticMethods.NullActivityException ex) {
            StaticMethods.logDebugFormat("Target - Could not show the floating button (%s)", ex);
        }
    }

    private void setPreviewButtonLastKnownPosXY(float lastX, float lastY) {
        this.lastFloatingButtonX = lastX;
        this.lastFloatingButtonY = lastY;
    }

    float getLastFloatingButtonX() {
        return this.lastFloatingButtonX;
    }

    float getLastFloatingButtonY() {
        return this.lastFloatingButtonY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TargetPreviewManager getInstance() {
        Object object = _instanceMutex;
        synchronized (object) {
            if (targetPreviewManager == null) {
                targetPreviewManager = new TargetPreviewManager();
            }
            return targetPreviewManager;
        }
    }

    void setTargetPreviewToken(String token) {
        if (token == null || !MobileConfig.getInstance().mobileUsingTarget()) {
            return;
        }
        this.setToken(token);
    }

    private String getRequestUrl() {
        String url = TARGET_PREVIEW_API_UI_FETCH_URL_BASE;
        if (this.targetPreviewApiUiFetchUrlBaseOverride != null && !this.targetPreviewApiUiFetchUrlBaseOverride.isEmpty()) {
            url = this.targetPreviewApiUiFetchUrlBaseOverride;
        }
        url = url + TARGET_PREVIEW_API_UI_FETCH_URL_PATH;
        return String.format(Locale.US, url, MobileConfig.getInstance().getClientCode(), StaticMethods.URLEncode(this.getToken()));
    }

    void downloadAndShowTargetPreviewUI() {
        if (this.getToken() == null || this.getToken().isEmpty()) {
            StaticMethods.logDebugFormat("No Target Preview token setup!", new Object[0]);
            return;
        }
        StaticMethods.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                NetworkObject networkObject = RequestHandler.retrieveNetworkObject(TargetPreviewManager.getInstance().getRequestUrl(), "GET", "text/html", null, MobileConfig.getInstance().getDefaultLocationTimeout(), null, "Target Preview", null);
                if (networkObject != null && networkObject.responseCode == 200 && networkObject.response != null) {
                    TargetPreviewManager.this.setTargetPreviewExperienceUIHtml(networkObject.response);
                    MobileConfig.getInstance().enableTargetPreviewMessage();
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put(TargetPreviewManager.TARGET_PREVIEW_UI_MESSAGE_TRIGGER_KEY, TargetPreviewManager.TARGET_PREVIEW_UI_MESSAGE_TRIGGER_VALUE);
                    Messages.checkForInAppMessage(data, null, null);
                } else {
                    try {
                        StaticMethods.getCurrentActivity().runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Toast.makeText((Context)StaticMethods.getCurrentActivity(), (CharSequence)"Could not download Target Preview UI. Please try again!", (int)0).show();
                                }
                                catch (StaticMethods.NullActivityException e) {
                                    StaticMethods.logDebugFormat("Could not show error message!(%s) ", e);
                                }
                            }
                        });
                    }
                    catch (StaticMethods.NullActivityException e) {
                        StaticMethods.logDebugFormat("Could not show error message!(%s) ", e);
                    }
                }
            }
        });
    }

    String getTargetPreviewExperienceUIHtml() {
        return this.targetPreviewExperienceUIHtml;
    }

    private void setTargetPreviewExperienceUIHtml(String html) {
        this.targetPreviewExperienceUIHtml = html;
    }

    private void removeTargetPreviewProperties() {
        this.setToken(null);
        this.setPreviewParams(null);
        this.setTargetPreviewExperienceUIHtml(null);
        this.setTargetPreviewApiUiFetchUrlBaseOverride(null);
        this.setPreviewButtonLastKnownPosXY(-1.0f, -1.0f);
    }

    void setupPreviewButton() {
        if (this.getToken() != null) {
            this.showPreviewButton();
        } else {
            FloatingButton.hideActiveButton();
        }
    }

    @Override
    public void onButtonDetached(FloatingButton floatingButton) {
        if (floatingButton != null) {
            this.setPreviewButtonLastKnownPosXY(floatingButton.getXCompat(), floatingButton.getYCompat());
        }
    }

    @Override
    public void onPositionChanged(float newX, float newY) {
        this.setPreviewButtonLastKnownPosXY(newX, newY);
    }

    void setPreviewRestartDeeplink(String deeplink) {
        this.restartDeeplink = deeplink;
    }

    String getPreviewRestartDeeplink() {
        return this.restartDeeplink;
    }

    void setTargetPreviewApiUiFetchUrlBaseOverride(String baseUrl) {
        this.targetPreviewApiUiFetchUrlBaseOverride = baseUrl;
    }

    public void disableTargetPreviewMode() {
        MobileConfig.getInstance().disableTargetPreviewMessage();
        this.removeTargetPreviewProperties();
    }
}

