/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.util.Log;
import com.adobe.mobile.AnalyticsTrackInternal;
import com.adobe.mobile.Config;
import com.adobe.mobile.ContextData;
import com.adobe.mobile.Lifecycle;
import com.adobe.mobile.MobileConfig;
import com.adobe.mobile.MobilePrivacyStatus;
import com.adobe.mobile.RequestHandler;
import com.adobe.mobile.VisitorID;
import com.adobe.mobile.VisitorIDService;
import com.adobe.mobile.WearableFunctionBridge;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class StaticMethods {
    protected static final String LIBRARY_VERSION = "4.18.0-AN";
    protected static final String TIME_SINCE_LAUNCH_KEY = "a.TimeSinceLaunch";
    private static final String DEVICE_NAME_KEY = "a.DeviceName";
    private static final String RESOLUTION_KEY = "a.Resolution";
    private static final String CARRIER_NAME_KEY = "a.CarrierName";
    private static final String RUN_MODE_KEY = "a.RunMode";
    private static final String RUN_MODE_APPLICATION = "Application";
    private static final String RUN_MODE_EXTENSION = "Extension";
    protected static final String LAST_KNOWN_TIMESTAMP_KEY = "ADBLastKnownTimestampKey";
    private static final String AID_JSON_ID_KEY = "id";
    static final String ADID_DSID = "DSID_20914";
    static final String MCPNS_DPID = "20919";
    private static final String PUSH_ID_ENABLED_ACTION_NAME = "Push";
    private static final String LOCALE_LIST_CLASS_PATH = "android.os.LocaleList";
    private static final String GET_LOCALES_API_NAME = "getLocales";
    private static final String TO_LANGUAGE_TAG_API_NAME = "toLanguageTag";
    private static final int API_LEVEL_24 = 24;
    private static final int API_LEVEL_21 = 21;
    private static final String[] encodedChars = new String[]{"%00", "%01", "%02", "%03", "%04", "%05", "%06", "%07", "%08", "%09", "%0A", "%0B", "%0C", "%0D", "%0E", "%0F", "%10", "%11", "%12", "%13", "%14", "%15", "%16", "%17", "%18", "%19", "%1A", "%1B", "%1C", "%1D", "%1E", "%1F", "%20", "%21", "%22", "%23", "%24", "%25", "%26", "%27", "%28", "%29", "*", "%2B", "%2C", "-", ".", "%2F", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "%3A", "%3B", "%3C", "%3D", "%3E", "%3F", "%40", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "%5B", "%5C", "%5D", "%5E", "_", "%60", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "%7B", "%7C", "%7D", "%7E", "%7F", "%80", "%81", "%82", "%83", "%84", "%85", "%86", "%87", "%88", "%89", "%8A", "%8B", "%8C", "%8D", "%8E", "%8F", "%90", "%91", "%92", "%93", "%94", "%95", "%96", "%97", "%98", "%99", "%9A", "%9B", "%9C", "%9D", "%9E", "%9F", "%A0", "%A1", "%A2", "%A3", "%A4", "%A5", "%A6", "%A7", "%A8", "%A9", "%AA", "%AB", "%AC", "%AD", "%AE", "%AF", "%B0", "%B1", "%B2", "%B3", "%B4", "%B5", "%B6", "%B7", "%B8", "%B9", "%BA", "%BB", "%BC", "%BD", "%BE", "%BF", "%C0", "%C1", "%C2", "%C3", "%C4", "%C5", "%C6", "%C7", "%C8", "%C9", "%CA", "%CB", "%CC", "%CD", "%CE", "%CF", "%D0", "%D1", "%D2", "%D3", "%D4", "%D5", "%D6", "%D7", "%D8", "%D9", "%DA", "%DB", "%DC", "%DD", "%DE", "%DF", "%E0", "%E1", "%E2", "%E3", "%E4", "%E5", "%E6", "%E7", "%E8", "%E9", "%EA", "%EB", "%EC", "%ED", "%EE", "%EF", "%F0", "%F1", "%F2", "%F3", "%F4", "%F5", "%F6", "%F7", "%F8", "%F9", "%FA", "%FB", "%FC", "%FD", "%FE", "%FF"};
    private static final boolean[] utf8Mask = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, true, true, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private static final boolean[] contextDataMask = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private static boolean _debugLogging;
    private static Config.ApplicationType _appType;
    private static boolean _isWearable;
    private static final String NO_CONTEXT_MESSAGE = "Config - No Application Context (Application context must be set prior to calling any library functions.)";
    private static final String NO_ACTIVITY_MESSAGE = "Message - No Current Activity (Messages must have a reference to the current activity to work properly)";
    private static final String NO_SHARED_PREFERENCES_MESSAGE = "Config - No SharedPreferences available";
    private static final String NO_SHARED_PREFERENCES_EDITOR_MESSAGE = "Config - Unable to create an instance of a SharedPreferences Editor";
    private static SharedPreferences prefs;
    private static final Object _sharedPreferencesMutex;
    private static String appID;
    private static final Object _applicationIDMutex;
    private static String appName;
    private static final Object _applicationNameMutex;
    private static String versionName;
    private static final Object _applicationVersionMutex;
    private static int versionCode;
    private static final Object _applicationVersionCodeMutex;
    private static String visitorID;
    private static final Object _visitorIDMutex;
    private static final Object _userIdentifierMutex;
    private static boolean pushEnabled;
    private static final Object _pushEnabledMutex;
    private static String pushIdentifier;
    private static final Object _pushIdentifierMutex;
    private static String advertisingIdentifier;
    private static final Object _advertisingIdentifierMutex;
    private static String userAgent;
    private static final Object _userAgentMutex;
    private static HashMap<String, Object> defaultData;
    private static final Object _defaultDataMutex;
    private static String resolution;
    private static final Object _resolutionMutex;
    private static String carrier;
    private static final Object _carrierMutex;
    private static String operatingSystem;
    private static final Object _operatingSystemMutex;
    private static String timestamp;
    private static final Object _timestampMutex;
    private static ExecutorService mediaExecutor;
    private static final Object _mediaExecutorMutex;
    private static ExecutorService timedActionsExecutor;
    private static final Object _timedActionsExecutorMutex;
    private static ExecutorService sharedExecutor;
    private static final Object _sharedExecutorMutex;
    private static ExecutorService analyticsExecutor;
    private static final Object _analyticsExecutorMutex;
    private static ExecutorService messagesExecutor;
    private static final Object _messagesExecutorMutex;
    private static ExecutorService thirdPartyCallbacksExecutor;
    private static final Object _thirdPartyCallbacksExecutorMutex;
    private static ExecutorService messageImageCachingExecutor;
    private static final Object _messageImageCachingExecutorMutex;
    private static ExecutorService audienceExecutor;
    private static final Object _audienceExecutorMutex;
    private static ExecutorService piiExecutor;
    private static final Object _piiExecutorMutex;
    private static String aid;
    private static final Object _aidMutex;
    static final Map<String, String> _contextDataKeyWhiteList;
    static int _contextDataKeyWhiteListCount;
    private static Context sharedContext;
    private static WeakReference<Activity> _activity;
    private static final Object _currentActivityMutex;
    private static final char[] BYTE_TO_HEX;
    private static final char[] hexArray;

    StaticMethods() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static SharedPreferences getSharedPreferences() throws NullContextException {
        Object object = _sharedPreferencesMutex;
        synchronized (object) {
            if (prefs == null && (prefs = StaticMethods.getSharedContext().getSharedPreferences("APP_MEASUREMENT_CACHE", 0)) == null) {
                StaticMethods.logWarningFormat(NO_SHARED_PREFERENCES_MESSAGE, new Object[0]);
            }
            if (prefs == null) {
                throw new NullContextException(NO_SHARED_PREFERENCES_MESSAGE);
            }
            return prefs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getApplicationID() {
        Object object = _applicationIDMutex;
        synchronized (object) {
            if (appID == null) {
                appID = (StaticMethods.getApplicationName() != null ? StaticMethods.getApplicationName() : "") + (StaticMethods.getApplicationVersion() != null && StaticMethods.getApplicationVersion().length() > 0 ? " " + StaticMethods.getApplicationVersion() + " " : "") + (StaticMethods.getApplicationVersionCode() != 0 ? String.format(Locale.US, "(%d)", StaticMethods.getApplicationVersionCode()) : "");
                try {
                    SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
                    editor.putString("ADOBEMOBILE_STOREDDEFAULTS_APPID", appID);
                    editor.commit();
                }
                catch (NullContextException ex) {
                    StaticMethods.logWarningFormat("Config - Unable to set Application ID in preferences (%s)", ex.getLocalizedMessage());
                }
            }
            return appID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getApplicationName() {
        Object object = _applicationNameMutex;
        synchronized (object) {
            if (appName == null) {
                appName = "";
                try {
                    PackageManager packageManager = StaticMethods.getSharedContext().getPackageManager();
                    if (packageManager != null) {
                        ApplicationInfo applicationInfo = packageManager.getApplicationInfo(StaticMethods.getSharedContext().getPackageName(), 0);
                        if (applicationInfo != null) {
                            appName = packageManager.getApplicationLabel(applicationInfo) != null ? (String)packageManager.getApplicationLabel(applicationInfo) : "";
                        } else {
                            StaticMethods.logWarningFormat("Analytics - ApplicationInfo was null", new Object[0]);
                            appName = "";
                        }
                    } else {
                        StaticMethods.logWarningFormat("Analytics - PackageManager was null", new Object[0]);
                        appName = "";
                    }
                }
                catch (PackageManager.NameNotFoundException e) {
                    StaticMethods.logWarningFormat("Analytics - PackageManager couldn't find application name (%s)", e.toString());
                    appName = "";
                }
                catch (NullContextException e) {
                    StaticMethods.logErrorFormat("Config - Unable to get package to pull application name. (%s)", e.getMessage());
                    appName = "";
                }
            }
            return appName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getApplicationVersion() {
        Object object = _applicationVersionMutex;
        synchronized (object) {
            if (versionName == null) {
                versionName = "";
                try {
                    PackageManager packageManager = StaticMethods.getSharedContext().getPackageManager();
                    if (packageManager != null) {
                        PackageInfo packageInfo = packageManager.getPackageInfo(StaticMethods.getSharedContext().getPackageName(), 0);
                        if (packageInfo != null) {
                            versionName = packageInfo.versionName != null ? packageInfo.versionName : "";
                        } else {
                            StaticMethods.logWarningFormat("Analytics - PackageInfo was null", new Object[0]);
                            versionName = "";
                        }
                    } else {
                        StaticMethods.logWarningFormat("Analytics - PackageManager was null", new Object[0]);
                        versionName = "";
                    }
                }
                catch (PackageManager.NameNotFoundException e) {
                    StaticMethods.logWarningFormat("Analytics - PackageManager couldn't find application version (%s)", e.toString());
                    versionName = "";
                }
                catch (NullContextException e) {
                    StaticMethods.logErrorFormat("Config - Unable to get package to pull application version. (%s)", e.getMessage());
                    versionName = "";
                }
            }
            return versionName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int getApplicationVersionCode() {
        Object object = _applicationVersionCodeMutex;
        synchronized (object) {
            if (versionCode == -1) {
                try {
                    PackageManager packageManager = StaticMethods.getSharedContext().getPackageManager();
                    if (packageManager != null) {
                        PackageInfo packageInfo = packageManager.getPackageInfo(StaticMethods.getSharedContext().getPackageName(), 0);
                        if (packageInfo != null) {
                            versionCode = packageInfo.versionCode > 0 ? packageInfo.versionCode : 0;
                        } else {
                            StaticMethods.logWarningFormat("Analytics - PackageInfo was null", new Object[0]);
                            versionCode = 0;
                        }
                    } else {
                        StaticMethods.logWarningFormat("Analytics - PackageManager was null", new Object[0]);
                        versionCode = 0;
                    }
                }
                catch (PackageManager.NameNotFoundException e) {
                    StaticMethods.logWarningFormat("Analytics - PackageManager couldn't find application version code (%s)", e.toString());
                    versionCode = 0;
                }
                catch (NullContextException e) {
                    StaticMethods.logErrorFormat("Config - Unable to get package to pull application version code. (%s)", e.getMessage());
                    versionCode = 0;
                }
            }
            return versionCode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getVisitorID() {
        Object object = _visitorIDMutex;
        synchronized (object) {
            if (visitorID == null) {
                try {
                    visitorID = StaticMethods.getSharedPreferences().getString("APP_MEASUREMENT_VISITOR_ID", null);
                }
                catch (NullContextException e) {
                    StaticMethods.logErrorFormat("Config - Unable to pull visitorID from shared preferences. (%s)", e.getMessage());
                }
            }
            return visitorID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setVisitorID(String uid) {
        Object object = _userIdentifierMutex;
        synchronized (object) {
            visitorID = uid;
            WearableFunctionBridge.syncVisitorIDToWearable(uid);
            try {
                SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
                editor.putString("APP_MEASUREMENT_VISITOR_ID", uid);
                editor.commit();
            }
            catch (NullContextException e) {
                StaticMethods.logErrorFormat("Config - Error updating visitorID. (%s)", e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void purgeVisitorID() {
        Object object = _userIdentifierMutex;
        synchronized (object) {
            visitorID = null;
            WearableFunctionBridge.syncVisitorIDToWearable(null);
            try {
                SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
                editor.remove("APP_MEASUREMENT_VISITOR_ID");
                editor.commit();
            }
            catch (NullContextException e) {
                StaticMethods.logErrorFormat("Config - Error purging visitorID. (%s)", e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean isPushEnabled() {
        Object object = _pushEnabledMutex;
        synchronized (object) {
            try {
                pushEnabled = StaticMethods.getSharedPreferences().getBoolean("ADBMOBILE_KEY_PUSH_ENABLED", false);
            }
            catch (NullContextException e) {
                StaticMethods.logErrorFormat("Config - Unable to pull push status from shared preferences. (%s)", e.getMessage());
            }
        }
        return pushEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setPushEnabled(boolean enabled) {
        Object object = _pushEnabledMutex;
        synchronized (object) {
            try {
                SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
                editor.putBoolean("ADBMOBILE_KEY_PUSH_ENABLED", enabled);
                editor.commit();
                pushEnabled = enabled;
                WearableFunctionBridge.syncPushEnabledToWearable(enabled);
            }
            catch (NullContextException e) {
                StaticMethods.logErrorFormat("Config - Unable to set pushEnabled shared preferences. (%s)", e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getPushIdentifier() {
        Object object = _pushIdentifierMutex;
        synchronized (object) {
            return pushIdentifier;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setPushIdentifier(final String registrationID) {
        Object object = _pushIdentifierMutex;
        synchronized (object) {
            pushIdentifier = registrationID;
            if (StaticMethods.processNewPushToken(registrationID)) {
                StaticMethods.sendPushSettingsToAnalytics(registrationID);
            } else {
                StaticMethods.logDebugFormat("Config - Provided push token matches existing push token.  Analytics push settings will not be resent to Analytics.", new Object[0]);
            }
            VisitorIDService.sharedInstance().idSync(null, (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put(StaticMethods.MCPNS_DPID, registrationID);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void purgePushIdentifier() {
        Object object = _pushIdentifierMutex;
        synchronized (object) {
            StaticMethods.setPushEnabled(false);
            pushIdentifier = null;
            try {
                SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
                editor.remove("ADBMOBILE_KEY_PUSH_TOKEN");
                editor.commit();
            }
            catch (NullContextException e) {
                StaticMethods.logErrorFormat("Config - Failed to remove push identifier from shared preferences. (%s)", e.getMessage());
            }
        }
    }

    private static void sendPushSettingsToAnalytics(String pushToken) {
        if ((pushToken == null || pushToken.isEmpty()) && StaticMethods.isPushEnabled()) {
            StaticMethods.setPushEnabled(false);
            AnalyticsTrackInternal.trackInternal(PUSH_ID_ENABLED_ACTION_NAME, (Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("a.push.optin", "False");
                }
            }, StaticMethods.getTimeSince1970());
        }
        if (pushToken != null && !pushToken.isEmpty() && !StaticMethods.isPushEnabled()) {
            StaticMethods.setPushEnabled(true);
            AnalyticsTrackInternal.trackInternal(PUSH_ID_ENABLED_ACTION_NAME, (Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("a.push.optin", "True");
                }
            }, StaticMethods.getTimeSince1970());
        }
    }

    private static boolean processNewPushToken(String pushToken) {
        try {
            String existingPushToken = StaticMethods.getSharedPreferences().getString("ADBMOBILE_KEY_PUSH_TOKEN", null);
            String newHashedToken = StaticMethods.getSha1HashedString(pushToken);
            if (existingPushToken == null && newHashedToken == null || existingPushToken != null && existingPushToken.equals(newHashedToken)) {
                return false;
            }
            SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
            if (newHashedToken != null) {
                editor.putString("ADBMOBILE_KEY_PUSH_TOKEN", newHashedToken);
            } else {
                editor.remove("ADBMOBILE_KEY_PUSH_TOKEN");
            }
            editor.commit();
            return true;
        }
        catch (NullContextException ex) {
            StaticMethods.logDebugFormat("Unable to retrieve shared preferences (%s)", ex);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getAdvertisingIdentifier() {
        Object object = _advertisingIdentifierMutex;
        synchronized (object) {
            return advertisingIdentifier;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setAdvertisingIdentifier(String adid) {
        String existingAdid = StaticMethods.getAdvertisingIdentifier();
        if (adid != null && adid.equals(existingAdid) || adid == null && existingAdid == null) {
            return;
        }
        Object object = _advertisingIdentifierMutex;
        synchronized (object) {
            advertisingIdentifier = adid;
            WearableFunctionBridge.syncAdvertisingIdentifierToWearable(adid);
            HashMap<String, String> identifierMap = new HashMap<String, String>();
            identifierMap.put(ADID_DSID, advertisingIdentifier);
            VisitorIDService.sharedInstance().idSync(identifierMap, VisitorID.VisitorIDAuthenticationState.VISITOR_ID_AUTHENTICATION_STATE_AUTHENTICATED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void purgeAdvertisingIdentifier() {
        Object object = _advertisingIdentifierMutex;
        synchronized (object) {
            advertisingIdentifier = null;
            WearableFunctionBridge.syncAdvertisingIdentifierToWearable(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getDefaultUserAgent() {
        Object object = _userAgentMutex;
        synchronized (object) {
            if (userAgent == null) {
                userAgent = "Mozilla/5.0 (Linux; U; Android " + StaticMethods.getAndroidVersion() + "; " + StaticMethods.getDefaultAcceptLanguage() + "; " + Build.MODEL + " Build/" + Build.ID + ")";
            }
            return userAgent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static HashMap<String, Object> getDefaultData() {
        Object object = _defaultDataMutex;
        synchronized (object) {
            if (defaultData == null) {
                defaultData = new HashMap();
                defaultData.put(DEVICE_NAME_KEY, Build.MODEL);
                defaultData.put(RESOLUTION_KEY, StaticMethods.getResolution());
                defaultData.put("a.OSVersion", StaticMethods.getOperatingSystem());
                defaultData.put(CARRIER_NAME_KEY, StaticMethods.getCarrier());
                defaultData.put("a.AppID", StaticMethods.getApplicationID());
                defaultData.put(RUN_MODE_KEY, StaticMethods.isWearableApp() ? RUN_MODE_EXTENSION : RUN_MODE_APPLICATION);
            }
            return defaultData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getResolution() {
        Object object = _resolutionMutex;
        synchronized (object) {
            if (resolution == null) {
                try {
                    DisplayMetrics displayMetrics = StaticMethods.getSharedContext().getResources().getDisplayMetrics();
                    resolution = displayMetrics.widthPixels + "x" + displayMetrics.heightPixels;
                }
                catch (NullContextException e) {
                    StaticMethods.logErrorFormat("Config - Error getting device resolution. (%s)", e.getMessage());
                }
            }
            return resolution;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getCarrier() {
        Object object = _carrierMutex;
        synchronized (object) {
            if (carrier == null) {
                try {
                    TelephonyManager telephonyManager = (TelephonyManager)StaticMethods.getSharedContext().getSystemService("phone");
                    carrier = telephonyManager.getNetworkOperatorName();
                }
                catch (NullContextException e) {
                    StaticMethods.logErrorFormat("Config - Error getting device carrier. (%s)", e.getMessage());
                }
            }
            return carrier;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getOperatingSystem() {
        Object object = _operatingSystemMutex;
        synchronized (object) {
            if (operatingSystem == null) {
                operatingSystem = "Android " + StaticMethods.getAndroidVersion();
                try {
                    SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
                    editor.putString("ADOBEMOBILE_STOREDDEFAULTS_OS", operatingSystem);
                    editor.commit();
                }
                catch (NullContextException ex) {
                    StaticMethods.logWarningFormat("Config - Unable to set OS version in preferences (%s)", ex.getLocalizedMessage());
                }
            }
            return operatingSystem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getTimestampString() {
        Object object = _timestampMutex;
        synchronized (object) {
            if (timestamp == null) {
                Date date = new Date();
                Calendar tm = Calendar.getInstance();
                tm.setTime(date);
                timestamp = "00/00/0000 00:00:00 0 " + tm.getTimeZone().getOffset(1, tm.get(1), tm.get(2), tm.get(5), tm.get(7), ((tm.get(11) * 60 + tm.get(12)) * 60 + tm.get(13)) * 1000 + tm.get(14)) / 60000 * -1;
            }
            return timestamp;
        }
    }

    protected static File getCacheDirectory() {
        try {
            return StaticMethods.getSharedContext().getCacheDir();
        }
        catch (NullContextException e) {
            StaticMethods.logErrorFormat("Config - Error getting cache directory. (%s)", e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ExecutorService getMediaExecutor() {
        Object object = _mediaExecutorMutex;
        synchronized (object) {
            if (mediaExecutor == null) {
                mediaExecutor = Executors.newSingleThreadExecutor();
            }
            return mediaExecutor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutorService getTimedActionsExecutor() {
        Object object = _timedActionsExecutorMutex;
        synchronized (object) {
            if (timedActionsExecutor == null) {
                timedActionsExecutor = Executors.newSingleThreadExecutor();
            }
            return timedActionsExecutor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ExecutorService getSharedExecutor() {
        Object object = _sharedExecutorMutex;
        synchronized (object) {
            if (sharedExecutor == null) {
                sharedExecutor = Executors.newSingleThreadExecutor();
            }
            return sharedExecutor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ExecutorService getAnalyticsExecutor() {
        Object object = _analyticsExecutorMutex;
        synchronized (object) {
            if (analyticsExecutor == null) {
                analyticsExecutor = Executors.newSingleThreadExecutor();
            }
            return analyticsExecutor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ExecutorService getMessagesExecutor() {
        Object object = _messagesExecutorMutex;
        synchronized (object) {
            if (messagesExecutor == null) {
                messagesExecutor = Executors.newSingleThreadExecutor();
            }
            return messagesExecutor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ExecutorService getThirdPartyCallbacksExecutor() {
        Object object = _thirdPartyCallbacksExecutorMutex;
        synchronized (object) {
            if (thirdPartyCallbacksExecutor == null) {
                thirdPartyCallbacksExecutor = Executors.newSingleThreadExecutor();
            }
            return thirdPartyCallbacksExecutor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ExecutorService getMessageImageCachingExecutor() {
        Object object = _messageImageCachingExecutorMutex;
        synchronized (object) {
            if (messageImageCachingExecutor == null) {
                messageImageCachingExecutor = Executors.newSingleThreadExecutor();
            }
            return messageImageCachingExecutor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ExecutorService getAudienceExecutor() {
        Object object = _audienceExecutorMutex;
        synchronized (object) {
            if (audienceExecutor == null) {
                audienceExecutor = Executors.newSingleThreadExecutor();
            }
            return audienceExecutor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ExecutorService getPIIExecutor() {
        Object object = _piiExecutorMutex;
        synchronized (object) {
            if (piiExecutor == null) {
                piiExecutor = Executors.newSingleThreadExecutor();
            }
            return piiExecutor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void purgeAID() {
        Object object = _aidMutex;
        synchronized (object) {
            aid = null;
            try {
                SharedPreferences.Editor prefsEditor = StaticMethods.getSharedPreferences().edit();
                prefsEditor.remove("ADOBEMOBILE_STOREDDEFAULTS_AID");
                prefsEditor.remove("ADOBEMOBILE_STOREDDEFAULTS_IGNORE_AID");
                prefsEditor.remove("ADOBEMOBILE_STOREDDEFAULTS_AID_SYNCED");
                prefsEditor.apply();
            }
            catch (NullContextException e) {
                StaticMethods.logWarningFormat("Config - Failed to purge AID (application context is null)", new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getAID() {
        if (!MobileConfig.getInstance().mobileUsingAnalytics() || MobileConfig.getInstance().getPrivacyStatus() == MobilePrivacyStatus.MOBILE_PRIVACY_STATUS_OPT_OUT) {
            return null;
        }
        Object object = _aidMutex;
        synchronized (object) {
            if (aid == null || aid.isEmpty()) {
                try {
                    boolean ignoreAid = StaticMethods.getSharedPreferences().getBoolean("ADOBEMOBILE_STOREDDEFAULTS_IGNORE_AID", false);
                    aid = StaticMethods.getSharedPreferences().getString("ADOBEMOBILE_STOREDDEFAULTS_AID", null);
                    if (!ignoreAid && aid == null || !MobileConfig.getInstance().getVisitorIdServiceEnabled() && ignoreAid) {
                        aid = StaticMethods.retrieveAIDFromVisitorIDService();
                        SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
                        if (aid != null) {
                            editor.putString("ADOBEMOBILE_STOREDDEFAULTS_AID", aid);
                            editor.putBoolean("ADOBEMOBILE_STOREDDEFAULTS_IGNORE_AID", false);
                        } else {
                            editor.putBoolean("ADOBEMOBILE_STOREDDEFAULTS_IGNORE_AID", true);
                        }
                        editor.commit();
                        StaticMethods.syncAIDIfNeeded(aid);
                    }
                }
                catch (NullContextException e) {
                    StaticMethods.logErrorFormat("Config - Error getting AID. (%s)", e.getMessage());
                }
            }
        }
        return aid;
    }

    private static void syncAIDIfNeeded(String aid) {
        if (aid == null) {
            return;
        }
        if (!MobileConfig.getInstance().getVisitorIdServiceEnabled()) {
            return;
        }
        boolean idSynced = false;
        try {
            idSynced = StaticMethods.getSharedPreferences().getBoolean("ADOBEMOBILE_STOREDDEFAULTS_AID_SYNCED", false);
        }
        catch (NullContextException ex) {
            StaticMethods.logWarningFormat("Visitor ID - Null context when attempting to determine visitor ID sync status (%s)", ex.getLocalizedMessage());
        }
        if (!idSynced) {
            HashMap<String, String> integrationsMap = new HashMap<String, String>();
            integrationsMap.put("AVID", aid);
            VisitorIDService.sharedInstance().idSync(integrationsMap);
            try {
                SharedPreferences.Editor e = StaticMethods.getSharedPreferencesEditor();
                e.putBoolean("ADOBEMOBILE_STOREDDEFAULTS_AID_SYNCED", true);
                e.commit();
            }
            catch (NullContextException ex) {
                StaticMethods.logWarningFormat("Visitor ID - Null context when attempting to persist visitor ID sync status (%s)", ex.getLocalizedMessage());
            }
        }
    }

    private static String retrieveAIDFromVisitorIDService() {
        String identifier;
        boolean useVisidService;
        block7: {
            StringBuilder urlSb = new StringBuilder(64);
            urlSb.append(MobileConfig.getInstance().getSSL() ? "https" : "http");
            urlSb.append("://");
            urlSb.append(MobileConfig.getInstance().getTrackingServer());
            urlSb.append("/id");
            useVisidService = MobileConfig.getInstance().getVisitorIdServiceEnabled();
            if (useVisidService) {
                urlSb.append(VisitorIDService.sharedInstance().getAnalyticsIDRequestParameterString());
            }
            StaticMethods.logDebugFormat("Analytics ID - Sending Analytics ID call(%s)", urlSb);
            byte[] serverResponse = RequestHandler.retrieveData(urlSb.toString(), null, 500, "Analytics ID");
            identifier = null;
            if (serverResponse != null) {
                try {
                    JSONObject jsonResponse = new JSONObject(new String(serverResponse, "UTF-8"));
                    identifier = jsonResponse.getString(AID_JSON_ID_KEY);
                }
                catch (UnsupportedEncodingException ex) {
                    StaticMethods.logErrorFormat("Analytics ID - Unable to decode /id response(%s)", ex.getLocalizedMessage());
                }
                catch (JSONException ex) {
                    if (useVisidService) break block7;
                    StaticMethods.logErrorFormat("Analytics ID - Unable to parse /id response(%s)", ex.getLocalizedMessage());
                }
            }
        }
        if (identifier == null || identifier.length() != 33) {
            if (useVisidService) {
                return null;
            }
            identifier = StaticMethods.generateAID();
        }
        return identifier;
    }

    private static String generateAID() {
        String uuid = UUID.randomUUID().toString().replace("-", "");
        uuid = uuid.toUpperCase(Locale.US);
        Pattern firstPattern = Pattern.compile("^[89A-F]");
        Pattern secondPattern = Pattern.compile("^[4-9A-F]");
        Matcher firstMatcher = firstPattern.matcher(uuid.substring(0, 16));
        Matcher secondMatcher = secondPattern.matcher(uuid.substring(16, 32));
        SecureRandom r = new SecureRandom();
        String vi_hi = firstMatcher.replaceAll(String.valueOf(r.nextInt(7)));
        String vi_lo = secondMatcher.replaceAll(String.valueOf(r.nextInt(3)));
        return vi_hi + "-" + vi_lo;
    }

    protected static void setDebugLogging(boolean enabled) {
        _debugLogging = enabled;
    }

    protected static boolean getDebugLogging() {
        return _debugLogging;
    }

    protected static void setApplicationType(Config.ApplicationType apptype) {
        _appType = apptype;
        _isWearable = _appType == Config.ApplicationType.APPLICATION_TYPE_WEARABLE;
    }

    protected static Config.ApplicationType getApplicationType() {
        return _appType;
    }

    protected static boolean isWearableApp() {
        return _isWearable;
    }

    protected static void serializeToQueryString(Map<String, Object> parameters, StringBuilder builder) {
        if (parameters == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String key = StaticMethods.URLEncode(entry.getKey());
            if (key == null) continue;
            Object obj = entry.getValue();
            if (obj instanceof ContextData) {
                ContextData data = (ContextData)obj;
                if (data.value != null) {
                    StaticMethods.serializeKeyValuePair(key, data.value, builder);
                }
                if (data.contextData == null || data.contextData.size() <= 0) continue;
                builder.append("&");
                builder.append(key);
                builder.append(".");
                StaticMethods.serializeToQueryString(data.contextData, builder);
                builder.append("&.");
                builder.append(key);
                continue;
            }
            StaticMethods.serializeKeyValuePair(key, obj, builder);
        }
    }

    private static void serializeKeyValuePair(String key, Object value, StringBuilder builder) {
        if (key == null || value == null || value instanceof ContextData || key.length() <= 0) {
            return;
        }
        if (value instanceof String && ((String)value).length() <= 0) {
            return;
        }
        builder.append("&");
        builder.append(key);
        builder.append("=");
        if (value instanceof List) {
            builder.append(StaticMethods.URLEncode(StaticMethods.join((List)value, ",")));
        } else {
            builder.append(StaticMethods.URLEncode(value.toString()));
        }
    }

    protected static String join(Iterable<?> elements, String delimiter) {
        StringBuilder sb = new StringBuilder();
        Iterator<?> iter = elements.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) break;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    protected static String URLEncode(String unencodedString) {
        if (unencodedString == null) {
            return null;
        }
        try {
            int curIndex;
            byte[] stringBytes = unencodedString.getBytes("UTF-8");
            int len = stringBytes.length;
            for (curIndex = 0; curIndex < len && utf8Mask[stringBytes[curIndex] & 0xFF]; ++curIndex) {
            }
            if (curIndex == len) {
                return unencodedString;
            }
            StringBuilder encodedString = new StringBuilder(stringBytes.length << 1);
            if (curIndex > 0) {
                encodedString.append(new String(stringBytes, 0, curIndex, "UTF-8"));
            }
            while (curIndex < len) {
                encodedString.append(encodedChars[stringBytes[curIndex] & 0xFF]);
                ++curIndex;
            }
            return encodedString.toString();
        }
        catch (UnsupportedEncodingException e) {
            StaticMethods.logWarningFormat("UnsupportedEncodingException : " + e.getMessage(), new Object[0]);
            return null;
        }
    }

    protected static void logErrorFormat(String format, Object ... args) {
        if (args != null && args.length > 0) {
            String formattedString = String.format("ADBMobile Error : " + format, args);
            Log.e((String)"ADBMobile", (String)formattedString);
        } else {
            Log.e((String)"ADBMobile", (String)("ADBMobile Error : " + format));
        }
    }

    protected static void logWarningFormat(String format, Object ... args) {
        if (StaticMethods.getDebugLogging()) {
            if (args != null && args.length > 0) {
                String formattedString = String.format("ADBMobile Warning : " + format, args);
                Log.w((String)"ADBMobile", (String)formattedString);
            } else {
                Log.w((String)"ADBMobile", (String)("ADBMobile Warning : " + format));
            }
        }
    }

    protected static void logDebugFormat(String format, Object ... args) {
        if (StaticMethods.getDebugLogging()) {
            if (args != null && args.length > 0) {
                String formattedString = String.format("ADBMobile Debug : " + format, args);
                Log.d((String)"ADBMobile", (String)formattedString);
            } else {
                Log.d((String)"ADBMobile", (String)("ADBMobile Debug : " + format));
            }
        }
    }

    protected static ContextData translateContextData(Map<String, Object> dict) {
        ContextData tempContextData = new ContextData();
        for (Map.Entry<String, Object> entry : StaticMethods.cleanContextDataDictionary(dict).entrySet()) {
            int end;
            String key = entry.getKey();
            ArrayList<String> list = new ArrayList<String>();
            int pos = 0;
            while ((end = key.indexOf(46, pos)) >= 0) {
                list.add(key.substring(pos, end));
                pos = end + 1;
            }
            list.add(key.substring(pos, key.length()));
            StaticMethods.addValueToHashMap(entry.getValue(), tempContextData, list, 0);
        }
        return tempContextData;
    }

    protected static Map<String, Object> cleanContextDataDictionary(Map<String, Object> dict) {
        if (dict == null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> tempContextData = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : dict.entrySet()) {
            String cleanedKey = StaticMethods.cleanContextDataKey(entry.getKey());
            if (cleanedKey == null) continue;
            tempContextData.put(cleanedKey, entry.getValue());
        }
        return tempContextData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String cleanContextDataKey(String key) {
        String cleanKey;
        if (key == null) {
            return null;
        }
        Map<String, String> map = _contextDataKeyWhiteList;
        synchronized (map) {
            String preCleanedKey = _contextDataKeyWhiteList.get(key);
            if (preCleanedKey != null) {
                return preCleanedKey;
            }
        }
        try {
            int startIndex;
            byte[] utf8Key = key.getBytes("UTF-8");
            byte[] outPut = new byte[utf8Key.length];
            int lastByte = 0;
            int outIndex = 0;
            for (int n : utf8Key) {
                if (n == 46 && lastByte == 46 || !contextDataMask[n & 0xFF]) continue;
                outPut[outIndex++] = n;
                lastByte = n;
            }
            if (outIndex == 0) {
                return null;
            }
            int endTrim = outPut[outIndex - 1] == 46 ? 1 : 0;
            int totalLength = outIndex - endTrim - (startIndex = outPut[0] == 46 ? 1 : 0);
            if (totalLength <= 0) {
                return null;
            }
            cleanKey = new String(outPut, startIndex, totalLength, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            StaticMethods.logErrorFormat("Analytics - Unable to clean context data key (%s)", ex.getLocalizedMessage());
            return null;
        }
        Map<String, String> map2 = _contextDataKeyWhiteList;
        synchronized (map2) {
            if (_contextDataKeyWhiteListCount > 250) {
                _contextDataKeyWhiteList.clear();
                _contextDataKeyWhiteListCount = 0;
            }
            _contextDataKeyWhiteList.put(key, cleanKey);
            ++_contextDataKeyWhiteListCount;
        }
        return cleanKey;
    }

    private static void addValueToHashMap(Object object, ContextData table, List<String> subKeyArray, int index) {
        String keyName;
        if (table == null || subKeyArray == null) {
            return;
        }
        int arrayCount = subKeyArray.size();
        String string = keyName = index < arrayCount ? subKeyArray.get(index) : null;
        if (keyName == null) {
            return;
        }
        ContextData data = new ContextData();
        if (table.containsKey(keyName)) {
            data = table.get(keyName);
        }
        if (arrayCount - 1 == index) {
            data.value = object;
            table.put(keyName, data);
        } else {
            table.put(keyName, data);
            StaticMethods.addValueToHashMap(object, data, subKeyArray, ++index);
        }
    }

    protected static long getTimeSince1970() {
        return System.currentTimeMillis() / 1000L;
    }

    protected static void updateLastKnownTimestamp(Long timestamp) {
        MobileConfig config = MobileConfig.getInstance();
        if (config == null) {
            StaticMethods.logErrorFormat("Config - Lost config instance", new Object[0]);
            return;
        }
        if (!config.getOfflineTrackingEnabled()) {
            return;
        }
        try {
            SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
            editor.putLong(LAST_KNOWN_TIMESTAMP_KEY, timestamp.longValue());
            editor.commit();
        }
        catch (NullContextException e) {
            StaticMethods.logErrorFormat("Config - Error while updating last known timestamp. (%s)", e.getMessage());
        }
    }

    protected static String getDefaultAcceptLanguage() {
        Resources resources;
        try {
            resources = StaticMethods.getSharedContext().getResources();
        }
        catch (NullContextException e) {
            StaticMethods.logErrorFormat("Config - Error getting application resources for default accepted language. (%s)", e.getMessage());
            return null;
        }
        if (resources == null) {
            return null;
        }
        Configuration configuration = resources.getConfiguration();
        if (configuration == null) {
            return null;
        }
        Locale locale = StaticMethods.getCurrentLocale(configuration);
        return StaticMethods.languageTagFromLocale(locale);
    }

    protected static Locale getCurrentLocale(Configuration configuration) {
        if (configuration == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT < 24) {
            return configuration.locale;
        }
        try {
            Class<?> localeListClass = Class.forName(LOCALE_LIST_CLASS_PATH);
            Method getLocalesMethod = Configuration.class.getMethod(GET_LOCALES_API_NAME, new Class[0]);
            Object localesList = localeListClass.cast(getLocalesMethod.invoke((Object)configuration, new Object[0]));
            Locale locale = (Locale)localeListClass.getMethod("get", Integer.TYPE).invoke(localesList, 0);
            return locale;
        }
        catch (Exception e) {
            StaticMethods.logWarningFormat("Config - Warning, failed getting locale. (%s)", e.getMessage());
            return null;
        }
    }

    protected static String languageTagFromLocale(Locale locale) {
        if (locale == null) {
            return null;
        }
        String result = locale.getLanguage();
        String countryCode = locale.getCountry();
        if (!countryCode.isEmpty()) {
            result = result + "-" + countryCode;
        }
        return result;
    }

    private static String getAndroidVersion() {
        return Build.VERSION.RELEASE;
    }

    protected static SharedPreferences.Editor getSharedPreferencesEditor() throws NullContextException {
        SharedPreferences.Editor editor = StaticMethods.getSharedPreferences().edit();
        if (editor == null) {
            throw new NullContextException(NO_SHARED_PREFERENCES_EDITOR_MESSAGE);
        }
        return editor;
    }

    protected static Context getSharedContext() throws NullContextException {
        if (sharedContext == null) {
            throw new NullContextException(NO_CONTEXT_MESSAGE);
        }
        return sharedContext;
    }

    protected static void setSharedContext(Context context) {
        if (context != null) {
            sharedContext = context instanceof Activity ? context.getApplicationContext() : context;
        }
    }

    protected static long getTimeSinceLaunch() {
        long originalStartDate = Lifecycle.sessionStartTime;
        long timeSinceLaunch = StaticMethods.getTimeSince1970() - originalStartDate;
        return timeSinceLaunch < 604800L ? timeSinceLaunch : 0L;
    }

    protected static HashMap<String, Object> mapFromJson(JSONObject jsonData) {
        if (jsonData == null) {
            return null;
        }
        Iterator keyItr = jsonData.keys();
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (keyItr.hasNext()) {
            String name = (String)keyItr.next();
            try {
                map.put(name, jsonData.getString(name));
            }
            catch (JSONException ex) {
                StaticMethods.logWarningFormat("Problem parsing json data (%s)", ex.getLocalizedMessage());
            }
        }
        return map;
    }

    static JSONObject mapToJson(Map<String, Object> map) {
        JSONObject jsonObject = new JSONObject();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof List) {
                try {
                    jsonObject.put(key, (Object)StaticMethods.listToJson((List)value));
                }
                catch (JSONException jSONException) {}
                continue;
            }
            if (value instanceof Map) {
                try {
                    jsonObject.put(key, (Object)StaticMethods.mapToJson((Map)value));
                }
                catch (JSONException jSONException) {}
                continue;
            }
            try {
                jsonObject.put(key, value);
            }
            catch (JSONException jSONException) {}
        }
        return jsonObject;
    }

    static JSONArray listToJson(List<Object> list) {
        JSONArray jsonArray = new JSONArray();
        for (Object element : list) {
            if (element instanceof List) {
                jsonArray.put((Object)StaticMethods.listToJson((List)element));
                continue;
            }
            if (element instanceof Map) {
                jsonArray.put((Object)StaticMethods.mapToJson((Map)element));
                continue;
            }
            jsonArray.put(element);
        }
        return jsonArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setCurrentActivity(Activity activity) {
        Object object = _currentActivityMutex;
        synchronized (object) {
            _activity = new WeakReference<Activity>(activity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Activity getCurrentActivity() throws NullActivityException {
        Object object = _currentActivityMutex;
        synchronized (object) {
            if (_activity == null || _activity.get() == null) {
                throw new NullActivityException(NO_ACTIVITY_MESSAGE);
            }
            return (Activity)_activity.get();
        }
    }

    protected static String expandTokens(String inputString, Map<String, String> tokens) {
        String returnString = inputString;
        try {
            for (Map.Entry<String, String> entry : tokens.entrySet()) {
                returnString = returnString.replace(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception ex) {
            StaticMethods.logDebugFormat("Unable to expand tokens (%s)", ex.toString());
        }
        return returnString;
    }

    protected static int getCurrentOrientation() {
        try {
            return StaticMethods.getCurrentActivity().getResources().getConfiguration().orientation;
        }
        catch (NullActivityException ex) {
            return -1;
        }
    }

    protected static String getHexString(String originalString) {
        byte[] bytes;
        if (originalString == null || originalString.length() <= 0) {
            return null;
        }
        try {
            bytes = originalString.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            StaticMethods.logDebugFormat("Failed to get hex from string (%s)", ex.getMessage());
            return null;
        }
        int bytesLength = bytes.length;
        char[] chars = new char[bytesLength << 1];
        int index = 0;
        int offset = 0;
        while (offset < bytesLength) {
            int hexIndex = (bytes[offset++] & 0xFF) << 1;
            chars[index++] = BYTE_TO_HEX[hexIndex++];
            chars[index++] = BYTE_TO_HEX[hexIndex];
        }
        return new String(chars);
    }

    protected static String hexToString(String hexString) {
        if (hexString == null || hexString.length() <= 0 || hexString.length() % 2 != 0) {
            return null;
        }
        int length = hexString.length();
        byte[] data = new byte[length / 2];
        for (int i = 0; i < length; i += 2) {
            data[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        String decodedString = null;
        try {
            decodedString = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            StaticMethods.logDebugFormat("Failed to get string from hex (%s)", ex.getMessage());
        }
        return decodedString;
    }

    protected static String appendContextData(Map<String, Object> referrerData, String source) {
        if (source == null || referrerData == null || referrerData.size() == 0) {
            return source;
        }
        Pattern pattern = Pattern.compile(".*(&c\\.(.*)&\\.c).*");
        Matcher matcher = pattern.matcher(source);
        if (!matcher.matches()) {
            return source;
        }
        String contextDataString = matcher.group(2);
        if (contextDataString == null) {
            return source;
        }
        HashMap<String, Object> contextData = new HashMap<String, Object>(64);
        ArrayList<String> keyPath = new ArrayList<String>(16);
        for (String param : contextDataString.split("&")) {
            if (param.endsWith(".") && !param.contains("=")) {
                keyPath.add(param);
                continue;
            }
            if (param.startsWith(".")) {
                if (keyPath.size() <= 0) continue;
                keyPath.remove(keyPath.size() - 1);
                continue;
            }
            String[] kvpair = param.split("=");
            if (kvpair.length != 2) continue;
            String contextDataKey = StaticMethods.contextDataStringPath(keyPath, kvpair[0]);
            try {
                contextData.put(contextDataKey, URLDecoder.decode(kvpair[1], "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        contextData.putAll(referrerData);
        StringBuilder urlSb = new StringBuilder(source.substring(0, matcher.start(1)));
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        contextMap.put("c", StaticMethods.translateContextData(contextData));
        StaticMethods.serializeToQueryString(contextMap, urlSb);
        urlSb.append(source.substring(matcher.end(1)));
        return urlSb.toString();
    }

    protected static String contextDataStringPath(List<String> keyPath, String lastComponent) {
        StringBuilder sb = new StringBuilder();
        for (String pathComponent : keyPath) {
            sb.append(pathComponent);
        }
        sb.append(lastComponent);
        return sb.toString();
    }

    private static Locale getDeviceLocale() {
        Resources resources;
        try {
            resources = StaticMethods.getSharedContext().getResources();
        }
        catch (NullContextException e) {
            StaticMethods.logErrorFormat("Config - Error getting application resources for device locale. (%s)", e.getMessage());
            return Locale.US;
        }
        if (resources == null) {
            return Locale.US;
        }
        Configuration configuration = resources.getConfiguration();
        if (configuration == null) {
            return Locale.US;
        }
        Locale locale = StaticMethods.getCurrentLocale(configuration);
        return locale != null ? locale : Locale.US;
    }

    protected static String getIso8601Date() {
        return StaticMethods.getIso8601Date(new Date());
    }

    protected static String getIso8601Date(Date date) {
        SimpleDateFormat iso8601Format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZZ", StaticMethods.getDeviceLocale());
        return iso8601Format.format(date != null ? date : new Date());
    }

    static String getSha1HashedString(String inputString) {
        if (inputString == null || inputString.isEmpty()) {
            return null;
        }
        String hash = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            byte[] bytes = inputString.getBytes("UTF-8");
            digest.update(bytes, 0, bytes.length);
            bytes = digest.digest();
            char[] hexChars = new char[bytes.length * 2];
            for (int j = 0; j < bytes.length; ++j) {
                int v = bytes[j] & 0xFF;
                hexChars[j * 2] = hexArray[v >>> 4];
                hexChars[j * 2 + 1] = hexArray[v & 0xF];
            }
            hash = new String(hexChars);
        }
        catch (NoSuchAlgorithmException ex) {
            StaticMethods.logDebugFormat("ADBMobile - error while attempting to encode a string (%s)", ex);
        }
        catch (UnsupportedEncodingException ex) {
            StaticMethods.logDebugFormat("ADBMobile - error while attempting to encode a string (%s)", ex);
        }
        return hash;
    }

    static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void reset() {
        appID = null;
        appName = null;
        visitorID = null;
        userAgent = null;
        Object object = _defaultDataMutex;
        synchronized (object) {
            defaultData = null;
        }
        resolution = null;
        versionCode = -1;
        versionName = null;
        carrier = null;
        operatingSystem = null;
        aid = null;
        sharedContext = null;
        prefs = null;
        _activity = null;
        _contextDataKeyWhiteList.clear();
        _contextDataKeyWhiteListCount = 0;
        _appType = Config.ApplicationType.APPLICATION_TYPE_HANDHELD;
        _isWearable = false;
    }

    static {
        _appType = Config.ApplicationType.APPLICATION_TYPE_HANDHELD;
        _isWearable = false;
        prefs = null;
        _sharedPreferencesMutex = new Object();
        appID = null;
        _applicationIDMutex = new Object();
        appName = null;
        _applicationNameMutex = new Object();
        versionName = null;
        _applicationVersionMutex = new Object();
        versionCode = -1;
        _applicationVersionCodeMutex = new Object();
        visitorID = null;
        _visitorIDMutex = new Object();
        _userIdentifierMutex = new Object();
        pushEnabled = false;
        _pushEnabledMutex = new Object();
        pushIdentifier = null;
        _pushIdentifierMutex = new Object();
        advertisingIdentifier = null;
        _advertisingIdentifierMutex = new Object();
        userAgent = null;
        _userAgentMutex = new Object();
        defaultData = null;
        _defaultDataMutex = new Object();
        resolution = null;
        _resolutionMutex = new Object();
        carrier = null;
        _carrierMutex = new Object();
        operatingSystem = null;
        _operatingSystemMutex = new Object();
        timestamp = null;
        _timestampMutex = new Object();
        mediaExecutor = null;
        _mediaExecutorMutex = new Object();
        timedActionsExecutor = null;
        _timedActionsExecutorMutex = new Object();
        sharedExecutor = null;
        _sharedExecutorMutex = new Object();
        analyticsExecutor = null;
        _analyticsExecutorMutex = new Object();
        messagesExecutor = null;
        _messagesExecutorMutex = new Object();
        thirdPartyCallbacksExecutor = null;
        _thirdPartyCallbacksExecutorMutex = new Object();
        messageImageCachingExecutor = null;
        _messageImageCachingExecutorMutex = new Object();
        audienceExecutor = null;
        _audienceExecutorMutex = new Object();
        piiExecutor = null;
        _piiExecutorMutex = new Object();
        aid = null;
        _aidMutex = new Object();
        _contextDataKeyWhiteList = new HashMap<String, String>(256);
        _contextDataKeyWhiteListCount = 0;
        sharedContext = null;
        _activity = null;
        _currentActivityMutex = new Object();
        BYTE_TO_HEX = "000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F202122232425262728292A2B2C2D2E2F303132333435363738393A3B3C3D3E3F404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F707172737475767778797A7B7C7D7E7F808182838485868788898A8B8C8D8E8F909192939495969798999A9B9C9D9E9FA0A1A2A3A4A5A6A7A8A9AAABACADAEAFB0B1B2B3B4B5B6B7B8B9BABBBCBDBEBFC0C1C2C3C4C5C6C7C8C9CACBCCCDCECFD0D1D2D3D4D5D6D7D8D9DADBDCDDDEDFE0E1E2E3E4E5E6E7E8E9EAEBECEDEEEFF0F1F2F3F4F5F6F7F8F9FAFBFCFDFEFF".toCharArray();
        hexArray = "0123456789abcdef".toCharArray();
    }

    protected static class NullActivityException
    extends Exception {
        public NullActivityException(String message) {
            super(message);
        }
    }

    protected static class NullContextException
    extends Exception {
        public NullContextException(String message) {
            super(message);
        }
    }
}

