/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import android.os.Build;
import com.adobe.mobile.MobileConfig;
import com.adobe.mobile.NetworkObject;
import com.adobe.mobile.StaticMethods;
import com.adobe.mobile.TLSSocketFactory;
import com.adobe.mobile.WearableFunctionBridge;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.net.ssl.HttpsURLConnection;

final class RequestHandler {
    private static final int DEFAULT_CONNECTION_TIMEOUT = 2000;
    private static final int DEFAULT_READ_TIMEOUT = 2000;
    private static final int BUF_SIZE = 1024;
    private static final int MAX_REDIRECT_COUNT = 21;
    private static final int TO_MILLI = 1000;
    private static final String DEFAULT_ENCODING = "UTF-8";

    RequestHandler() {
    }

    protected static byte[] retrieveData(String url, Map<String, String> headers, int readTimeout, String source) {
        return RequestHandler.retrieveData(url, headers, readTimeout, 2000, source);
    }

    protected static byte[] retrieveData(String url, final Map<String, String> headers, int readTimeout, int connectTimeout, String source) {
        if (StaticMethods.isWearableApp()) {
            return WearableFunctionBridge.retrieveData(url, readTimeout);
        }
        Callable<Map<String, String>> headersCallback = new Callable<Map<String, String>>(){

            @Override
            public Map<String, String> call() throws Exception {
                return headers;
            }
        };
        return RequestHandler.retrieveData(url, readTimeout, connectTimeout, source, headers != null ? headersCallback : null, null);
    }

    /*
     * Exception decompiling
     */
    protected static byte[] retrieveData(String url, int readTimeout, int connectTimeout, String source, Callable<Map<String, String>> requestHeaderProvider, HeaderCallback responseHeaderReceiver) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static void sendGenericRequest(String url, Map<String, String> headers, int timeout, String source) {
        if (url == null) {
            return;
        }
        if (StaticMethods.isWearableApp()) {
            WearableFunctionBridge.sendGenericRequest(url, timeout, source);
            return;
        }
        try {
            HttpURLConnection connection = RequestHandler.requestConnect(url);
            if (connection != null) {
                connection.setConnectTimeout(timeout);
                connection.setReadTimeout(timeout);
                connection.setRequestProperty("Accept-Language", StaticMethods.getDefaultAcceptLanguage());
                connection.setRequestProperty("User-Agent", StaticMethods.getDefaultUserAgent());
                if (headers != null) {
                    for (Map.Entry<String, String> entry : headers.entrySet()) {
                        String value = entry.getValue();
                        if (value.trim().length() <= 0) continue;
                        connection.setRequestProperty(entry.getKey(), value);
                    }
                }
                StaticMethods.logDebugFormat("%s - Request Sent(%s)", source, url);
                connection.getResponseCode();
                InputStream stream = connection.getInputStream();
                stream.close();
                connection.disconnect();
            }
        }
        catch (SocketTimeoutException e) {
            StaticMethods.logWarningFormat("%s - Timed out sending request(%s)", source, url);
        }
        catch (IOException e) {
            StaticMethods.logWarningFormat("%s - IOException while sending request, may retry(%s)", source, e.getLocalizedMessage());
        }
        catch (Exception e) {
            StaticMethods.logWarningFormat("%s - Exception while attempting to send hit, will not retry(%s)", source, e.getLocalizedMessage());
        }
        catch (Error e) {
            StaticMethods.logWarningFormat("%s - Exception while attempting to send hit, will not retry(%s)", source, e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] retrieveAnalyticsRequestData(String url, String postBody, Map<String, String> headers, int timeout, String logPrefix) {
        if (url == null) {
            return null;
        }
        if (StaticMethods.isWearableApp()) {
            return WearableFunctionBridge.retrieveAnalyticsRequestData(url, postBody, timeout, logPrefix);
        }
        HttpURLConnection connection = RequestHandler.requestConnect(url);
        if (connection == null) {
            return null;
        }
        try {
            connection.setConnectTimeout(timeout);
            connection.setReadTimeout(timeout);
            connection.setRequestMethod("POST");
            if (!MobileConfig.getInstance().getSSL()) {
                connection.setRequestProperty("connection", "close");
            }
            byte[] outputBytes = postBody.getBytes(DEFAULT_ENCODING);
            connection.setFixedLengthStreamingMode(outputBytes.length);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    connection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            BufferedOutputStream postBodyStream = new BufferedOutputStream(connection.getOutputStream());
            ((OutputStream)postBodyStream).write(outputBytes);
            ((OutputStream)postBodyStream).close();
            InputStream inputStream = connection.getInputStream();
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (MobileConfig.getInstance().getSSL() || connection.getResponseCode() == 200) {
                int len;
                while ((len = inputStream.read(buffer)) != -1) {
                    baos.write(buffer, 0, len);
                }
            }
            inputStream.close();
            StaticMethods.logDebugFormat("%s - Request Sent(%s)", logPrefix, postBody);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (SocketTimeoutException e) {
            StaticMethods.logDebugFormat("%s - Timed out sending request(%s)", logPrefix, postBody);
            byte[] byArray = null;
            return byArray;
        }
        catch (IOException e) {
            StaticMethods.logDebugFormat("%s - IOException while sending request, may retry(%s)", logPrefix, e.getLocalizedMessage());
            byte[] byArray = null;
            return byArray;
        }
        catch (Exception e) {
            StaticMethods.logErrorFormat("%s - Exception while attempting to send hit, will not retry(%s)", logPrefix, e.getLocalizedMessage());
            byte[] byArray = new byte[]{};
            return byArray;
        }
        catch (Error e) {
            StaticMethods.logErrorFormat("%s - Exception while attempting to send hit, will not retry(%s)", logPrefix, e.getLocalizedMessage());
            byte[] byArray = new byte[]{};
            return byArray;
        }
        finally {
            if (!MobileConfig.getInstance().getSSL()) {
                connection.disconnect();
            }
        }
    }

    protected static boolean sendThirdPartyRequest(String url, String postBody, Map<String, String> headers, int timeout, String postType, String logPrefix) {
        if (url == null) {
            return false;
        }
        if (StaticMethods.isWearableApp()) {
            return WearableFunctionBridge.sendThirdPartyRequest(url, postBody, timeout, postType, logPrefix);
        }
        HttpURLConnection connection = RequestHandler.requestConnect(url);
        if (connection == null) {
            return false;
        }
        try {
            connection.setConnectTimeout(timeout);
            connection.setReadTimeout(timeout);
            connection.setRequestMethod("GET");
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    connection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            if (postBody != null && postBody.length() > 0) {
                connection.setRequestMethod("POST");
                String contentType = postType != null && postType.length() > 0 ? postType : "application/x-www-form-urlencoded";
                byte[] outputBytes = postBody.getBytes(DEFAULT_ENCODING);
                connection.setFixedLengthStreamingMode(outputBytes.length);
                connection.setRequestProperty("Content-Type", contentType);
                OutputStream connectionOutputStream = connection.getOutputStream();
                BufferedOutputStream postBodyStream = new BufferedOutputStream(connectionOutputStream);
                ((OutputStream)postBodyStream).write(outputBytes);
                ((OutputStream)postBodyStream).close();
            }
            InputStream inputStream = connection.getInputStream();
            byte[] b = new byte[10];
            while (inputStream.read(b) > 0) {
            }
            inputStream.close();
            StaticMethods.logDebugFormat("%s - Successfully forwarded hit (%s body: %s type: %s)", logPrefix, url, postBody, postType);
        }
        catch (SocketTimeoutException e) {
            StaticMethods.logDebugFormat("%s - Timed out sending request (%s)", logPrefix, postBody);
            return false;
        }
        catch (IOException e) {
            StaticMethods.logDebugFormat("%s - IOException while sending request, will not retry (%s)", logPrefix, e.getLocalizedMessage());
        }
        catch (Exception e) {
            StaticMethods.logErrorFormat("%s - Exception while attempting to send hit, will not retry (%s)", logPrefix, e.getLocalizedMessage());
        }
        catch (Error e) {
            StaticMethods.logErrorFormat("%s - Exception while attempting to send hit, will not retry (%s)", logPrefix, e.getLocalizedMessage());
        }
        return true;
    }

    static HttpURLConnection requestConnect(String url) {
        try {
            HttpURLConnection connection;
            URL urlObject = new URL(url);
            String protocol = urlObject.getProtocol();
            if (protocol == null) {
                return null;
            }
            if (protocol.startsWith("https")) {
                connection = (HttpsURLConnection)urlObject.openConnection();
            } else if (protocol.startsWith("http")) {
                connection = (HttpURLConnection)urlObject.openConnection();
            } else {
                return null;
            }
            if (Build.VERSION.SDK_INT >= 16 && Build.VERSION.SDK_INT < 20 && connection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)connection).setSSLSocketFactory(TLSSocketFactory.getInstance());
            }
            return connection;
        }
        catch (Exception e) {
            StaticMethods.logErrorFormat("Adobe Mobile - Exception opening URL (%s)", e.getLocalizedMessage());
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    protected static NetworkObject retrieveNetworkObject(String url, String requestType, String acceptHeader, String postBodyString, int timeoutSecs, String contentType, String source, String sessionID) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static interface HeaderCallback {
        public void call(Map<String, List<String>> var1);
    }
}

