/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import com.adobe.mobile.StaticMethods;
import java.util.Date;

public final class MediaState {
    public Date openTime = new Date();
    public String name;
    public String segment;
    public String playerName;
    public String mediaEvent;
    public int offsetMilestone;
    public int segmentNum;
    public int milestone;
    public double length;
    public double offset;
    public double percent;
    public double timePlayed;
    public double segmentLength;
    public boolean complete = false;
    public boolean clicked = false;
    public boolean ad;
    public boolean eventFirstTime;
    protected int eventType;
    private long timestamp;
    private double timePlayedSinceTrack;

    protected MediaState(String name, double length, String playerName, long openTime) {
        this.name = name;
        this.length = length;
        this.playerName = playerName;
        this.timestamp = StaticMethods.getTimeSince1970();
        this.segment = "";
        this.segmentNum = 0;
        this.segmentLength = 0.0;
        this.openTime.setTime(openTime);
    }

    protected MediaState(MediaState masterState) {
        this.name = masterState.name;
        this.length = masterState.length;
        this.playerName = masterState.playerName;
        this.mediaEvent = masterState.mediaEvent;
        this.eventFirstTime = masterState.eventFirstTime;
        this.openTime = masterState.openTime;
        this.offset = masterState.offset;
        this.percent = masterState.percent;
        this.timePlayed = masterState.timePlayed;
        this.milestone = masterState.milestone;
        this.offsetMilestone = masterState.offsetMilestone;
        this.segmentNum = masterState.segmentNum;
        this.segment = masterState.segment;
        this.segmentLength = masterState.segmentLength;
        this.complete = masterState.complete;
        this.eventType = masterState.eventType;
        this.timestamp = masterState.timestamp;
        this.timePlayedSinceTrack = masterState.timePlayedSinceTrack;
        this.clicked = masterState.clicked;
        this.ad = masterState.ad;
    }

    protected int getEventType() {
        return this.eventType;
    }

    protected void setEventType(int eventType) {
        String mediaEvent;
        this.eventType = eventType;
        switch (this.eventType) {
            case 1: {
                mediaEvent = "PLAY";
                break;
            }
            case 2: {
                mediaEvent = "STOP";
                break;
            }
            case 3: {
                mediaEvent = "MONITOR";
                break;
            }
            case 4: {
                mediaEvent = "TRACK";
                break;
            }
            case 5: {
                mediaEvent = "COMPLETE";
                break;
            }
            case 6: {
                mediaEvent = "CLICK";
                break;
            }
            default: {
                mediaEvent = "CLOSE";
            }
        }
        this.mediaEvent = mediaEvent;
    }

    protected void setOffset(double offset) {
        this.offset = offset;
        if (this.length > 0.0) {
            double d = this.offset = offset < this.length ? offset : this.length;
        }
        if (this.offset < 0.0) {
            this.offset = 0.0;
        }
        this.generatePercent();
        this.checkComplete();
    }

    private void generatePercent() {
        if (this.length != -1.0) {
            this.percent = this.offset / this.length * 100.0;
            this.percent = this.percent < 100.0 ? this.percent : 100.0;
        }
    }

    private void checkComplete() {
        if (this.length == -1.0) {
            this.complete = false;
            return;
        }
        if (this.percent >= 100.0) {
            this.complete = true;
        }
    }

    protected double getTimestamp() {
        return this.timestamp;
    }

    protected double getTimePlayedSinceTrack() {
        return this.timePlayedSinceTrack;
    }

    protected void setTimePlayedSinceTrack(double timePlayedSinceTrack) {
        this.timePlayedSinceTrack = timePlayedSinceTrack;
    }

    protected double getTimePlayed() {
        return this.timePlayed;
    }

    protected void setTimePlayed(double timePlayed) {
        this.timePlayed = timePlayed;
    }
}

