/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import com.adobe.mobile.AnalyticsTrackInternal;
import com.adobe.mobile.Media;
import com.adobe.mobile.MediaItem;
import com.adobe.mobile.MediaSettings;
import com.adobe.mobile.MediaState;
import com.adobe.mobile.StaticMethods;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class MediaAnalytics {
    protected static final double LIVE_EVENT_LENGTH = -1.0;
    protected int trackSeconds = 0;
    protected int completeCloseOffsetThreshold = 1;
    private static final String CONTENT_TYPE_KEY = "a.contentType";
    private static final String MEDIA_VIEW_KEY = "a.media.view";
    private static final String CHANNEL_KEY = "a.media.channel";
    private static final String NAME_KEY = "a.media.name";
    private static final String PLAYER_NAME_KEY = "a.media.playerName";
    private static final String LENGTH_KEY = "a.media.length";
    private static final String MILESTONE_KEY = "a.media.milestone";
    private static final String OFFSET_MILESTONE_KEY = "a.media.offsetMilestone";
    private static final String COMPLETE_KEY = "a.media.complete";
    private static final String TIME_PLAYED_KEY = "a.media.timePlayed";
    private static final String SEGMENT_VIEW_KEY = "a.media.segmentView";
    private static final String SEGMENT_KEY = "a.media.segment";
    private static final String SEGMENT_NUM_KEY = "a.media.segmentNum";
    private static final String MEDIA_CLICKED_KEY = "a.media.clicked";
    private static final String AD_VIEW_KEY = "a.media.ad.view";
    private static final String AD_NAME_KEY = "a.media.ad.name";
    private static final String AD_PLAYER_NAME_KEY = "a.media.ad.playerName";
    private static final String AD_LENGTH_KEY = "a.media.ad.length";
    private static final String AD_MILESTONE_KEY = "a.media.ad.milestone";
    private static final String AD_OFFSET_MILESTONE_KEY = "a.media.ad.offsetMilestone";
    private static final String AD_COMPLETE_KEY = "a.media.ad.complete";
    private static final String AD_TIME_PLAYED_KEY = "a.media.ad.timePlayed";
    private static final String AD_SEGMENT_VIEW_KEY = "a.media.ad.segmentView";
    private static final String AD_SEGMENT_KEY = "a.media.ad.segment";
    private static final String AD_SEGMENT_NUM_KEY = "a.media.ad.segmentNum";
    private static final String AD_CLICKED_KEY = "a.media.ad.clicked";
    private static final String AD_POD = "a.media.ad.pod";
    private static final String AD_POD_POSITION = "a.media.ad.podPosition";
    private static final String AD_CPM = "a.media.ad.CPM";
    private static final String PAGE_EVENT_VAR_OVERRIDE = "&&pe";
    private static final String PEV_VAR_OVERRIDE = "&&pev3";
    private static final String DEFAULT_PLAYER_NAME = "Not_Specified";
    private static final String CONTENT_TYPE_VALUE = "video";
    private static final String CONTENT_TYPE_VALUE_AD = "videoAd";
    private static final String INITIAL_HIT_PAGE_EVENT = "m_s";
    private static final String MEDIA_HIT_PAGE_EVENT = "m_i";
    private static final String PEV_VALUE_OVERRIDE = "video";
    private static final String PEV_VALUE_OVERRIDE_AD = "videoAd";
    private final HashMap<String, Object> mediaItemList = new HashMap();
    private static final List<String> unwantedValues = Arrays.asList(null, "");
    private static MediaAnalytics _instance = null;
    private static final Object _instanceMutex = new Object();

    MediaAnalytics() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static MediaAnalytics sharedInstance() {
        Object object = _instanceMutex;
        synchronized (object) {
            if (_instance == null) {
                _instance = new MediaAnalytics();
            }
            return _instance;
        }
    }

    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected synchronized void open(MediaSettings settings, Media.MediaCallback callback) {
        String cleanPlayerName;
        String cleanMediaName = this.cleanName(settings.name);
        if (this.isNilOrEmptyString(cleanMediaName)) {
            StaticMethods.logWarningFormat("Analytics - ADBMediaSettings is required with a valid name. Media item not opened", new Object[0]);
            return;
        }
        if (settings.isMediaAd && this.isNilOrEmptyString(settings.parentName)) {
            StaticMethods.logWarningFormat("Analytics - Media ad requires parent name, please specify a parent name. Media item not opened", new Object[0]);
            return;
        }
        double validLength = settings.length > 0.0 ? settings.length : -1.0;
        String string = cleanPlayerName = this.isNilOrEmptyString(settings.playerName) ? DEFAULT_PLAYER_NAME : this.cleanName(settings.playerName);
        if (this.mediaItemList.containsKey(cleanMediaName)) {
            this.close(cleanMediaName);
        }
        if (!this.isNilOrEmptyString(settings.playerID)) {
            for (String key : this.mediaItemList.keySet()) {
                String mediaName = key;
                String existingPlayerID = ((MediaItem)this.mediaItemList.get(mediaName)).getPlayerID();
                if (existingPlayerID == null || !existingPlayerID.equals(settings.playerID)) continue;
                this.close(mediaName);
                break;
            }
        }
        MediaItem mediaItem = new MediaItem(settings, this, cleanMediaName, validLength, cleanPlayerName);
        mediaItem.callback = callback;
        this.mediaItemList.put(cleanMediaName, mediaItem);
    }

    protected synchronized void close(String name) {
        MediaItem mediaItem = this.mediaItemWithName(name);
        if (mediaItem == null) {
            return;
        }
        mediaItem.trackCalled = false;
        mediaItem.close();
        this.notifyDelegateOfMediaState(mediaItem);
        if (!mediaItem.trackCalled) {
            if (mediaItem.currentMediaState.getTimePlayed() > 0.0) {
                this.trackMediaStateIfNecessary(mediaItem, null, true);
            }
            this.mediaItemList.remove(mediaItem.name);
        } else {
            mediaItem.itemClosed = true;
        }
    }

    protected synchronized void play(String name, double offset) {
        MediaItem mediaItem = this.mediaItemWithName(name);
        if (mediaItem == null) {
            return;
        }
        mediaItem.trackCalled = false;
        mediaItem.play(offset);
        this.notifyDelegateOfMediaState(mediaItem);
        if (!mediaItem.trackCalled) {
            if (mediaItem.previousMediaState == null) {
                this.trackMediaViewed(mediaItem);
            } else if (mediaItem.currentMediaState.segmentNum != mediaItem.lastTrackSegmentNumber && mediaItem.currentMediaState.timePlayed > 0.0) {
                this.trackMediaStateIfNecessary(mediaItem, null, true);
            } else {
                this.trackMediaStateIfNecessary(mediaItem, null, false);
            }
        }
        mediaItem.trackCalled = false;
        this.removeMediaItemIfComplete(mediaItem);
    }

    protected synchronized void complete(String name, double offset) {
        MediaItem mediaItem = this.mediaItemWithName(name);
        if (mediaItem == null || !mediaItem.isPlaying()) {
            return;
        }
        mediaItem.trackCalled = false;
        mediaItem.complete(offset);
        this.notifyDelegateOfMediaState(mediaItem);
        if (!mediaItem.trackCalled && mediaItem.previousMediaState != null) {
            this.trackMediaStateIfNecessary(mediaItem, null, false);
        }
    }

    protected synchronized void stop(String name, double offset) {
        MediaItem mediaItem = this.mediaItemWithName(name);
        if (mediaItem == null || !mediaItem.isPlaying()) {
            return;
        }
        mediaItem.trackCalled = false;
        mediaItem.stop(offset);
        this.notifyDelegateOfMediaState(mediaItem);
        if (!mediaItem.trackCalled && mediaItem.previousMediaState != null) {
            this.trackMediaStateIfNecessary(mediaItem, null, false);
        }
    }

    protected synchronized void click(String name, double offset) {
        MediaItem mediaItem = this.mediaItemWithName(name);
        if (mediaItem == null || !mediaItem.isPlaying()) {
            return;
        }
        mediaItem.trackCalled = false;
        mediaItem.click(offset);
        this.notifyDelegateOfMediaState(mediaItem);
        if (!mediaItem.trackCalled && mediaItem.previousMediaState != null) {
            this.trackMediaStateIfNecessary(mediaItem, null, true);
        }
    }

    protected void setTrackCalledOnItem(String name) {
        MediaItem mediaItem = this.mediaItemWithName(name);
        if (mediaItem == null) {
            return;
        }
        mediaItem.trackCalled = true;
    }

    protected synchronized void track(String name, Map<String, Object> data) {
        MediaItem mediaItem = this.mediaItemWithName(name);
        if (mediaItem == null) {
            return;
        }
        if (mediaItem.currentMediaState != null) {
            HashMap<String, Object> contextData = data != null ? new HashMap<String, Object>(data) : new HashMap();
            this.removeEmptyValues(contextData);
            this.trackMediaStateIfNecessary(mediaItem, contextData, true);
        }
        if (mediaItem.itemClosed) {
            this.mediaItemList.remove(mediaItem.name);
        }
        mediaItem.trackCalled = false;
    }

    protected synchronized void monitor(String name, double offset) {
        MediaItem mediaItem = this.mediaItemWithName(name);
        if (mediaItem == null || !mediaItem.isPlaying()) {
            return;
        }
        if (mediaItem.trackCalled) {
            mediaItem.trackCalled = false;
            return;
        }
        mediaItem.monitor(offset);
        this.notifyDelegateOfMediaState(mediaItem);
        if (mediaItem.previousMediaState != null && !mediaItem.trackCalled) {
            this.trackMediaStateIfNecessary(mediaItem, null, false);
        }
    }

    private void notifyDelegateOfMediaState(MediaItem mediaItem) {
        if (mediaItem.callback != null) {
            mediaItem.callback.call(mediaItem.getReportMediaState());
        }
    }

    private void trackMediaViewed(MediaItem mediaItem) {
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        contextData.put(!mediaItem.mediaAd ? MEDIA_VIEW_KEY : AD_VIEW_KEY, String.valueOf(true));
        this.addGenericMediaContextData(contextData, mediaItem, true);
        this.addSegmentContextData(contextData, mediaItem);
        this.trackMediaItemWithContextData(mediaItem, contextData);
        this.removeMediaItemIfComplete(mediaItem);
    }

    private void trackMediaStateIfNecessary(MediaItem mediaItem, HashMap<String, Object> data, boolean forceTrack) {
        HashMap<String, Object> contextData = data != null ? new HashMap<String, Object>(data) : new HashMap();
        this.addGenericMediaContextData(contextData, mediaItem, false);
        this.addSegmentContextData(contextData, mediaItem);
        boolean track = forceTrack;
        if (mediaItem.previousMediaState == null) {
            contextData.put(PAGE_EVENT_VAR_OVERRIDE, INITIAL_HIT_PAGE_EVENT);
            contextData.put(!mediaItem.mediaAd ? MEDIA_VIEW_KEY : AD_VIEW_KEY, true);
            this.trackMediaItemWithContextData(mediaItem, contextData);
            return;
        }
        if (mediaItem.currentMediaState.complete) {
            if (!mediaItem.isCompleteTracked()) {
                contextData.put(!mediaItem.mediaAd ? COMPLETE_KEY : AD_COMPLETE_KEY, String.valueOf(true));
                mediaItem.setCompleteTracked(true);
                track = true;
            }
            this.removeMediaItemIfComplete(mediaItem);
        }
        if (mediaItem.currentMediaState.clicked) {
            contextData.put(!mediaItem.mediaAd ? MEDIA_CLICKED_KEY : AD_CLICKED_KEY, String.valueOf(true));
        }
        if (mediaItem.currentMediaState.offsetMilestone > mediaItem.previousMediaState.offsetMilestone) {
            contextData.put(!mediaItem.mediaAd ? OFFSET_MILESTONE_KEY : AD_OFFSET_MILESTONE_KEY, Integer.toString(mediaItem.currentMediaState.offsetMilestone));
            track = true;
        }
        if (mediaItem.currentMediaState.milestone > mediaItem.previousMediaState.milestone) {
            contextData.put(!mediaItem.mediaAd ? MILESTONE_KEY : AD_MILESTONE_KEY, Integer.toString(mediaItem.currentMediaState.milestone));
            track = true;
        }
        if (mediaItem.getTrackSecondsThreshold() > 0 && mediaItem.currentMediaState.getTimePlayedSinceTrack() >= (double)mediaItem.getTrackSecondsThreshold()) {
            track = true;
        }
        if (track) {
            if (mediaItem.currentMediaState.getTimePlayedSinceTrack() > 0.0) {
                contextData.put(!mediaItem.mediaAd ? TIME_PLAYED_KEY : AD_TIME_PLAYED_KEY, Integer.toString((int)mediaItem.currentMediaState.getTimePlayedSinceTrack()));
            }
            this.trackMediaItemWithContextData(mediaItem, contextData);
        }
    }

    private void trackMediaItemWithContextData(MediaItem mediaItem, HashMap<String, Object> contextData) {
        this.trackMedia(contextData);
        mediaItem.currentMediaState.setTimePlayedSinceTrack(0.0);
    }

    private void addSegmentContextData(HashMap<String, Object> contextData, MediaItem mediaItem) {
        if (mediaItem.isSegmentByMilestones() || mediaItem.isSegmentByOffsetMilestones()) {
            MediaState segmentMediaState = mediaItem.currentMediaState;
            if (mediaItem.previousMediaState != null) {
                if (mediaItem.currentMediaState.segmentNum != mediaItem.lastTrackSegmentNumber || mediaItem.currentMediaState.complete) {
                    contextData.put(!mediaItem.mediaAd ? SEGMENT_VIEW_KEY : AD_SEGMENT_VIEW_KEY, String.valueOf(true));
                }
                if (mediaItem.currentMediaState.segmentNum != mediaItem.previousMediaState.segmentNum) {
                    segmentMediaState = mediaItem.previousMediaState;
                }
            }
            if (segmentMediaState.segmentNum > 0) {
                contextData.put(!mediaItem.mediaAd ? SEGMENT_NUM_KEY : AD_SEGMENT_NUM_KEY, Integer.toString(segmentMediaState.segmentNum));
            }
            if (segmentMediaState.segment != null) {
                contextData.put(!mediaItem.mediaAd ? SEGMENT_KEY : AD_SEGMENT_KEY, segmentMediaState.segment);
            }
        }
        mediaItem.lastTrackSegmentNumber = mediaItem.currentMediaState.segmentNum;
    }

    private void addGenericMediaContextData(HashMap<String, Object> contextData, MediaItem mediaItem, boolean mediaViewed) {
        contextData.put(PAGE_EVENT_VAR_OVERRIDE, mediaViewed ? INITIAL_HIT_PAGE_EVENT : MEDIA_HIT_PAGE_EVENT);
        if (mediaItem.mediaAd && !this.isNilOrEmptyString(mediaItem.parentName)) {
            contextData.put(PEV_VAR_OVERRIDE, "videoAd");
            contextData.put(CONTENT_TYPE_KEY, "videoAd");
            contextData.put(AD_NAME_KEY, mediaItem.getName());
            contextData.put(AD_PLAYER_NAME_KEY, mediaItem.getPlayerName());
            contextData.put(NAME_KEY, this.cleanName(mediaItem.parentName));
            if (!mediaItem.isLive()) {
                contextData.put(AD_LENGTH_KEY, Integer.toString((int)mediaItem.getLength()));
            }
            if (mediaItem.parentPod != null && mediaItem.parentPod.length() > 0) {
                contextData.put(AD_POD, mediaItem.parentPod);
            }
            if (mediaItem.parentPodPosition > 0.0) {
                contextData.put(AD_POD_POSITION, Integer.toString((int)mediaItem.parentPodPosition));
            }
            if (mediaViewed && !this.isNilOrEmptyString(mediaItem.CPM)) {
                contextData.put(AD_CPM, mediaItem.CPM);
            }
        } else {
            contextData.put(PEV_VAR_OVERRIDE, "video");
            contextData.put(CONTENT_TYPE_KEY, "video");
            contextData.put(NAME_KEY, mediaItem.getName());
            contextData.put(PLAYER_NAME_KEY, mediaItem.getPlayerName());
            if (!mediaItem.isLive()) {
                contextData.put(LENGTH_KEY, Integer.toString((int)mediaItem.getLength()));
            }
        }
        if (!this.isNilOrEmptyString(mediaItem.channel)) {
            contextData.put(CHANNEL_KEY, mediaItem.channel);
        }
    }

    private void trackMedia(HashMap<String, Object> contextData) {
        AnalyticsTrackInternal.trackInternal("Media", contextData, StaticMethods.getTimeSince1970());
    }

    private void removeMediaItemIfComplete(MediaItem mediaItem) {
        if (mediaItem.currentMediaState.percent >= 100.0) {
            this.mediaItemList.remove(mediaItem.name);
        }
    }

    private String cleanName(String name) {
        if (this.isNilOrEmptyString(name)) {
            return null;
        }
        return name.replace("\n", "").replace("\r", "").replace("--**--", "");
    }

    private MediaItem mediaItemWithName(String name) {
        String cleanName = this.cleanName(name);
        if (this.isNilOrEmptyString(cleanName) || this.hashMapIsNullOrEmpty(this.mediaItemList)) {
            return null;
        }
        return (MediaItem)this.mediaItemList.get(cleanName);
    }

    private void removeEmptyValues(HashMap<String, Object> data) {
        Collection<Object> cleanValues = data.values();
        cleanValues.removeAll(unwantedValues);
    }

    private boolean hashMapIsNullOrEmpty(HashMap val) {
        return val == null || val.size() == 0;
    }

    private boolean isNilOrEmptyString(String val) {
        return val == null || val.trim().length() == 0;
    }
}

