/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteStatement;
import com.adobe.mobile.AbstractDatabaseBacking;
import com.adobe.mobile.Analytics;
import com.adobe.mobile.AnalyticsTimedAction;
import com.adobe.mobile.AnalyticsTrackAction;
import com.adobe.mobile.StaticMethods;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

final class AnalyticsTrackTimedAction
extends AbstractDatabaseBacking {
    private static final String TIMED_ACTION_TOTAL_TIME_KEY = "a.action.time.total";
    private static final String TIMED_ACTION_IN_APP_TIME_KEY = "a.action.time.inapp";
    private static final int NUMBER_OF_SECONDS_IN_A_YEAR = 31536000;
    private SQLiteStatement sqlInsertAction;
    private SQLiteStatement sqlUpdateAction;
    private SQLiteStatement sqlUpdateActionsClearAdjustedTime;
    private String sqlSelectAction;
    private SQLiteStatement sqlDeleteAction;
    private String sqlExistsAction;
    private SQLiteStatement sqlInsertContextData;
    private SQLiteStatement sqlUpdateContextData;
    private String sqlSelectContextDataForAction;
    private SQLiteStatement sqlDeleteContextDataForAction;
    private String sqlExistsContextDataByActionAndKey;
    private static AnalyticsTrackTimedAction _instance = null;
    private static final Object _instanceMutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AnalyticsTrackTimedAction sharedInstance() {
        Object object = _instanceMutex;
        synchronized (object) {
            if (_instance == null) {
                _instance = new AnalyticsTrackTimedAction();
            }
            return _instance;
        }
    }

    private AnalyticsTrackTimedAction() {
        this.fileName = "ADBMobileTimedActionsCache.sqlite";
        this.logPrefix = "Analytics";
        this.initDatabaseBacking(new File(StaticMethods.getCacheDirectory(), this.fileName));
    }

    protected void trackTimedActionStart(String timedActionName, Map<String, Object> contextData) {
        if (timedActionName == null || timedActionName.trim().length() == 0) {
            StaticMethods.logWarningFormat("%s - trackTimedActionStart() failed(the required parameter actionName was null or empty.)", this.logPrefix);
            return;
        }
        long startTime = StaticMethods.getTimeSince1970();
        AnalyticsTimedAction timedAction = this.getTimedAction(timedActionName);
        if (timedAction != null) {
            this.deleteTimedAction(timedAction.databaseID);
        }
        this.insertTimedAction(timedActionName, contextData, startTime);
    }

    protected void trackTimedActionUpdate(String timedActionName, Map<String, Object> contextData) {
        if (timedActionName == null || timedActionName.trim().length() == 0) {
            StaticMethods.logWarningFormat("%s - Unable to update the timed action (timed action name was null or empty)", this.logPrefix);
            return;
        }
        if (contextData == null || contextData.isEmpty()) {
            StaticMethods.logWarningFormat("%s - Unable to update the timed action (context data was null or empty)", this.logPrefix);
            return;
        }
        this.saveContextDataForTimedAction(timedActionName, contextData);
    }

    protected void trackTimedActionEnd(final String timedActionName, Analytics.TimedActionBlock<Boolean> logicBlock) {
        if (timedActionName == null || timedActionName.trim().length() == 0) {
            StaticMethods.logWarningFormat("%s - Unable to end the timed action (timed action name was null or empty)", this.logPrefix);
            return;
        }
        AnalyticsTimedAction timedAction = this.getTimedAction(timedActionName);
        if (timedAction != null) {
            HashMap<String, Object> contextData;
            Long now = StaticMethods.getTimeSince1970();
            long inAppDuration = timedAction.adjustedStartTime == -1L ? -1L : now - timedAction.adjustedStartTime;
            long totalDuration = now - timedAction.startTime;
            if (inAppDuration < 0L || inAppDuration > 31536000L) {
                inAppDuration = -1L;
            }
            if (totalDuration < 0L || totalDuration > 31536000L) {
                totalDuration = -1L;
            }
            HashMap<String, Object> hashMap = contextData = timedAction.contextData != null ? new HashMap<String, Object>(timedAction.contextData) : new HashMap();
            if (logicBlock == null || logicBlock.call(inAppDuration, totalDuration, contextData).booleanValue()) {
                if (totalDuration >= 0L) {
                    contextData.put(TIMED_ACTION_TOTAL_TIME_KEY, String.valueOf(totalDuration));
                }
                if (inAppDuration >= 0L) {
                    contextData.put(TIMED_ACTION_IN_APP_TIME_KEY, String.valueOf(inAppDuration));
                }
                StaticMethods.getAnalyticsExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        AnalyticsTrackAction.trackAction(timedActionName, contextData);
                    }
                });
            } else {
                StaticMethods.logDebugFormat("%s - Not sending hit for timed action due to block cancellation (%s)", this.logPrefix, timedActionName);
            }
            this.deleteTimedAction(timedAction.databaseID);
        } else {
            StaticMethods.logWarningFormat("%s - Unable to end a timed action that has not yet begun (no timed action was found matching the name %s)", this.logPrefix, timedActionName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackTimedActionUpdateAdjustedStartTime(long timeDelta) {
        Object object = this.dbMutex;
        synchronized (object) {
            try {
                this.sqlUpdateAction.bindLong(1, timeDelta);
                this.sqlUpdateAction.execute();
                this.sqlUpdateAction.clearBindings();
            }
            catch (SQLException e) {
                StaticMethods.logErrorFormat("%s - Unable to bind prepared statement values for updating the adjusted start time for timed action (%s)", this.logPrefix, e.getLocalizedMessage());
                this.resetDatabase((Exception)((Object)e));
            }
            catch (Exception e) {
                StaticMethods.logErrorFormat("%s - Unable to adjust start times for timed actions (%s)", this.logPrefix, e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackTimedActionUpdateActionsClearAdjustedStartTime() {
        Object object = this.dbMutex;
        synchronized (object) {
            try {
                this.sqlUpdateActionsClearAdjustedTime.execute();
                this.sqlUpdateActionsClearAdjustedTime.clearBindings();
            }
            catch (SQLException e) {
                StaticMethods.logErrorFormat("%s - Unable to update adjusted time for timed actions after crash (%s)", this.logPrefix, e.getMessage());
                this.resetDatabase((Exception)((Object)e));
            }
            catch (Exception e) {
                StaticMethods.logErrorFormat("%s - Unknown error clearing adjusted start times for timed actions (%s)", this.logPrefix, e.getMessage());
                this.resetDatabase(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean trackTimedActionExists(String timedActionName) {
        if (timedActionName == null || timedActionName.trim().length() == 0) {
            StaticMethods.logWarningFormat("%s - Unable to verify the existence of timed action (timed action name was null or empty)", this.logPrefix);
            return false;
        }
        boolean timedActionExists = false;
        Object object = this.dbMutex;
        synchronized (object) {
            if (this.database == null) {
                return false;
            }
            try {
                Cursor cursor = this.database.rawQuery(this.sqlExistsAction, new String[]{timedActionName});
                if (cursor.moveToFirst()) {
                    timedActionExists = cursor.getInt(0) > 0;
                }
                cursor.close();
            }
            catch (SQLException e) {
                StaticMethods.logErrorFormat("%s - Unable to query timed actions database (%s)", this.logPrefix, e.getMessage());
            }
            catch (Exception e) {
                StaticMethods.logErrorFormat("%s - Unknown error checking for timed action (%s)", this.logPrefix, e.getMessage());
            }
        }
        return timedActionExists;
    }

    @Override
    protected void preMigrate() {
        File oldFile = new File(StaticMethods.getCacheDirectory() + "ADBMobileDataCache.sqlite" + this.fileName);
        File newFile = new File(StaticMethods.getCacheDirectory(), this.fileName);
        if (oldFile.exists() && !newFile.exists()) {
            try {
                if (!oldFile.renameTo(newFile)) {
                    StaticMethods.logWarningFormat("%s - Unable to migrate old Timed Actions db, creating new Timed Actions db (move file returned false)", this.logPrefix);
                }
            }
            catch (Exception e) {
                StaticMethods.logWarningFormat("%s - Unable to migrate old Timed Actions db, creating new Timed Actions db (%s)", this.logPrefix, e.getLocalizedMessage());
            }
        }
    }

    @Override
    protected void postMigrate() {
    }

    @Override
    protected void postReset() {
    }

    @Override
    protected void initializeDatabase() {
        try {
            this.database.execSQL("CREATE TABLE IF NOT EXISTS TIMEDACTIONS (ID INTEGER PRIMARY KEY AUTOINCREMENT, NAME TEXT, STARTTIME INTEGER, ADJSTARTTIME INTEGER)");
            this.database.execSQL("CREATE TABLE IF NOT EXISTS CONTEXTDATA (ID INTEGER PRIMARY KEY AUTOINCREMENT, ACTIONID INTEGER, KEY TEXT, VALUE TEXT, FOREIGN KEY(ACTIONID) REFERENCES TIMEDACTIONS(ID))");
        }
        catch (SQLException e) {
            StaticMethods.logErrorFormat("%s - Unable to open or create timed actions database (%s)", this.logPrefix, e.getMessage());
        }
        catch (Exception e) {
            StaticMethods.logErrorFormat("%s - Uknown error creating timed actions database (%s)", this.logPrefix, e.getMessage());
        }
    }

    @Override
    protected void prepareStatements() {
        this.sqlSelectAction = "SELECT ID, STARTTIME, ADJSTARTTIME FROM TIMEDACTIONS WHERE NAME=?";
        this.sqlExistsAction = "SELECT COUNT(*) FROM TIMEDACTIONS WHERE NAME=?";
        this.sqlSelectContextDataForAction = "SELECT KEY, VALUE FROM CONTEXTDATA WHERE ACTIONID=?";
        this.sqlExistsContextDataByActionAndKey = "SELECT COUNT(*) FROM CONTEXTDATA WHERE ACTIONID=? AND KEY=?";
        try {
            this.sqlInsertAction = this.database.compileStatement("INSERT INTO TIMEDACTIONS (NAME, STARTTIME, ADJSTARTTIME) VALUES (@NAME, @START, @START)");
            this.sqlUpdateAction = this.database.compileStatement("UPDATE TIMEDACTIONS SET ADJSTARTTIME=ADJSTARTTIME+@DELTA WHERE ADJSTARTTIME!=-1");
            this.sqlUpdateActionsClearAdjustedTime = this.database.compileStatement("UPDATE TIMEDACTIONS SET ADJSTARTTIME=-1");
            this.sqlDeleteAction = this.database.compileStatement("DELETE FROM TIMEDACTIONS WHERE ID=@ID");
            this.sqlInsertContextData = this.database.compileStatement("INSERT INTO CONTEXTDATA(ACTIONID, KEY, VALUE) VALUES (@ACTIONID, @KEY, @VALUE)");
            this.sqlUpdateContextData = this.database.compileStatement("UPDATE CONTEXTDATA SET VALUE=@VALUE WHERE ACTIONID=@ACTIONID AND KEY=@KEY");
            this.sqlDeleteContextDataForAction = this.database.compileStatement("DELETE FROM CONTEXTDATA WHERE ACTIONID=@ACTIONID");
        }
        catch (SQLException e) {
            StaticMethods.logErrorFormat("Analytics - unable to prepare the needed SQL statements for interacting with the timed actions database (%s)", e.getMessage());
        }
        catch (Exception e) {
            StaticMethods.logErrorFormat("Analytics - Unknown error preparing sql statements (%s)", e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertTimedAction(String timedActionName, Map<String, Object> contextData, long startTime) {
        if (timedActionName == null || timedActionName.trim().length() == 0) {
            StaticMethods.logWarningFormat("Analytics - Unable to insert timed action (timed action name was null or empty)", new Object[0]);
            return;
        }
        Object object = this.dbMutex;
        synchronized (object) {
            try {
                this.sqlInsertAction.bindString(1, timedActionName);
                this.sqlInsertAction.bindLong(2, startTime);
                if (this.sqlInsertAction.executeInsert() == -1L) {
                    StaticMethods.logWarningFormat("Analytics - Unable to insert the timed action (%s)", timedActionName);
                }
                this.sqlInsertAction.clearBindings();
            }
            catch (SQLException e) {
                StaticMethods.logErrorFormat("Analytics - Unable to bind prepared statement values for inserting the timed action (%s)", timedActionName);
                this.resetDatabase((Exception)((Object)e));
            }
            catch (Exception e) {
                StaticMethods.logErrorFormat("Analyitcs - Unknown error when inserting timed action (%s)", e.getMessage());
            }
        }
        this.saveContextDataForTimedAction(timedActionName, contextData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveContextDataForTimedAction(String timedActionName, Map<String, Object> contextData) {
        if (timedActionName == null || timedActionName.trim().length() == 0) {
            StaticMethods.logWarningFormat("Analytics - Unable to save context data (timed action name was null or empty)", new Object[0]);
            return;
        }
        if (contextData == null || contextData.isEmpty()) {
            StaticMethods.logWarningFormat("Analytics - Unable to save context data (context data was null or empty)", new Object[0]);
            return;
        }
        Object object = this.dbMutex;
        synchronized (object) {
            try {
                if (this.database == null) {
                    StaticMethods.logErrorFormat("Analytics - Null Database Object, unable to save context data for timed action", new Object[0]);
                    return;
                }
                Cursor cursor = this.database.rawQuery(this.sqlSelectAction, new String[]{timedActionName});
                if (!cursor.moveToFirst()) {
                    cursor.close();
                    StaticMethods.logWarningFormat("Analytics - Unable to save context data (no timed action was found matching the name %s)", timedActionName);
                    return;
                }
                int timedActionID = cursor.getInt(0);
                cursor.close();
                for (Map.Entry<String, Object> entry : contextData.entrySet()) {
                    String cDataValue;
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    if (key == null || key.length() <= 0) continue;
                    cursor = this.database.rawQuery(this.sqlExistsContextDataByActionAndKey, new String[]{String.valueOf(timedActionID), entry.getKey()});
                    String string = cDataValue = value == null ? "" : value.toString();
                    if (cursor.moveToFirst() && cursor.getInt(0) > 0) {
                        this.sqlUpdateContextData.bindString(1, cDataValue);
                        this.sqlUpdateContextData.bindLong(2, (long)timedActionID);
                        this.sqlUpdateContextData.bindString(3, entry.getKey());
                        this.sqlUpdateContextData.execute();
                        this.sqlUpdateContextData.clearBindings();
                    } else {
                        this.sqlInsertContextData.bindLong(1, (long)timedActionID);
                        this.sqlInsertContextData.bindString(2, entry.getKey());
                        this.sqlInsertContextData.bindString(3, cDataValue);
                        if (this.sqlInsertContextData.executeInsert() == -1L) {
                            StaticMethods.logWarningFormat("Analytics - Unable to insert the timed action's context data (%s)", timedActionName);
                        }
                        this.sqlInsertContextData.clearBindings();
                    }
                    cursor.close();
                }
            }
            catch (SQLException e) {
                StaticMethods.logErrorFormat("Analytics - SQL exception when attempting to update context data for timed action (%s)", e.getMessage());
            }
            catch (Exception e) {
                StaticMethods.logErrorFormat("Analytics - Unexpected exception when attempting to update context data for timed action (%s)", e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AnalyticsTimedAction getTimedAction(String timedActionName) {
        if (timedActionName == null || timedActionName.trim().length() == 0) {
            StaticMethods.logWarningFormat("Analytics - Unable to get timed action (timed action name was null or empty)", new Object[0]);
            return null;
        }
        AnalyticsTimedAction timedAction = null;
        Object object = this.dbMutex;
        synchronized (object) {
            if (this.database == null) {
                return null;
            }
            try {
                Cursor actionCursor = this.database.rawQuery(this.sqlSelectAction, new String[]{timedActionName});
                if (actionCursor.moveToFirst()) {
                    timedAction = new AnalyticsTimedAction(null, actionCursor.getLong(1), actionCursor.getLong(2), actionCursor.getInt(0));
                    Cursor contextDataCursor = this.database.rawQuery(this.sqlSelectContextDataForAction, new String[]{String.valueOf(timedAction.databaseID)});
                    if (contextDataCursor.moveToFirst()) {
                        timedAction.contextData = new HashMap<String, Object>();
                        do {
                            timedAction.contextData.put(contextDataCursor.getString(0), contextDataCursor.getString(1));
                        } while (contextDataCursor.moveToNext());
                    }
                    contextDataCursor.close();
                }
                actionCursor.close();
            }
            catch (SQLException e) {
                StaticMethods.logErrorFormat("Analytics - Unable to read from timed actions database (%s)", e.getMessage());
                this.resetDatabase((Exception)((Object)e));
            }
            catch (Exception e) {
                StaticMethods.logErrorFormat("Analytics - Unknown error reading from timed actions database (%s)", e.getMessage());
            }
        }
        return timedAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTimedAction(int timedActionID) {
        Object object = this.dbMutex;
        synchronized (object) {
            try {
                this.sqlDeleteContextDataForAction.bindLong(1, (long)timedActionID);
                this.sqlDeleteContextDataForAction.execute();
                this.sqlDeleteAction.bindLong(1, (long)timedActionID);
                this.sqlDeleteAction.execute();
                this.sqlDeleteContextDataForAction.clearBindings();
                this.sqlDeleteAction.clearBindings();
            }
            catch (SQLException e) {
                StaticMethods.logErrorFormat("Analytics - Unable to delete the timed action (ID = %d, Exception: %s)", timedActionID, e.getMessage());
                this.resetDatabase((Exception)((Object)e));
            }
            catch (Exception e) {
                StaticMethods.logErrorFormat("Analytics - Unknown error deleting timed action (%s)", e.getMessage());
            }
        }
    }
}

