/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import android.location.Location;
import com.adobe.mobile.AnalyticsTrackInternal;
import com.adobe.mobile.Lifecycle;
import com.adobe.mobile.MobileConfig;
import com.adobe.mobile.StaticMethods;
import com.adobe.mobile.TargetWorker;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

final class AnalyticsTrackLocation {
    private static final String ZERO_PADDED_11_6_FLOAT_FORMAT = "% 011.6f";
    private static final String WHOLE_ONLY_FLOAT_FORMAT = "%.0f";
    private static final String LOCATION_LAT_PART1_KEY = "a.loc.lat.a";
    private static final String LOCATION_LAT_PART2_KEY = "a.loc.lat.b";
    private static final String LOCATION_LAT_PART3_KEY = "a.loc.lat.c";
    private static final String LOCATION_LON_PART1_KEY = "a.loc.lon.a";
    private static final String LOCATION_LON_PART2_KEY = "a.loc.lon.b";
    private static final String LOCATION_LON_PART3_KEY = "a.loc.lon.c";
    private static final String ACCURACY_KEY = "a.loc.acc";
    private static final String POI_NAME_KEY = "a.loc.poi";
    private static final String POI_DIST_KEY = "a.loc.dist";
    private static final String LOCATION_ACTION_NAME = "Location";

    AnalyticsTrackLocation() {
    }

    public static void trackLocation(Location location, Map<String, Object> data) {
        if (location == null) {
            StaticMethods.logWarningFormat("Analytics - trackLocation failed, invalid location specified", new Object[0]);
            return;
        }
        String latString = String.format(Locale.US, ZERO_PADDED_11_6_FLOAT_FORMAT, location.getLatitude());
        String lonString = String.format(Locale.US, ZERO_PADDED_11_6_FLOAT_FORMAT, location.getLongitude());
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        if (data != null) {
            contextData.putAll(data);
        }
        contextData.put(LOCATION_LAT_PART1_KEY, latString.substring(0, 6).trim());
        contextData.put(LOCATION_LAT_PART2_KEY, latString.substring(6, 8));
        contextData.put(LOCATION_LAT_PART3_KEY, latString.substring(8, 10));
        contextData.put(LOCATION_LON_PART1_KEY, lonString.substring(0, 6).trim());
        contextData.put(LOCATION_LON_PART2_KEY, lonString.substring(6, 8));
        contextData.put(LOCATION_LON_PART3_KEY, lonString.substring(8, 10));
        if (location.hasAccuracy() && location.getAccuracy() > 0.0f) {
            contextData.put(ACCURACY_KEY, String.format(Locale.US, WHOLE_ONLY_FLOAT_FORMAT, Float.valueOf(location.getAccuracy())));
        }
        TargetWorker.removePersistentParameter(POI_NAME_KEY);
        TargetWorker.removePersistentParameter(POI_DIST_KEY);
        Lifecycle.removeContextData(POI_NAME_KEY);
        List<List<Object>> poi = MobileConfig.getInstance().getPointsOfInterest();
        if (poi != null) {
            for (List<Object> poiArray : poi) {
                double radius;
                double longitude;
                double latitude;
                String name;
                if (poiArray == null || poiArray.size() != 4) continue;
                try {
                    name = poiArray.get(0).toString();
                    latitude = (Double)poiArray.get(1);
                    longitude = (Double)poiArray.get(2);
                    radius = (Double)poiArray.get(3);
                }
                catch (ClassCastException ex) {
                    StaticMethods.logWarningFormat("Analytics - Invalid data for point of interest(%s)", ex.getLocalizedMessage());
                    continue;
                }
                Location poiLocation = new Location("poi");
                poiLocation.setLatitude(latitude);
                poiLocation.setLongitude(longitude);
                double distance = poiLocation.distanceTo(location);
                if (!(distance <= radius) || name == null) continue;
                contextData.put(POI_NAME_KEY, name);
                TargetWorker.addPersistentParameter(POI_NAME_KEY, name);
                contextData.put(POI_DIST_KEY, String.format(Locale.US, WHOLE_ONLY_FLOAT_FORMAT, distance));
                TargetWorker.addPersistentParameter(POI_DIST_KEY, String.valueOf(distance));
                HashMap<String, Object> poiData = new HashMap<String, Object>();
                poiData.put(POI_NAME_KEY, name);
                Lifecycle.updateContextData(poiData);
                break;
            }
        }
        AnalyticsTrackInternal.trackInternal(LOCATION_ACTION_NAME, contextData, StaticMethods.getTimeSince1970());
    }
}

