/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import android.content.SharedPreferences;
import com.adobe.mobile.AnalyticsTrackInternal;
import com.adobe.mobile.Lifecycle;
import com.adobe.mobile.StaticMethods;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

final class AnalyticsTrackLifetimeValueIncrease {
    private static final String LOCAL_STORAGE_LIFETIME_VALUE_KEY = "ADB_LIFETIME_VALUE";
    private static final String LTV_ACTION_NAME = "LifetimeValueIncrease";
    private static final String LTV_INCREASE_KEY = "a.ltv.increase";
    protected static final String LTV_AMOUNT_KEY = "a.ltv.amount";
    private static final Object _lifetimeValueMutex = new Object();

    AnalyticsTrackLifetimeValueIncrease() {
    }

    public static void trackLifetimeValueIncrease(BigDecimal amount, Map<String, Object> data) {
        if (amount == null || amount.signum() == -1) {
            StaticMethods.logWarningFormat("Analytics - trackLifetimeValueIncrease failed, invalid amount specified '%f'", amount);
            return;
        }
        AnalyticsTrackLifetimeValueIncrease.incrementLifetimeValue(amount);
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        if (data != null) {
            contextData.putAll(data);
        }
        if (AnalyticsTrackLifetimeValueIncrease.getLifetimeValue() == null) {
            return;
        }
        Lifecycle.updateContextData((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put(AnalyticsTrackLifetimeValueIncrease.LTV_AMOUNT_KEY, AnalyticsTrackLifetimeValueIncrease.getLifetimeValue());
            }
        });
        contextData.put(LTV_AMOUNT_KEY, AnalyticsTrackLifetimeValueIncrease.getLifetimeValue());
        contextData.put(LTV_INCREASE_KEY, amount);
        AnalyticsTrackInternal.trackInternal(LTV_ACTION_NAME, contextData, StaticMethods.getTimeSince1970());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static BigDecimal getLifetimeValue() {
        Object object = _lifetimeValueMutex;
        synchronized (object) {
            BigDecimal lifetimeValue;
            try {
                lifetimeValue = new BigDecimal(StaticMethods.getSharedPreferences().getString(LOCAL_STORAGE_LIFETIME_VALUE_KEY, "0"));
            }
            catch (NumberFormatException e) {
                lifetimeValue = new BigDecimal("0");
            }
            catch (StaticMethods.NullContextException e) {
                StaticMethods.logErrorFormat("Analytics - Error getting current lifetime value:(%s).", e.getMessage());
                lifetimeValue = null;
            }
            return lifetimeValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setLifetimeValue(BigDecimal ltv) {
        Object object = _lifetimeValueMutex;
        synchronized (object) {
            try {
                SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
                if (ltv == null || ltv.signum() == -1) {
                    editor.putString(LOCAL_STORAGE_LIFETIME_VALUE_KEY, "0.00");
                } else {
                    editor.putString(LOCAL_STORAGE_LIFETIME_VALUE_KEY, ltv.toString());
                }
                editor.commit();
            }
            catch (StaticMethods.NullContextException e) {
                StaticMethods.logErrorFormat("Analytics - Error updating lifetime value: (%s).", e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void incrementLifetimeValue(BigDecimal ltv) {
        Object object = _lifetimeValueMutex;
        synchronized (object) {
            BigDecimal currentLifetimeValue = AnalyticsTrackLifetimeValueIncrease.getLifetimeValue();
            if (ltv == null || ltv.signum() == -1 || currentLifetimeValue == null) {
                return;
            }
            AnalyticsTrackLifetimeValueIncrease.setLifetimeValue(currentLifetimeValue.add(ltv));
        }
    }
}

