/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import com.adobe.mobile.StaticMethods;
import java.io.File;

abstract class AbstractDatabaseBacking {
    protected SQLiteDatabase database;
    private File _dbFile = null;
    protected DatabaseStatus databaseStatus;
    protected final Object dbMutex = new Object();
    protected String fileName;
    protected String logPrefix;

    AbstractDatabaseBacking() {
    }

    protected void initializeDatabase() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("initializeDatabase must be overwritten");
    }

    protected void prepareStatements() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("prepareStatements must be overwritten");
    }

    protected void postReset() {
    }

    protected void preMigrate() {
    }

    protected void postMigrate() {
    }

    private void openOrCreateDatabase() {
        try {
            this.closeDataBase();
            int flags = 0x10000010;
            this.database = SQLiteDatabase.openDatabase((String)this._dbFile.getPath(), null, (int)flags);
            this.databaseStatus = DatabaseStatus.OK;
        }
        catch (SQLException x) {
            this.databaseStatus = DatabaseStatus.FATALERROR;
            StaticMethods.logErrorFormat("%s - Unable to open database (%s).", this.logPrefix, x.getLocalizedMessage());
        }
    }

    protected void closeDataBase() {
        if (this.database != null) {
            this.database.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initDatabaseBacking(File databaseFile) {
        this._dbFile = databaseFile;
        Object object = this.dbMutex;
        synchronized (object) {
            this.preMigrate();
            this.openOrCreateDatabase();
            if (this.database != null) {
                this.postMigrate();
                this.initializeDatabase();
                this.prepareStatements();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void resetDatabase(Exception reason) {
        StaticMethods.logErrorFormat("%s - Database in unrecoverable state (%s), resetting.", this.logPrefix, reason.getLocalizedMessage());
        Object object = this.dbMutex;
        synchronized (object) {
            if (this._dbFile.exists() && !this._dbFile.delete()) {
                StaticMethods.logErrorFormat("%s - Failed to delete database file(%s).", this.logPrefix, this._dbFile.getAbsolutePath());
                this.databaseStatus = DatabaseStatus.FATALERROR;
                return;
            }
            StaticMethods.logDebugFormat("%s - Database file(%s) was corrupt and had to be deleted.", this.logPrefix, this._dbFile.getAbsolutePath());
            this.openOrCreateDatabase();
            this.initializeDatabase();
            this.prepareStatements();
            this.postReset();
        }
    }

    protected static class CorruptedDatabaseException
    extends Exception {
        public CorruptedDatabaseException(String message) {
            super(message);
        }
    }

    static enum DatabaseStatus {
        OK(0),
        FATALERROR(1);

        public final int id;

        private DatabaseStatus(int identifier) {
            this.id = identifier;
        }
    }
}

