/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.extractor;

import com.akamai.amp.exoplayer2.ParserException;
import com.akamai.amp.exoplayer2.extractor.VorbisBitArray;
import com.akamai.amp.exoplayer2.util.Log;
import com.akamai.amp.exoplayer2.util.ParsableByteArray;
import java.util.Arrays;

public final class VorbisUtil {
    private static final String TAG = "VorbisUtil";

    public static int iLog(int x) {
        int val = 0;
        while (x > 0) {
            ++val;
            x >>>= 1;
        }
        return val;
    }

    public static VorbisIdHeader readVorbisIdentificationHeader(ParsableByteArray headerData) throws ParserException {
        int bitrateMinimum;
        int bitrateNominal;
        VorbisUtil.verifyVorbisHeaderCapturePattern(1, headerData, false);
        int version = headerData.readLittleEndianUnsignedIntToInt();
        int channels = headerData.readUnsignedByte();
        int sampleRate = headerData.readLittleEndianUnsignedIntToInt();
        int bitrateMaximum = headerData.readLittleEndianInt();
        if (bitrateMaximum <= 0) {
            bitrateMaximum = -1;
        }
        if ((bitrateNominal = headerData.readLittleEndianInt()) <= 0) {
            bitrateNominal = -1;
        }
        if ((bitrateMinimum = headerData.readLittleEndianInt()) <= 0) {
            bitrateMinimum = -1;
        }
        int blockSize = headerData.readUnsignedByte();
        int blockSize0 = (int)Math.pow(2.0, blockSize & 0xF);
        int blockSize1 = (int)Math.pow(2.0, (blockSize & 0xF0) >> 4);
        boolean framingFlag = (headerData.readUnsignedByte() & 1) > 0;
        byte[] data = Arrays.copyOf(headerData.getData(), headerData.limit());
        return new VorbisIdHeader(version, channels, sampleRate, bitrateMaximum, bitrateNominal, bitrateMinimum, blockSize0, blockSize1, framingFlag, data);
    }

    public static CommentHeader readVorbisCommentHeader(ParsableByteArray headerData) throws ParserException {
        return VorbisUtil.readVorbisCommentHeader(headerData, true, true);
    }

    public static CommentHeader readVorbisCommentHeader(ParsableByteArray headerData, boolean hasMetadataHeader, boolean hasFramingBit) throws ParserException {
        if (hasMetadataHeader) {
            VorbisUtil.verifyVorbisHeaderCapturePattern(3, headerData, false);
        }
        int length = 7;
        int len = (int)headerData.readLittleEndianUnsignedInt();
        length += 4;
        String vendor = headerData.readString(len);
        length += vendor.length();
        long commentListLen = headerData.readLittleEndianUnsignedInt();
        String[] comments = new String[(int)commentListLen];
        length += 4;
        int i = 0;
        while ((long)i < commentListLen) {
            len = (int)headerData.readLittleEndianUnsignedInt();
            length += 4;
            comments[i] = headerData.readString(len);
            length += comments[i].length();
            ++i;
        }
        if (hasFramingBit && (headerData.readUnsignedByte() & 1) == 0) {
            throw new ParserException("framing bit expected to be set");
        }
        return new CommentHeader(vendor, comments, ++length);
    }

    public static boolean verifyVorbisHeaderCapturePattern(int headerType, ParsableByteArray header, boolean quiet) throws ParserException {
        if (header.bytesLeft() < 7) {
            if (quiet) {
                return false;
            }
            throw new ParserException("too short header: " + header.bytesLeft());
        }
        if (header.readUnsignedByte() != headerType) {
            if (quiet) {
                return false;
            }
            throw new ParserException("expected header type " + Integer.toHexString(headerType));
        }
        if (header.readUnsignedByte() != 118 || header.readUnsignedByte() != 111 || header.readUnsignedByte() != 114 || header.readUnsignedByte() != 98 || header.readUnsignedByte() != 105 || header.readUnsignedByte() != 115) {
            if (quiet) {
                return false;
            }
            throw new ParserException("expected characters 'vorbis'");
        }
        return true;
    }

    public static Mode[] readVorbisModes(ParsableByteArray headerData, int channels) throws ParserException {
        VorbisUtil.verifyVorbisHeaderCapturePattern(5, headerData, false);
        int numberOfBooks = headerData.readUnsignedByte() + 1;
        VorbisBitArray bitArray = new VorbisBitArray(headerData.getData());
        bitArray.skipBits(headerData.getPosition() * 8);
        for (int i = 0; i < numberOfBooks; ++i) {
            VorbisUtil.readBook(bitArray);
        }
        int timeCount = bitArray.readBits(6) + 1;
        for (int i = 0; i < timeCount; ++i) {
            if (bitArray.readBits(16) == 0) continue;
            throw new ParserException("placeholder of time domain transforms not zeroed out");
        }
        VorbisUtil.readFloors(bitArray);
        VorbisUtil.readResidues(bitArray);
        VorbisUtil.readMappings(channels, bitArray);
        Mode[] modes = VorbisUtil.readModes(bitArray);
        if (!bitArray.readBit()) {
            throw new ParserException("framing bit after modes not set as expected");
        }
        return modes;
    }

    private static Mode[] readModes(VorbisBitArray bitArray) {
        int modeCount = bitArray.readBits(6) + 1;
        Mode[] modes = new Mode[modeCount];
        for (int i = 0; i < modeCount; ++i) {
            boolean blockFlag = bitArray.readBit();
            int windowType = bitArray.readBits(16);
            int transformType = bitArray.readBits(16);
            int mapping = bitArray.readBits(8);
            modes[i] = new Mode(blockFlag, windowType, transformType, mapping);
        }
        return modes;
    }

    private static void readMappings(int channels, VorbisBitArray bitArray) throws ParserException {
        int mappingsCount = bitArray.readBits(6) + 1;
        for (int i = 0; i < mappingsCount; ++i) {
            int j;
            int mappingType = bitArray.readBits(16);
            if (mappingType != 0) {
                Log.e(TAG, "mapping type other than 0 not supported: " + mappingType);
                continue;
            }
            int submaps = bitArray.readBit() ? bitArray.readBits(4) + 1 : 1;
            if (bitArray.readBit()) {
                int couplingSteps = bitArray.readBits(8) + 1;
                for (j = 0; j < couplingSteps; ++j) {
                    bitArray.skipBits(VorbisUtil.iLog(channels - 1));
                    bitArray.skipBits(VorbisUtil.iLog(channels - 1));
                }
            }
            if (bitArray.readBits(2) != 0) {
                throw new ParserException("to reserved bits must be zero after mapping coupling steps");
            }
            if (submaps > 1) {
                for (j = 0; j < channels; ++j) {
                    bitArray.skipBits(4);
                }
            }
            for (j = 0; j < submaps; ++j) {
                bitArray.skipBits(8);
                bitArray.skipBits(8);
                bitArray.skipBits(8);
            }
        }
    }

    private static void readResidues(VorbisBitArray bitArray) throws ParserException {
        int residueCount = bitArray.readBits(6) + 1;
        for (int i = 0; i < residueCount; ++i) {
            int j;
            int residueType = bitArray.readBits(16);
            if (residueType > 2) {
                throw new ParserException("residueType greater than 2 is not decodable");
            }
            bitArray.skipBits(24);
            bitArray.skipBits(24);
            bitArray.skipBits(24);
            int classifications = bitArray.readBits(6) + 1;
            bitArray.skipBits(8);
            int[] cascade = new int[classifications];
            for (j = 0; j < classifications; ++j) {
                int highBits = 0;
                int lowBits = bitArray.readBits(3);
                if (bitArray.readBit()) {
                    highBits = bitArray.readBits(5);
                }
                cascade[j] = highBits * 8 + lowBits;
            }
            for (j = 0; j < classifications; ++j) {
                for (int k = 0; k < 8; ++k) {
                    if ((cascade[j] & 1 << k) == 0) continue;
                    bitArray.skipBits(8);
                }
            }
        }
    }

    private static void readFloors(VorbisBitArray bitArray) throws ParserException {
        int floorCount = bitArray.readBits(6) + 1;
        block4: for (int i = 0; i < floorCount; ++i) {
            int floorType = bitArray.readBits(16);
            switch (floorType) {
                case 0: {
                    bitArray.skipBits(8);
                    bitArray.skipBits(16);
                    bitArray.skipBits(16);
                    bitArray.skipBits(6);
                    bitArray.skipBits(8);
                    int floorNumberOfBooks = bitArray.readBits(4) + 1;
                    for (int j = 0; j < floorNumberOfBooks; ++j) {
                        bitArray.skipBits(8);
                    }
                    continue block4;
                }
                case 1: {
                    int partitions = bitArray.readBits(5);
                    int maximumClass = -1;
                    int[] partitionClassList = new int[partitions];
                    for (int j = 0; j < partitions; ++j) {
                        partitionClassList[j] = bitArray.readBits(4);
                        if (partitionClassList[j] <= maximumClass) continue;
                        maximumClass = partitionClassList[j];
                    }
                    int[] classDimensions = new int[maximumClass + 1];
                    for (int j = 0; j < classDimensions.length; ++j) {
                        classDimensions[j] = bitArray.readBits(3) + 1;
                        int classSubclasses = bitArray.readBits(2);
                        if (classSubclasses > 0) {
                            bitArray.skipBits(8);
                        }
                        for (int k = 0; k < 1 << classSubclasses; ++k) {
                            bitArray.skipBits(8);
                        }
                    }
                    bitArray.skipBits(2);
                    int rangeBits = bitArray.readBits(4);
                    int count = 0;
                    int k = 0;
                    for (int j = 0; j < partitions; ++j) {
                        int idx = partitionClassList[j];
                        count += classDimensions[idx];
                        while (k < count) {
                            bitArray.skipBits(rangeBits);
                            ++k;
                        }
                    }
                    continue block4;
                }
                default: {
                    throw new ParserException("floor type greater than 1 not decodable: " + floorType);
                }
            }
        }
    }

    private static CodeBook readBook(VorbisBitArray bitArray) throws ParserException {
        int lookupType;
        if (bitArray.readBits(24) != 5653314) {
            throw new ParserException("expected code book to start with [0x56, 0x43, 0x42] at " + bitArray.getPosition());
        }
        int dimensions = bitArray.readBits(16);
        int entries = bitArray.readBits(24);
        long[] lengthMap = new long[entries];
        boolean isOrdered = bitArray.readBit();
        if (!isOrdered) {
            boolean isSparse = bitArray.readBit();
            for (i = 0; i < lengthMap.length; ++i) {
                if (isSparse) {
                    if (bitArray.readBit()) {
                        lengthMap[i] = bitArray.readBits(5) + 1;
                        continue;
                    }
                    lengthMap[i] = 0L;
                    continue;
                }
                lengthMap[i] = bitArray.readBits(5) + 1;
            }
        } else {
            int length = bitArray.readBits(5) + 1;
            i = 0;
            while (i < lengthMap.length) {
                int num = bitArray.readBits(VorbisUtil.iLog(entries - i));
                for (int j = 0; j < num && i < lengthMap.length; ++i, ++j) {
                    lengthMap[i] = length;
                }
                ++length;
            }
        }
        if ((lookupType = bitArray.readBits(4)) > 2) {
            throw new ParserException("lookup type greater than 2 not decodable: " + lookupType);
        }
        if (lookupType == 1 || lookupType == 2) {
            bitArray.skipBits(32);
            bitArray.skipBits(32);
            int valueBits = bitArray.readBits(4) + 1;
            bitArray.skipBits(1);
            long lookupValuesCount = lookupType == 1 ? (dimensions != 0 ? VorbisUtil.mapType1QuantValues(entries, dimensions) : 0L) : (long)entries * (long)dimensions;
            bitArray.skipBits((int)(lookupValuesCount * (long)valueBits));
        }
        return new CodeBook(dimensions, entries, lengthMap, lookupType, isOrdered);
    }

    private static long mapType1QuantValues(long entries, long dimension) {
        return (long)Math.floor(Math.pow(entries, 1.0 / (double)dimension));
    }

    private VorbisUtil() {
    }

    public static final class VorbisIdHeader {
        public final int version;
        public final int channels;
        public final int sampleRate;
        public final int bitrateMaximum;
        public final int bitrateNominal;
        public final int bitrateMinimum;
        public final int blockSize0;
        public final int blockSize1;
        public final boolean framingFlag;
        public final byte[] data;

        public VorbisIdHeader(int version, int channels, int sampleRate, int bitrateMaximum, int bitrateNominal, int bitrateMinimum, int blockSize0, int blockSize1, boolean framingFlag, byte[] data) {
            this.version = version;
            this.channels = channels;
            this.sampleRate = sampleRate;
            this.bitrateMaximum = bitrateMaximum;
            this.bitrateNominal = bitrateNominal;
            this.bitrateMinimum = bitrateMinimum;
            this.blockSize0 = blockSize0;
            this.blockSize1 = blockSize1;
            this.framingFlag = framingFlag;
            this.data = data;
        }
    }

    public static final class CommentHeader {
        public final String vendor;
        public final String[] comments;
        public final int length;

        public CommentHeader(String vendor, String[] comments, int length) {
            this.vendor = vendor;
            this.comments = comments;
            this.length = length;
        }
    }

    private static final class CodeBook {
        public final int dimensions;
        public final int entries;
        public final long[] lengthMap;
        public final int lookupType;
        public final boolean isOrdered;

        public CodeBook(int dimensions, int entries, long[] lengthMap, int lookupType, boolean isOrdered) {
            this.dimensions = dimensions;
            this.entries = entries;
            this.lengthMap = lengthMap;
            this.lookupType = lookupType;
            this.isOrdered = isOrdered;
        }
    }

    public static final class Mode {
        public final boolean blockFlag;
        public final int windowType;
        public final int transformType;
        public final int mapping;

        public Mode(boolean blockFlag, int windowType, int transformType, int mapping) {
            this.blockFlag = blockFlag;
            this.windowType = windowType;
            this.transformType = transformType;
            this.mapping = mapping;
        }
    }
}

