/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.analytics;

import android.view.Surface;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.C;
import com.akamai.amp.exoplayer2.ExoPlaybackException;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.MediaItem;
import com.akamai.amp.exoplayer2.PlaybackParameters;
import com.akamai.amp.exoplayer2.Player;
import com.akamai.amp.exoplayer2.Timeline;
import com.akamai.amp.exoplayer2.analytics.AnalyticsListener;
import com.akamai.amp.exoplayer2.audio.AudioAttributes;
import com.akamai.amp.exoplayer2.audio.AudioListener;
import com.akamai.amp.exoplayer2.audio.AudioRendererEventListener;
import com.akamai.amp.exoplayer2.decoder.DecoderCounters;
import com.akamai.amp.exoplayer2.drm.DrmSessionEventListener;
import com.akamai.amp.exoplayer2.metadata.Metadata;
import com.akamai.amp.exoplayer2.metadata.MetadataOutput;
import com.akamai.amp.exoplayer2.source.LoadEventInfo;
import com.akamai.amp.exoplayer2.source.MediaLoadData;
import com.akamai.amp.exoplayer2.source.MediaSource;
import com.akamai.amp.exoplayer2.source.MediaSourceEventListener;
import com.akamai.amp.exoplayer2.source.TrackGroupArray;
import com.akamai.amp.exoplayer2.trackselection.TrackSelectionArray;
import com.akamai.amp.exoplayer2.upstream.BandwidthMeter;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Clock;
import com.akamai.amp.exoplayer2.video.VideoListener;
import com.akamai.amp.exoplayer2.video.VideoRendererEventListener;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public class AnalyticsCollector
implements Player.EventListener,
MetadataOutput,
AudioRendererEventListener,
VideoRendererEventListener,
MediaSourceEventListener,
BandwidthMeter.EventListener,
DrmSessionEventListener,
VideoListener,
AudioListener {
    private final CopyOnWriteArraySet<AnalyticsListener> listeners;
    private final Clock clock;
    private final Timeline.Period period;
    private final Timeline.Window window;
    private final MediaPeriodQueueTracker mediaPeriodQueueTracker;
    private @MonotonicNonNull Player player;
    private boolean isSeeking;

    public AnalyticsCollector(Clock clock) {
        this.clock = Assertions.checkNotNull(clock);
        this.listeners = new CopyOnWriteArraySet();
        this.period = new Timeline.Period();
        this.window = new Timeline.Window();
        this.mediaPeriodQueueTracker = new MediaPeriodQueueTracker(this.period);
    }

    public void addListener(AnalyticsListener listener) {
        Assertions.checkNotNull(listener);
        this.listeners.add(listener);
    }

    public void removeListener(AnalyticsListener listener) {
        this.listeners.remove(listener);
    }

    public void setPlayer(Player player) {
        Assertions.checkState(this.player == null || this.mediaPeriodQueueTracker.mediaPeriodQueue.isEmpty());
        this.player = Assertions.checkNotNull(player);
    }

    public void updateMediaPeriodQueueInfo(List<MediaSource.MediaPeriodId> queue, @Nullable MediaSource.MediaPeriodId readingPeriod) {
        this.mediaPeriodQueueTracker.onQueueUpdated(queue, readingPeriod, Assertions.checkNotNull(this.player));
    }

    public final void notifySeekStarted() {
        if (!this.isSeeking) {
            AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
            this.isSeeking = true;
            for (AnalyticsListener listener : this.listeners) {
                listener.onSeekStarted(eventTime);
            }
        }
    }

    public final void resetForNewPlaylist() {
    }

    @Override
    public final void onMetadata(Metadata metadata) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onMetadata(eventTime, metadata);
        }
    }

    @Override
    public final void onAudioEnabled(DecoderCounters counters) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onAudioEnabled(eventTime, counters);
            listener.onDecoderEnabled(eventTime, 1, counters);
        }
    }

    @Override
    public final void onAudioDecoderInitialized(String decoderName, long initializedTimestampMs, long initializationDurationMs) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onAudioDecoderInitialized(eventTime, decoderName, initializationDurationMs);
            listener.onDecoderInitialized(eventTime, 1, decoderName, initializationDurationMs);
        }
    }

    @Override
    public final void onAudioInputFormatChanged(Format format) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onAudioInputFormatChanged(eventTime, format);
            listener.onDecoderInputFormatChanged(eventTime, 1, format);
        }
    }

    @Override
    public final void onAudioPositionAdvancing(long playoutStartSystemTimeMs) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onAudioPositionAdvancing(eventTime, playoutStartSystemTimeMs);
        }
    }

    @Override
    public final void onAudioUnderrun(int bufferSize, long bufferSizeMs, long elapsedSinceLastFeedMs) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onAudioUnderrun(eventTime, bufferSize, bufferSizeMs, elapsedSinceLastFeedMs);
        }
    }

    @Override
    public final void onAudioDisabled(DecoderCounters counters) {
        AnalyticsListener.EventTime eventTime = this.generatePlayingMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onAudioDisabled(eventTime, counters);
            listener.onDecoderDisabled(eventTime, 1, counters);
        }
    }

    @Override
    public final void onAudioSessionId(int audioSessionId) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onAudioSessionId(eventTime, audioSessionId);
        }
    }

    @Override
    public void onAudioAttributesChanged(AudioAttributes audioAttributes) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onAudioAttributesChanged(eventTime, audioAttributes);
        }
    }

    @Override
    public void onSkipSilenceEnabledChanged(boolean skipSilenceEnabled) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onSkipSilenceEnabledChanged(eventTime, skipSilenceEnabled);
        }
    }

    @Override
    public void onVolumeChanged(float audioVolume) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onVolumeChanged(eventTime, audioVolume);
        }
    }

    @Override
    public final void onVideoEnabled(DecoderCounters counters) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onVideoEnabled(eventTime, counters);
            listener.onDecoderEnabled(eventTime, 2, counters);
        }
    }

    @Override
    public final void onVideoDecoderInitialized(String decoderName, long initializedTimestampMs, long initializationDurationMs) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onVideoDecoderInitialized(eventTime, decoderName, initializationDurationMs);
            listener.onDecoderInitialized(eventTime, 2, decoderName, initializationDurationMs);
        }
    }

    @Override
    public final void onVideoInputFormatChanged(Format format) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onVideoInputFormatChanged(eventTime, format);
            listener.onDecoderInputFormatChanged(eventTime, 2, format);
        }
    }

    @Override
    public final void onDroppedFrames(int count, long elapsedMs) {
        AnalyticsListener.EventTime eventTime = this.generatePlayingMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onDroppedVideoFrames(eventTime, count, elapsedMs);
        }
    }

    @Override
    public final void onVideoDisabled(DecoderCounters counters) {
        AnalyticsListener.EventTime eventTime = this.generatePlayingMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onVideoDisabled(eventTime, counters);
            listener.onDecoderDisabled(eventTime, 2, counters);
        }
    }

    @Override
    public final void onRenderedFirstFrame(@Nullable Surface surface) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onRenderedFirstFrame(eventTime, surface);
        }
    }

    @Override
    public final void onVideoFrameProcessingOffset(long totalProcessingOffsetUs, int frameCount) {
        AnalyticsListener.EventTime eventTime = this.generatePlayingMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onVideoFrameProcessingOffset(eventTime, totalProcessingOffsetUs, frameCount);
        }
    }

    @Override
    public final void onRenderedFirstFrame() {
    }

    @Override
    public final void onVideoSizeChanged(int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onVideoSizeChanged(eventTime, width, height, unappliedRotationDegrees, pixelWidthHeightRatio);
        }
    }

    @Override
    public void onSurfaceSizeChanged(int width, int height) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onSurfaceSizeChanged(eventTime, width, height);
        }
    }

    @Override
    public final void onLoadStarted(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
        AnalyticsListener.EventTime eventTime = this.generateMediaPeriodEventTime(windowIndex, mediaPeriodId);
        for (AnalyticsListener listener : this.listeners) {
            listener.onLoadStarted(eventTime, loadEventInfo, mediaLoadData);
        }
    }

    @Override
    public final void onLoadCompleted(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
        AnalyticsListener.EventTime eventTime = this.generateMediaPeriodEventTime(windowIndex, mediaPeriodId);
        for (AnalyticsListener listener : this.listeners) {
            listener.onLoadCompleted(eventTime, loadEventInfo, mediaLoadData);
        }
    }

    @Override
    public final void onLoadCanceled(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
        AnalyticsListener.EventTime eventTime = this.generateMediaPeriodEventTime(windowIndex, mediaPeriodId);
        for (AnalyticsListener listener : this.listeners) {
            listener.onLoadCanceled(eventTime, loadEventInfo, mediaLoadData);
        }
    }

    @Override
    public final void onLoadError(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData, IOException error, boolean wasCanceled) {
        AnalyticsListener.EventTime eventTime = this.generateMediaPeriodEventTime(windowIndex, mediaPeriodId);
        for (AnalyticsListener listener : this.listeners) {
            listener.onLoadError(eventTime, loadEventInfo, mediaLoadData, error, wasCanceled);
        }
    }

    @Override
    public final void onUpstreamDiscarded(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, MediaLoadData mediaLoadData) {
        AnalyticsListener.EventTime eventTime = this.generateMediaPeriodEventTime(windowIndex, mediaPeriodId);
        for (AnalyticsListener listener : this.listeners) {
            listener.onUpstreamDiscarded(eventTime, mediaLoadData);
        }
    }

    @Override
    public final void onDownstreamFormatChanged(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, MediaLoadData mediaLoadData) {
        AnalyticsListener.EventTime eventTime = this.generateMediaPeriodEventTime(windowIndex, mediaPeriodId);
        for (AnalyticsListener listener : this.listeners) {
            listener.onDownstreamFormatChanged(eventTime, mediaLoadData);
        }
    }

    @Override
    public final void onTimelineChanged(Timeline timeline, int reason) {
        this.mediaPeriodQueueTracker.onTimelineChanged(Assertions.checkNotNull(this.player));
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onTimelineChanged(eventTime, reason);
        }
    }

    @Override
    public final void onMediaItemTransition(@Nullable MediaItem mediaItem, int reason) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onMediaItemTransition(eventTime, mediaItem, reason);
        }
    }

    @Override
    public final void onTracksChanged(TrackGroupArray trackGroups, TrackSelectionArray trackSelections) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onTracksChanged(eventTime, trackGroups, trackSelections);
        }
    }

    @Override
    public final void onIsLoadingChanged(boolean isLoading) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onIsLoadingChanged(eventTime, isLoading);
        }
    }

    @Override
    public final void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onPlayerStateChanged(eventTime, playWhenReady, playbackState);
        }
    }

    @Override
    public final void onPlaybackStateChanged(int state) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onPlaybackStateChanged(eventTime, state);
        }
    }

    @Override
    public final void onPlayWhenReadyChanged(boolean playWhenReady, int reason) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onPlayWhenReadyChanged(eventTime, playWhenReady, reason);
        }
    }

    @Override
    public void onPlaybackSuppressionReasonChanged(int playbackSuppressionReason) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onPlaybackSuppressionReasonChanged(eventTime, playbackSuppressionReason);
        }
    }

    @Override
    public void onIsPlayingChanged(boolean isPlaying) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onIsPlayingChanged(eventTime, isPlaying);
        }
    }

    @Override
    public final void onRepeatModeChanged(int repeatMode) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onRepeatModeChanged(eventTime, repeatMode);
        }
    }

    @Override
    public final void onShuffleModeEnabledChanged(boolean shuffleModeEnabled) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onShuffleModeChanged(eventTime, shuffleModeEnabled);
        }
    }

    @Override
    public final void onPlayerError(ExoPlaybackException error) {
        AnalyticsListener.EventTime eventTime = error.mediaPeriodId != null ? this.generateEventTime(error.mediaPeriodId) : this.generateCurrentPlayerMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onPlayerError(eventTime, error);
        }
    }

    @Override
    public final void onPositionDiscontinuity(int reason) {
        if (reason == 1) {
            this.isSeeking = false;
        }
        this.mediaPeriodQueueTracker.onPositionDiscontinuity(Assertions.checkNotNull(this.player));
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onPositionDiscontinuity(eventTime, reason);
        }
    }

    @Override
    public final void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onPlaybackParametersChanged(eventTime, playbackParameters);
        }
    }

    @Override
    public final void onSeekProcessed() {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onSeekProcessed(eventTime);
        }
    }

    @Override
    public final void onBandwidthSample(int elapsedMs, long bytes, long bitrate) {
        AnalyticsListener.EventTime eventTime = this.generateLoadingMediaPeriodEventTime();
        for (AnalyticsListener listener : this.listeners) {
            listener.onBandwidthEstimate(eventTime, elapsedMs, bytes, bitrate);
        }
    }

    @Override
    public final void onDrmSessionAcquired(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
        AnalyticsListener.EventTime eventTime = this.generateMediaPeriodEventTime(windowIndex, mediaPeriodId);
        for (AnalyticsListener listener : this.listeners) {
            listener.onDrmSessionAcquired(eventTime);
        }
    }

    @Override
    public final void onDrmKeysLoaded(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
        AnalyticsListener.EventTime eventTime = this.generateMediaPeriodEventTime(windowIndex, mediaPeriodId);
        for (AnalyticsListener listener : this.listeners) {
            listener.onDrmKeysLoaded(eventTime);
        }
    }

    @Override
    public final void onDrmSessionManagerError(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, Exception error) {
        AnalyticsListener.EventTime eventTime = this.generateMediaPeriodEventTime(windowIndex, mediaPeriodId);
        for (AnalyticsListener listener : this.listeners) {
            listener.onDrmSessionManagerError(eventTime, error);
        }
    }

    @Override
    public final void onDrmKeysRestored(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
        AnalyticsListener.EventTime eventTime = this.generateMediaPeriodEventTime(windowIndex, mediaPeriodId);
        for (AnalyticsListener listener : this.listeners) {
            listener.onDrmKeysRestored(eventTime);
        }
    }

    @Override
    public final void onDrmKeysRemoved(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
        AnalyticsListener.EventTime eventTime = this.generateMediaPeriodEventTime(windowIndex, mediaPeriodId);
        for (AnalyticsListener listener : this.listeners) {
            listener.onDrmKeysRemoved(eventTime);
        }
    }

    @Override
    public final void onDrmSessionReleased(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
        AnalyticsListener.EventTime eventTime = this.generateMediaPeriodEventTime(windowIndex, mediaPeriodId);
        for (AnalyticsListener listener : this.listeners) {
            listener.onDrmSessionReleased(eventTime);
        }
    }

    @RequiresNonNull(value={"player"})
    protected AnalyticsListener.EventTime generateEventTime(Timeline timeline, int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
        long eventPositionMs;
        boolean isInCurrentWindow;
        if (timeline.isEmpty()) {
            mediaPeriodId = null;
        }
        long realtimeMs = this.clock.elapsedRealtime();
        boolean bl = isInCurrentWindow = timeline.equals(this.player.getCurrentTimeline()) && windowIndex == this.player.getCurrentWindowIndex();
        if (mediaPeriodId != null && mediaPeriodId.isAd()) {
            boolean isCurrentAd = isInCurrentWindow && this.player.getCurrentAdGroupIndex() == mediaPeriodId.adGroupIndex && this.player.getCurrentAdIndexInAdGroup() == mediaPeriodId.adIndexInAdGroup;
            eventPositionMs = isCurrentAd ? this.player.getCurrentPosition() : 0L;
        } else {
            eventPositionMs = isInCurrentWindow ? this.player.getContentPosition() : (timeline.isEmpty() ? 0L : timeline.getWindow(windowIndex, this.window).getDefaultPositionMs());
        }
        MediaSource.MediaPeriodId currentMediaPeriodId = this.mediaPeriodQueueTracker.getCurrentPlayerMediaPeriod();
        return new AnalyticsListener.EventTime(realtimeMs, timeline, windowIndex, mediaPeriodId, eventPositionMs, this.player.getCurrentTimeline(), this.player.getCurrentWindowIndex(), currentMediaPeriodId, this.player.getCurrentPosition(), this.player.getTotalBufferedDuration());
    }

    private AnalyticsListener.EventTime generateEventTime(@Nullable MediaSource.MediaPeriodId mediaPeriodId) {
        Timeline knownTimeline;
        Assertions.checkNotNull(this.player);
        Timeline timeline = knownTimeline = mediaPeriodId == null ? null : this.mediaPeriodQueueTracker.getMediaPeriodIdTimeline(mediaPeriodId);
        if (mediaPeriodId == null || knownTimeline == null) {
            Timeline timeline2;
            int windowIndex = this.player.getCurrentWindowIndex();
            boolean windowIsInTimeline = windowIndex < (timeline2 = this.player.getCurrentTimeline()).getWindowCount();
            return this.generateEventTime(windowIsInTimeline ? timeline2 : Timeline.EMPTY, windowIndex, null);
        }
        int windowIndex = knownTimeline.getPeriodByUid((Object)mediaPeriodId.periodUid, (Timeline.Period)this.period).windowIndex;
        return this.generateEventTime(knownTimeline, windowIndex, mediaPeriodId);
    }

    private AnalyticsListener.EventTime generateCurrentPlayerMediaPeriodEventTime() {
        return this.generateEventTime(this.mediaPeriodQueueTracker.getCurrentPlayerMediaPeriod());
    }

    private AnalyticsListener.EventTime generatePlayingMediaPeriodEventTime() {
        return this.generateEventTime(this.mediaPeriodQueueTracker.getPlayingMediaPeriod());
    }

    private AnalyticsListener.EventTime generateReadingMediaPeriodEventTime() {
        return this.generateEventTime(this.mediaPeriodQueueTracker.getReadingMediaPeriod());
    }

    private AnalyticsListener.EventTime generateLoadingMediaPeriodEventTime() {
        return this.generateEventTime(this.mediaPeriodQueueTracker.getLoadingMediaPeriod());
    }

    private AnalyticsListener.EventTime generateMediaPeriodEventTime(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
        Assertions.checkNotNull(this.player);
        if (mediaPeriodId != null) {
            boolean isInKnownTimeline = this.mediaPeriodQueueTracker.getMediaPeriodIdTimeline(mediaPeriodId) != null;
            return isInKnownTimeline ? this.generateEventTime(mediaPeriodId) : this.generateEventTime(Timeline.EMPTY, windowIndex, mediaPeriodId);
        }
        Timeline timeline = this.player.getCurrentTimeline();
        boolean windowIsInTimeline = windowIndex < timeline.getWindowCount();
        return this.generateEventTime(windowIsInTimeline ? timeline : Timeline.EMPTY, windowIndex, null);
    }

    private static final class MediaPeriodQueueTracker {
        private final Timeline.Period period;
        private ImmutableList<MediaSource.MediaPeriodId> mediaPeriodQueue;
        private ImmutableMap<MediaSource.MediaPeriodId, Timeline> mediaPeriodTimelines;
        @Nullable
        private MediaSource.MediaPeriodId currentPlayerMediaPeriod;
        private @MonotonicNonNull MediaSource.MediaPeriodId playingMediaPeriod;
        private @MonotonicNonNull MediaSource.MediaPeriodId readingMediaPeriod;

        public MediaPeriodQueueTracker(Timeline.Period period) {
            this.period = period;
            this.mediaPeriodQueue = ImmutableList.of();
            this.mediaPeriodTimelines = ImmutableMap.of();
        }

        @Nullable
        public MediaSource.MediaPeriodId getCurrentPlayerMediaPeriod() {
            return this.currentPlayerMediaPeriod;
        }

        @Nullable
        public MediaSource.MediaPeriodId getPlayingMediaPeriod() {
            return this.playingMediaPeriod;
        }

        @Nullable
        public MediaSource.MediaPeriodId getReadingMediaPeriod() {
            return this.readingMediaPeriod;
        }

        @Nullable
        public MediaSource.MediaPeriodId getLoadingMediaPeriod() {
            return this.mediaPeriodQueue.isEmpty() ? null : (MediaSource.MediaPeriodId)Iterables.getLast(this.mediaPeriodQueue);
        }

        @Nullable
        public Timeline getMediaPeriodIdTimeline(MediaSource.MediaPeriodId mediaPeriodId) {
            return (Timeline)this.mediaPeriodTimelines.get((Object)mediaPeriodId);
        }

        public void onPositionDiscontinuity(Player player) {
            this.currentPlayerMediaPeriod = MediaPeriodQueueTracker.findCurrentPlayerMediaPeriodInQueue(player, this.mediaPeriodQueue, this.playingMediaPeriod, this.period);
        }

        public void onTimelineChanged(Player player) {
            this.currentPlayerMediaPeriod = MediaPeriodQueueTracker.findCurrentPlayerMediaPeriodInQueue(player, this.mediaPeriodQueue, this.playingMediaPeriod, this.period);
            this.updateMediaPeriodTimelines(player.getCurrentTimeline());
        }

        public void onQueueUpdated(List<MediaSource.MediaPeriodId> queue, @Nullable MediaSource.MediaPeriodId readingPeriod, Player player) {
            this.mediaPeriodQueue = ImmutableList.copyOf(queue);
            if (!queue.isEmpty()) {
                this.playingMediaPeriod = queue.get(0);
                this.readingMediaPeriod = Assertions.checkNotNull(readingPeriod);
            }
            if (this.currentPlayerMediaPeriod == null) {
                this.currentPlayerMediaPeriod = MediaPeriodQueueTracker.findCurrentPlayerMediaPeriodInQueue(player, this.mediaPeriodQueue, this.playingMediaPeriod, this.period);
            }
            this.updateMediaPeriodTimelines(player.getCurrentTimeline());
        }

        private void updateMediaPeriodTimelines(Timeline preferredTimeline) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            if (this.mediaPeriodQueue.isEmpty()) {
                this.addTimelineForMediaPeriodId((ImmutableMap.Builder<MediaSource.MediaPeriodId, Timeline>)builder, this.playingMediaPeriod, preferredTimeline);
                if (!Objects.equal((Object)this.readingMediaPeriod, (Object)this.playingMediaPeriod)) {
                    this.addTimelineForMediaPeriodId((ImmutableMap.Builder<MediaSource.MediaPeriodId, Timeline>)builder, this.readingMediaPeriod, preferredTimeline);
                }
                if (!Objects.equal((Object)this.currentPlayerMediaPeriod, (Object)this.playingMediaPeriod) && !Objects.equal((Object)this.currentPlayerMediaPeriod, (Object)this.readingMediaPeriod)) {
                    this.addTimelineForMediaPeriodId((ImmutableMap.Builder<MediaSource.MediaPeriodId, Timeline>)builder, this.currentPlayerMediaPeriod, preferredTimeline);
                }
            } else {
                for (int i = 0; i < this.mediaPeriodQueue.size(); ++i) {
                    this.addTimelineForMediaPeriodId((ImmutableMap.Builder<MediaSource.MediaPeriodId, Timeline>)builder, (MediaSource.MediaPeriodId)this.mediaPeriodQueue.get(i), preferredTimeline);
                }
                if (!this.mediaPeriodQueue.contains((Object)this.currentPlayerMediaPeriod)) {
                    this.addTimelineForMediaPeriodId((ImmutableMap.Builder<MediaSource.MediaPeriodId, Timeline>)builder, this.currentPlayerMediaPeriod, preferredTimeline);
                }
            }
            this.mediaPeriodTimelines = builder.build();
        }

        private void addTimelineForMediaPeriodId(ImmutableMap.Builder<MediaSource.MediaPeriodId, Timeline> mediaPeriodTimelinesBuilder, @Nullable MediaSource.MediaPeriodId mediaPeriodId, Timeline preferredTimeline) {
            if (mediaPeriodId == null) {
                return;
            }
            if (preferredTimeline.getIndexOfPeriod(mediaPeriodId.periodUid) != -1) {
                mediaPeriodTimelinesBuilder.put((Object)mediaPeriodId, (Object)preferredTimeline);
            } else {
                Timeline existingTimeline = (Timeline)this.mediaPeriodTimelines.get((Object)mediaPeriodId);
                if (existingTimeline != null) {
                    mediaPeriodTimelinesBuilder.put((Object)mediaPeriodId, (Object)existingTimeline);
                }
            }
        }

        @Nullable
        private static MediaSource.MediaPeriodId findCurrentPlayerMediaPeriodInQueue(Player player, ImmutableList<MediaSource.MediaPeriodId> mediaPeriodQueue, @Nullable MediaSource.MediaPeriodId playingMediaPeriod, Timeline.Period period) {
            Timeline playerTimeline = player.getCurrentTimeline();
            int playerPeriodIndex = player.getCurrentPeriodIndex();
            Object playerPeriodUid = playerTimeline.isEmpty() ? null : playerTimeline.getUidOfPeriod(playerPeriodIndex);
            int playerNextAdGroupIndex = player.isPlayingAd() || playerTimeline.isEmpty() ? -1 : playerTimeline.getPeriod(playerPeriodIndex, period).getAdGroupIndexAfterPositionUs(C.msToUs(player.getCurrentPosition()) - period.getPositionInWindowUs());
            for (int i = 0; i < mediaPeriodQueue.size(); ++i) {
                MediaSource.MediaPeriodId mediaPeriodId = (MediaSource.MediaPeriodId)mediaPeriodQueue.get(i);
                if (!MediaPeriodQueueTracker.isMatchingMediaPeriod(mediaPeriodId, playerPeriodUid, player.isPlayingAd(), player.getCurrentAdGroupIndex(), player.getCurrentAdIndexInAdGroup(), playerNextAdGroupIndex)) continue;
                return mediaPeriodId;
            }
            if (mediaPeriodQueue.isEmpty() && playingMediaPeriod != null && MediaPeriodQueueTracker.isMatchingMediaPeriod(playingMediaPeriod, playerPeriodUid, player.isPlayingAd(), player.getCurrentAdGroupIndex(), player.getCurrentAdIndexInAdGroup(), playerNextAdGroupIndex)) {
                return playingMediaPeriod;
            }
            return null;
        }

        private static boolean isMatchingMediaPeriod(MediaSource.MediaPeriodId mediaPeriodId, @Nullable Object playerPeriodUid, boolean isPlayingAd, int playerAdGroupIndex, int playerAdIndexInAdGroup, int playerNextAdGroupIndex) {
            if (!mediaPeriodId.periodUid.equals(playerPeriodUid)) {
                return false;
            }
            return isPlayingAd && mediaPeriodId.adGroupIndex == playerAdGroupIndex && mediaPeriodId.adIndexInAdGroup == playerAdIndexInAdGroup || !isPlayingAd && mediaPeriodId.adGroupIndex == -1 && mediaPeriodId.nextAdGroupIndex == playerNextAdGroupIndex;
        }
    }
}

