/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.config.js;

import android.content.Context;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.parser.feed.FeedParser;
import com.akamai.amp.utils.Utils;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsEvaluator {
    private String media;
    private String params;
    private String app;
    private String evalRegex = "/#\\{([^#]*)\\}/g";
    private Pattern SPECIAL_REGEX_CHARS = Pattern.compile("[\"\"]");

    public void startEval() {
    }

    public void finishEval() {
    }

    public String escapeSpecialRegexChars(String str) {
        return this.SPECIAL_REGEX_CHARS.matcher(str).replaceAll("\\\\$0");
    }

    public void createAppJS(Context context) {
        this.app = "var app= {";
        this.app = this.app + this.setValue("name", Utils.getApplicationName(context));
        this.app = this.app + " f:0};";
    }

    public void createParamsJS(Hashtable<String, Object> paramsArray) {
        this.params = "var params= {";
        this.params = this.params + this.setValue("version", "Akamai Android SDK 9.10.7 player");
        this.params = this.params + this.setValue("mode", "Android SDK");
        for (Map.Entry<String, Object> entry : paramsArray.entrySet()) {
            this.params = this.params + this.setValue(entry.getKey().toString(), String.valueOf(paramsArray.get(entry)));
        }
        this.params = this.params + " f:0};";
    }

    public void createMediaJS(MediaResource mediaResource) {
        this.media = "var media= {";
        this.addMediaVal("description", mediaResource.getDescription());
        this.addMediaVal("guid", mediaResource.getGuid());
        this.addMediaVal("poster", mediaResource.getPoster());
        this.addMediaVal("title", mediaResource.getTitle());
        this.addMediaVal("temporalType", mediaResource.getTemporalType());
        this.addMediaVal("category", mediaResource.getCategory());
        this.media = this.media + " f:0};";
    }

    private void addMediaVal(String key, String value) {
        if (value != null) {
            this.media = this.media + this.setValue(key, value);
        }
    }

    private String setValue(String tag, String value) {
        String var = tag + ": \"" + this.escapeSpecialRegexChars(value) + "\", ";
        return var;
    }

    public String evaluate(String raw) {
        return raw;
    }

    public void evalObject(String object) {
    }

    public static boolean containsJSExpression(String value) {
        return value.indexOf("#{") >= 0;
    }

    public static String evaluateVariable(Context context, MediaResource mediaResource, String variable) {
        String sRes = "";
        if (variable.indexOf("#{") >= 0) {
            Pattern p = Pattern.compile("(\\#\\{)(\\D+)(\\})");
            Matcher m = p.matcher(variable);
            StringBuffer result = new StringBuffer();
            while (m.find()) {
                String param = JsEvaluator.evaluateExpression(context, mediaResource, m.group(2));
                m.appendReplacement(result, param);
            }
            m.appendTail(result);
            sRes = result.toString();
        } else {
            sRes = variable;
        }
        return sRes;
    }

    private static String evaluateExpression(Context context, MediaResource mediaResource, String expr) {
        String sRes = null;
        if (expr.startsWith("media.") && mediaResource != null) {
            sRes = expr.startsWith("media.title") ? mediaResource.getTitle() : FeedParser.getStringPropertyByPath(expr, mediaResource);
        } else if (expr.startsWith("player.mode")) {
            sRes = "Android SDK";
        } else if (expr.startsWith("player.version")) {
            sRes = "Akamai Android SDK 9.10.7 player";
        } else if (expr.startsWith("app.name")) {
            sRes = Utils.getApplicationName(context);
        }
        if (sRes == null) {
            sRes = expr;
        }
        return sRes;
    }
}

