package com.akamai.analytics.akamaimedia;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.WindowManager;
import android.widget.ProgressBar;

import com.akamai.amp.analytics.akamaimedia.AmpAkamaiMediaAnalyticsTracker;
import com.akamai.amp.analytics.akamaimedia.MediaAnalytics;
import com.akamai.amp.config.data.MediaAnalyticsData;
import com.akamai.amp.media.VideoPlayerContainer;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.media.errors.ErrorType;
import com.akamai.amp.uimobile.generic.media.PlayerControlsOverlay;

import java.util.HashMap;
import java.util.Map;


public class MainActivity extends Activity
        implements VideoPlayerContainer.VideoPlayerContainerCallback {

    private static final String LOG_TAG = "AMPv6";

    private static final String STREAM_URL = "http://devimages.apple.com/iphone/samples/bipbop/bipbopall.m3u8";
    //private static final String STREAM_URL = "https://cmafref.akamaized.net/cmaf/live/2003074/akamai/master.m3u8";

    private static final String MEDIA_ANALYTICS_CONFIG_URL = "http://ma1-r.analytics.edgesuite.net/config/beacon-3018.xml?setVideoObject=1";

    private VideoPlayerContainer playerContainer;
    private VideoPlayerView playerView;
    private ProgressBar progressBar;
    private PlayerControlsOverlay mPlayerControlsOverlay;

    private AmpAkamaiMediaAnalyticsTracker mediaAnalyticsTracker;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
        progressBar = findViewById(R.id.progressBar);
        playerContainer = findViewById(R.id.playerViewCtrl);
        mPlayerControlsOverlay = (PlayerControlsOverlay) findViewById(R.id.playerControls);
        setInlineUI();
        playerContainer.addVideoPlayerContainerCallback(this);
        playerContainer.setApiKey("demo");
        playerContainer.prepareResource(STREAM_URL);
    }

    @Override
    public void onResourceReady(MediaResource mediaResource) {
        playerView = playerContainer.getVideoPlayer();
        mPlayerControlsOverlay.setVideoPlayerContainer(playerContainer);
        playerView.setProgressBarControl(progressBar);
        playerView.setLogEnabled(true);
        playerView.setFullScreen(true);
        playerView.setFullScreenMode(VideoPlayerView.FULLSCREEN_MODE_KEEP_ASPECT_RATIO);

        mediaAnalyticsTracker = MediaAnalytics.create(playerView, buildMediaAnalyticsData());

        playerView.play(mediaResource);
    }

    private MediaAnalyticsData buildMediaAnalyticsData() {
        MediaAnalyticsData data = new MediaAnalyticsData();
        data.setMediaAnalyticsBeacon(MEDIA_ANALYTICS_CONFIG_URL);
        data.setMediaAnalyticsDimensions(buildCustomDimensions());
        return data;
    }

    private Map<String,String> buildCustomDimensions() {
        Map<String, String> customDimensions = new HashMap<>();
        customDimensions.put("test", "customDimension");
        customDimensions.put("another", "customDimension2");
        customDimensions.put("playerId", "playerId-pd");
        customDimensions.put("eventName", "eventName-en");
        customDimensions.put("title", "title-tt");
        customDimensions.put("show", "show-sh");
        customDimensions.put("category", "category-cg");
        customDimensions.put("subCategory", "subcategory-sc");
        customDimensions.put("contentLength", "contentlength-cl");
        customDimensions.put("device", "device-sa");

        return customDimensions;
    }

    @Override
    public void onVideoPlayerCreated() {
        Log.i(LOG_TAG, "onVideoPlayerCreated()");
    }

    @Override
    public void onResourceError(ErrorType errorType, Exception exception) {
        Log.e(LOG_TAG, "onResourceError() " + exception);
    }

    private void setInlineUI() {
        mPlayerControlsOverlay.overrideControlsLayout(R.layout.overlay_controls);
        mPlayerControlsOverlay.setShowControlsAtStart(false);
        setupInlinePlayerControls();
    }

    private void setupInlinePlayerControls() {
        mPlayerControlsOverlay.managePlayPause(R.id.androidsdk_playPauseCtrl,
                R.drawable.play,
                R.drawable.pause);
        mPlayerControlsOverlay.manageCurrentPosition(R.id.androidsdk_seekbarTextCtrl);
        mPlayerControlsOverlay.manageTimeRemaining(R.id.video_duration);
        mPlayerControlsOverlay.manageScrubbing(R.id.androidsdk_seekbarCtrl,
                R.id.androidsdk_seekToLiveAction);
    }


    //It's mandatory to let the SDK know when the app goes and comes to the background

    @Override
    protected void onPause() {
        Log.d(LOG_TAG, "onPause");
        if (playerView != null) playerView.onPause();
        super.onPause();
    }

    @Override
    protected void onResume() {
        Log.d(LOG_TAG, "onResume");
        if (playerView != null) playerView.onResume();
        super.onResume();
    }

    @Override
    protected void onDestroy() {
        Log.d(LOG_TAG, "onDestroy");
        if (playerView != null) playerView.onDestroy();
        super.onDestroy();
    }

}
