package com.akamai.amp.data.scte35;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.WindowManager;
import android.widget.ProgressBar;

import com.akamai.amp.media.VideoPlayerContainer;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.elements.AMPLibraryInfo;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.media.errors.ErrorType;


public class MainActivity extends Activity {

    private final static String TAG = "AMP-SCTE35-Sample";
    private final static String VIDEO_URL = "https://livesim2.dashif.org/livesim2/scte35_2/testpic_2s/Manifest.mpd";

    private VideoPlayerContainer mVideoContainer;
    private VideoPlayerView mVideoView;
    private ProgressBar mProgressBar;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
        mProgressBar = findViewById(R.id.progressBar);
        mVideoContainer = findViewById(R.id.playerViewCtrl);

        mVideoContainer.addVideoPlayerContainerCallback(createVideoPlayerCallback());
        mVideoContainer.setApiKey("demo");
        mVideoContainer.prepareResource(VIDEO_URL);
    }

    private VideoPlayerContainer.VideoPlayerContainerCallback createVideoPlayerCallback() {
        return new VideoPlayerContainer.VideoPlayerContainerCallback() {
            @Override
            public void onVideoPlayerCreated() {
                String versionMsg = "AMP v" + AMPLibraryInfo.VERSION + " using SCTE-35 module v" + AmpScte35Manager.VERSION;
                Log.i(TAG, versionMsg);
            }

            @Override
            public void onResourceReady(MediaResource mediaResource) {
                mVideoView = mVideoContainer.getVideoPlayer();
                mVideoView.setProgressBarControl(mProgressBar);
                mVideoView.setFullScreenMode(VideoPlayerView.FULLSCREEN_MODE_KEEP_ASPECT_RATIO_FIT_SCREEN);
                mVideoView.setLogEnabled(true);

                AmpScte35Manager.of(mVideoView, createScteListener());

                mVideoView.play(mediaResource);
            }

            @Override
            public void onResourceError(ErrorType errorType, Exception exception) {
                Log.e(TAG, "onResourceError()");
            }
        };
    }

    private ScteEventsListener createScteListener() {
        return new ScteEventsListener() {
            @Override
            public void onOatclsScte35(String uri, String scte) {
                Log.i(TAG, "onOatclsScte35() " + uri + " -> Scte: " + scte);
            }

            @Override
            public void onCueOut(String uri, float duration) {
                Log.i(TAG, "onCueOut() " + uri + " -> Duration: " + duration);
            }

            @Override
            public void onCueOutCont(String uri, float elapsedTime, float duration) {
                Log.i(TAG, "onCueOutCont() " + uri + " ElapsedTime: -> " + elapsedTime + " Duration: " + duration);
            }

            @Override
            public void onCueIn(String uri) {
                Log.i(TAG, "onCueIn() " + uri);
            }
        };
    }

}
