package com.akamai.amp.demo;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.widget.Toast;

import com.akamai.amp.AmpPlayer;
import com.akamai.amp.ads.ima.AmpIMAManager;
import com.akamai.amp.ads.ima.IMA;
import com.akamai.amp.analytics.adobeheartbeat.AdobeHeartbeat;
import com.akamai.amp.analytics.adobeheartbeat.AmpAdobeHeartbeatAnalyticsTracker;
import com.akamai.amp.analytics.firebase.AmpFirebaseAnalyticsTracker;
import com.akamai.amp.analytics.firebase.FireBase;
import com.akamai.amp.analytics.nielsenanalytics.AmpNielsenDcrAnalyticsTracker;
import com.akamai.amp.analytics.nielsenanalytics.NielsenDcr;
import com.akamai.amp.demo.helpers.analytics.FirebaseHelper;
import com.akamai.amp.demo.helpers.analytics.HeartbeatHelper;
import com.akamai.amp.demo.helpers.analytics.NielsenHelper;
import com.akamai.amp.uimobile.generic.listeners.IMediaPlayerControllerListener;

import static com.akamai.amp.AmpPlayerControlsOverlay.Mode;
import static com.akamai.amp.AmpPlayerControlsOverlay.State;


public class MainActivity extends Activity {

    private static final String HLS_VOD = "https://media-demo-host.akamaized.net/test/video/kluge/hls/all.m3u8";
    private static final String HLS_LIVE = "http://multiformatlive-f.akamaihd.net/i/demostream_1@2131/master.m3u8";
    private static final String ADS_URL = "https://pubads.g.doubleclick.net/gampad/ads?sz=640x480&iu=/124319096/external/single_ad_samples&ciu_szs=300x250&impl=s&gdfp_req=1&env=vp&output=vast&unviewed_position_start=1&cust_params=deployment%3Ddevsite%26sample_ct%3Dlinear&correlator=";

    private AmpPlayer amp;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        // AMP's main class instantiation
        amp = findViewById(R.id.amp);
        amp.configure("demo",this, customButtonsCallback());

        /*
        Parameter 1: defines the initial player overlay state
        State.INLINE_PLAYER or State.FULLSCREEN_PLAYER

        Parameter 2: initial Controls mode
        Mode.INLINE, Mode.EMBEDDED or Mode.CONTENT_LIST

        Parameter 3: determines if the player must rotate when the device's orientation changes

        Parameter 4: determines if the player must start on mini-player mode
        */
        amp.configureVisually(State.INLINE_PLAYER, Mode.INLINE, true, true);

        // Ad Provider
        AmpIMAManager imaAds = IMA.create(this).buildClientSideManager();
        imaAds.setLoadVideoTimeout(30000);

        // Analytics
        AmpAdobeHeartbeatAnalyticsTracker heartbeatAnalytics = AdobeHeartbeat.create(HeartbeatHelper.buildData());
        AmpNielsenDcrAnalyticsTracker nielsenAnalytics = NielsenDcr.create(NielsenHelper.buildData());
        AmpFirebaseAnalyticsTracker firebaseAnalytics = FireBase.create(FirebaseHelper.buildData());

        // Plugins integration
        //amp.setPlugins(imaAds, heartbeatAnalytics, nielsenAnalytics, firebaseAnalytics);
        amp.setPlugins(imaAds, firebaseAnalytics);

        amp.prepare().withClientSideIMA(ADS_URL).withStream(HLS_VOD).init();
    }

    @Override
    public void onResume() {
        if (amp != null) amp.onResume();
        super.onResume();
    }

    @Override
    public void onPause() {
        if (amp != null) amp.onPause();
        super.onPause();
    }

    @Override
    protected void onDestroy() {
        if (amp != null) amp.onDestroy();
        super.onDestroy();
    }

    private IMediaPlayerControllerListener customButtonsCallback() {
        return buttonId -> {
            switch (buttonId) {
                case IMediaPlayerControllerListener.MEDIAPLAYERCONTROLLER_BUTTON_CLOSE:
                    showToast("CLOSE");
                    break;
                case IMediaPlayerControllerListener.MEDIAPLAYERCONTROLLER_BUTTON_SHARE:
                    showToast("SHARE");
                    break;
                default:
                    break;
            }
        };
    }

    private void showToast(String message) {
        Context context = getApplication().getApplicationContext();
        Toast.makeText(context, message, Toast.LENGTH_LONG).show();
    }

}
