package com.akamai.ampdemo;

import android.app.Activity;
import android.os.Bundle;
import android.view.WindowManager;

import com.akamai.amp.media.VideoPlayerContainer;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.elements.AMPLibraryInfo;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.media.errors.ErrorType;
import com.akamai.amp.media.exowrapper2.drm.DrmScheme;
import com.akamai.amp.utils.LogManager;

import java.util.HashMap;
import java.util.Map;

public class MainActivity extends Activity
        implements VideoPlayerContainer.VideoPlayerContainerCallback {

    private final static String LOG_TAG = AMPLibraryInfo.NAME;

    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BEARER_TOKEN = "YOUR_TOKEN_HERE";

    private final static String WIDEVINE_VIDEO_URL = "https://storage.googleapis.com/shaka-demo-assets/angel-one-widevine-hls/hls.m3u8";
    private static final String WIDEVINE_LICENSE_URL = "https://cwip-shaka-proxy.appspot.com/no_auth";

    private static final String PLAYREADY_VIDEO_URL = "https://playready.directtaps.net/smoothstreaming/SSWSS720H264PR/SuperSpeedway_720.ism/Manifest";
    private static final String PLAYREADY_LICENSE_URL = "https://playready.directtaps.net/pr/svc/rightsmanager.asmx";


    private VideoPlayerContainer videoPlayerContainer;
    private VideoPlayerView videoPlayerView;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);

        videoPlayerContainer = findViewById(R.id.playerViewCtrl);
        videoPlayerContainer.addVideoPlayerContainerCallback(this);
        //videoPlayerContainer.setApiKey("demo");

        addDrmLicenseRequestHeaders();

        // Set DRM Security Level with Fixed DrmHandler L1/L3 Value.
        //videoPlayerContainer.setDRMSecurityLevel(DrmHandler.L3);

        videoPlayerContainer.prepareResource(WIDEVINE_VIDEO_URL, DrmScheme.WIDEVINE, WIDEVINE_LICENSE_URL);
        //videoPlayerContainer.prepareResource(PLAYREADY_VIDEO_URL, DrmScheme.PLAYREADY, PLAYREADY_LICENSE_URL);
    }

    private void addDrmLicenseRequestHeaders() {
        Map<String, String> headers = new HashMap<>();
        headers.put("TestDrmLicenseHeader","TestValue-DRM-HEADER");
        headers.put(AUTHORIZATION_HEADER,"Bearer " + BEARER_TOKEN);
        videoPlayerContainer.setDrmLicenseRequestHeaders(headers);
    }

    @Override
    public void onResourceReady(MediaResource mediaResource) {
        videoPlayerView = videoPlayerContainer.getVideoPlayer();
        videoPlayerView.setLogEnabled(true);
        videoPlayerView.setLicense("vk7AP7OWCt-3MFboJDu5NBBzaiwTM722rDgkPADOeAPM7Q-eGHlWNMRvBcovOZphR6_o8sgYeethhgN2wes8bQ==");

        videoPlayerView.play(mediaResource);
    }

    @Override
    public void onVideoPlayerCreated() {
        LogManager.log(LOG_TAG, "onVideoPlayerCreated()");
    }

    @Override
    public void onResourceError(ErrorType errorType, Exception exception) {
        LogManager.error(LOG_TAG, "onResourceError() " + exception);
    }

    @Override
    protected void onResume() {
        LogManager.log(LOG_TAG, "onResume");
        if (videoPlayerView != null) videoPlayerView.onResume();
        super.onResume();
    }

    @Override
    protected void onPause() {
        LogManager.log(LOG_TAG, "onPause");
        if (videoPlayerView != null) videoPlayerView.onPause();
        super.onPause();
    }

    @Override
    protected void onDestroy() {
        LogManager.log(LOG_TAG, "onDestroy");
        if (videoPlayerView != null) videoPlayerView.onDestroy();
        super.onDestroy();
    }

}
