/*
 * Copyright (C) 2016 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.akamai.downloader.sample;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;

import com.akamai.amp.AmpPlayer;
import com.akamai.amp.exoplayer2.MediaItem;
import com.akamai.amp.media.exowrapper2.ExoTags;
import com.akamai.amp.media.exowrapper2.drm.DrmScheme;

import java.util.List;
import java.util.UUID;

/** An activity that plays media using AMP*/
public class PlayerActivity extends Activity {

  private AmpPlayer amp;

  @Override
  public void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    setContentView(R.layout.player_activity);

    String streamUrl = getStreamUrlFromIntent();
    if (streamUrl == null) return;

    Intent intent = getIntent();
    List<MediaItem> mediaItems =  SampleIntentUtil.createMediaItemsFromIntent(intent);
    MediaItem mediaItem = mediaItems.get(0);
    amp = findViewById(R.id.player_view);
    amp.configure(this);
    amp.setDownloadRequestProvider(SampleApplication.ampDownloadManager);
    String extension = getStreamUrlExtensionFromIntent();

    if(mediaItem.playbackProperties.drmConfiguration != null){
      DrmScheme drmScheme;
      UUID uuid = mediaItem.playbackProperties.drmConfiguration.uuid;
      if(DrmScheme.WIDEVINE.getUuid().equals(uuid)){
        drmScheme = DrmScheme.WIDEVINE;
      } else if(DrmScheme.CLEARKEY.getUuid().equals(uuid)){
        drmScheme = DrmScheme.CLEARKEY;
      } else {
        drmScheme = DrmScheme.PLAYREADY;
      }
      amp.prepare().withStream(mediaItem.playbackProperties.uri.toString()).withDRM(drmScheme,
              mediaItem.playbackProperties.drmConfiguration.licenseUri.toString()).init();
    } else {
      amp.prepare().withStream(mediaItem.playbackProperties.uri.toString()).init();
    }

  }

  private String getStreamUrlFromIntent() {
      Intent intent = getIntent();
      String action = intent.getAction();
      if (ExoTags.ACTION_VIEW.equals(action)) {
        return String.valueOf(intent.getData());
      } else if (ExoTags.ACTION_VIEW_LIST.equals(action)) {
        String[] uriStrings = intent.getStringArrayExtra(ExoTags.URI_LIST_EXTRA);
        return uriStrings[0];
      }
      return null;
  }

  private String getStreamUrlExtensionFromIntent() {
    Intent intent = getIntent();
    String action = intent.getAction();
    if (ExoTags.ACTION_VIEW.equals(action)) {
        return intent.getStringExtra(ExoTags.EXTENSION_EXTRA);
    }
    return null;
  }

  @Override
  public void onResume() {
    if (amp != null) amp.onResume();
    super.onResume();
  }

  @Override
  public void onPause() {
    if (amp != null) amp.onPause();
    super.onPause();
  }

  @Override
  public void onDestroy() {
    if (amp != null) {
      amp.stop();
      amp.onDestroy();
    }

    super.onDestroy();
  }
}
