package com.akamai.downloader.sample;

import android.app.Fragment;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.Nullable;

public class LoadingFragment extends Fragment {

    public static String DESCRIPTION_KEY = "description";

    TextView loadingText;

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.fragment_loading, container, false);
        loadingText = v.findViewById(R.id.text_loading);
        loadArgs();
        return v;
    }

    private void loadArgs() {
        if (getArguments() != null && getArguments().containsKey(DESCRIPTION_KEY)) {
            CharSequence description = getArguments().getCharSequence(DESCRIPTION_KEY);
            loadingText.setText(description);
        }
    }

}
