package com.akamai.ampfreewheelsample;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.WindowManager;

import com.akamai.amp.ads.AdsCount;
import com.akamai.amp.ads.AdsInfo;
import com.akamai.amp.ads.IAdsComponentListener;
import com.akamai.amp.ads.freewheel.AmpFreewheelManager;
import com.akamai.amp.ads.freewheel.Freewheel;
import com.akamai.amp.bidder.aps.AmazonBidder;
import com.akamai.amp.bidder.aps.AmpBidderManager;
import com.akamai.amp.media.VideoPlayerContainer;
import com.akamai.amp.media.VideoPlayerContainer.VideoPlayerContainerCallback;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.media.errors.ErrorType;
import com.akamai.amp.uimobile.generic.media.PlayerControlsOverlay;
import com.akamai.amp.utils.Utils;

import java.util.Arrays;


public class FreeWheelActivity extends Activity
        implements VideoPlayerContainerCallback, IAdsComponentListener {

    private static final String TAG = FreeWheelActivity.class.getName();
    private PlayerControlsOverlay mPlayerControlsOverlay;

    public static final String STREAM = "https://welcomevideo.akamaized.net/delivery/1f/07/1f0756a1-f54b-4e22-adbc-8c68680532ea/tom-intro-for-new-customers-v26b238090-d41d-336d-4347-3dac7fc07f0e.m3u8";


    //Freewheel Ads constants, reach out to your Freewheel representative to get these values
    public static String FW_ADS_URL = "http://demo.v.fwmrm.net/";
    public static int FW_NETWORK_ID = 42015;
    // Request parameters — these may change from request to request
    // depending on how your content is arranged in the MRM system
    public static String FW_PROFILE = "android_demo_since_5.13";
    public static String FW_SITE_SECTION_ID = "android_allinone_demo_site_section";
    public static String FW_VIDEO_ASSET_ID = "android_allinone_demo_video";

    //Amazon Publisher Services constants, reach out to your Amazon representative to get these values
    private static final String APS_APP_ID = "uuid123sample";
    private static final long APS_TIME_OUT_MILLIS = 1000L;
    private static final boolean APS_TEST_FLAG = true;
    private static final String APS_AD_BREAK_ID_22_MINS = "ad-break-identifier-22";
    private static final String APS_AD_BREAK_ID_42_MINS = "ad-break-identifier-42";
    private static final String APS_AD_BREAK_ID_MOVIE = "ad-break-identifier-movie";



    private VideoPlayerContainer videoPlayerContainer;
    private VideoPlayerView videoPlayerView;
    private AmpFreewheelManager ampFreewheelManager;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        Log.i(TAG,"onCreate");

        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);

        videoPlayerContainer = findViewById(R.id.videoContainer);
        videoPlayerContainer.addVideoPlayerContainerCallback(this);

        mPlayerControlsOverlay = findViewById(R.id.playerControls);
        setInlineUI();

        ampFreewheelManager = Freewheel.create(this, FW_NETWORK_ID, FW_ADS_URL,
                FW_SITE_SECTION_ID, FW_VIDEO_ASSET_ID, FW_PROFILE);
        ampFreewheelManager.addEventsListener(this);
        ampFreewheelManager.setVideoPlayerContainer(videoPlayerContainer);

        videoPlayerContainer.setApiKey("demo");
        videoPlayerContainer.prepareResource(STREAM);
    }

    private void setInlineUI() {
        mPlayerControlsOverlay.overrideControlsLayout(R.layout.overlay_controls);
        mPlayerControlsOverlay.setShowControlsAtStart(false);
        setupInlinePlayerControls();
    }

    private void setupInlinePlayerControls() {
        mPlayerControlsOverlay.managePlayPause(R.id.androidsdk_playPauseCtrl,
                R.mipmap.play,
                R.mipmap.pause);
        mPlayerControlsOverlay.manageCurrentPosition(R.id.androidsdk_seekbarTextCtrl);
        mPlayerControlsOverlay.manageTimeRemaining(R.id.video_duration);
        mPlayerControlsOverlay.manageScrubbing(R.id.androidsdk_seekbarCtrl,
                R.id.androidsdk_seekToLiveAction);
    }


    @Override
    public void onResourceReady(MediaResource mediaResource) {
        Log.i(TAG,"onResourceReady");
        videoPlayerView = videoPlayerContainer.getVideoPlayer();
        mPlayerControlsOverlay.setVideoPlayerContainer(videoPlayerContainer);
        videoPlayerView.setLogEnabled(true);
        ampFreewheelManager.setVideoPlayerView(videoPlayerView);
        ampFreewheelManager.addEventsListener(mPlayerControlsOverlay.getAdsComponentListener());
        checkAps(mediaResource);

        videoPlayerView.play(mediaResource);
    }

    private void checkAps(MediaResource mediaResource) {
        if (!Utils.isFireTV(this)) return;

        setApsData(mediaResource);
        AmpBidderManager apsBidder = AmazonBidder.create(ampFreewheelManager.getBidderCallback(), this, APS_APP_ID, APS_TIME_OUT_MILLIS, APS_TEST_FLAG);
        apsBidder.requestBids(mediaResource, APS_AD_BREAK_ID_22_MINS);
    }

    private void setApsData(MediaResource mediaResource) {
        mediaResource.setGuid("abc123");
        mediaResource.setRating("TV-Y");
        mediaResource.setGenres(Arrays.asList("Action", "Adventure"));
        mediaResource.setChannel("My APS Channel");
        mediaResource.setDuration(3600);
    }

    @Override
    public void onVideoPlayerCreated() {
        Log.i(TAG,"onVideoPlayerCreated");
    }

    @Override
    public void onResourceError(ErrorType errorType, Exception exception) {
        Log.e(TAG,"onResourceError " + exception);
    }

    @Override
    protected void onResume(){
        Log.i(TAG, "onResume");
        ampFreewheelManager.onResume();
        if(videoPlayerView != null) {
            videoPlayerView.onResume();
        }
        super.onResume();
    }

    @Override
    protected void onPause() {
        Log.i(TAG,"onPause");
        ampFreewheelManager.onPause();
        if(videoPlayerView != null){
            videoPlayerView.onPause();
        }
        super.onPause();
    }

    @Override
    protected void onStop() {
        Log.i(TAG,"onStop");
        super.onStop();
        ampFreewheelManager.onStop();
    }

    @Override
    protected void onDestroy() {
        Log.i(TAG,"onDestroy");
        super.onDestroy();
        videoPlayerView.onDestroy();
        ampFreewheelManager.onDestroy();
    }

    @Override
    protected void onStart() {
        Log.i(TAG,"onStart");
        super.onStart();
        ampFreewheelManager.onStart();
    }

    @Override
    protected void onRestart() {
        Log.i(TAG,"onRestart");
        super.onRestart();
        ampFreewheelManager.onRestart();
    }


    // IAdsComponentListener

    @Override
    public void onAdsStarted(AdsInfo adsInfo) {
        Log.i(TAG,"onAdsStarted " + adsInfo);
    }

    @Override
    public void onAdsEnded() {
        Log.i(TAG,"onAdsEnded");
    }

    @Override
    public void onAllPostrollsEnded() {
        Log.i(TAG,"onAllPostrollsEnded");
    }

    @Override
    public void onAdBreakStarted(){
        Log.i(TAG,"onAdBreakStarted");
    }

    @Override
    public void onAdBreakEnded(){
        Log.i(TAG,"onAdBreakEnded");
    }

    @Override
    public void onListenerRegistered() {
        Log.i(TAG,"onListenerRegistered");
    }

    @Override
    public void onAdsInitialized() {
        Log.i(TAG,"onAdsInitialized");
    }

    @Override
    public void onAdRequest() {
        Log.i(TAG,"onAdRequest");
    }

    @Override
    public void onAdsLoaded(AdsCount adsCount) {
        Log.i(TAG,"onAdsLoaded " + adsCount);
    }

    @Override
    public void onAdsTrackProgress(int i) {
        Log.i(TAG,"onAdsTrackProgress " + i);
    }

    @Override
    public void onAdsPlayheadUpdate(int i) {
        Log.i(TAG,"onAdsPlayheadUpdate " + i);
    }

    @Override
    public void onAdEvent() {
        Log.i(TAG,"onAdEvent ");}

    @Override
    public void onAdBufferingStarted() {
        Log.i(TAG,"onAdBufferingStarted");
    }

    @Override
    public void onAdBufferingEnded() {
        Log.i(TAG,"onAdBufferingEnded");
    }

    @Override
    public void onAdsError(String errorMessage) {
        Log.i(TAG,"onAdsError " + errorMessage);
    }

    @Override
    public void onPauseContentRequested() {
        Log.i(TAG, "onPauseContentRequested");
    }

    @Override
    public void onResumeContentRequested() {
        Log.i(TAG, "onResumeContentRequested");
    }

    @Override
    public void onAdsPaused() {
        Log.i(TAG,"onAdsPaused");
    }

    @Override
    public void onAdsResumed() {
        Log.i(TAG,"onAdsResumed");
    }

    @Override
    public void onAdsTapped() {Log.i(TAG,"onAdsTapped");}

    @Override
    public void onAdSkipped() {Log.i(TAG,"onAdSkipped");}

}
