package com.akamai.ampaudiodemo;

import android.app.Activity;
import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.widget.Toast;

import com.akamai.amp.media.IPlayerEventsListener;
import com.akamai.amp.media.VideoPlayerContainer;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.media.errors.ErrorType;

public class AudioService extends Service implements IPlayerEventsListener {


    public VideoPlayerView mVideoView;
    public VideoPlayerContainer mVideoContainer;
    private final IBinder iBinder = new LocalBinder();
    private String poster;

    public static boolean isRunning = false;

    @Override
    public IBinder onBind(Intent arg0) {
        return iBinder;
    }

    public void onCreate(){
        super.onCreate();
    }

    public void setActivity(Activity activity){
        mVideoContainer = (VideoPlayerContainer) activity.findViewById(R.id.container);
    }

    public int onStartCommand(android.content.Intent intent, int flags, int startId) {
        if(mVideoView != null && isRunning){
            mVideoView.stop();
        }

        String url = intent.getStringExtra("URL");
        poster = intent.getStringExtra("IMG");
        Toast.makeText(getApplicationContext(), "Playing: " + url, Toast.LENGTH_SHORT).show();
        mVideoContainer.addVideoPlayerContainerCallback(createCallback());
        mVideoContainer.setApiKey("demo");
        mVideoContainer.prepareResource(url);
        return Service.START_NOT_STICKY;
    }



    private VideoPlayerContainer.VideoPlayerContainerCallback createCallback() {
        return new VideoPlayerContainer.VideoPlayerContainerCallback() {
            @Override
            public void onVideoPlayerCreated() {}

            @Override
            public void onResourceReady(MediaResource mediaResource) {
                mVideoContainer.loadPoster(poster);
                mVideoView =  mVideoContainer.getAudioPlayer();
                mVideoView.addEventsListener(AudioService.this);
                mVideoView.enableDVRfeatures(false);
                mVideoView.playAudio(mediaResource);
                mVideoView.resume();
                isRunning = true;
            }

            @Override
            public void onResourceError(ErrorType errorType, Exception exception)
            {}
        };
    }

    public void onDestroy(){

        super.onDestroy();
        if(mVideoView != null){
            mVideoView.stop();
            mVideoView.onDestroy();
        }
        isRunning = false;
    }

    @Override
    public boolean onPlayerEvent(int iInEventType) {
        return true;
    }

    @Override
    public boolean onPlayerExtendedEvent(int iInEventType, int arg1, int arg2) {
        return true;
    }

    /**
     * Class used for the client Binder.  Because we know this service always
     * runs in the same process as its clients, we don't need to deal with IPC.
     */
    public class LocalBinder extends Binder{
        AudioService getService(){
            return AudioService.this;
        }
    }

}
