package com.akamai.ampdemo;

import android.app.ProgressDialog;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings.LayoutAlgorithm;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;

public class OptOutActivity extends MasterActivity
{
	private final String TAG = OptOutActivity.class.getSimpleName();

	private Button pgBack, pgClose;

	private WebView mWebView;

	private ProgressDialog dialog;

	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.opt_out);
		try
		{
			pgBack = (Button) findViewById(R.id.btnOptOutBack);
			pgBack.setOnClickListener(new OnClickListener()
			{
				public void onClick(View v)
				{
					bailOut(null);
				}
			});

			pgClose = (Button) findViewById(R.id.btnOptOutClose);
			pgClose.setOnClickListener(new OnClickListener()
			{
				public void onClick(View v)
				{
					bailOut("closeAll");
				}
			});

			final Bundle extras = getIntent().getExtras();

			String url = extras.getString(Global.keyWebUrl);
			mWebView = (WebView) findViewById(R.id.webView);
			mWebView.getSettings().setJavaScriptEnabled(true);

			// Handle webview scaling
			mWebView.setInitialScale(1);
			mWebView.getSettings().setBuiltInZoomControls(true);
			mWebView.getSettings().setSupportZoom(true);
			mWebView.getSettings().setDisplayZoomControls(false);
			mWebView.getSettings().setLoadWithOverviewMode(true);
			mWebView.getSettings().setUseWideViewPort(true);
			mWebView.getSettings().setLayoutAlgorithm(LayoutAlgorithm.NORMAL);
			mWebView.setWebViewClient(new MonitorWebView());
			mWebView.setWebChromeClient(new WebChromeClient());

			Log.d("WEB", "Launching: " + url);
			mWebView.loadUrl(url);
		}
		catch (NullPointerException e)
		{
			e.printStackTrace();
		}
	}

	private void bailOut(String val)
	{
		Intent i = new Intent();
		i.putExtra(Global.keyOptResult, val);
		setResult(RESULT_OK, i);
		finish();
	}

	private class MonitorWebView extends WebViewClient
	{

		public void onPageFinished(WebView view, String url)
		{
			Log.d(TAG, "FINISHED LOADING: " + url);
			cancelDialog();
		};

		public void cancelDialog()
		{
			if (dialog != null)
			{
				dialog.cancel();
				dialog = null;
			}
		}

		@Override
		public boolean shouldOverrideUrlLoading(WebView view, String url)
		{
			Log.d(TAG, "shouldOverrideUrlLoading: " + url);

			if (url != null && url.indexOf("nielsen") == 0)
			{
				bailOut(url); // send URL value app SDK
				return false;
			}
			else if (url == null)
			{
				dialog = ProgressDialog.show(OptOutActivity.this, "OptOut", "Loading...");
				return true;
			}
			else
			{
				return false; // let Webview handle all the other URLs
			}
		}
	}

	public void onBackPressed()
	{
		bailOut(null);
	}

}
