package com.akamai.ampdemo;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListView;

import java.util.ArrayList;
import java.util.List;


public class MainActivity extends Activity {

    private static final String NIELSEN_VOD_HLS = "http://www.nielseninternet.com/BBB/prog_index.m3u8";
    private static final String NIELSEN_LIVE_HLS = "http://www.nielseninternet.com/NielsenLiveTest/prog_index.m3u8";
    //private static final String NIELSEN_DTVR_HLS = "http://nielsense-assets.s3.amazonaws.com/id3/001/prog_index.m3u8";

    private static final String PUBLIC_VOD_HLS = "http://nobelvod-vh.akamaihd.net/i/flashcontent/acceptance_1964_pea_king_01_,128,296,396,496,.mp4.csmil/master.m3u8";
    private static final String PUBLIC_LIVE_HLS = "http://multiformatlive-f.akamaihd.net/i/demostream_1@2131/master.m3u8";

    private static final String PREROLL_ADS_URL = "https://pubads.g.doubleclick.net/gampad/ads?sz=640x480&iu=/124319096/external/ad_rule_samples&ciu_szs=300x250&ad_rule=1&impl=s&gdfp_req=1&env=vp&output=vmap&unviewed_position_start=1&cust_params=deployment%3Ddevsite%26sample_ar%3Dpreonly&cmsid=496&vid=short_onecue&correlator=";
    private static final String PREROLL_MIDROLL_ADS_URL = "https://pubads.g.doubleclick.net/gampad/ads?sz=640x480&iu=/124319096/external/ad_rule_samples&ciu_szs=300x250&ad_rule=1&impl=s&gdfp_req=1&env=vp&output=vmap&unviewed_position_start=1&cust_params=deployment%3Ddevsite%26sample_ar%3Dpremidpost&cmsid=496&vid=short_onecue&correlator=";


    private ArrayList<Video> videos;
    private PlaylistAdapter adapter;
    private ListView listView;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        listView = (ListView) findViewById(R.id.playlist);
        createPlaylist();
        adapter = new PlaylistAdapter(this, videos);
        listView.setAdapter(adapter);
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Intent intent = new Intent(MainActivity.this, PlayerActivity.class);
                intent.putExtra("videoSelected", adapter.getItem(i));
                startActivity(intent);
            }
        });
    }

    private void createPlaylist() {
        videos = new ArrayList<>();
        addNielsenVideos(videos);
    }

    private void addPublicVideos(List<Video> videos) {
        videos.add(new Video("VOD Short Film", "12:15", PUBLIC_VOD_HLS, null, R.drawable.dream));
        videos.add(new Video("Live HLS Stream", "∞", PUBLIC_LIVE_HLS, null, R.drawable.live));
        videos.add(new Video("Pre-roll ads", "9:54", PUBLIC_VOD_HLS, PREROLL_ADS_URL, R.drawable.pre));
        videos.add(new Video("Pre-roll and mid-roll ads", "9:54", PUBLIC_VOD_HLS, PREROLL_MIDROLL_ADS_URL, R.drawable.mid));
    }

    private void addNielsenVideos(List<Video> videos) {
        //videos.add(new Video("DTVR HLS", "6:57", NIELSEN_DTVR_HLS, NIELSEN_CONFIG, null, R.drawable.logo));
        videos.add(new Video("VOD Short Film", "12:15", NIELSEN_VOD_HLS, null, R.drawable.bbb));
        videos.add(new Video("Live HLS Stream", "∞", NIELSEN_LIVE_HLS, null, R.drawable.live));

        //videos.add(new Video("Pre-roll ads", "9:54", NIELSEN_VOD_HLS, PREROLL_ADS_URL, R.drawable.pre));
        //videos.add(new Video("Pre-roll and mid-roll ads", "9:54", NIELSEN_VOD_HLS, PREROLL_MIDROLL_ADS_URL, R.drawable.mid));
        videos.add(new Video("Pre-roll ads", "6:57", NIELSEN_VOD_HLS, PREROLL_ADS_URL, R.drawable.pre));
        videos.add(new Video("Pre-roll and mid-roll ads", "6:57", NIELSEN_VOD_HLS, PREROLL_MIDROLL_ADS_URL, R.drawable.mid));
    }

}
