package com.akamai.ampdemo;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListView;

import java.util.ArrayList;
import java.util.List;


public class MainActivity extends Activity {

    private static final String VOD_HLS = "https://welcomevideo.akamaized.net/delivery/1f/07/1f0756a1-f54b-4e22-adbc-8c68680532ea/tom-intro-for-new-customers-v26b238090-d41d-336d-4347-3dac7fc07f0e.m3u8";
    private static final String LIVE_HLS = "https://stream.mux.com/v69RSHhFelSm4701snP22dYz2jICy4E4FUyk02rW4gxRM.m3u8";
    //private static final String WORLD_VOD_HLS = "http://multiplatform-f.akamaihd.net/i/multi/april11/hdworld/hdworld_,512x288_450_b,640x360_700_b,768x432_1000_b,1024x576_1400_m,.mp4.csmil/master.m3u8";
    private static final String PREROLL_ADS_URL = "https://pubads.g.doubleclick.net/gampad/ads?sz=640x480&iu=/124319096/external/ad_rule_samples&ciu_szs=300x250&ad_rule=1&impl=s&gdfp_req=1&env=vp&output=vmap&unviewed_position_start=1&cust_params=deployment%3Ddevsite%26sample_ar%3Dpreonly&cmsid=496&vid=short_onecue&correlator=";
    private static final String PREROLL_MIDROLL_ADS_URL = "https://pubads.g.doubleclick.net/gampad/ads?sz=640x480&iu=/124319096/external/ad_rule_samples&ciu_szs=300x250&ad_rule=1&impl=s&gdfp_req=1&env=vp&output=vmap&unviewed_position_start=1&cust_params=deployment%3Ddevsite%26sample_ar%3Dpremidpost&cmsid=496&vid=short_onecue&correlator=";
    private static final String PREROLL_MULTIPLE_MIDROLL_ADS_URL = "https://pubads.g.doubleclick.net/gampad/ads?sz=640x480&iu=/124319096/external/ad_rule_samples&ciu_szs=300x250&ad_rule=1&impl=s&gdfp_req=1&env=vp&output=vmap&unviewed_position_start=1&cust_params=deployment%3Ddevsite%26sample_ar%3Dpremidpostpodbumper&cmsid=496&vid=short_onecue&correlator=";
    private static final String ANOTHER_ADS_URL = "https://pubads.g.doubleclick.net/gampad/ads?sz=640x480&iu=/124319096/external/ad_rule_samples&ciu_szs=300x250&ad_rule=1&impl=s&gdfp_req=1&env=vp&output=vmap&unviewed_position_start=1&cust_params=deployment%3Ddevsite%26sample_ar%3Dpremidpost&cmsid=496&vid=short_onecue&correlator=";


    private ArrayList<Video> videos;
    private PlaylistAdapter adapter;
    private ListView listView;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        listView = (ListView) findViewById(R.id.playlist);
        createPlaylist();
        adapter = new PlaylistAdapter(this, videos);
        listView.setAdapter(adapter);
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Intent intent = new Intent(MainActivity.this, PlayerActivity.class);
                intent.putExtra("videoSelected", adapter.getItem(i));
                startActivity(intent);
            }
        });
    }

    private void createPlaylist() {
        videos = new ArrayList<>();
        addVideos(videos);
    }

    private void addVideos(List<Video> videos) {
        videos.add(new Video("VOD Short Film", "12:15", VOD_HLS, null, R.drawable.bbb, false, "VOD"));
        videos.add(new Video("Live HLS Stream", "∞", LIVE_HLS, null, R.drawable.live, false, "Live"));
        videos.add(new Video("Pre-roll ads", "6:57", VOD_HLS, PREROLL_ADS_URL, R.drawable.pre, true, "VOD"));
        videos.add(new Video("Pre-roll and mid-roll ads", "6:57", VOD_HLS, PREROLL_MIDROLL_ADS_URL, R.drawable.mid, true, "VOD"));
        videos.add(new Video("Multiple ads in adBreak", "6:57", VOD_HLS, PREROLL_MULTIPLE_MIDROLL_ADS_URL, R.drawable.logo, true, "VOD"));
        videos.add(new Video("Another ads URL", "6:57", VOD_HLS, ANOTHER_ADS_URL, R.drawable.logo, true, "VOD"));
    }

}
