package com.akamai.ampdemo;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.WindowManager;
import android.widget.ProgressBar;

import com.akamai.amp.ads.ima.AmpIMAManager;
import com.akamai.amp.ads.ima.IMA;
import com.akamai.amp.analytics.comscorestreamsense.AmpComscoreStreamsenseAnalyticsTracker;
import com.akamai.amp.analytics.comscorestreamsense.ComscoreStreamsense;
import com.akamai.amp.config.data.streamsense.StreamsenseData;
import com.akamai.amp.media.VideoPlayerContainer;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.media.errors.ErrorType;
import com.akamai.amp.uimobile.generic.media.PlayerControlsOverlay;
import com.akamai.amp.utils.LogManager;
import com.comscore.streaming.ContentMetadata;


public class MainActivity extends Activity
        implements VideoPlayerContainer.VideoPlayerContainerCallback {

    private final static String LOG_TAG = "AMPv6";
    private final static String VIDEO_URL = "https://welcomevideo.akamaized.net/delivery/1f/07/1f0756a1-f54b-4e22-adbc-8c68680532ea/tom-intro-for-new-customers-v26b238090-d41d-336d-4347-3dac7fc07f0e.m3u8";
    private final static String ADS_URL = "https://pubads.g.doubleclick.net/gampad/ads?iu=/21775744923/external/vmap_ad_samples&sz=640x480&cust_params=sample_ar%3Dpremidpost&ciu_szs=300x250&gdfp_req=1&ad_rule=1&output=vmap&unviewed_position_start=1&env=vp&impl=s&cmsid=496&vid=short_onecue&correlator=";

    private VideoPlayerContainer videoPlayerContainer;
    private VideoPlayerView videoPlayerView;
    private ProgressBar progressBar;
    private PlayerControlsOverlay mPlayerControlsOverlay;

    private AmpIMAManager ads;
    private AmpComscoreStreamsenseAnalyticsTracker analytics;



    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
        progressBar = findViewById(R.id.progressBar);
        mPlayerControlsOverlay = (PlayerControlsOverlay) findViewById(R.id.playerControls);
        setInlineUI();
        videoPlayerContainer = findViewById(R.id.playerViewCtrl);
        videoPlayerContainer.addVideoPlayerContainerCallback(this);
        videoPlayerContainer.setApiKey("demo");
        videoPlayerContainer.prepareResource(VIDEO_URL);
    }

    private void setInlineUI() {
        mPlayerControlsOverlay.overrideControlsLayout(R.layout.overlay_controls);
        mPlayerControlsOverlay.setShowControlsAtStart(false);
        setupInlinePlayerControls();
    }

    private void setupInlinePlayerControls() {
        mPlayerControlsOverlay.managePlayPause(R.id.androidsdk_playPauseCtrl,
                R.drawable.play,
                R.drawable.pause);
        mPlayerControlsOverlay.manageCurrentPosition(R.id.androidsdk_seekbarTextCtrl);
        mPlayerControlsOverlay.manageTimeRemaining(R.id.video_duration);
        mPlayerControlsOverlay.manageScrubbing(R.id.androidsdk_seekbarCtrl,
                R.id.androidsdk_seekToLiveAction);
    }

    @Override
    public void onVideoPlayerCreated() {
        videoPlayerView = videoPlayerContainer.getVideoPlayer();
        videoPlayerView.setProgressBarControl(progressBar);
        videoPlayerView.setLogEnabled(true);
        videoPlayerView.setFullScreen(true);
        videoPlayerView.setFullScreenMode(VideoPlayerView.FULLSCREEN_MODE_KEEP_ASPECT_RATIO);

        mPlayerControlsOverlay.setVideoPlayerContainer(videoPlayerContainer);

        StreamsenseData streamsenseData = StreamsenseHelper.buildStreamsenseData(videoPlayerView);
        analytics = ComscoreStreamsense.create(videoPlayerView, streamsenseData);
        ContentMetadata contentMetadata = StreamsenseHelper.buildContentMetadata();
        analytics.setContentMetadata(contentMetadata);

        initGoogleAds();
    }

    private void initGoogleAds() {
        ads = IMA.create(this)
        .buildClientSideManager();
        ads.setVideoPlayerContainer(videoPlayerContainer);
        ads.setVideoPlayerView(videoPlayerView);
        ads.addEventsListener(analytics.getiAdsComponentListener());
        ads.setAdsUrl(ADS_URL);
    }

    @Override
    public void onResourceReady(MediaResource mediaResource) {
        videoPlayerView.play(mediaResource);
    }

    @Override
    public void onResourceError(ErrorType errorType, Exception exception) {
        LogManager.error(LOG_TAG, "onResourceError()");
    }


    //It's mandatory to let the SDK know when the app goes and comes to the background

    @Override
    protected void onPause() {
        Log.d(LOG_TAG, "onPause");
        if (videoPlayerView != null) videoPlayerView.onPause();
        super.onPause();
    }

    @Override
    protected void onResume() {
        Log.d(LOG_TAG, "onResume");
        if (videoPlayerView != null) videoPlayerView.onResume();
        super.onResume();
    }

    @Override
    protected void onDestroy() {
        Log.d(LOG_TAG, "onDestroy");
        if (videoPlayerView != null) videoPlayerView.onDestroy();
        super.onDestroy();
    }

}
