package com.akamai.ampdemo;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import java.util.ArrayList;

public class PlaylistAdapter extends BaseAdapter {

    private Activity mActivity;
    private ArrayList<Video> videos;
    private LayoutInflater mLayoutInflater;

    public PlaylistAdapter(Activity mActivity, ArrayList<Video> videos){
        this.mActivity = mActivity;
        this.videos = videos;

        mLayoutInflater = (LayoutInflater) mActivity.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
    }


    @Override
    public int getCount(){
        return videos.size();
    }

    @Override
    public Video getItem(int pos){
        return videos.get(pos);
    }

    @Override
    public long getItemId(int pos){
        return pos;
    }


    @Override
    public View getView(int position, View convertView, ViewGroup parent){
        View v = convertView;

        Video video = videos.get(position);

        v = mLayoutInflater.inflate(R.layout.player_cell, null);
        TextView title = (TextView) v.findViewById(R.id.videoTitle);
        TextView duration = (TextView) v.findViewById(R.id.duration);
        ImageView thumbnail = (ImageView) v.findViewById(R.id.thumbnail);
        title.setText("Title: " + video.title);
        duration.setText("Duration: " + video.duration);
        thumbnail.setImageDrawable(mActivity.getResources().getDrawable(video.thumbnail));
        return v;
    }
}
