package com.akamai.ampdemo;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.widget.ProgressBar;

import com.adobe.marketing.mobile.MediaConstants;
import com.akamai.amp.ads.AdsCount;
import com.akamai.amp.ads.AdsInfo;
import com.akamai.amp.ads.IAdsComponentListener;
import com.akamai.amp.ads.ima.AmpIMAManager;
import com.akamai.amp.ads.ima.IMA;
import com.akamai.amp.analytics.adobeexperienceplatform.AdobeExperience;
import com.akamai.amp.analytics.adobeexperienceplatform.AmpAdobeExperienceAnalyticsTracker;
import com.akamai.amp.config.data.experienceplatform.ExperiencePlatformData;
import com.akamai.amp.media.VideoPlayerContainer;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.media.errors.ErrorType;
import com.akamai.amp.uimobile.generic.media.PlayerControlsOverlay;

import java.util.HashMap;
import java.util.Map;


public class PlayerActivity extends Activity
        implements VideoPlayerContainer.VideoPlayerContainerCallback, IAdsComponentListener {

    private static final String LOG_TAG = PlayerActivity.class.getSimpleName();
    private static final String VIDEO_NAME = "testVideoName";
    private static final String VIDEO_ID = "testVideoID";
    private static final String CHANNEL = "testChannel";

    private VideoPlayerContainer videoPlayerContainer;
    private VideoPlayerView videoPlayerView;
    private ProgressBar progressBar;
    private PlayerControlsOverlay mPlayerControlsOverlay;

    private AmpIMAManager ads;
    private AmpAdobeExperienceAnalyticsTracker analytics;

    private Video videoSelected;



    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_player);

        Intent intent = getIntent();
        videoSelected = (Video) intent.getSerializableExtra("videoSelected");

        progressBar = findViewById(R.id.progressBar);
        videoPlayerContainer = findViewById(R.id.playerViewCtrl);
        mPlayerControlsOverlay = findViewById(R.id.playerControls);
        setInlineUI();
        videoPlayerContainer.addVideoPlayerContainerCallback(this);
        videoPlayerContainer.setApiKey("demo");
        videoPlayerContainer.prepareResource(videoSelected.videoURL);
    }

    private void setInlineUI() {
        mPlayerControlsOverlay.overrideControlsLayout(R.layout.overlay_controls);
        mPlayerControlsOverlay.setShowControlsAtStart(false);
        setupInlinePlayerControls();
    }

    private void setupInlinePlayerControls() {
        mPlayerControlsOverlay.managePlayPause(R.id.androidsdk_playPauseCtrl,
                R.drawable.play,
                R.drawable.pause);
        mPlayerControlsOverlay.manageCurrentPosition(R.id.androidsdk_seekbarTextCtrl);
        mPlayerControlsOverlay.manageTimeRemaining(R.id.video_duration);
        mPlayerControlsOverlay.manageScrubbing(R.id.androidsdk_seekbarCtrl,
                R.id.androidsdk_seekToLiveAction);
    }

    private void initGoogleAds() {
        String adsUrl = videoSelected.adsUrl;
        if (adsUrl == null) return;

        ads = IMA.create(PlayerActivity.this)
        .buildClientSideManager();
        ads.setVideoPlayerContainer(videoPlayerContainer);
        ads.setVideoPlayerView(videoPlayerView);
        ads.addEventsListener(this);
        ads.addEventsListener(analytics.getiAdsComponentListener());
        ads.setAdsUrl(adsUrl);
        ads.addEventsListener(mPlayerControlsOverlay.getAdsComponentListener());
    }

    @Override
    public void onVideoPlayerCreated() {
        Log.i(LOG_TAG, "onVideoPlayerCreated()");
    }

    @Override
    public void onResourceError(ErrorType errorType, Exception exception) {
        Log.d(LOG_TAG, "onResourceError()");
    }

    @Override
    public void onResourceReady(MediaResource mediaResource) {
        videoPlayerView = videoPlayerContainer.getVideoPlayer();
        videoPlayerView.setLogEnabled(true);
        videoPlayerView.setKeepScreenOn(true);
        videoPlayerView.setProgressBarControl(progressBar);

        analytics = AdobeExperience.create(videoPlayerView, buildAdobeExperienceData());
        initGoogleAds();
        mPlayerControlsOverlay.setVideoPlayerContainer(videoPlayerContainer);

        videoPlayerView.play(mediaResource);
    }

    private ExperiencePlatformData buildAdobeExperienceData() {
        ExperiencePlatformData data = new ExperiencePlatformData();
        data.setChannel(CHANNEL);
        data.setVideoID(VIDEO_ID);
        data.setVideoName(VIDEO_NAME);
        data.setMetadata(buildContentMetadata());
        data.setAdMetadata(buildAdMetadata());
        return data;
    }

    private Map<String, String> buildContentMetadata() {
        Map<String, String> metadata = new HashMap<>();
        metadata.put(MediaConstants.VideoMetadataKeys.SHOW, "myShow");
        metadata.put(MediaConstants.VideoMetadataKeys.SEASON, "mySeason");
        metadata.put(MediaConstants.VideoMetadataKeys.EPISODE, "myEpisode");
        metadata.put(MediaConstants.VideoMetadataKeys.ORIGINATOR, "weDontKnow");
        metadata.put(MediaConstants.VideoMetadataKeys.NETWORK, "Akamai");
        return metadata;
    }

    private Map<String, String> buildAdMetadata() {
        Map<String, String> metadata = new HashMap<>();
        metadata.put(MediaConstants.AdMetadataKeys.ADVERTISER, "myAdv");
        metadata.put(MediaConstants.AdMetadataKeys.CAMPAIGN_ID, "myCmp");
        metadata.put(MediaConstants.AdMetadataKeys.CREATIVE_ID, "myCid");
        metadata.put(MediaConstants.AdMetadataKeys.PLACEMENT_ID, "myPid");
        metadata.put(MediaConstants.AdMetadataKeys.SITE_ID, "mySid");
        metadata.put(MediaConstants.AdMetadataKeys.CREATIVE_URL, "myCurl");
        return metadata;
    }


    //It's mandatory to let the SDK know when the app goes and comes to the background

    @Override
    protected void onPause() {
        Log.d(LOG_TAG, "onPause");
        if (videoPlayerView != null) videoPlayerView.onPause();
        super.onPause();
    }

    @Override
    protected void onResume() {
        Log.d(LOG_TAG, "onResume");
        if (videoPlayerView != null) videoPlayerView.onResume();
        super.onResume();
    }

    @Override
    protected void onDestroy() {
        Log.d(LOG_TAG, "onDestroy");
        if (videoPlayerView != null) videoPlayerView.onDestroy();
        super.onDestroy();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        return false;
    }

    @Override
    public void onAdsError(String s) {
            Log.d(LOG_TAG, "onAdsError " + s);
    }

    @Override
    public void onPauseContentRequested() {

    }

    @Override
    public void onResumeContentRequested() {
        Log.d(LOG_TAG, "onResumeContentRequested");
    }

    @Override
    public void onListenerRegistered() {
        Log.d(LOG_TAG, "onListenerRegistered");
    }

    @Override
    public void onAdsInitialized() {
        Log.d(LOG_TAG, "onAdsInitialized");
    }

    @Override
    public void onAdRequest() {
        Log.d(LOG_TAG, "onAdRequest");
    }

    @Override
    public void onAdsLoaded(AdsCount adsCount) {
        Log.d(LOG_TAG, "onAdsLoaded " + adsCount);
    }

    @Override
    public void onAdsStarted(AdsInfo ads) {
        Log.i(LOG_TAG, "onAdsStarted");
    }

    @Override
    public void onAdsPaused() {
        Log.d(LOG_TAG, "onAdsPaused");
    }

    @Override
    public void onAdsResumed() {
        Log.d(LOG_TAG, "onAdsResumed");
    }

    @Override
    public void onAdBreakStarted() {
        Log.d(LOG_TAG, "onAdBreakStarted");
    }

    @Override
    public void onAdBreakEnded() {
        Log.d(LOG_TAG, "onAdBreakEnded");
    }

    @Override
    public void onAdsEnded() {
        Log.d(LOG_TAG, "onAdsEnded");
    }

    @Override
    public void onAllPostrollsEnded() {
        Log.d(LOG_TAG, "onAllPostrollsEnded");
    }

    @Override
    public void onAdsTrackProgress(int i) {
        Log.d(LOG_TAG, "onAdsTrackProgress " + i);
    }

    @Override
    public void onAdsPlayheadUpdate(int i) {
        Log.d(LOG_TAG, "onAdsPlayheadUpdate " + i);
    }

    @Override
    public void onAdEvent() {
        Log.d(LOG_TAG, "onAdEvent");
    }

    @Override
    public void onAdBufferingStarted() {
        Log.d(LOG_TAG, "onAdBufferingStarted");
    }

    @Override
    public void onAdBufferingEnded() {
        Log.d(LOG_TAG, "onAdBufferingEnded");
    }

    @Override
    public void onAdsTapped() {
        Log.d(LOG_TAG, "onAdsTapped");
    }

    @Override
    public void onAdSkipped() {
        Log.d(LOG_TAG, "onAdSkipped");
    }
}
