package com.akamai.ampdemo;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListView;

import java.util.ArrayList;
import java.util.List;


public class MainActivity extends Activity {

    private static final String VOD_HLS = "https://welcomevideo.akamaized.net/delivery/1f/07/1f0756a1-f54b-4e22-adbc-8c68680532ea/tom-intro-for-new-customers-v26b238090-d41d-336d-4347-3dac7fc07f0e.m3u8";
    private static final String LIVE_HLS = "https://moctobpltc-i.akamaihd.net/hls/live/571329/eight/playlist.m3u8";

    private static final String PREROLL_ADS_URL = "https://pubads.g.doubleclick.net/gampad/ads?sz=640x480&iu=/124319096/external/ad_rule_samples&ciu_szs=300x250&ad_rule=1&impl=s&gdfp_req=1&env=vp&output=vmap&unviewed_position_start=1&cust_params=deployment%3Ddevsite%26sample_ar%3Dpreonly&cmsid=496&vid=short_onecue&correlator=";
    private static final String PREROLL_MIDROLL_ADS_URL = "https://pubads.g.doubleclick.net/gampad/ads?sz=640x480&iu=/124319096/external/ad_rule_samples&ciu_szs=300x250&ad_rule=1&impl=s&gdfp_req=1&env=vp&output=vmap&unviewed_position_start=1&cust_params=deployment%3Ddevsite%26sample_ar%3Dpremidpost&cmsid=496&vid=short_onecue&correlator=";


    private ArrayList<Video> videos;
    private PlaylistAdapter adapter;
    private ListView listView;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        listView = findViewById(R.id.playlist);
        createPlaylist();
        adapter = new PlaylistAdapter(this, videos);
        listView.setAdapter(adapter);
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Intent intent = new Intent(MainActivity.this, PlayerActivity.class);
                intent.putExtra("videoSelected", adapter.getItem(i));
                startActivity(intent);
            }
        });
    }

    private void createPlaylist() {
        videos = new ArrayList<>();
        addNielsenVideos(videos);
    }

    private void addPublicVideos(List<Video> videos) {
        videos.add(new Video("VOD Short Film", "12:15", VOD_HLS, null, R.drawable.dream));
        videos.add(new Video("Live HLS Stream", "∞", LIVE_HLS, null, R.drawable.live));
        videos.add(new Video("Pre-roll ads", "9:54", VOD_HLS, PREROLL_ADS_URL, R.drawable.pre));
        videos.add(new Video("Pre-roll and mid-roll ads", "9:54", VOD_HLS, PREROLL_MIDROLL_ADS_URL, R.drawable.mid));
    }

    private void addNielsenVideos(List<Video> videos) {
        videos.add(new Video("VOD Short Film", "12:15", VOD_HLS, null, R.drawable.bbb));
        videos.add(new Video("Live HLS Stream", "∞", LIVE_HLS, null, R.drawable.live));
        videos.add(new Video("Pre-roll ads", "6:57", VOD_HLS, PREROLL_ADS_URL, R.drawable.pre));
        videos.add(new Video("Pre-roll and mid-roll ads", "6:57", VOD_HLS, PREROLL_MIDROLL_ADS_URL, R.drawable.mid));
    }

}
