package com.truex.referenceapp.player;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.res.Resources;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;

import com.akamai.amp.ads.truex.AdBreak;
import com.akamai.amp.ads.truex.AmpTruexManager;
import com.akamai.amp.ads.truex.TruexEventListener;
import com.akamai.amp.media.VideoPlayerContainer;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.media.errors.ErrorType;
import com.akamai.amp.utils.LogManager;
import com.truex.referenceapp.R;

import org.apache.commons.text.StringEscapeUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class PlayerFragment extends Fragment  {
    private static final String CLASSTAG = "PlayerFragment";
    //private static final String CONTENT_STREAM_URL = "https://ctv.truex.com/assets/reference-app-stream-no-ads-720p.mp4";
    private static final String CONTENT_STREAM_URL = "https://devstreaming-cdn.apple.com/videos/streaming/examples/bipbop_16x9/bipbop_16x9_variant.m3u8";
    private static final String AMP_LICENSE = "F2mj6H18-GE5D4eC9WJH5JzObOwVlPZoG6DIIr5NYpnD5-JD6liUieI_ie7106dVSsgyR2tQVL1-YSUrKVr8Ww==";

    private VideoPlayerContainer playerView;

    private List<AdBreak> adBreaks;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Force playback in landscape.
        Activity activity = getActivity();
        activity.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR_LANDSCAPE);
        return inflater.inflate(R.layout.fragment_player, container, false);
    }

    @Override
    public void onDetach() {
        // Restore portrait orientation for normal usage.
        Activity activity = getActivity();
        activity.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR_PORTRAIT);
        super.onDetach();
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        Log.d(CLASSTAG, "onViewCreated");

        super.onViewCreated(view, savedInstanceState);

        // Simulates the parsed result of making a service call to some ad provider and
        // getting useful information
        adBreaks = getAdPayload(R.raw.adbreaks_stub);

        playerView = getView().findViewById(R.id.videoContainer);
        playerView.addVideoPlayerContainerCallback(ampCallback);
        playerView.prepareResource(CONTENT_STREAM_URL);
    }

    private final VideoPlayerContainer.VideoPlayerContainerCallback ampCallback = new VideoPlayerContainer.VideoPlayerContainerCallback() {
        @Override
        public void onVideoPlayerCreated() {}

        @Override
        public void onResourceReady(MediaResource mediaResource) {
            VideoPlayerView amp = playerView.getVideoPlayer();
            amp.setLicense(AMP_LICENSE);
            List<TruexEventListener> listeners = new ArrayList<TruexEventListener>();
            listeners.add(listener);
            AmpTruexManager ampTruexManager = new AmpTruexManager(PlayerFragment.this.getContext(), playerView, adBreaks, listeners);
            //ampTruexManager.setVideoPlayerView(amp);
            //ampTruexManager.setViewGroup((ViewGroup) playerView.getParent());
            amp.play(mediaResource);
        }

        @Override
        public void onResourceError(ErrorType errorType, Exception e) {
            LogManager.error(CLASSTAG, e);
        }
    };

    private static final TruexEventListener listener = new TruexEventListener() {

        private String prettyPrint(Map<String, ?> map) {
            return Arrays.toString(map.entrySet().toArray());
        }

        @Override
        public void onAdFetchCompleted(Map<String, ?> map) {
            LogManager.log(CLASSTAG, "onAdFetchCompleted " + prettyPrint(map));
        }

        @Override
        public void onAdStarted(Map<String, ?> map) {
            LogManager.log(CLASSTAG, "onAdStarted " + prettyPrint(map));
        }

        @Override
        public void onAdDisplayed(Map<String, ?> map) {
            LogManager.log(CLASSTAG, "onAdDisplayed " + prettyPrint(map));
        }

        @Override
        public void onAdCompleted(Map<String, ?> map) {
            LogManager.log(CLASSTAG, "onAdCompleted " + prettyPrint(map));
        }

        @Override
        public void onAdError(Map<String, ?> map) {
            LogManager.log(CLASSTAG, "onAdError " + prettyPrint(map));
        }

        @Override
        public void onNoAds(Map<String, ?> map) {
            LogManager.log(CLASSTAG, "onNoAds " + prettyPrint(map));
        }

        @Override
        public void onAdFree(Map<String, ?> map) {
            LogManager.log(CLASSTAG, "onAdFree " + prettyPrint(map));
        }

        @Override
        public void onUserCancel(Map<String, ?> map) {
            LogManager.log(CLASSTAG, "onUserCancel " + prettyPrint(map));
        }

        @Override
        public void onOptIn(Map<String, ?> map) {
            LogManager.log(CLASSTAG, "onOptIn " + prettyPrint(map));
        }

        @Override
        public void onOptOut(Map<String, ?> map) {
            LogManager.log(CLASSTAG, "onOptOut " + prettyPrint(map));
        }

        @Override
        public void onSkipCardShown(Map<String, ?> map) {
            LogManager.log(CLASSTAG, "onSkipCardShown " + prettyPrint(map));
        }

        @Override
        public void onPopUp(Map<String, ?> map) {
            LogManager.log(CLASSTAG, "onPopUp " + prettyPrint(map));
        }
    };

    @Override
    public void onResume() {
        Log.d(CLASSTAG, "onResume");
        super.onResume();
        if (playerView != null) playerView.onResume();
    }

    @Override
    public void onPause() {
        Log.d(CLASSTAG, "onPause");
        super.onPause();
        if (playerView != null) playerView.onPause();
    }

    @Override
    public void onDestroy() {
        Log.d(CLASSTAG, "onDestroy");
        super.onDestroy();
        if (playerView != null) playerView.onDestroy();
    }

    private List<AdBreak> getAdPayload(Integer resourceId) {
        String rawFile = getRawFileContents(resourceId);
        try {
            JSONObject rawJson = new JSONObject(rawFile);
            JSONArray adBreaks = rawJson.getJSONArray("adBreaks");
            List<AdBreak> result = new ArrayList<>();

            for (int i = 0; i < adBreaks.length(); i++) {
                AdBreak adBreak = parseJson(adBreaks.getJSONObject(i));
                result.add(adBreak);
            }

            return result;
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    public AdBreak parseJson(JSONObject adBreakJson) {
        try {
            String id = adBreakJson.getString("breakId");
            int timeOffsetMs = adBreakJson.getInt("timeOffsetMs");
            int duration = adBreakJson.getInt("videoAdDuration");

            JSONArray ads = adBreakJson.getJSONArray("ads");
            List<String> adUrls = new ArrayList();
            for (int i = 0; i < ads.length(); i++) {
                JSONObject ad = ads.getJSONObject(i);
                String adUrl = StringEscapeUtils.unescapeJava(ad.getString("adUrl"));
                adUrls.add(adUrl);
            }
            AdBreak adBreak = new AdBreak(id, timeOffsetMs, duration, adUrls);
            return adBreak;
        } catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private String getRawFileContents(int resourceId) {
        Context context = getContext();
        if (context == null) return "";

        Resources resources = context.getResources();
        InputStream vastContentStream = resources.openRawResource(resourceId);

        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(vastContentStream));

            String line;
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (reader != null) {
                try {
                    reader.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        return stringBuilder.toString();
    }

}
