package com.akamai.ampfreewheelsample;

import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import android.view.WindowManager;

import com.akamai.amp.ads.AdsCount;
import com.akamai.amp.ads.IAdsComponentListener;
import com.akamai.amp.ads.freewheel.AdSlot;
import com.akamai.amp.ads.freewheel.AmpFreewheelManager;
import com.akamai.amp.ads.freewheel.Freewheel;
import com.akamai.amp.ads.freewheel.FreewheelAdsInfo;
import com.akamai.amp.media.IPlayerEventsListener;
import com.akamai.amp.media.PlayerEvents;
import com.akamai.amp.media.VideoPlayerContainer;
import com.akamai.amp.media.VideoPlayerContainer.VideoPlayerContainerCallback;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.elements.AMPLibraryInfo;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.media.errors.ErrorType;
import com.akamai.amp.uimobile.generic.media.PlayerControlsOverlay;

import java.util.HashMap;
import java.util.Map;

import tv.freewheel.ad.InternalConstants;
import tv.freewheel.ad.interfaces.IAdInstance;
import tv.freewheel.utils.Logger;


public class FreeWheelActivity extends AppCompatActivity
        implements IAdsComponentListener<FreewheelAdsInfo>,
                   VideoPlayerContainerCallback {

    private static final String TAG = FreeWheelActivity.class.getName();


    private VideoPlayerContainer videoPlayerContainer;
    private VideoPlayerView videoPlayerView;

    private AmpFreewheelManager freewheelManager;
    private PlayerControlsOverlay mPlayerControlsOverlay;

    //Freewheel Ads constants, reach out to your Freewheel representative to get these values
    public static String FW_ADS_URL = "https://demo.v.fwmrm.net/";
    public static int FW_NETWORK_ID = 42015;
    // Request parameters — these may change from request to request
    // depending on how your content is arranged in the MRM system
    public static String FW_PROFILE = "android_demo_since_5.13";
    public static String FW_SITE_SECTION_ID = "android_allinone_demo_site_section";
    public static String FW_VIDEO_ASSET_ID = "android_allinone_demo_video";


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        Log.i(TAG,"onCreate()");

        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);

        videoPlayerContainer = (VideoPlayerContainer) findViewById(R.id.videoContainer);
        mPlayerControlsOverlay = (PlayerControlsOverlay) findViewById(R.id.playerControls);
        setInlineUI();
        videoPlayerContainer.addVideoPlayerContainerCallback(this);
        videoPlayerContainer.setApiKey("demo");

        freewheelManager = Freewheel.create(this, FW_NETWORK_ID, FW_ADS_URL,
                FW_SITE_SECTION_ID, FW_VIDEO_ASSET_ID, FW_PROFILE);
        freewheelManager.setExternalLogLevel(Logger.VERBOSE);
        freewheelManager.addEventsListener(this);
        freewheelManager.setVideoPlayerContainer(videoPlayerContainer);
        //freewheelManager.warnOnAdClick("warnOnAdClick()");
        //freewheelManager.addTemporalSlots(createAdSlots());

        Log.i(TAG,"Started AMP version " + AMPLibraryInfo.VERSION +
                " with Freewheel version " + freewheelManager.getExternalLibVersion());

        videoPlayerContainer.prepareResource("https://media-demo-host.akamaized.net/test/video/kluge/hls/all.m3u8");
    }

    private AdSlot[] createAdSlots() {
        return new AdSlot[]{
                new AdSlot("pre1",  AmpFreewheelManager.PREROLL,  0),
                new AdSlot("post1", AmpFreewheelManager.POSTROLL, 60),
                new AdSlot("mid1",  AmpFreewheelManager.MIDROLL,  30),
                new AdSlot("mid2",  AmpFreewheelManager.MIDROLL,  900),
                new AdSlot("mid3",  AmpFreewheelManager.MIDROLL,  1800)};
    }

    private void configVideoPlayer(){

        videoPlayerView = videoPlayerContainer.getVideoPlayer();
        mPlayerControlsOverlay.setVideoPlayerContainer(videoPlayerContainer);
        videoPlayerView.setLogEnabled(true);

        freewheelManager.setVideoPlayerView(videoPlayerView);
        freewheelManager.addEventsListener(mPlayerControlsOverlay.getAdsComponentListener());

        videoPlayerView.addEventsListener(new IPlayerEventsListener() {
            @Override
            public boolean onPlayerEvent(int eventID) {
                Log.i(TAG, "AMP Event: " + PlayerEvents.toString(eventID));
                switch (eventID){
                    case IPlayerEventsListener.PLAYER_EXTENDED_EVENT_SEEKING_SUCCEDEED:
                        // this line is to make mid rolls play if the user seeks after cue point
                        if (freewheelManager != null){
                            freewheelManager.getUIEventsListener().onScrubbingEnded();
                        }
                        break;
                    default:
                        // code block
                }
                return false;
            }

            @Override
            public boolean onPlayerExtendedEvent(int i, int i1, int i2) {
                return false;
            }
        });
    }

    @Override
    public void onVideoPlayerCreated() {
        Log.i(TAG,"onVideoPlayerCreated");
        configVideoPlayer();
    }

    @Override
    public void onResourceReady(MediaResource resource) {
        Log.i(TAG,"onResourceReady");

        addRequestMetadata();

        // in case you don't have the duration of the VOD.
        //videoPlayerView.play(resource);
        // in case you have the duration of the VOD to reduce startup time
        videoPlayerView.play(resource, 0, 357);
    }

    private void addRequestMetadata() {
        Map<String, String> adRequestMetadata = new HashMap<>();
        adRequestMetadata.put(InternalConstants.FW_PLAYER_WIDTH, "640");
        adRequestMetadata.put(InternalConstants.FW_PLAYER_HEIGHT, "480");
        adRequestMetadata.put("SHOW_TITLE", "My Show Title"); //Freewheel does not provide constants for the items below
        adRequestMetadata.put("SHOW_LENGTH", "123");
        adRequestMetadata.put("GENRE_BUNDLE_ID", "gnr456");

        /**
         * This method can be called at any point in time, before the ad request has been placed.
         * Remember to change the values for every piece of media you use.
         */
        freewheelManager.setAdRequestMetadata(adRequestMetadata);
    }

    @Override
    public void onResourceError(ErrorType errorType, Exception exception) {

        Log.e(TAG,"onResourceError");
    }

    @Override
    protected void onResume(){
        Log.i(TAG, "onResume");
        freewheelManager.onResume();
        if(videoPlayerView != null) {
            videoPlayerView.onResume();
        }
        super.onResume();
    }

    @Override
    protected void onPause() {
        Log.i(TAG,"onPause");
        freewheelManager.onPause();
        if(videoPlayerView != null){
            videoPlayerView.onPause();
        }
        super.onPause();
    }

    @Override
    protected void onStop() {
        Log.i(TAG,"onStop");
        super.onStop();
        freewheelManager.onStop();
    }

    @Override
    protected void onDestroy() {
        Log.i(TAG,"onDestroy");
        super.onDestroy();
        videoPlayerView.onDestroy();
        //freewheelManager.onDestroy();
    }

    @Override
    protected void onStart() {
        Log.i(TAG,"onStart");
        super.onStart();
        freewheelManager.onStart();
    }

    @Override
    protected void onRestart() {
        Log.i(TAG,"onRestart");
        super.onRestart();
        freewheelManager.onRestart();
    }


    // IAdsComponentListener
    @Override
    public void onAdBreakStarted(){
        Log.i(TAG,"onAdBreakStarted");
    }

    @Override
    public void onAdsStarted(FreewheelAdsInfo adsInfo) {
        Log.i(TAG,"onAdsStarted " + adsInfo + " . Ads URL: " + freewheelManager.getAdsURL());

        /*
        IAdInstance ad = adsInfo.getAdInstance();
        Log.i("IAdsInstance", " getActiveCreativeRendition: " + ad.getActiveCreativeRendition());
        Log.i("IAdsInstance", " getAdUniqueId: " + ad.getAdUniqueId());
        Log.i("IAdsInstance", " getExternalAdId: " + ad.getExternalAdId());
        Log.i("IAdsInstance", " getAdId: " + ad.getAdId());
        Log.i("IAdsInstance", " getAllCreativeRenditions: " + ad.getAllCreativeRenditions());
        Log.i("IAdsInstance", " getCompanionAdInstances: " + ad.getCompanionAdInstances());
        Log.i("IAdsInstance", " getDuration: " + ad.getDuration());
        Log.i("IAdsInstance", " getPlayheadTime: " + ad.getPlayheadTime());
        Log.i("IAdsInstance", " getRenderableCreativeRenditions: " + ad.getRenderableCreativeRenditions());
        Log.i("IAdsInstance", " getRendererController: " + ad.getRendererController());
        Log.i("IAdsInstance", " getSlot: " + ad.getSlot());
        Log.i("IAdsInstance", " getUniversalAdId: " + ad.getUniversalAdId());
        */

    }

    @Override
    public void onAdBreakEnded(){
        Log.i(TAG,"onAdBreakEnded");
     }

    @Override
    public void onAdsEnded() {
        Log.i(TAG,"onAdsEnded");
        //mPlayerControlsOverlay.setVisibility(View.VISIBLE);
        //mPlayerControlsOverlay.setControlsVisibility(View.VISIBLE);
    }

    @Override
    public void onListenerRegistered() {
        Log.i(TAG,"onListenerRegistered");
    }

    @Override
    public void onAdsInitialized() {
        Log.i(TAG,"onAdsInitialized");
    }

    @Override
    public void onAdRequest() {
        Log.i(TAG,"onAdRequest");
    }

    @Override
    public void onAdsLoaded(AdsCount adsCount) {
        Log.i(TAG,"onAdsLoaded " + adsCount);
    }

    @Override
    public void onAllPostrollsEnded() {
        Log.i(TAG,"onAllPostrollsEnded");
    }

    @Override
    public void onAdsTrackProgress(int i) {
        Log.i(TAG,"onAdsTrackProgress " + i);
    }

    @Override
    public void onAdsPlayheadUpdate(int i) {
        Log.i(TAG,"onAdsPlayheadUpdate " + i);
    }

    @Override
    public void onAdEvent() {
        Log.i(TAG,"onAdEvent ");}

    @Override
    public void onAdBufferingStarted() {
        Log.i(TAG,"onAdBufferingStarted");
    }

    @Override
    public void onAdBufferingEnded() {
        Log.i(TAG,"onAdBufferingEnded");
    }

    @Override
    public void onAdsError(String errorMessage) {
        Log.i(TAG,"onAdsError " + errorMessage);
    }

    @Override
    public void onPauseContentRequested() {
        Log.i(TAG, "onPauseContentRequested");
    }

    @Override
    public void onResumeContentRequested() {
        Log.i(TAG, "onResumeContentRequested");
    }

    @Override
    public void onAdsPaused() {
        Log.i(TAG,"onAdsPaused");
    }

    @Override
    public void onAdsResumed() {
        Log.i(TAG,"onAdsResumed");
    }

    @Override
    public void onAdsTapped() {
        Log.i(TAG,"onAdsTapped. Ads URL: " + freewheelManager.getAdsURL());
    }

    @Override
    public void onAdSkipped(){
        Log.i(TAG,"onAdSkipped");
    }

    private void setInlineUI() {
        mPlayerControlsOverlay.overrideControlsLayout(R.layout.overlay_controls);
        mPlayerControlsOverlay.setShowControlsAtStart(false);
        mPlayerControlsOverlay.waitForPreroll(true);
        setupInlinePlayerControls();
    }

    private void setupInlinePlayerControls() {
        mPlayerControlsOverlay.managePlayPause(R.id.androidsdk_playPauseCtrl,
                R.mipmap.play,
                R.mipmap.pause);
        mPlayerControlsOverlay.manageCurrentPosition(R.id.androidsdk_seekbarTextCtrl);
        mPlayerControlsOverlay.manageTimeRemaining(R.id.video_duration);
        mPlayerControlsOverlay.manageScrubbing(R.id.androidsdk_seekbarCtrl,
                R.id.androidsdk_seekToLiveAction);
    }

}
