/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.ads.ima.ImaSDK;

import android.content.Context;
import android.content.res.Configuration;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.akamai.amp.ads.ima.IPlayheadUpdate;
import com.akamai.amp.ads.ima.ImaSDK.AdsVideoView;
import com.akamai.amp.utils.LogManager;
import com.akamai.amp.utils.Utils;
import com.google.ads.interactivemedia.v3.api.AdPodInfo;
import com.google.ads.interactivemedia.v3.api.player.AdMediaInfo;
import com.google.ads.interactivemedia.v3.api.player.VideoAdPlayer;
import com.google.ads.interactivemedia.v3.api.player.VideoProgressUpdate;
import java.util.Timer;
import java.util.TimerTask;

public class AdsPlayerHolder
extends RelativeLayout
implements VideoAdPlayer {
    private static final String TAG = "AdsPlayerHolder";
    public AdsVideoView mAdsVideoView = null;
    private FrameLayout mAdUiContainer = null;
    private int mSavedContentPosition = -1;
    private boolean mIsContentPlaying = false;
    private IPlayheadUpdate playheadUpdateMember;
    private Timer adProgressTimer;
    int previousSecond = -1;

    public AdsPlayerHolder(Context context) {
        super(context);
        this.init();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.resizeVideo();
    }

    private void init() {
        LogManager.log((String)TAG, (String)"AdEvent - Initializing holder");
        RelativeLayout.LayoutParams videoLayoutParams = new RelativeLayout.LayoutParams(-1, -1);
        videoLayoutParams.addRule(14);
        videoLayoutParams.addRule(13);
        this.mAdsVideoView = new AdsVideoView(this.getContext());
        this.mAdsVideoView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (!AdsPlayerHolder.this.mIsContentPlaying) {
                    AdsPlayerHolder.this.mAdsVideoView.togglePlayback();
                }
                return false;
            }
        });
        this.addView((View)this.mAdsVideoView, (ViewGroup.LayoutParams)videoLayoutParams);
        this.mAdUiContainer = new FrameLayout(this.getContext());
        this.addView((View)this.mAdUiContainer, (ViewGroup.LayoutParams)videoLayoutParams);
    }

    public void showVideoAdsLayer() {
        try {
            if (this.mAdsVideoView != null) {
                this.mAdsVideoView.setVisibility(0);
            }
            this.requestLayout();
            this.forceLayout();
        }
        catch (Exception e) {
            LogManager.error((String)TAG, (String)("showVideoAdsLayer() exception: " + e));
        }
    }

    public void hideVideoAdsLayer() {
        try {
            if (this.mAdsVideoView != null) {
                this.mAdsVideoView.setVisibility(4);
            }
            this.requestLayout();
            this.forceLayout();
        }
        catch (Exception e) {
            LogManager.error((String)TAG, (String)("hideVideoAdsLayer() exception: " + e));
        }
    }

    public int getVolume() {
        return Utils.getDeviceVolume((Context)this.getContext());
    }

    public void playAd(AdMediaInfo info) {
        this.startTracking();
        this.mIsContentPlaying = false;
        this.mSavedContentPosition = -1;
        this.mAdsVideoView.play();
    }

    public void loadAd(AdMediaInfo info, AdPodInfo api) {
        this.mAdsVideoView.adMediaInfo = info;
        this.mAdsVideoView.setVideoPath(info.getUrl());
    }

    public void stopAd(AdMediaInfo adMediaInfo) {
        this.stopTracking();
        this.mAdsVideoView.stopPlayback();
    }

    public void pauseAd(AdMediaInfo adMediaInfo) {
        this.stopTracking();
        this.mAdsVideoView.pause();
    }

    public void release() {
    }

    public void addCallback(VideoAdPlayer.VideoAdPlayerCallback callback) {
        this.mAdsVideoView.addCallback(callback);
    }

    public void removeCallback(VideoAdPlayer.VideoAdPlayerCallback callback) {
        this.mAdsVideoView.removeCallback(callback);
    }

    public VideoProgressUpdate getAdProgress() {
        int durationMs = this.mAdsVideoView.getDuration();
        if (durationMs <= 0) {
            return VideoProgressUpdate.VIDEO_TIME_NOT_READY;
        }
        int currentPositionMillis = this.mAdsVideoView.getCurrentPosition();
        this.checkIsNewSecond(currentPositionMillis);
        return new VideoProgressUpdate((long)currentPositionMillis, (long)durationMs);
    }

    private void checkIsNewSecond(int currentPositionMillis) {
        int seconds = currentPositionMillis / 1000;
        if (seconds != this.previousSecond) {
            this.previousSecond = seconds;
            this.playheadUpdateMember.onPlayheadUpdate(seconds);
        }
    }

    public ViewGroup getUiContainer() {
        return this.mAdUiContainer;
    }

    public boolean ismIsContentPlaying() {
        return this.mIsContentPlaying;
    }

    public void pauseContent() {
        this.mSavedContentPosition = this.mAdsVideoView.getCurrentPosition();
    }

    public void resumeContent() {
        this.mIsContentPlaying = true;
        this.mAdsVideoView.seekTo(this.mSavedContentPosition);
    }

    public void play() {
        this.mAdsVideoView.play();
    }

    public void stop() {
        this.stopAd(this.getAdMediaInfo());
    }

    public void savePosition() {
        this.pauseContent();
    }

    public int getSavedPosition() {
        return this.mSavedContentPosition;
    }

    public void setCompletionCallback(AdsVideoView.TrackingVideoCallback callback) {
        this.mAdsVideoView.setmCompleteCallback(callback);
    }

    private void startTracking() {
        if (this.adProgressTimer != null) {
            return;
        }
        int initialDelayMs = 250;
        int pollingTimeMs = 250;
        this.adProgressTimer = new Timer();
        TimerTask updateTimerTask = new TimerTask(){

            @Override
            public void run() {
                AdsPlayerHolder.this.mAdsVideoView.onAdProgressChanged(AdsPlayerHolder.this.getAdProgress());
            }
        };
        this.adProgressTimer.schedule(updateTimerTask, pollingTimeMs, (long)initialDelayMs);
    }

    private void stopTracking() {
        if (this.adProgressTimer != null) {
            this.adProgressTimer.cancel();
            this.adProgressTimer = null;
        }
    }

    public void resizeVideo() {
        if (this.getChildCount() > 0) {
            int parentWidth = this.getMeasuredWidth();
            int parentHeight = this.getMeasuredHeight();
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                if (child.getVisibility() != 0) continue;
                int width = child.getMeasuredWidth();
                int height = child.getMeasuredHeight();
                if (child instanceof AdsVideoView) {
                    int videoWidth = ((AdsVideoView)child).getVideoWidth();
                    int videoHeight = ((AdsVideoView)child).getVideoHeight();
                    if (videoWidth > 0 && videoHeight > 0) {
                        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
                        this.calculateDstRect(videoWidth, videoHeight, displayMetrics.widthPixels, displayMetrics.heightPixels, (View)this.mAdUiContainer);
                    }
                    if (videoWidth > 0 && videoHeight > 0) {
                        if (videoWidth * height > width * videoHeight) {
                            height = width * videoHeight / videoWidth;
                        } else if (videoWidth * height < width * videoHeight) {
                            width = height * videoWidth / videoHeight;
                        }
                    }
                } else {
                    return;
                }
                int childL = (parentWidth - width) / 2;
                int childR = childL + width;
                int childT = (parentHeight - height) / 2;
                int n = childT + height;
            }
        }
    }

    public void calculateDstRect(int srcWidth, int srcHeight, int dstWidth, int dstHeight, View child) {
        float srcAspect = (float)srcWidth / (float)srcHeight;
        float dstAspect = (float)dstWidth / (float)dstHeight;
        if (srcAspect > dstAspect) {
            child.getLayoutParams().width = dstWidth;
            child.getLayoutParams().height = (int)((float)dstWidth / srcAspect);
        } else {
            child.getLayoutParams().width = (int)((float)dstHeight * srcAspect);
            child.getLayoutParams().height = dstHeight;
        }
    }

    public void setPlayheadUpdateMember(IPlayheadUpdate playheadUpdateMember) {
        this.playheadUpdateMember = playheadUpdateMember;
    }

    private AdMediaInfo getAdMediaInfo() {
        if (this.mAdsVideoView == null) {
            return null;
        }
        return this.mAdsVideoView.adMediaInfo;
    }

    public void onContentComplete() {
        if (this.mAdsVideoView == null) {
            return;
        }
        this.mAdsVideoView.onContentComplete();
    }
}

