/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import android.content.Context;
import com.adobe.mobile.Config;
import com.adobe.mobile.StaticMethods;
import com.adobe.mobile.WearableDataConnection;
import com.adobe.mobile.WearableDataRequest;
import com.adobe.mobile.WearableDataResponse;

final class WearableFunction {
    private static boolean sendHitFlag = false;

    WearableFunction() {
    }

    protected static boolean isHandheldAppStarted() {
        try {
            return StaticMethods.getSharedPreferences().getLong("ADMS_Handheld_App_InstallDate", 0L) != 0L;
        }
        catch (StaticMethods.NullContextException e) {
            StaticMethods.logWarningFormat("Wearable - Error getting install date of handheld app", new Object[0]);
            return false;
        }
    }

    protected static boolean shouldSendHit() {
        if (sendHitFlag) {
            return true;
        }
        if (Config.getApplicationType() != Config.ApplicationType.APPLICATION_TYPE_WEARABLE) {
            sendHitFlag = true;
            return true;
        }
        if (WearableFunction.isHandheldAppStarted()) {
            sendHitFlag = true;
            return true;
        }
        StaticMethods.logWarningFormat("Analytics - Failed to send the Wearable request, containing app should get launched before Wearable app.", new Object[0]);
        return false;
    }

    protected static void sendGenericRequest(String url, int timeout) {
        WearableFunction.retrieveData(url, timeout);
    }

    protected static byte[] retrieveData(String url, int readTimeout) {
        if (StaticMethods.isWearableApp()) {
            Context appCtx;
            try {
                appCtx = StaticMethods.getSharedContext().getApplicationContext();
            }
            catch (StaticMethods.NullContextException e) {
                StaticMethods.logErrorFormat("Analytics - Error registering network receiver (%s)", e.getMessage());
                return null;
            }
            WearableDataResponse.GetResponse response = (WearableDataResponse.GetResponse)new WearableDataConnection(appCtx).send(WearableDataRequest.createGetRequest(url, readTimeout));
            return response == null ? null : response.getResult();
        }
        return null;
    }

    protected static byte[] retrieveAnalyticsRequestData(String url, String postBody, int timeout) {
        if (StaticMethods.isWearableApp()) {
            Context appCtx;
            try {
                appCtx = StaticMethods.getSharedContext().getApplicationContext();
            }
            catch (StaticMethods.NullContextException e) {
                StaticMethods.logErrorFormat("Analytics - Error registering network receiver (%s)", e.getMessage());
                return null;
            }
            WearableDataRequest request = WearableDataRequest.createPostRequest(url, postBody, timeout);
            WearableDataConnection connection = new WearableDataConnection(appCtx);
            WearableDataResponse.PostResponse response = (WearableDataResponse.PostResponse)connection.send(request);
            return response == null ? null : response.getResult();
        }
        return null;
    }

    protected static boolean sendThirdPartyRequest(String url, String postBody, int timeout, String postType) {
        if (StaticMethods.isWearableApp()) {
            Context appCtx;
            try {
                appCtx = StaticMethods.getSharedContext().getApplicationContext();
            }
            catch (StaticMethods.NullContextException e) {
                StaticMethods.logErrorFormat("External Callback - Error registering network receiver (%s)", e.getMessage());
                return false;
            }
            WearableDataResponse response = new WearableDataConnection(appCtx).send(WearableDataRequest.createThirdPartyRequest(url, postBody, timeout, postType));
            return response != null && response.isSuccess();
        }
        return true;
    }
}

