/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import android.content.Context;
import android.net.Uri;
import com.adobe.mobile.GoogleApiClientWrapper;
import com.adobe.mobile.StaticMethods;
import com.adobe.mobile.WearableDataRequest;
import com.adobe.mobile.WearableDataResponse;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataEvent;
import com.google.android.gms.wearable.DataEventBuffer;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataMap;
import com.google.android.gms.wearable.DataMapItem;
import com.google.android.gms.wearable.NodeApi;
import com.google.android.gms.wearable.PutDataMapRequest;
import com.google.android.gms.wearable.PutDataRequest;
import com.google.android.gms.wearable.Wearable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

final class WearableDataConnection
implements GoogleApiClient.OnConnectionFailedListener,
DataApi.DataListener {
    private static final int LATCH_TIMEOUT_MSEC = 60000;
    protected String requestID;
    protected DataMap mDataMap;
    private CountDownLatch mInTimeCountDownLatch;
    private final GoogleApiClient mGoogleApiClient;

    protected WearableDataConnection(Context context) {
        this.mGoogleApiClient = new GoogleApiClient.Builder(context).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).addApi(Wearable.API).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WearableDataResponse send(WearableDataRequest wearableDataRequest) {
        WearableDataResponse response;
        if (!this.connect(wearableDataRequest.getTimeOut())) {
            return null;
        }
        Wearable.DataApi.addListener(this.mGoogleApiClient, (DataApi.DataListener)this);
        this.requestID = wearableDataRequest.getUUID();
        PutDataMapRequest dataMapRequest = PutDataMapRequest.create((String)"/abdmobile/data/request");
        DataMap dataMap = dataMapRequest.getDataMap();
        dataMap.putAll(wearableDataRequest.getDataMap());
        PutDataRequest putDataRequest = dataMapRequest.asPutDataRequest();
        this.mInTimeCountDownLatch = new CountDownLatch(1);
        Wearable.DataApi.putDataItem(this.mGoogleApiClient, putDataRequest);
        try {
            if (!this.mInTimeCountDownLatch.await(60000 + wearableDataRequest.getTimeOut(), TimeUnit.MILLISECONDS)) {
                StaticMethods.logWarningFormat("Wearable - Failed to get data from handheld app", new Object[0]);
                WearableDataResponse wearableDataResponse = null;
                return wearableDataResponse;
            }
            response = this.getResponse();
        }
        catch (InterruptedException e) {
            StaticMethods.logWarningFormat("Wearable - Failed to get data from handheld app", new Object[0]);
            response = null;
        }
        finally {
            Wearable.DataApi.removeListener(this.mGoogleApiClient, (DataApi.DataListener)this);
            GoogleApiClientWrapper.disconnect(this.mGoogleApiClient);
        }
        return response;
    }

    private boolean connect(int timeOut) {
        GoogleApiClientWrapper.connect(this.mGoogleApiClient);
        if (!this.waitForConnect(timeOut)) {
            StaticMethods.logWarningFormat("Wearable - Timeout setup connection", new Object[0]);
            return false;
        }
        if (!this.hasNodes()) {
            StaticMethods.logWarningFormat("Wearable - No connected Node found", new Object[0]);
            return false;
        }
        return true;
    }

    public void onDataChanged(DataEventBuffer dataEvents) {
        for (DataEvent event : dataEvents) {
            DataMap returnedDataMap;
            Uri uri;
            if (event.getType() != 1) {
                return;
            }
            DataItem item = event.getDataItem();
            if (item == null || (uri = item.getUri()) == null || uri.getPath() == null || uri.getPath().compareTo("/abdmobile/data/response") != 0 || (returnedDataMap = DataMapItem.fromDataItem((DataItem)event.getDataItem()).getDataMap()) == null || !returnedDataMap.containsKey("ID") || !returnedDataMap.getString("ID").equals(this.requestID)) continue;
            this.mDataMap = returnedDataMap;
            this.mInTimeCountDownLatch.countDown();
            return;
        }
    }

    private boolean waitForConnect(int timeOut) {
        if (GoogleApiClientWrapper.isConnected(this.mGoogleApiClient).booleanValue()) {
            return true;
        }
        ConnectionResult connectionResult = GoogleApiClientWrapper.blockingConnect(this.mGoogleApiClient, timeOut, TimeUnit.MILLISECONDS);
        return connectionResult != null && connectionResult.isSuccess();
    }

    private boolean hasNodes() {
        PendingResult result = Wearable.NodeApi.getConnectedNodes(this.mGoogleApiClient);
        Result awaitResult = GoogleApiClientWrapper.await(result);
        NodeApi.GetConnectedNodesResult nodes = awaitResult instanceof NodeApi.GetConnectedNodesResult ? (NodeApi.GetConnectedNodesResult)awaitResult : null;
        return nodes != null && nodes.getNodes() != null && nodes.getNodes().size() > 0;
    }

    protected WearableDataResponse getResponse() {
        if (this.mDataMap == null) {
            return null;
        }
        return WearableDataResponse.createResponseFromDataMap(this.mDataMap, this.mGoogleApiClient);
    }

    public void onConnectionFailed(ConnectionResult result) {
    }
}

