/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import com.adobe.mobile.AudienceManagerWorker;
import com.adobe.mobile.MobileConfig;
import com.adobe.mobile.StaticMethods;
import com.adobe.mobile.TargetPrefetchObject;
import com.adobe.mobile.TargetPreviewManager;
import com.adobe.mobile.TargetRequestObject;
import com.adobe.mobile.TargetWorker;
import com.adobe.mobile.Visitor;
import com.adobe.mobile.VisitorID;
import com.adobe.mobile.VisitorIDService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class TargetJsonBuilder {
    TargetJsonBuilder() {
    }

    protected static JSONObject getRequestPayload(List<TargetPrefetchObject> prefetchArray, List<TargetRequestObject> batchRequest, Map<String, Object> profileParameters, List<JSONObject> notifications, Map<String, Object> targetInternalParameters) throws JSONException {
        JSONArray mBoxParamNode;
        JSONArray prefetchMboxesNode;
        JSONObject parametersJson = TargetJsonBuilder.getDefaultJsonObject();
        JSONObject profileParamNode = TargetJsonBuilder.getProfileParameters(profileParameters);
        if (profileParamNode != null && profileParamNode.length() > 0) {
            parametersJson.put("profileParameters", (Object)profileParamNode);
        }
        if ((prefetchMboxesNode = TargetJsonBuilder.getPrefetchMboxes(prefetchArray, targetInternalParameters)) != null && prefetchMboxesNode.length() > 0) {
            parametersJson.put("prefetch", (Object)prefetchMboxesNode);
        }
        if (notifications != null && !notifications.isEmpty()) {
            JSONArray notificationArray = new JSONArray();
            for (JSONObject eachNotification : notifications) {
                notificationArray.put((Object)eachNotification);
            }
            parametersJson.put("notifications", (Object)notificationArray);
        }
        if ((mBoxParamNode = TargetJsonBuilder.getRequestedMboxJSON(batchRequest, targetInternalParameters)) != null && mBoxParamNode.length() > 0) {
            parametersJson.put("mboxes", (Object)mBoxParamNode);
        }
        JSONObject newParametersJSON = TargetJsonBuilder.addPreviewParameters(parametersJson);
        return newParametersJSON;
    }

    protected static JSONObject getNotificationsJsonObject(JSONObject cachedMboxJson, TargetRequestObject requestObject, Map<String, Object> internalParameters) {
        if (cachedMboxJson == null) {
            return null;
        }
        try {
            JSONObject requestLocationNode;
            JSONObject productNode;
            JSONObject orderDetailsJson;
            JSONObject visitedMboxNode = new JSONObject(cachedMboxJson.toString());
            JSONObject visitedMboxNodeUpdated = TargetJsonBuilder.updateNotificationJson(visitedMboxNode);
            visitedMboxNodeUpdated.remove("clickToken");
            visitedMboxNodeUpdated.put("type", (Object)"hit");
            JSONObject mboxParametersJson = TargetJsonBuilder.getMboxParameters(requestObject.getMboxParameters(), internalParameters);
            if (mboxParametersJson != null && mboxParametersJson.length() > 0) {
                visitedMboxNodeUpdated.put("parameters", (Object)mboxParametersJson);
            }
            if ((orderDetailsJson = TargetJsonBuilder.getOrderParameters(requestObject.getOrderParameters())) != null && orderDetailsJson.length() > 0) {
                visitedMboxNodeUpdated.put("order", (Object)orderDetailsJson);
            }
            if ((productNode = TargetJsonBuilder.getProductParameters(requestObject.getProductParameters())) != null && productNode.length() > 0) {
                visitedMboxNodeUpdated.put("product", (Object)productNode);
            }
            if ((requestLocationNode = TargetJsonBuilder.getRequestLocationParameters(requestObject.getRequestLocationParameters())) != null && requestLocationNode.length() > 0) {
                visitedMboxNodeUpdated.put("requestLocation", (Object)requestLocationNode);
            }
            return visitedMboxNodeUpdated;
        }
        catch (JSONException exception) {
            StaticMethods.logWarningFormat("Target - failed to create notification Json Node for %s", cachedMboxJson.toString());
            return null;
        }
    }

    protected static JSONObject getClickNotificationJsonObject(JSONObject cachedMboxJson, Map<String, Object> mboxParameters, Map<String, Object> orderParameters, Map<String, Object> productParameters, Map<String, Object> internalParameters) {
        if (cachedMboxJson == null) {
            return null;
        }
        try {
            JSONObject productNode;
            JSONObject orderDetailsJson;
            JSONObject notificationJson = new JSONObject(cachedMboxJson.toString());
            JSONObject notificationJsonUpdated = TargetJsonBuilder.updateNotificationJson(notificationJson);
            notificationJsonUpdated.remove("eventTokens");
            notificationJsonUpdated.put("type", (Object)"click");
            JSONObject mboxParametersJson = TargetJsonBuilder.getMboxParameters(mboxParameters, internalParameters);
            if (mboxParametersJson != null && mboxParametersJson.length() > 0) {
                notificationJsonUpdated.put("parameters", (Object)mboxParametersJson);
            }
            if ((orderDetailsJson = TargetJsonBuilder.getOrderParameters(orderParameters)) != null && orderDetailsJson.length() > 0) {
                notificationJsonUpdated.put("order", (Object)orderDetailsJson);
            }
            if ((productNode = TargetJsonBuilder.getProductParameters(productParameters)) != null && productNode.length() > 0) {
                notificationJsonUpdated.put("product", (Object)productNode);
            }
            return notificationJsonUpdated;
        }
        catch (JSONException exception) {
            StaticMethods.logWarningFormat("Target - failed to create JSON object for location click notification (%s)", cachedMboxJson.toString());
            return null;
        }
    }

    private static JSONObject updateNotificationJson(JSONObject notificationJson) throws JSONException {
        JSONObject notificationJsonCopy = new JSONObject(notificationJson.toString());
        notificationJsonCopy.put("timestamp", System.currentTimeMillis());
        notificationJsonCopy.remove("content");
        notificationJsonCopy.remove("clientSideAnalyticsLoggingPayload");
        notificationJsonCopy.remove("errorType");
        notificationJsonCopy.remove("parameters");
        notificationJsonCopy.remove("order");
        notificationJsonCopy.remove("product");
        return notificationJsonCopy;
    }

    private static JSONObject getDefaultJsonObject() throws JSONException {
        List<VisitorID> customerIDs;
        String marketingCloudID;
        String thirdPartyId;
        String dpid;
        String dpuuid;
        long environmentID;
        JSONObject parametersJson = new JSONObject();
        parametersJson.put("client", (Object)MobileConfig.getInstance().getClientCode());
        parametersJson.put("contentAsJson", false);
        if (MobileConfig.getInstance().mobileUsingTarget() && (environmentID = MobileConfig.getInstance().getEnvironmentID()) != 0L) {
            parametersJson.put("environmentId", environmentID);
        }
        JSONObject aamParametersNode = new JSONObject();
        HashMap<String, Object> aamParams = VisitorIDService.sharedInstance().getTargetParameterMap();
        if (aamParams != null && !aamParams.isEmpty()) {
            for (Map.Entry param : aamParams.entrySet()) {
                aamParametersNode.put((String)param.getKey(), param.getValue());
            }
        }
        if (!TargetJsonBuilder.isNullOrEmpty(dpuuid = AudienceManagerWorker.GetDpuuid())) {
            aamParametersNode.put("dataPartnerUserId", (Object)dpuuid);
        }
        if (!TargetJsonBuilder.isNullOrEmpty(dpid = AudienceManagerWorker.GetDpid())) {
            aamParametersNode.put("dataPartnerId", (Object)dpid);
        }
        String uuid = null;
        try {
            uuid = StaticMethods.getSharedPreferences().getString("AAMUserId", null);
        }
        catch (StaticMethods.NullContextException e) {
            StaticMethods.logDebugFormat("Target - Error getting uuid from shared preferences (%s).", e.getMessage());
        }
        if (!TargetJsonBuilder.isNullOrEmpty(uuid)) {
            aamParametersNode.put("uuid", (Object)uuid);
        }
        if (aamParametersNode.length() > 0) {
            parametersJson.put("aamParameters", (Object)aamParametersNode);
        }
        JSONObject idNode = new JSONObject();
        String tntId = TargetWorker.getTntId();
        if (!TargetJsonBuilder.isNullOrEmpty(tntId)) {
            idNode.put("tntId", (Object)tntId);
        }
        if (!TargetJsonBuilder.isNullOrEmpty(thirdPartyId = TargetWorker.getThirdPartyId())) {
            idNode.put("thirdPartyId", (Object)thirdPartyId);
        }
        if (!TargetJsonBuilder.isNullOrEmpty(marketingCloudID = VisitorIDService.sharedInstance().getMarketingCloudID())) {
            idNode.put("marketingCloudVisitorId", (Object)marketingCloudID);
        }
        if ((customerIDs = Visitor.getIdentifiers()) != null && !customerIDs.isEmpty()) {
            idNode.put("customerIds", (Object)TargetJsonBuilder.getCustomerIDs(customerIDs));
        }
        if (idNode.length() > 0) {
            parametersJson.put("id", (Object)idNode);
        }
        return parametersJson;
    }

    private static JSONArray getRequestedMboxJSON(List<TargetRequestObject> batchRequest, Map<String, Object> targetInternalParameters) throws JSONException {
        JSONArray mBoxArrayNode = new JSONArray();
        long index = 0L;
        if (batchRequest == null) {
            return null;
        }
        for (TargetRequestObject eachRequest : batchRequest) {
            try {
                JSONObject requestLocationNode;
                JSONObject productNode;
                JSONObject mboxParametersJson;
                JSONObject mboxJson = new JSONObject();
                mboxJson.put("indexId", index);
                mboxJson.put("mbox", (Object)eachRequest.getMboxName());
                JSONObject orderDetailsJson = TargetJsonBuilder.getOrderParameters(eachRequest.getOrderParameters());
                if (orderDetailsJson != null && orderDetailsJson.length() > 0) {
                    mboxJson.put("order", (Object)orderDetailsJson);
                }
                if ((mboxParametersJson = TargetJsonBuilder.getMboxParameters(eachRequest.getMboxParameters(), targetInternalParameters)) != null && mboxParametersJson.length() > 0) {
                    mboxJson.put("parameters", (Object)mboxParametersJson);
                }
                if ((productNode = TargetJsonBuilder.getProductParameters(eachRequest.getProductParameters())) != null && productNode.length() > 0) {
                    mboxJson.put("product", (Object)productNode);
                }
                if ((requestLocationNode = TargetJsonBuilder.getRequestLocationParameters(eachRequest.getRequestLocationParameters())) != null && requestLocationNode.length() > 0) {
                    mboxJson.put("requestLocation", (Object)requestLocationNode);
                }
                mBoxArrayNode.put((Object)mboxJson);
                ++index;
            }
            catch (JSONException exception) {
                StaticMethods.logWarningFormat("Target - failed to create Json Node for mbox %s", eachRequest.getMboxName());
            }
        }
        return mBoxArrayNode;
    }

    private static JSONObject getProfileParameters(Map<String, Object> customerParams) {
        return TargetJsonBuilder.getJsonObjectFromMap(customerParams);
    }

    private static JSONArray getCustomerIDs(List<VisitorID> customerIDs) throws JSONException {
        JSONArray customerIDsArrayNode = new JSONArray();
        for (VisitorID visitorID : customerIDs) {
            JSONObject newVisitorIDNode = new JSONObject();
            newVisitorIDNode.put("id", (Object)visitorID.id);
            newVisitorIDNode.put("integrationCode", (Object)visitorID.idType);
            newVisitorIDNode.put("authenticatedState", (Object)visitorID.authenticationState.getTextValue());
            customerIDsArrayNode.put((Object)newVisitorIDNode);
        }
        return customerIDsArrayNode;
    }

    private static JSONArray getPrefetchMboxes(List<TargetPrefetchObject> prefetchArray, Map<String, Object> targetInternalParameters) {
        JSONArray prefetchMboxesArrayNode = new JSONArray();
        long index = 0L;
        if (prefetchArray == null) {
            return null;
        }
        for (TargetPrefetchObject param : prefetchArray) {
            try {
                JSONObject productNode;
                JSONObject orderNode;
                JSONObject prefetchMboxNode = new JSONObject();
                prefetchMboxNode.put("indexId", index);
                prefetchMboxNode.put("mbox", (Object)param.getMboxName());
                JSONObject mboxParametersNode = TargetJsonBuilder.getMboxParameters(param.getMboxParameters(), targetInternalParameters);
                if (mboxParametersNode != null && mboxParametersNode.length() > 0) {
                    prefetchMboxNode.put("parameters", (Object)mboxParametersNode);
                }
                if ((orderNode = TargetJsonBuilder.getOrderParameters(param.getOrderParameters())) != null && orderNode.length() > 0) {
                    prefetchMboxNode.put("order", (Object)orderNode);
                }
                if ((productNode = TargetJsonBuilder.getProductParameters(param.getProductParameters())) != null && productNode.length() > 0) {
                    prefetchMboxNode.put("product", (Object)productNode);
                }
                prefetchMboxesArrayNode.put((Object)prefetchMboxNode);
                ++index;
            }
            catch (JSONException exception) {
                StaticMethods.logWarningFormat("Target - failed to create Json Node for mbox %s", param.getMboxName());
            }
        }
        return prefetchMboxesArrayNode;
    }

    private static JSONObject getMboxParameters(Map<String, Object> mboxParameters, Map<String, Object> targetInternalParameters) {
        JSONObject mboxParametersJson = TargetJsonBuilder.getJsonObjectFromMap(mboxParameters);
        if (mboxParametersJson == null) {
            mboxParametersJson = new JSONObject();
        }
        try {
            if (targetInternalParameters != null && !targetInternalParameters.isEmpty()) {
                for (Map.Entry<String, Object> param : targetInternalParameters.entrySet()) {
                    mboxParametersJson.put(param.getKey(), param.getValue());
                }
            }
        }
        catch (JSONException exception) {
            StaticMethods.logWarningFormat("Target - Failed to append target internal parameters to the target request json (%s)", new Object[]{exception});
        }
        return mboxParametersJson;
    }

    private static JSONObject getOrderParameters(Map<String, Object> orderParams) {
        Object orderTotal;
        if (orderParams == null || orderParams.size() <= 0) {
            return null;
        }
        JSONObject orderJson = new JSONObject();
        Object orderId = orderParams.get("id");
        if (orderId == null || orderId.toString().isEmpty()) {
            orderId = orderParams.get("orderId");
        }
        if ((orderTotal = orderParams.get("total")) == null || orderTotal.toString().isEmpty()) {
            orderTotal = orderParams.get("orderTotal");
        }
        Object products = orderParams.get("purchasedProductIds");
        try {
            if (orderId != null && !orderId.toString().isEmpty()) {
                orderJson.put("id", (Object)orderId.toString());
            }
            if (orderTotal != null && !orderTotal.toString().isEmpty()) {
                try {
                    double orderTotalDouble = Double.parseDouble(orderTotal.toString());
                    orderJson.put("total", orderTotalDouble);
                }
                catch (NumberFormatException ex) {
                    StaticMethods.logWarningFormat("Target - NumberFormatException while creating order details (%s)", ex.getLocalizedMessage());
                }
            }
            if (products instanceof List) {
                try {
                    List productIdsArray = (List)products;
                    List<String> cleanedProductIDs = TargetJsonBuilder.cleanProductArrayToHaveOnlyStrings(productIdsArray);
                    if (cleanedProductIDs != null && !cleanedProductIDs.isEmpty()) {
                        JSONArray productsJson = new JSONArray(cleanedProductIDs);
                        orderJson.put("purchasedProductIds", (Object)productsJson);
                    }
                }
                catch (Exception exp) {
                    StaticMethods.logWarningFormat("Target - Unable to process productID's .Should be of type ArrayList<String>", new Object[0]);
                }
            } else if (products instanceof String) {
                if (products != null && !products.toString().isEmpty()) {
                    String[] productsList = products.toString().split(",");
                    JSONArray productsJson = new JSONArray();
                    for (String product : productsList) {
                        productsJson.put((Object)product.trim());
                    }
                    orderJson.put("purchasedProductIds", (Object)productsJson);
                    StaticMethods.logWarningFormat("Target - Deprecated type for productPurchaseID. Use List<String> instead of comma separated array string", new Object[0]);
                }
            } else {
                StaticMethods.logWarningFormat("Target -Unknown type for order productID's. Should be either comma seperated string or arraylist ", new Object[0]);
            }
            return orderJson;
        }
        catch (JSONException ex) {
            StaticMethods.logWarningFormat("Target - JSONException while creating order details (%s)", ex.getLocalizedMessage());
            return null;
        }
    }

    private static JSONObject getProductParameters(Map<String, Object> productParams) {
        if (productParams == null || productParams.isEmpty()) {
            return null;
        }
        JSONObject productNode = new JSONObject();
        try {
            Object productCategoryId;
            Object productId = productParams.get("id");
            if (productId != null) {
                productNode.put("id", (Object)productId.toString());
            }
            if ((productCategoryId = productParams.get("categoryId")) != null) {
                productNode.put("categoryId", (Object)productCategoryId.toString());
            }
        }
        catch (JSONException exception) {
            StaticMethods.logWarningFormat("Target - Failed to append product parameters to the target request json (%s)", new Object[]{exception});
            return null;
        }
        return productNode;
    }

    private static JSONObject getRequestLocationParameters(Map<String, Object> requestLocationParams) {
        if (requestLocationParams == null || requestLocationParams.isEmpty()) {
            return null;
        }
        return TargetJsonBuilder.getJsonObjectFromMap(requestLocationParams);
    }

    private static JSONObject getJsonObjectFromMap(Map<String, Object> params) {
        try {
            JSONObject parametersJson = new JSONObject();
            if (params != null && !params.isEmpty()) {
                for (Map.Entry<String, Object> param : params.entrySet()) {
                    if (param.getKey() == null) continue;
                    parametersJson.put(param.getKey(), param.getValue());
                }
            }
            return parametersJson;
        }
        catch (JSONException ex) {
            StaticMethods.logWarningFormat("Target - Error adding parameters to JSON Object (%s)", ex.getLocalizedMessage());
            return null;
        }
    }

    private static boolean isNullOrEmpty(String param) {
        return param == null || param.isEmpty();
    }

    private static JSONObject addPreviewParameters(JSONObject parametersJson) {
        JSONObject targetRequestParameters = parametersJson;
        if (TargetPreviewManager.getInstance().getToken() != null && TargetPreviewManager.getInstance().getPreviewParams() != null) {
            try {
                JSONObject params = new JSONObject(TargetPreviewManager.getInstance().getPreviewParams());
                Iterator keys = params.keys();
                if (keys != null) {
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        targetRequestParameters.put(key, params.get(key));
                    }
                }
            }
            catch (Exception e) {
                StaticMethods.logErrorFormat("Target - Could not compile the target preview params with the Target request! (%s)", e);
            }
        }
        return targetRequestParameters;
    }

    private static List<String> cleanProductArrayToHaveOnlyStrings(List productsArray) {
        ArrayList<String> cleanArray = new ArrayList<String>();
        for (Object eachID : productsArray) {
            if (eachID instanceof String) {
                cleanArray.add(eachID.toString());
                continue;
            }
            StaticMethods.logErrorFormat("Target - Unknown Format of purchased Product ID (%s). Should be String", eachID);
        }
        return cleanArray;
    }
}

