/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import com.adobe.mobile.MessageMatcherContains;
import com.adobe.mobile.MessageMatcherEndsWith;
import com.adobe.mobile.MessageMatcherEquals;
import com.adobe.mobile.MessageMatcherExists;
import com.adobe.mobile.MessageMatcherGreaterThan;
import com.adobe.mobile.MessageMatcherGreaterThanOrEqual;
import com.adobe.mobile.MessageMatcherLessThan;
import com.adobe.mobile.MessageMatcherLessThanOrEqual;
import com.adobe.mobile.MessageMatcherNotContains;
import com.adobe.mobile.MessageMatcherNotEquals;
import com.adobe.mobile.MessageMatcherNotExists;
import com.adobe.mobile.MessageMatcherStartsWith;
import com.adobe.mobile.MessageMatcherUnknown;
import com.adobe.mobile.StaticMethods;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

abstract class MessageMatcher {
    protected String key;
    protected ArrayList<Object> values;
    private static final String MESSAGE_JSON_KEY = "key";
    private static final String MESSAGE_JSON_MATCHES = "matches";
    private static final String MESSAGE_JSON_VALUES = "values";
    private static final String MESSAGE_MATCHER_STRING_EQUALS = "eq";
    private static final String MESSAGE_MATCHER_STRING_NOT_EQUALS = "ne";
    private static final String MESSAGE_MATCHER_STRING_GREATER_THAN = "gt";
    private static final String MESSAGE_MATCHER_STRING_GREATER_THAN_OR_EQUALS = "ge";
    private static final String MESSAGE_MATCHER_STRING_LESS_THAN = "lt";
    private static final String MESSAGE_MATCHER_STRING_LESS_THAN_OR_EQUALS = "le";
    private static final String MESSAGE_MATCHER_STRING_CONTAINS = "co";
    private static final String MESSAGE_MATCHER_STRING_NOT_CONTAINS = "nc";
    private static final String MESSAGE_MATCHER_STRING_STARTS_WITH = "sw";
    private static final String MESSAGE_MATCHER_STRING_ENDS_WITH = "ew";
    private static final String MESSAGE_MATCHER_STRING_EXISTS = "ex";
    private static final String MESSAGE_MATCHER_STRING_NOT_EXISTS = "nx";
    private static final Map<String, Class> _messageMatcherDictionary = new HashMap<String, Class>(){
        {
            this.put(MessageMatcher.MESSAGE_MATCHER_STRING_EQUALS, MessageMatcherEquals.class);
            this.put(MessageMatcher.MESSAGE_MATCHER_STRING_NOT_EQUALS, MessageMatcherNotEquals.class);
            this.put(MessageMatcher.MESSAGE_MATCHER_STRING_GREATER_THAN, MessageMatcherGreaterThan.class);
            this.put(MessageMatcher.MESSAGE_MATCHER_STRING_GREATER_THAN_OR_EQUALS, MessageMatcherGreaterThanOrEqual.class);
            this.put(MessageMatcher.MESSAGE_MATCHER_STRING_LESS_THAN, MessageMatcherLessThan.class);
            this.put(MessageMatcher.MESSAGE_MATCHER_STRING_LESS_THAN_OR_EQUALS, MessageMatcherLessThanOrEqual.class);
            this.put(MessageMatcher.MESSAGE_MATCHER_STRING_CONTAINS, MessageMatcherContains.class);
            this.put(MessageMatcher.MESSAGE_MATCHER_STRING_NOT_CONTAINS, MessageMatcherNotContains.class);
            this.put(MessageMatcher.MESSAGE_MATCHER_STRING_STARTS_WITH, MessageMatcherStartsWith.class);
            this.put(MessageMatcher.MESSAGE_MATCHER_STRING_ENDS_WITH, MessageMatcherEndsWith.class);
            this.put(MessageMatcher.MESSAGE_MATCHER_STRING_EXISTS, MessageMatcherExists.class);
            this.put(MessageMatcher.MESSAGE_MATCHER_STRING_NOT_EXISTS, MessageMatcherNotExists.class);
        }
    };

    MessageMatcher() {
    }

    protected static MessageMatcher messageMatcherWithJsonObject(JSONObject dictionary) {
        String matcherString;
        MessageMatcher matcher = null;
        try {
            matcherString = dictionary.getString(MESSAGE_JSON_MATCHES);
            if (matcherString != null && matcherString.length() <= 0) {
                StaticMethods.logWarningFormat("Messages - message matcher type is empty", new Object[0]);
            }
        }
        catch (JSONException ex) {
            matcherString = "UNKNOWN";
            StaticMethods.logWarningFormat("Messages - message matcher type is required", new Object[0]);
        }
        Class<MessageMatcherUnknown> matcherClass = _messageMatcherDictionary.get(matcherString);
        if (matcherClass == null) {
            matcherClass = MessageMatcherUnknown.class;
            StaticMethods.logWarningFormat("Messages - message matcher type \"%s\" is invalid", matcherString);
        }
        try {
            matcher = (MessageMatcher)matcherClass.newInstance();
        }
        catch (InstantiationException ex) {
            StaticMethods.logErrorFormat("Messages - Error creating matcher (%s)", ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            StaticMethods.logErrorFormat("Messages - Error creating matcher (%s)", ex.getMessage());
        }
        if (matcher != null) {
            try {
                matcher.key = dictionary.getString(MESSAGE_JSON_KEY).toLowerCase();
                if (matcher.key != null && matcher.key.length() <= 0) {
                    StaticMethods.logWarningFormat("Messages - error creating matcher, key is empty", new Object[0]);
                }
            }
            catch (JSONException ex) {
                StaticMethods.logWarningFormat("Messages - error creating matcher, key is required", new Object[0]);
            }
            catch (NullPointerException ex) {
                StaticMethods.logWarningFormat("Messages - error creating matcher, key is required", new Object[0]);
            }
            try {
                matcher.values = new ArrayList();
                if (matcher instanceof MessageMatcherExists) {
                    return matcher;
                }
                JSONArray jsonArray = dictionary.getJSONArray(MESSAGE_JSON_VALUES);
                int arrayLength = jsonArray.length();
                for (int i = 0; i < arrayLength; ++i) {
                    matcher.values.add(jsonArray.get(i));
                }
                if (matcher.values.size() == 0) {
                    StaticMethods.logWarningFormat("Messages - error creating matcher, values is empty", new Object[0]);
                }
            }
            catch (JSONException ex) {
                StaticMethods.logWarningFormat("Messages - error creating matcher, values is required", new Object[0]);
            }
        }
        return matcher;
    }

    protected boolean matchesInMaps(Map<String, Object> ... maps) {
        if (maps == null || maps.length <= 0) {
            return false;
        }
        Object value = null;
        for (Map<String, Object> map : maps) {
            if (map == null || !map.containsKey(this.key)) continue;
            value = map.get(this.key);
            break;
        }
        return value != null && this.matches(value);
    }

    protected boolean matches(Object value) {
        return false;
    }

    protected Double tryParseDouble(Object value) {
        try {
            return Double.valueOf(value.toString());
        }
        catch (Exception ex) {
            return null;
        }
    }
}

