/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.adobe.mobile.AnalyticsTrackLifetimeValueIncrease;
import com.adobe.mobile.Message;
import com.adobe.mobile.MessageFullScreenActivity;
import com.adobe.mobile.Messages;
import com.adobe.mobile.MobileConfig;
import com.adobe.mobile.MobilePrivacyStatus;
import com.adobe.mobile.RemoteDownload;
import com.adobe.mobile.StaticMethods;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class MessageFullScreen
extends Message {
    protected String html;
    protected String replacedHtml;
    protected WebView webView;
    protected Activity messageFullScreenActivity;
    protected ViewGroup rootViewGroup;
    protected boolean shouldSendAnalyticsHitsOnInteractions = true;
    protected static final String JSON_CONFIG_HTML = "html";
    protected static final String MESSAGE_SCHEME = "adbinapp";
    protected static final String MESSAGE_SCHEME_PATH_CANCEL = "cancel";
    protected static final String MESSAGE_SCHEME_PATH_CONFIRM = "confirm";

    MessageFullScreen() {
    }

    @Override
    protected boolean initWithPayloadObject(JSONObject dictionary) {
        JSONObject jsonPayload;
        if (dictionary == null || dictionary.length() <= 0) {
            return false;
        }
        if (!super.initWithPayloadObject(dictionary)) {
            return false;
        }
        try {
            jsonPayload = dictionary.getJSONObject("payload");
            if (jsonPayload.length() <= 0) {
                StaticMethods.logDebugFormat("Messages - Unable to create fullscreen message \"%s\", payload is empty", this.messageId);
                return false;
            }
        }
        catch (JSONException ex) {
            StaticMethods.logDebugFormat("Messages - Unable to create fullscreen message \"%s\", payload is required", this.messageId);
            return false;
        }
        try {
            this.html = jsonPayload.getString(JSON_CONFIG_HTML);
            if (this.html.length() <= 0) {
                StaticMethods.logDebugFormat("Messages - Unable to create fullscreen message \"%s\", html is empty", this.messageId);
                return false;
            }
        }
        catch (JSONException ex) {
            StaticMethods.logDebugFormat("Messages - Unable to create fullscreen message \"%s\", html is required", this.messageId);
            return false;
        }
        try {
            JSONArray assetsArray = jsonPayload.getJSONArray("assets");
            if (assetsArray != null && assetsArray.length() > 0) {
                this.assets = new ArrayList();
                int count = assetsArray.length();
                for (int i = 0; i < count; ++i) {
                    JSONArray currentAssetJson = assetsArray.getJSONArray(i);
                    if (currentAssetJson == null || currentAssetJson.length() <= 0) continue;
                    ArrayList<String> currentAsset = new ArrayList<String>();
                    int innerCount = currentAssetJson.length();
                    for (int j = 0; j < innerCount; ++j) {
                        currentAsset.add(currentAssetJson.getString(j));
                    }
                    this.assets.add(currentAsset);
                }
            }
        }
        catch (JSONException ex) {
            StaticMethods.logDebugFormat("Messages - No assets found for fullscreen message \"%s\"", this.messageId);
        }
        return true;
    }

    protected void showInRootViewGroup() {
        int currentOrientation = StaticMethods.getCurrentOrientation();
        if (this.isVisible && this.orientationWhenShown == currentOrientation) {
            return;
        }
        this.orientationWhenShown = currentOrientation;
        Handler mainHandler = new Handler(Looper.getMainLooper());
        mainHandler.post((Runnable)this.getNewMessageFullScreenRunner(this));
    }

    protected void setShouldSendAnalyticsHitsOnInteractions(boolean send) {
        this.shouldSendAnalyticsHitsOnInteractions = send;
    }

    @Override
    protected void show() {
        Activity currentActivity;
        try {
            currentActivity = StaticMethods.getCurrentActivity();
        }
        catch (StaticMethods.NullActivityException ex) {
            StaticMethods.logErrorFormat(ex.getMessage(), new Object[0]);
            return;
        }
        super.show();
        if (this.shouldSendAnalyticsHitsOnInteractions) {
            this.messageTriggered();
        }
        Messages.setCurrentMessageFullscreen(this);
        HashMap<String, String> imageTokens = new HashMap<String, String>();
        if (this.assets != null && this.assets.size() > 0) {
            for (ArrayList currentAssetArray : this.assets) {
                int currentAssetArrayCount = currentAssetArray.size();
                if (currentAssetArrayCount <= 0) continue;
                String assetUrl = (String)currentAssetArray.get(0);
                String assetValue = null;
                for (String currentAsset : currentAssetArray) {
                    File imageFile = RemoteDownload.getFileForCachedURL(currentAsset, "messageImages");
                    if (imageFile == null) continue;
                    assetValue = imageFile.toURI().toString();
                    break;
                }
                if (assetValue == null) {
                    boolean isLocalImage;
                    String lastAsset = (String)currentAssetArray.get(currentAssetArrayCount - 1);
                    boolean bl = isLocalImage = !RemoteDownload.stringIsUrl(lastAsset);
                    if (isLocalImage) {
                        assetValue = lastAsset;
                    }
                }
                if (assetValue == null) continue;
                imageTokens.put(assetUrl, assetValue);
            }
        }
        this.replacedHtml = StaticMethods.expandTokens(this.html, imageTokens);
        try {
            Intent fullscreen = new Intent(currentActivity.getApplicationContext(), MessageFullScreenActivity.class);
            fullscreen.addFlags(65536);
            currentActivity.startActivity(fullscreen);
            currentActivity.overridePendingTransition(0, 0);
        }
        catch (ActivityNotFoundException ex) {
            StaticMethods.logWarningFormat("Messages - Must declare MessageFullScreenActivity in AndroidManifest.xml in order to show full screen messages (%s)", ex.getMessage());
        }
    }

    protected MessageFullScreenWebViewClient getMessageFullScreenWebViewClient() {
        return new MessageFullScreenWebViewClient(this);
    }

    protected MessageFullScreenRunner getNewMessageFullScreenRunner(MessageFullScreen messageFullScreen) {
        return new MessageFullScreenRunner(messageFullScreen);
    }

    private static void killMessageActivity(MessageFullScreen message) {
        message.messageFullScreenActivity.finish();
        message.messageFullScreenActivity.overridePendingTransition(0, 0);
        message.isVisible = false;
    }

    protected static class MessageFullScreenWebViewClient
    extends WebViewClient {
        protected MessageFullScreen message;

        protected MessageFullScreenWebViewClient(MessageFullScreen message) {
            this.message = message;
        }

        protected void dismissMessage(WebView view) {
            if (this.message.rootViewGroup == null) {
                StaticMethods.logErrorFormat("Messages - unable to get root view group from os", new Object[0]);
                return;
            }
            TranslateAnimation animation = new TranslateAnimation(0.0f, 0.0f, 0.0f, (float)this.message.rootViewGroup.getMeasuredHeight());
            animation.setDuration(300L);
            animation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationEnd(Animation animation) {
                    MessageFullScreen.killMessageActivity(MessageFullScreenWebViewClient.this.message);
                }

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            view.setAnimation((Animation)animation);
            this.message.rootViewGroup.removeView((View)view);
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (!url.startsWith(MessageFullScreen.MESSAGE_SCHEME)) {
                return true;
            }
            if (url.contains(MessageFullScreen.MESSAGE_SCHEME_PATH_CANCEL)) {
                if (this.message.shouldSendAnalyticsHitsOnInteractions) {
                    this.message.viewed();
                }
                this.dismissMessage(view);
            } else if (url.contains(MessageFullScreen.MESSAGE_SCHEME_PATH_CONFIRM)) {
                if (this.message.shouldSendAnalyticsHitsOnInteractions) {
                    this.message.clickedThrough();
                }
                this.dismissMessage(view);
                int customUrlRange = url.indexOf("url=");
                if (customUrlRange < 0) {
                    return true;
                }
                String customUrl = url.substring(customUrlRange + 4);
                if (customUrl == null || customUrl.isEmpty()) {
                    return true;
                }
                HashMap<String, String> urlTokens = this.message.buildExpansionsForTokens(this.message.findTokensForExpansion(customUrl), true);
                urlTokens.put("{userId}", "0");
                urlTokens.put("{trackingId}", "0");
                urlTokens.put("{messageId}", this.message.messageId);
                urlTokens.put("{lifetimeValue}", AnalyticsTrackLifetimeValueIncrease.getLifetimeValue().toString());
                if (MobileConfig.getInstance().getPrivacyStatus() == MobilePrivacyStatus.MOBILE_PRIVACY_STATUS_OPT_IN) {
                    urlTokens.put("{userId}", StaticMethods.getVisitorID() == null ? "" : StaticMethods.getVisitorID());
                    urlTokens.put("{trackingId}", StaticMethods.getAID() == null ? "" : StaticMethods.getAID());
                }
                if ((customUrl = StaticMethods.expandTokens(customUrl, urlTokens)) != null && !customUrl.isEmpty()) {
                    try {
                        Intent intent = new Intent("android.intent.action.VIEW");
                        intent.setData(Uri.parse((String)customUrl));
                        this.message.messageFullScreenActivity.startActivity(intent);
                    }
                    catch (Exception ex) {
                        StaticMethods.logDebugFormat("Messages - unable to launch intent from full screen message (%s)", ex.getMessage());
                        return true;
                    }
                }
            }
            return true;
        }
    }

    protected static class MessageFullScreenRunner
    implements Runnable {
        private MessageFullScreen message;

        protected MessageFullScreenRunner(MessageFullScreen message) {
            this.message = message;
        }

        @Override
        public void run() {
            try {
                this.message.webView = this.createWebView();
                this.message.webView.loadDataWithBaseURL("file:///android_asset/", this.message.replacedHtml, "text/html", "UTF-8", null);
                if (this.message.rootViewGroup == null) {
                    StaticMethods.logErrorFormat("Messages - unable to get root view group from os", new Object[0]);
                    MessageFullScreen.killMessageActivity(this.message);
                    return;
                }
                int width = this.message.rootViewGroup.getMeasuredWidth();
                int height = this.message.rootViewGroup.getMeasuredHeight();
                if (width == 0 || height == 0) {
                    StaticMethods.logErrorFormat("Messages - root view hasn't been measured, cannot show message", new Object[0]);
                    MessageFullScreen.killMessageActivity(this.message);
                    return;
                }
                if (this.message.isVisible) {
                    this.message.rootViewGroup.addView((View)this.message.webView, width, height);
                } else {
                    TranslateAnimation translate = new TranslateAnimation(0.0f, 0.0f, (float)height, 0.0f);
                    translate.setDuration(300L);
                    this.message.webView.setAnimation((Animation)translate);
                    this.message.rootViewGroup.addView((View)this.message.webView, width, height);
                }
                this.message.isVisible = true;
            }
            catch (Exception ex) {
                StaticMethods.logDebugFormat("Messages - Failed to show full screen message (%s)", ex.getMessage());
            }
        }

        protected WebView createWebView() {
            WebView webView = new WebView((Context)this.message.messageFullScreenActivity);
            webView.setVerticalScrollBarEnabled(false);
            webView.setHorizontalScrollBarEnabled(false);
            webView.setBackgroundColor(0);
            webView.setWebViewClient((WebViewClient)this.message.getMessageFullScreenWebViewClient());
            WebSettings settings = webView.getSettings();
            settings.setJavaScriptEnabled(true);
            settings.setAllowFileAccess(true);
            settings.setDefaultTextEncodingName("UTF-8");
            return webView;
        }
    }
}

